/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.security.Security;
import java.util.Arrays;
import java.util.EnumSet;
import oracle.kv.util.shell.Shell;

public abstract class CommandParser {
    public static final String ROOT_FLAG = "-root";
    public static final String HOST_FLAG = "-host";
    public static final String STORE_FLAG = "-store";
    public static final String PORT_FLAG = "-port";
    public static final String NO_ADMIN_FLAG = "-noadmin";
    public static final String USAGE_FLAG = "-usage";
    public static final String VERBOSE_FLAG = "-verbose";
    public static final String DEBUG_FLAG = "-debug";
    public static final String USER_FLAG = "-username";
    public static final String SECURITY_FLAG = "-security";
    public static final String ADMIN_USER_FLAG = "-admin-username";
    public static final String ADMIN_SECURITY_FLAG = "-admin-security";
    public static final String TIMEOUT_FLAG = "-timeout";
    public static final String CONSISTENCY_FLAG = "-consistency";
    public static final String DURABILITY_FLAG = "-durability";
    public static final String HELPER_HOSTS_FLAG = "-helper-hosts";
    public static final String NOCONNECT_FLAG = "-noconnect";
    public static final String NOPROMPT_FLAG = "-noprompt";
    public static final String DONTEXIT_FLAG = "-no-exit";
    public static final String HIDDEN_FLAG = "-hidden";
    public static final String NAME_FLAG = "-name";
    public static final String LAST_FLAG = "-last";
    public static final String FROM_FLAG = "-from";
    public static final String TO_FLAG = "-to";
    public static final String ON_FLAG = "on";
    public static final String OFF_FLAG = "off";
    public static final String CONSISTENCY_TIME_FLAG = "-time";
    public static final String PERMISSIBLE_LAG_FLAG = "-permissible-lag";
    public static final String MASTER_SYNC_FLAG = "-master-sync";
    public static final String REPLICA_SYNC_FLAG = "-replica-sync";
    public static final String REPLICA_ACK_FLAG = "-replica-ack";
    public static final String TABLE_FLAG = "-table";
    public static final String FILE_FLAG = "-file";
    public static final String JSON_FLAG = "-json";
    public static final String JSON_V1_FLAG = "-json-v1";
    public static final String DNS_CACHETTL_FLAG = "-dns-cachettl";
    public static final String COMMAND_FLAG = "-command";
    public static final String PRETTY_FLAG = "-pretty";
    public static final String REG_OPEN_TIME_FLAG = "-registry-open-timeout";
    public static final String REG_READ_TIME_FLAG = "-registry-read-timeout";
    public static final String NAMESPACE_FLAG = "-namespace";
    private static final String ADMIN_FLAG = "-admin";
    public static final int JSON_V1 = 1;
    public static final int JSON_V2 = 2;
    public static final String KVSTORE_USAGE_PREFIX = "Usage: java -jar KVHOME/lib/kvstore.jar ";
    public static final String KVCLI_USAGE_PREFIX = "Usage: java -jar KVHOME/lib/kvcli.jar ";
    public static final String KVSQLCLI_USAGE_PREFIX = "Usage: java -jar KVHOME/lib/sql.jar ";
    public static final String KVTOOL_USAGE_PREFIX = "Usage: java -jar KVHOME/lib/kvtool.jar ";
    public static final String MIGRATOR_USAGE_PREFIX = "Usage: java -jar KVHOME/lib/migrator.jar ";
    protected String rootDir;
    protected String hostname;
    protected String storeName;
    protected String userName;
    protected String securityFile;
    protected String adminUserName;
    protected String adminSecurityFilePath;
    protected boolean runBootAdmin;
    protected int registryPort;
    protected String portStr;
    protected boolean verbose;
    protected boolean json;
    protected boolean jsonV1;
    protected String[] argArray;
    protected int dnsCacheTTL = -1;
    protected int registryOpenTimeout = 3000;
    protected int registryReadTimeout = 10000;
    private final boolean dontParse;
    private String[] rcArgs;
    private String[] inputArgs;
    private int argc;
    private boolean ignoreUnknown;

    public CommandParser(String[] args) {
        this(args, false);
    }

    public CommandParser(String[] args, boolean dontParse) {
        this(args, null, dontParse);
    }

    public CommandParser(String[] args, String[] rcArgs, boolean dontParse) {
        this.dontParse = dontParse;
        if (args == null) {
            throw new IllegalArgumentException();
        }
        this.inputArgs = args;
        this.rcArgs = rcArgs;
        this.ignoreUnknown = false;
    }

    public void setDefaults(String rootDir, String storeName, String hostname, int registryPort) {
        this.rootDir = rootDir;
        this.storeName = storeName;
        this.hostname = hostname;
        this.registryPort = registryPort;
        this.portStr = Integer.toString(registryPort);
    }

    public String getPortStr() {
        return this.portStr;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getRootDir() {
        return this.rootDir;
    }

    public String getStoreName() {
        return this.storeName;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getSecurityFile() {
        return this.securityFile;
    }

    public String getAdminUserName() {
        return this.adminUserName;
    }

    public String getAdminSecurityFile() {
        return this.adminSecurityFilePath;
    }

    public int getRegistryPort() {
        return this.registryPort;
    }

    public boolean isRunBootAdmin() {
        return this.runBootAdmin;
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public boolean getJson() {
        return this.json || this.jsonV1;
    }

    public int getJsonVersion() {
        if (!this.getJson()) {
            return -1;
        }
        return this.json ? 2 : 1;
    }

    public static int getJsonVersion(String[] args) {
        if (Shell.checkArg(args, JSON_FLAG)) {
            return 2;
        }
        if (Shell.checkArg(args, JSON_V1_FLAG)) {
            return 1;
        }
        return -1;
    }

    public int getDnsCacheTTL() {
        return this.dnsCacheTTL;
    }

    public int getRegistryOpenTimeout() {
        return this.registryOpenTimeout;
    }

    public int getRegistryReadTimeout() {
        return this.registryReadTimeout;
    }

    public void verbose(String msg) {
        if (this.verbose) {
            System.err.println(msg);
        }
    }

    public String nextArg(String arg) {
        if (this.argc >= this.argArray.length) {
            this.usage("Flag " + arg + " requires an argument");
        }
        return this.argArray[this.argc++];
    }

    public int nextIntArg(String arg) {
        String next = this.nextArg(arg);
        try {
            return Integer.parseInt(next);
        }
        catch (NumberFormatException e) {
            this.usage("Flag " + arg + " requires an integer argument");
            return 0;
        }
    }

    public long nextLongArg(String arg) {
        String next = this.nextArg(arg);
        try {
            return Long.parseLong(next);
        }
        catch (NumberFormatException e) {
            this.usage("Flag " + arg + " requires a long argument");
            return 0L;
        }
    }

    public <E extends Enum<E>> E nextEnumArg(String arg, Class<E> enumClass) {
        String next = this.nextArg(arg);
        try {
            return Enum.valueOf(enumClass, next.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.usage("Flag " + arg + " requires a constant of enum type " + enumClass.getName() + ", one of: " + Arrays.toString(enumClass.getEnumConstants()));
            return null;
        }
    }

    public <E extends Enum<E>> EnumSet<E> nextEnumSetArg(String arg, Class<E> enumClass) {
        EnumSet<E> set = EnumSet.noneOf(enumClass);
        for (String value : this.nextArg(arg).split(",")) {
            try {
                set.add(Enum.valueOf(enumClass, value.toUpperCase()));
            }
            catch (IllegalArgumentException e) {
                this.usage("Flag " + arg + " requires one or more constants of enum type " + enumClass.getName() + ": " + Arrays.toString(enumClass.getEnumConstants()));
            }
        }
        return set;
    }

    protected int getNRemainingArgs() {
        return this.argArray.length - this.argc;
    }

    protected void missingArg(String arg) {
        this.usage("Flag " + arg + " is required");
    }

    private void unknownArg(String arg) {
        this.usage("Unknown argument: " + arg);
    }

    public boolean isIgnoreUnknownArg() {
        return this.ignoreUnknown;
    }

    public void parseArgs() {
        if (this.rcArgs != null) {
            this.argArray = this.rcArgs;
            this.ignoreUnknown = true;
            this.doParseArgs();
        }
        this.argArray = this.inputArgs;
        this.ignoreUnknown = false;
        this.doParseArgs();
        this.verifyArgs();
    }

    protected void validateHostname(String name) {
        try {
            new URI("rmi", name, null, null);
        }
        catch (URISyntaxException use) {
            this.usage("Invalid hostname: " + use.getMessage());
        }
    }

    private void doParseArgs() {
        int nArgs = this.argArray.length;
        this.argc = 0;
        String errorArg = null;
        this.runBootAdmin = true;
        while (this.argc < nArgs) {
            String arg;
            if ((arg = this.argArray[this.argc++]).equals(JSON_FLAG)) {
                this.json = true;
            }
            if (!arg.equals(JSON_V1_FLAG)) continue;
            this.jsonV1 = true;
        }
        if (this.json && this.jsonV1) {
            this.usage("cannot specify -json and -json-v1 together");
        }
        this.argc = 0;
        while (this.argc < nArgs) {
            String thisArg;
            if ((thisArg = this.argArray[this.argc++]).equals(DNS_CACHETTL_FLAG)) {
                this.dnsCacheTTL = Integer.parseInt(this.nextArg(thisArg));
                Security.setProperty("networkaddress.cache.ttl", Integer.toString(this.dnsCacheTTL));
                Security.setProperty("networkaddress.cache.negative.ttl", Integer.toString(this.dnsCacheTTL));
                continue;
            }
            if (this.dontParse) {
                if (this.checkArg(thisArg) || this.isIgnoreUnknownArg()) continue;
                this.unknownArg(thisArg);
                continue;
            }
            if (thisArg.equals(ROOT_FLAG)) {
                this.rootDir = this.nextArg(thisArg);
                continue;
            }
            if (thisArg.equals(USAGE_FLAG)) {
                this.usage(null);
                continue;
            }
            if (thisArg.equals(VERBOSE_FLAG)) {
                this.verbose = true;
                continue;
            }
            if (thisArg.equals(HOST_FLAG)) {
                this.hostname = this.nextArg(thisArg);
                this.validateHostname(this.hostname);
                continue;
            }
            if (thisArg.equals(PORT_FLAG)) {
                this.portStr = this.nextArg(thisArg);
                if (this.portStr.contains(":")) continue;
                this.registryPort = Integer.parseInt(this.portStr);
                continue;
            }
            if (thisArg.equals(ADMIN_FLAG)) {
                System.err.println("WARNING: the -admin argument is obsolete and was benignly ignored.");
                this.nextArg(thisArg);
                continue;
            }
            if (thisArg.equals(NO_ADMIN_FLAG)) {
                this.runBootAdmin = false;
                continue;
            }
            if (thisArg.equals(STORE_FLAG)) {
                this.storeName = this.nextArg(thisArg);
                continue;
            }
            if (thisArg.equals(USER_FLAG)) {
                this.userName = this.nextArg(thisArg);
                continue;
            }
            if (thisArg.equals(SECURITY_FLAG)) {
                this.securityFile = this.nextArg(thisArg);
                continue;
            }
            if (thisArg.equals(ADMIN_USER_FLAG)) {
                this.adminUserName = this.nextArg(thisArg);
                continue;
            }
            if (thisArg.equals(ADMIN_SECURITY_FLAG)) {
                this.adminSecurityFilePath = this.nextArg(thisArg);
                continue;
            }
            if (thisArg.equals(JSON_FLAG) || thisArg.equals(JSON_V1_FLAG)) continue;
            if (thisArg.equals(REG_OPEN_TIME_FLAG)) {
                this.registryOpenTimeout = Integer.parseInt(this.nextArg(thisArg));
                continue;
            }
            if (thisArg.equals(REG_READ_TIME_FLAG)) {
                this.registryReadTimeout = Integer.parseInt(this.nextArg(thisArg));
                continue;
            }
            if (this.checkArg(thisArg) || this.isIgnoreUnknownArg()) continue;
            errorArg = thisArg;
        }
        if (errorArg != null) {
            this.unknownArg(errorArg);
        }
    }

    public static String optional(String msg) {
        return "[" + msg + "]";
    }

    public static String getUsage() {
        return CommandParser.optional(USAGE_FLAG);
    }

    public static String getRootUsage() {
        return "-root <rootDirectory>";
    }

    public static String getHostUsage() {
        return "-host <hostname>";
    }

    public static String getStoreUsage() {
        return "-store <storeName>";
    }

    public static String getPortUsage() {
        return "-port <port>";
    }

    public static String getNoAdminUsage() {
        return NO_ADMIN_FLAG;
    }

    public static String getUserUsage() {
        return "-username <user>";
    }

    public static String getSecurityUsage() {
        return "-security <security-file-path>";
    }

    public static String getAdminUserUsage() {
        return "-admin-username <adminUser>";
    }

    public static String getAdminSecurityUsage() {
        return "-admin-security <admin-security-file-path>";
    }

    public static String getTimeoutUsage() {
        return "-timeout <timeout ms>";
    }

    public static String getConsistencyUsage() {
        return "-consistency <NONE_REQUIRED(default) | ABSOLUTE | NONE_REQUIRED_NO_MASTER>";
    }

    public static String getDurabilityUsage() {
        return "-durability <COMMIT_SYNC(default) | COMMIT_NO_SYNC | COMMIT_WRITE_NO_SYNC>";
    }

    public static String getJsonUsage() {
        return CommandParser.optional("-json|-json-v1");
    }

    public static String getHelperHostUsage() {
        return "-helper-hosts <host:port[,host:port]*>";
    }

    public static String getDnsCacheTTLUsage() {
        return "-dns-cachettl <time in sec>";
    }

    public static String getRegOpenTimeoutUsage() {
        return "-registry-open-timeout <time in ms>";
    }

    public static String getRegReadTimeoutUsage() {
        return "-registry-read-timeout <time in ms>";
    }

    protected abstract boolean checkArg(String var1);

    protected abstract void verifyArgs();

    public abstract void usage(String var1);
}

