/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.util.shell;

import java.util.ArrayList;
import java.util.List;

public class Column {
    private static final char SEPARATOR_DEF = '-';
    private static final int LEFT_PAD_DEF = 1;
    private static final int RIGHT_PAD_DEF = 1;
    private static final int INDENT_DEF = 4;
    private static final char WHITESPACE = ' ';
    private final int leftPad;
    private final int rightPad;
    private final Align alignment;
    private final int indent;
    private List<Cell> cells = new ArrayList<Cell>();
    private int width = 0;
    private int labelWidth = 0;
    private int labelSize;

    public Column() {
        this(null);
    }

    public Column(String title) {
        this(title, Align.LEFT);
    }

    public Column(String title, Align alignment) {
        this(title, alignment, true, 1, 1);
    }

    public Column(String title, Align alignment, boolean hasTopBorder, int leftPad, int rightPad) {
        this(title, alignment, hasTopBorder, leftPad, rightPad, 4);
    }

    public Column(String title, Align alignment, boolean hasTopBorder, int leftPad, int rightPad, int indent) {
        if (title != null) {
            if (hasTopBorder) {
                this.appendSeparatorLine();
            }
            this.appendTitle(title);
        }
        this.alignment = alignment;
        this.leftPad = leftPad;
        this.rightPad = rightPad;
        this.indent = indent;
    }

    public void appendTitle(String title) {
        assert (title != null);
        this.appendHeader(title);
        this.appendSeparatorLine();
        this.labelSize = this.cells.size();
        this.labelWidth = this.width;
    }

    private void appendHeader(String text) {
        this.appendCell(new HeaderCell(text));
    }

    public void appendData(String text) {
        this.appendData(0, text, this.alignment);
    }

    public void appendData(String text, Align align) {
        this.appendData(0, text, align);
    }

    public void appendData(int level, String text) {
        this.appendData(level, text, this.alignment);
    }

    public void appendData(int level, String label, String data) {
        this.appendData(level, data);
    }

    private void appendData(int level, String text, Align align) {
        this.appendCell(new Cell(text, align, level, this.indent));
    }

    public void appendEmptyData() {
        this.appendData("");
    }

    public void appendSeparatorLine() {
        this.appendCell(new SeparatorLineCell());
    }

    public void appendEmptyLine() {
        this.appendCell(new SeparatorLineCell(' '));
    }

    private void appendCell(Cell cell) {
        int len;
        this.cells.add(cell);
        if (cell.getAlign() != Align.UNALIGNED && (len = cell.getWidth()) > this.width) {
            this.width = len;
        }
    }

    public int getHeight() {
        return this.cells.size();
    }

    public int getWidth() {
        return this.width + this.leftPad + this.rightPad;
    }

    public boolean isHeader(int index) {
        return this.cells.get(index).isHeader();
    }

    public boolean isSeparatorLine(int index) {
        return this.cells.get(index).isSeparatorLine();
    }

    public char getSeparatorLineChar(int index) {
        Cell cell = this.cells.get(index);
        if (!cell.isSeparatorLine()) {
            throw new IllegalArgumentException("The specified cell is not separator line");
        }
        return ((SeparatorLineCell)cell).getSeparatorChar();
    }

    public boolean isSeparatorEmptyLine(int index) {
        if (!this.isSeparatorLine(index)) {
            return false;
        }
        return this.getSeparatorLineChar(index) == ' ';
    }

    public int getIndentLevel(int index) {
        Cell cell = this.cells.get(index);
        return cell.getIndentLevel();
    }

    public void reset(boolean keepLabel, boolean keepWidth) {
        if (keepLabel) {
            ArrayList<Cell> newList = new ArrayList<Cell>(this.cells.subList(0, this.labelSize));
            this.cells.clear();
            this.cells = newList;
            this.width = this.labelWidth;
        } else {
            this.cells.clear();
            if (!keepWidth) {
                this.width = 0;
            }
        }
    }

    public String getFormattedText(int index) {
        char separatorChar;
        if (index < 0 || index >= this.cells.size()) {
            throw new IllegalArgumentException("Invalid cell: " + index);
        }
        Cell cell = this.cells.get(index);
        String text = cell.getText();
        int n = this.getWidth();
        switch (cell.getAlign()) {
            case LEFT: {
                text = Column.padLeft(text, text.length() + this.leftPad);
                text = Column.padRight(text, n);
                break;
            }
            case RIGHT: {
                text = Column.padRight(text, text.length() + this.rightPad);
                text = Column.padLeft(text, n);
                break;
            }
            case CENTER: {
                text = Column.centerAlign(text, n);
                break;
            }
        }
        if (cell.isSeparatorLine() && (separatorChar = ((SeparatorLineCell)cell).getSeparatorChar()) != ' ') {
            return text.replace(' ', separatorChar);
        }
        return text;
    }

    public static String padLeft(String s, int n) {
        if (n == 0) {
            return s;
        }
        return String.format("%1$" + n + "s", s);
    }

    public static String padRight(String s, int n) {
        if (n == 0) {
            return s;
        }
        return String.format("%1$-" + n + "s", s);
    }

    public static String centerAlign(String s, int n) {
        if (n == 0) {
            return s;
        }
        int padding = n - s.length();
        if (padding <= 0) {
            return s;
        }
        int left = padding / 2 + s.length();
        return Column.padRight(Column.padLeft(s, left), n);
    }

    static class SeparatorLineCell
    extends Cell {
        private char separatorChar;

        SeparatorLineCell() {
            this('-');
        }

        SeparatorLineCell(char ch) {
            super("", Align.LEFT);
            this.separatorChar = ch;
        }

        @Override
        boolean isSeparatorLine() {
            return true;
        }

        char getSeparatorChar() {
            return this.separatorChar;
        }
    }

    static class HeaderCell
    extends Cell {
        HeaderCell(String text) {
            super(text, Align.CENTER);
        }

        @Override
        boolean isHeader() {
            return true;
        }
    }

    static class Cell {
        static final Align ALIGN_DEF = Align.LEFT;
        private final String text;
        private final Align align;
        private final int level;
        private final int indent;

        Cell(String text, Align align) {
            this(text, align, 0, 0);
        }

        Cell(String text, Align align, int level, int indent) {
            this.text = text;
            this.align = align == null ? ALIGN_DEF : align;
            this.level = level;
            this.indent = indent;
        }

        String getText() {
            if (this.level == 0 || this.indent == 0) {
                return this.text;
            }
            int n = this.level * this.indent + this.text.length();
            return String.format("%1$" + n + "s", this.text);
        }

        Align getAlign() {
            return this.align;
        }

        int getWidth() {
            return this.indent * this.level + this.text.length();
        }

        int getIndentLevel() {
            return this.level;
        }

        boolean isData() {
            return true;
        }

        boolean isHeader() {
            return false;
        }

        boolean isSeparatorLine() {
            return false;
        }
    }

    public static enum Align {
        LEFT,
        RIGHT,
        CENTER,
        UNALIGNED;

    }
}

