/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.util.shell;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import oracle.kv.util.shell.CommandNotFoundException;
import oracle.kv.util.shell.Shell;
import oracle.kv.util.shell.ShellCommand;
import oracle.kv.util.shell.ShellCommandResult;
import oracle.kv.util.shell.ShellException;

public abstract class CommandWithSubs
extends ShellCommand {
    private final List<? extends SubCommand> subCommands;
    private final int minArgCount;

    protected CommandWithSubs(List<? extends SubCommand> subCommands, String name, int prefixLength, int minArgCount) {
        super(name, prefixLength);
        this.subCommands = subCommands;
        this.minArgCount = minArgCount;
        Collections.sort(this.subCommands, new Shell.CommandComparator());
    }

    protected abstract String getCommandOverview();

    public List<? extends SubCommand> getSubCommands() {
        return this.subCommands;
    }

    @Override
    public String execute(final String[] args, final Shell shell) throws ShellException {
        return (String)new CommandWithSubExecutor<String>(){

            @Override
            public String subCommandResult(SubCommand command) throws ShellException {
                String output = command.execute(Arrays.copyOfRange(args, 1, args.length), shell, CommandWithSubs.this.getCommandLine());
                CommandWithSubs.this.exitCode = command.exitCode;
                return output;
            }
        }.commonExecute(args, shell);
    }

    @Override
    public ShellCommandResult executeJsonOutput(final String[] args, final Shell shell) throws ShellException {
        return (ShellCommandResult)new CommandWithSubExecutor<ShellCommandResult>(){

            @Override
            public ShellCommandResult subCommandResult(SubCommand command) throws ShellException {
                ShellCommandResult output = command.executeJsonOutput(Arrays.copyOfRange(args, 1, args.length), shell);
                CommandWithSubs.this.exitCode = command.exitCode;
                return output;
            }
        }.commonExecute(args, shell);
    }

    @Override
    protected final String getHelp(String[] args, Shell shell) {
        if (args.length <= 1) {
            String msg = this.getCommandOverview();
            msg = msg + eol + this.getBriefHelp(shell.getHidden(), shell.showDeprecated());
            return msg;
        }
        String commandName = args[1];
        SubCommand command = this.findCommand(commandName);
        if (command != null && (!command.isHidden() || shell.getHidden())) {
            return command.getVerboseHelp();
        }
        return "Could not find " + this.name + " subcommand: " + commandName + eol + this.getVerboseHelp();
    }

    @Override
    protected final String getBriefHelp() {
        return this.getBriefHelp(false, false);
    }

    private String getBriefHelp(boolean showHidden, boolean showDeprecated) {
        StringBuilder sb = new StringBuilder();
        sb.append("Usage: ").append(this.name).append(" ");
        String ws = Shell.makeWhiteSpace(sb.length());
        boolean first = true;
        for (SubCommand subCommand : this.subCommands) {
            if (!showHidden && subCommand.isHidden() || !showDeprecated && subCommand.isDeprecated()) continue;
            if (first) {
                sb.append(subCommand.getCommandName());
                first = false;
                continue;
            }
            sb.append(" |").append(eol);
            sb.append(ws).append(subCommand.getCommandName());
        }
        return sb.toString();
    }

    @Override
    protected final String getCommandSyntax() {
        throw new AssertionError();
    }

    @Override
    protected final String getCommandDescription() {
        return "";
    }

    public SubCommand findCommand(String commandName) {
        for (SubCommand subCommand : this.subCommands) {
            if (!subCommand.matches(commandName)) continue;
            return subCommand;
        }
        return null;
    }

    protected static abstract class SubCommandJsonConvert
    extends SubCommand {
        protected SubCommandJsonConvert(String name, int prefixLength) {
            super(name, prefixLength);
        }

        @Override
        public ShellCommandResult executeJsonOutput(String[] args, Shell shell) throws ShellException {
            return this.filterJsonResult(this.execute(args, shell));
        }
    }

    public static abstract class SubCommand
    extends ShellCommand {
        protected static final String cantGetHere = "Cannot get here";

        protected SubCommand(String name, int prefixLength) {
            super(name, prefixLength);
        }
    }

    private abstract class CommandWithSubExecutor<T>
    implements ShellCommand.Executor<T> {
        private CommandWithSubExecutor() {
        }

        @Override
        public T commonExecute(String[] args, Shell shell) throws ShellException {
            String commandName;
            SubCommand command;
            if (CommandWithSubs.this.minArgCount > 0 && args.length < CommandWithSubs.this.minArgCount || args.length == 1) {
                shell.badArgCount(CommandWithSubs.this);
            }
            if ((command = CommandWithSubs.this.findCommand(commandName = args[1])) == null || command.isHidden() && !shell.getHidden()) {
                Shell.checkHelp(args, CommandWithSubs.this);
                throw new CommandNotFoundException("Could not find " + CommandWithSubs.this.name + " subcommand: " + commandName + ShellCommand.eol + CommandWithSubs.this.getVerboseHelp());
            }
            return this.subCommandResult(command);
        }

        public abstract T subCommandResult(SubCommand var1) throws ShellException;
    }
}

