/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.util.shell;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import oracle.kv.AuthenticationFailureException;
import oracle.kv.Consistency;
import oracle.kv.Durability;
import oracle.kv.KVStore;
import oracle.kv.KVStoreConfig;
import oracle.kv.KVStoreFactory;
import oracle.kv.LoginCredentials;
import oracle.kv.StatementResult;
import oracle.kv.impl.admin.CommandResult;
import oracle.kv.impl.api.table.NameUtils;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.query.shell.output.ResultOutputFactory;
import oracle.kv.impl.security.PasswordExpiredException;
import oracle.kv.impl.security.util.KVStoreLogin;
import oracle.kv.impl.util.CommandParser;
import oracle.kv.impl.util.HostPort;
import oracle.kv.query.ExecuteOptions;
import oracle.kv.util.ErrorMessage;
import oracle.kv.util.shell.Shell;
import oracle.kv.util.shell.ShellCommand;
import oracle.kv.util.shell.ShellCommandResult;
import oracle.kv.util.shell.ShellException;
import oracle.kv.util.shell.ShellInputReader;

public abstract class CommonShell
extends Shell {
    private String kvstoreName = null;
    private String storeHostname = null;
    private int storePort = 0;
    private String storeUser = null;
    private String storeSecurityFile = null;
    private List<String> helperHosts = null;
    protected String[] commandToRun;
    private int nextCommandIdx = 0;
    private boolean noprompt = false;
    private boolean noconnect = false;
    private boolean dontExit = false;
    private Integer storeTimeout = null;
    private Consistency storeConsistency = null;
    private Durability storeDurability = null;
    private LoginHelper loginHelper = null;
    private KVStore store = null;
    private KVStoreConfig kvstoreConfig = null;
    private int pageHeight = 0;
    private String namespace = null;
    static final Consistency CONSISTENCY_DEF = Consistency.ABSOLUTE;
    static final Durability DURABILITY_DEF = Durability.COMMIT_SYNC;
    static final int REQUEST_TIMEOUT_DEF = 5000;
    private static Map<String, Consistency> consistencyMap;
    private static Map<String, Durability> durabilityMap;

    public CommonShell(InputStream input, PrintStream output) {
        this(input, output, null);
    }

    public CommonShell(InputStream input, PrintStream output, String[] maskFlags) {
        super(input, output, true, maskFlags);
    }

    public KVStore getStore() throws ShellException {
        if (this.store == null) {
            throw new ShellException("Not Connected.");
        }
        return this.store;
    }

    public KVStoreConfig getKVStoreConfig() {
        return this.kvstoreConfig;
    }

    public void setStoreConsistency(Consistency consistency) {
        this.storeConsistency = consistency;
    }

    public Consistency getStoreConsistency() {
        return this.storeConsistency != null ? this.storeConsistency : CONSISTENCY_DEF;
    }

    public static String getConsistencyName(Consistency consistency) {
        if (consistency instanceof Consistency.Time) {
            Consistency.Time tcons = (Consistency.Time)consistency;
            return tcons.getName() + "[permissibleLag_ms=" + tcons.getPermissibleLag(TimeUnit.MILLISECONDS) + ", timeout_ms=" + tcons.getTimeout(TimeUnit.MILLISECONDS) + "]";
        }
        for (Map.Entry<String, Consistency> entry : consistencyMap.entrySet()) {
            if (!consistency.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    public void setStoreDurability(Durability durability) {
        this.storeDurability = durability;
    }

    public Durability getStoreDurability() {
        return this.storeDurability != null ? this.storeDurability : DURABILITY_DEF;
    }

    public static String getDurabilityName(Durability durability) {
        for (Map.Entry<String, Durability> entry : durabilityMap.entrySet()) {
            if (!durability.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return "Durability[MasterSync=" + durability.getMasterSync() + ", ReplicaSync=" + durability.getReplicaSync() + ", ReplicaAck= " + durability.getReplicaAck() + "]";
    }

    public void setRequestTimeout(int timeout) {
        this.storeTimeout = timeout;
    }

    public int getRequestTimeout() {
        return this.storeTimeout != null ? this.storeTimeout : 5000;
    }

    public void connectStore() throws ShellException {
        this.connectStore(null);
    }

    public void connectStore(List<String> extraHostPorts) throws ShellException {
        if (this.kvstoreName != null) {
            this.getLoginHelper().updateStoreLogin(this.storeUser, this.storeSecurityFile);
            this.openStore(extraHostPorts);
        }
    }

    void setPageHeight(int height) {
        this.pageHeight = height;
    }

    public int getPageHeight() {
        if (this.pageHeight == 0) {
            ShellInputReader inputReader = this.getInput();
            return inputReader == null ? -1 : inputReader.getTerminalHeight();
        }
        return this.pageHeight;
    }

    public boolean isPagingEnabled() {
        return this.getPageHeight() >= 0;
    }

    public boolean isNoPrompt() {
        return this.noprompt;
    }

    public boolean isNoConnect() {
        return this.noconnect;
    }

    public boolean dontExit() {
        return this.dontExit;
    }

    public static Consistency getConsistency(String name) {
        return consistencyMap.get(name.toUpperCase());
    }

    public static Set<String> getConsistencyNames() {
        return consistencyMap.keySet();
    }

    public static Durability getDurability(String name) {
        return durabilityMap.get(name.toUpperCase());
    }

    public static Set<String> getDurabilityNames() {
        return durabilityMap.keySet();
    }

    public void setNamespace(String namespace) {
        if (namespace != null) {
            TableImpl.validateNamespace(namespace);
        }
        this.namespace = namespace;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public ExecuteOptions getExecuteOptions() {
        return new ExecuteOptions().setConsistency(this.getStoreConsistency()).setTimeout(this.getRequestTimeout(), TimeUnit.MILLISECONDS).setNamespace(this.getNamespace());
    }

    public void setLoginHelper(LoginHelper loginHelper) {
        this.loginHelper = loginHelper;
    }

    public LoginHelper getLoginHelper() {
        if (this.loginHelper == null) {
            this.loginHelper = new LoginHelper();
        }
        return this.loginHelper;
    }

    public void openStore(String host, int port, String storeName, String user, String securityFile) throws ShellException {
        this.openStore(host, port, storeName, user, securityFile, null, null, null);
    }

    public void openStore(String host, int port, String storeName, String user, String securityFile, Integer timeout, Consistency consistency, Durability durability) throws ShellException {
        this.storeHostname = host;
        this.storePort = port;
        this.kvstoreName = storeName;
        if (timeout != null) {
            this.setRequestTimeout(timeout);
        }
        if (consistency != null) {
            this.setStoreConsistency(consistency);
        }
        if (durability != null) {
            this.setStoreDurability(durability);
        }
        try {
            this.getLoginHelper().updateStoreLogin(user, securityFile);
        }
        catch (IllegalStateException ise) {
            throw new ShellException(ise.getMessage());
        }
        catch (IllegalArgumentException iae) {
            this.output.println(iae.getMessage());
        }
        this.openStore();
    }

    String[] getHostPorts(List<String> extraHostPorts) {
        ArrayList<String> hostports = new ArrayList<String>();
        if (this.storeHostname != null) {
            hostports.add(this.storeHostname + ":" + this.storePort);
        } else {
            hostports.addAll(this.helperHosts);
        }
        if (extraHostPorts != null) {
            hostports.addAll(extraHostPorts);
        }
        return hostports.toArray(new String[0]);
    }

    public void openStore() throws ShellException {
        this.openStore(null);
    }

    public void openStore(List<String> extraHostPorts) throws ShellException {
        String[] hostports = this.getHostPorts(extraHostPorts);
        this.kvstoreConfig = new KVStoreConfig(this.kvstoreName, hostports);
        Durability durability = this.getStoreDurability();
        this.kvstoreConfig.setDurability(durability);
        Consistency consistency = this.getStoreConsistency();
        this.kvstoreConfig.setConsistency(consistency);
        int requestTimeout = this.getRequestTimeout();
        this.kvstoreConfig.setRequestTimeout(requestTimeout, TimeUnit.MILLISECONDS);
        long socketTimeout = this.kvstoreConfig.getSocketReadTimeout(TimeUnit.MILLISECONDS);
        if (socketTimeout < (long)requestTimeout) {
            this.kvstoreConfig.setSocketReadTimeout(requestTimeout, TimeUnit.MILLISECONDS);
        }
        this.kvstoreConfig.setUseAsync(false);
        try {
            this.store = this.getLoginHelper().getAuthenticatedStore(this.kvstoreConfig);
        }
        catch (ShellException se) {
            throw se;
        }
        catch (Exception e) {
            throw new ShellException("Cannot connect to " + this.kvstoreName + " at " + (this.storeHostname != null ? this.storeHostname + ":" + this.storePort : this.joinHostsWithComma(hostports)), e);
        }
    }

    private String joinHostsWithComma(String[] hostports) {
        StringBuilder sb = new StringBuilder();
        for (String hp : hostports) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(hp);
        }
        return sb.toString();
    }

    public void closeStore() {
        if (this.store != null) {
            this.store.close();
            this.store = null;
        }
    }

    public String displayDDLResults(StatementResult result) {
        if (result.getErrorMessage() != null) {
            return result.getErrorMessage() + "\n" + result.getInfo();
        }
        if (result.isSuccessful()) {
            if (result.getResult() != null) {
                return result.getResult();
            }
            if (result.getInfo().equals("Statement did not require execution")) {
                return result.getInfo();
            }
            return "Statement completed successfully";
        }
        return "Statement did not complete successfully:\n" + result.getInfo();
    }

    public String displayDMLResults(ResultOutputFactory.OutputMode outputMode, StatementResult result) throws ShellException {
        return this.displayDMLResults(outputMode, result, this.isPagingEnabled(), this.getOutput());
    }

    public String displayDMLResults(ResultOutputFactory.OutputMode outputMode, StatementResult result, boolean isPagingEnabled, PrintStream queryOutput) throws ShellException {
        if (result.getErrorMessage() != null) {
            return result.getErrorMessage() + "\n" + result.getInfo();
        }
        ResultOutputFactory.ResultOutput resultOutput = ResultOutputFactory.getOutput(outputMode, this, queryOutput, result.getResultDef(), result.iterator(), isPagingEnabled, this.getPageHeight());
        try {
            long num = resultOutput.outputResultSet();
            return String.format("\n%d %s returned", num, num > 1L ? "rows" : "row");
        }
        catch (IllegalArgumentException iae) {
            throw new ShellException("Failed to display result set: " + iae.getMessage(), iae);
        }
        catch (IOException ioe) {
            throw new ShellException("Failed to display result set: " + ioe.getMessage(), ioe);
        }
    }

    public void start() {
        this.init();
        if (this.getExitCode() != 0 && this.dontExit()) {
            this.shutdown();
            return;
        }
        try {
            if (this.commandToRun != null) {
                try {
                    String result = this.run(this.commandToRun[0], this.commandToRun);
                    this.output.println(result);
                }
                catch (ShellException se) {
                    this.handleShellException(this.commandToRun[0], se);
                }
                catch (Exception e) {
                    this.handleUnknownException(this.commandToRun[0], e);
                }
            } else {
                this.loop();
            }
        }
        finally {
            this.shutdown();
        }
    }

    static {
        HashMap<String, Consistency> consMap = new HashMap<String, Consistency>();
        consMap.put("NONE_REQUIRED", Consistency.NONE_REQUIRED);
        Consistency NONE_REQUIRED_NO_MASTER = Consistency.NONE_REQUIRED_NO_MASTER;
        consMap.put("NONE_REQUIRED_NO_MASTER", NONE_REQUIRED_NO_MASTER);
        consMap.put("ABSOLUTE", Consistency.ABSOLUTE);
        consistencyMap = Collections.unmodifiableMap(consMap);
        HashMap<String, Durability> durMap = new HashMap<String, Durability>();
        durMap.put("COMMIT_SYNC", Durability.COMMIT_SYNC);
        durMap.put("COMMIT_NO_SYNC", Durability.COMMIT_NO_SYNC);
        durMap.put("COMMIT_WRITE_NO_SYNC", Durability.COMMIT_WRITE_NO_SYNC);
        durabilityMap = Collections.unmodifiableMap(durMap);
    }

    public static class NamespaceCommand
    extends ShellCommand {
        static final String NAME = "namespace";
        static final String SYNTAX = "namespace " + CommandParser.optional("namespace");
        static final String DESCRIPTION = "Sets or clears the default namespace to use for table operations and queries";

        public NamespaceCommand() {
            super(NAME, 3);
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            Shell.checkHelp(args, this);
            CommonShell commonShell = (CommonShell)shell;
            if (args.length > 2) {
                shell.badArgCount(this);
            } else if (args.length > 1) {
                commonShell.setNamespace(args[1]);
            } else {
                commonShell.setNamespace(null);
            }
            return "Namespace is " + NameUtils.switchToExternalUse(commonShell.getNamespace());
        }

        @Override
        public String getCommandSyntax() {
            return SYNTAX;
        }

        @Override
        public String getCommandDescription() {
            return DESCRIPTION;
        }
    }

    public static class HiddenCommand
    extends ShellCommand {
        private static final String NAME = "hidden";
        static final String SYNTAX = "hidden " + CommandParser.optional("on | <n> | off");
        static final String DESCRIPTION = "Toggles visibility of commands and flags that are normally" + eolt + "hidden. Use these only if advised to do so by Oracle Support.";

        public HiddenCommand() {
            super(NAME, 3);
        }

        @Override
        protected boolean isHidden() {
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            if (args.length > 2) {
                shell.badArgCount(this);
            }
            if (args.length > 1) {
                String arg = args[1];
                if ("on".equals(arg)) {
                    shell.setHidden(true);
                    return "Hidden commands and parameters are " + (shell.getHidden() ? "enabled" : "disabled");
                } else {
                    if (!"off".equals(arg)) return "Invalid argument: " + arg + eolt + this.getBriefHelp();
                    shell.setHidden(false);
                }
                return "Hidden commands and parameters are " + (shell.getHidden() ? "enabled" : "disabled");
            } else {
                shell.toggleHidden();
            }
            return "Hidden commands and parameters are " + (shell.getHidden() ? "enabled" : "disabled");
        }

        @Override
        protected String getCommandSyntax() {
            return SYNTAX;
        }

        @Override
        public String getCommandDescription() {
            return DESCRIPTION;
        }
    }

    public static class VerboseCommand
    extends ShellCommand {
        private static final String NAME = "verbose";
        static final String SYNTAX = "verbose " + CommandParser.optional("on | off");
        static final String DESCRIPTION = "Toggles or sets the global verbosity setting.  This property can also" + eolt + "be set per-command using the -verbose flag.";

        public VerboseCommand() {
            super(NAME, 4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            if (args.length > 2) {
                shell.badArgCount(this);
                return "Verbose mode is now " + (shell.getVerbose() ? "on" : "off");
            } else if (args.length > 1) {
                String arg = args[1];
                if ("on".equals(arg)) {
                    shell.setVerbose(true);
                    return "Verbose mode is now " + (shell.getVerbose() ? "on" : "off");
                } else {
                    if (!"off".equals(arg)) return "Invalid argument: " + arg + eolt + this.getBriefHelp();
                    shell.setVerbose(false);
                }
                return "Verbose mode is now " + (shell.getVerbose() ? "on" : "off");
            } else {
                shell.toggleVerbose();
            }
            return "Verbose mode is now " + (shell.getVerbose() ? "on" : "off");
        }

        @Override
        protected String getCommandSyntax() {
            return SYNTAX;
        }

        @Override
        public String getCommandDescription() {
            return DESCRIPTION;
        }
    }

    public static class DebugCommand
    extends ShellCommand {
        private static String NAME = "debug";
        static final String SYNTAX = NAME + " " + CommandParser.optional("on | off");
        static final String DESCRIPTION = "Toggles or sets the global debug setting.  This property can also" + eolt + "be set per-command using the -debug flag.";

        public DebugCommand() {
            super(NAME, 4);
        }

        @Override
        public boolean isHidden() {
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            if (args.length > 2) {
                shell.badArgCount(this);
                return "Debug mode is now " + (shell.getDebug() ? "on" : "off");
            } else if (args.length > 1) {
                String arg = args[1];
                if ("on".equals(arg)) {
                    shell.setDebug(true);
                    return "Debug mode is now " + (shell.getDebug() ? "on" : "off");
                } else {
                    if (!"off".equals(arg)) return "Invalid argument: " + arg + eolt + this.getBriefHelp();
                    shell.setDebug(false);
                }
                return "Debug mode is now " + (shell.getDebug() ? "on" : "off");
            } else {
                shell.toggleDebug();
            }
            return "Debug mode is now " + (shell.getDebug() ? "on" : "off");
        }

        @Override
        protected String getCommandSyntax() {
            return SYNTAX;
        }

        @Override
        public String getCommandDescription() {
            return DESCRIPTION;
        }
    }

    public static class HistoryCommand
    extends ShellCommand {
        static final String NAME = "history";
        static final String SYNTAX = "history " + CommandParser.optional("-last <n>") + " " + CommandParser.optional("-from <n>") + " " + CommandParser.optional("-to <n>");
        static final String DESCRIPTION = "Displays command history.  By default all history is displayed." + eolt + "Optional flags are used to choose ranges for display";

        public HistoryCommand() {
            super(NAME, 4);
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            Shell.checkHelp(args, this);
            Shell.CommandHistory history = shell.getHistory();
            int from = 0;
            int to = history.getSize();
            boolean isLast = false;
            if (args.length > 1) {
                for (int i = 1; i < args.length; ++i) {
                    String arg = args[i];
                    if ("-last".equals(arg)) {
                        from = this.parseInt(Shell.nextArg(args, i++, this));
                        isLast = true;
                        continue;
                    }
                    if ("-from".equals(arg)) {
                        from = this.parseInt(Shell.nextArg(args, i++, this));
                        continue;
                    }
                    if ("-to".equals(arg)) {
                        to = this.parseInt(Shell.nextArg(args, i++, this));
                        continue;
                    }
                    shell.unknownArgument(arg, this);
                }
                if (isLast) {
                    from = history.getSize() - from + 1;
                }
            }
            return history.dump(this.toZeroBasedIndex(from), this.toZeroBasedIndex(to));
        }

        private int toZeroBasedIndex(int index) {
            return index > 0 ? index - 1 : 0;
        }

        @Override
        protected String getCommandSyntax() {
            return SYNTAX;
        }

        @Override
        protected String getCommandDescription() {
            return DESCRIPTION;
        }
    }

    public static class PageCommand
    extends ShellCommand {
        private static final String NAME = "page";
        static final String SYNTAX = "page " + CommandParser.optional("on | <n> | off");
        static final String DESCRIPTION = "Turns query output paging on or off.  If specified, n is used as the page" + eolt + "height. If n is 0, or 'on' is specified the default page height is used." + eolt + "'off' turns paging off.";

        public PageCommand() {
            super(NAME, 4);
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            Shell.checkHelp(args, this);
            CommonShell comShell = (CommonShell)shell;
            if (args.length > 2) {
                shell.badArgCount(this);
            } else if (args.length > 1) {
                String arg = args[1];
                if ("on".equals(arg)) {
                    comShell.setPageHeight(0);
                } else if ("off".equals(arg)) {
                    comShell.setPageHeight(-1);
                } else {
                    int height = this.parseInt(arg);
                    if (height < 1) {
                        this.invalidArgument(arg);
                    }
                    comShell.setPageHeight(height);
                }
            }
            if (comShell.isPagingEnabled()) {
                return "Paging mode is now on, height: " + comShell.getPageHeight();
            }
            return "Paging mode is now off";
        }

        @Override
        public String getCommandSyntax() {
            return SYNTAX;
        }

        @Override
        public String getCommandDescription() {
            return DESCRIPTION;
        }
    }

    public static class TimeCommand
    extends ShellCommand {
        private static final String NAME = "timer";
        static final String SYNTAX = "timer " + CommandParser.optional("on | off");
        static final String DESCRIPTION = "Turns the measurement and display of execution time for commands on or off.";

        public TimeCommand() {
            super(NAME, 5);
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            Shell.checkHelp(args, this);
            if (args.length > 2) {
                shell.badArgCount(this);
            } else if (args.length > 1) {
                String arg = args[1];
                if ("on".equals(arg)) {
                    shell.setTimer(true);
                } else if ("off".equals(arg)) {
                    shell.setTimer(false);
                } else {
                    shell.unknownArgument(arg, this);
                }
            }
            return "Timer is now " + (shell.getTimer() ? "on" : "off");
        }

        @Override
        public String getCommandSyntax() {
            return SYNTAX;
        }

        @Override
        public String getCommandDescription() {
            return DESCRIPTION;
        }
    }

    public static class ConnectStoreCommand
    extends ShellCommand {
        static final String NAME = "connect";
        public static final String CONNECT_STORE_COMMAND_DESC = "Connects to a KVStore to perform data access functions." + eolt + "If the instance is secured, you may need to provide login credentials.";
        public static final String CONNECT_STORE_COMMAND_ARGUMENTS = CommandParser.optional(CommandParser.getHostUsage()) + " " + CommandParser.optional(CommandParser.getPortUsage()) + " " + "-name" + " <storeName>" + eolt + CommandParser.optional(CommandParser.getTimeoutUsage()) + " " + eolt + CommandParser.optional(CommandParser.getConsistencyUsage()) + eolt + CommandParser.optional(CommandParser.getDurabilityUsage()) + eolt + CommandParser.optional(CommandParser.getUserUsage()) + " " + CommandParser.optional(CommandParser.getSecurityUsage());
        public static final String CONNECT_STORE_COMMAND_SYNTAX = "connect " + CONNECT_STORE_COMMAND_ARGUMENTS;

        public ConnectStoreCommand() {
            super(NAME, 4);
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            return this.execute(args, shell, new ArrayList<HostPort>());
        }

        public String execute(String[] args, Shell shell, List<HostPort> extraHostports) throws ShellException {
            Shell.checkHelp(args, this);
            String hostname = null;
            int port = 0;
            String storeName = null;
            String user = null;
            String security = null;
            Integer timeout = null;
            Consistency consistency = null;
            Durability durability = null;
            for (int i = 1; i < args.length; ++i) {
                String arg = args[i];
                if ("-host".equals(arg)) {
                    hostname = Shell.nextArg(args, i++, this);
                    continue;
                }
                if ("-port".equals(arg)) {
                    if ((port = this.parseInt(Shell.nextArg(args, i++, this))) >= 1 && port <= 65535) continue;
                    this.invalidArgument(arg);
                    continue;
                }
                if ("-name".equals(arg)) {
                    storeName = Shell.nextArg(args, i++, this);
                    continue;
                }
                if ("-username".equals(arg)) {
                    user = Shell.nextArg(args, i++, this);
                    continue;
                }
                if ("-security".equals(arg)) {
                    security = Shell.nextArg(args, i++, this);
                    continue;
                }
                if ("-timeout".equals(arg)) {
                    if ((timeout = Integer.valueOf(this.parseInt(Shell.nextArg(args, i++, this)))) > 0) continue;
                    this.invalidArgument(arg);
                    continue;
                }
                if ("-consistency".equals(arg)) {
                    String cname;
                    if ((consistency = CommonShell.getConsistency(cname = Shell.nextArg(args, i++, this))) != null) continue;
                    this.invalidArgument(arg);
                    continue;
                }
                if ("-durability".equals(arg)) {
                    Object dname;
                    if ((durability = CommonShell.getDurability((String)(dname = Shell.nextArg(args, i++, this)))) != null) continue;
                    this.invalidArgument(arg);
                    continue;
                }
                shell.unknownArgument(arg, this);
            }
            if (storeName == null) {
                shell.requiredArg("-name", this);
            }
            CommonShell cshell = (CommonShell)shell;
            cshell.closeStore();
            ArrayList<HostPort> hostports = new ArrayList<HostPort>();
            if (hostname != null && port != 0) {
                hostports.add(new HostPort(hostname, port));
            } else {
                if (cshell.helperHosts != null) {
                    if (hostname == null && port != 0) {
                        shell.requiredArg("-host", this);
                    } else if (hostname != null && port == 0) {
                        shell.requiredArg("-port", this);
                    }
                    assert (hostname == null && port == 0);
                    for (Object helperHost : cshell.helperHosts) {
                        hostports.add(HostPort.parse((String)helperHost));
                    }
                } else {
                    if (hostname == null) {
                        hostname = cshell.storeHostname;
                    }
                    if (port == 0) {
                        port = cshell.storePort;
                    }
                    hostports.add(new HostPort(hostname, port));
                }
                if (extraHostports != null) {
                    hostports.addAll(extraHostports);
                }
            }
            boolean connected = false;
            for (HostPort hostPort : hostports) {
                try {
                    hostname = hostPort.hostname();
                    port = hostPort.port();
                    cshell.openStore(hostname, port, storeName, user, security, timeout, consistency, durability);
                    connected = true;
                    break;
                }
                catch (ShellException shellException) {
                }
            }
            if (!connected) {
                String fmt = "Failed to connect to %s at %s" + eol + "Warning: You are no longer connected to a store.";
                String helperHosts = Arrays.toString(hostports.toArray(new HostPort[hostports.size()]));
                throw new ShellException(String.format(fmt, storeName, helperHosts));
            }
            String ret = "Connected to " + storeName + " at " + hostname + ":" + port + ".";
            if (timeout != null) {
                ret = ret + " Set timeout: " + timeout + "ms.";
            }
            if (consistency != null) {
                ret = ret + " Set consistency: " + consistency + ".";
            }
            if (durability != null) {
                ret = ret + " Set durability: " + durability + ".";
            }
            return ret;
        }

        @Override
        protected String getCommandSyntax() {
            return CONNECT_STORE_COMMAND_SYNTAX;
        }

        @Override
        protected String getCommandDescription() {
            return CONNECT_STORE_COMMAND_DESC;
        }
    }

    public static class LoginHelper
    implements KVStoreLogin.CredentialsProvider {
        protected final KVStoreLogin storeLogin = new KVStoreLogin();
        private LoginCredentials storeCreds;
        private boolean isSecuredStore;

        void updateStoreLogin(String newUser, String newLoginFile) {
            this.storeLogin.updateLoginInfo(newUser, newLoginFile);
            this.isSecuredStore = this.storeLogin.foundTransportSettings();
            this.storeCreds = null;
        }

        protected KVStore getAuthenticatedStore(KVStoreConfig config) throws ShellException {
            config.setSecurityProperties(this.storeLogin.getSecurityProperties());
            try {
                if (this.isSecuredStore && this.storeCreds == null) {
                    this.storeCreds = this.storeLogin.makeShellLoginCredentials();
                }
                return KVStoreFactory.getStore(config, this.storeCreds, KVStoreLogin.makeReauthenticateHandler(this));
            }
            catch (PasswordExpiredException pee) {
                this.storeCreds = null;
                String errorMsg = "Login failed: Password is expired. Log into the Admin CLI to renew your password.";
                throw new ShellException(errorMsg, pee);
            }
            catch (AuthenticationFailureException afe) {
                this.storeCreds = null;
                String errorMsg = "Login failed: " + afe.getMessage();
                throw new ShellException(errorMsg, afe);
            }
            catch (IOException ioe) {
                throw new ShellException("Failed to get login credentials: " + ioe.getMessage());
            }
            catch (IllegalArgumentException iae) {
                throw new ShellException("Login properties error: " + iae.getMessage());
            }
        }

        @Override
        public LoginCredentials getCredentials() {
            return this.storeCreds;
        }
    }

    public abstract class ShellParser
    extends CommandParser {
        private List<String> reqFlags;
        private boolean hasNonHiddenArg;

        public ShellParser(String[] args, String[] rcArgs, String[] requiredFlags) {
            super(args, rcArgs, true);
            this.hasNonHiddenArg = false;
            if (requiredFlags != null) {
                this.reqFlags = new ArrayList<String>();
                this.reqFlags.addAll(Arrays.asList(requiredFlags));
            }
        }

        @Override
        protected void verifyArgs() {
            if (!this.hasNonHiddenArg && !CommonShell.this.noconnect) {
                CommonShell.this.noconnect = true;
            }
            if (!CommonShell.this.noconnect && this.reqFlags != null && this.reqFlags.size() > 0) {
                this.usage("Missing required argument");
            }
            if (CommonShell.this.commandToRun != null && CommonShell.this.nextCommandIdx < CommonShell.this.commandToRun.length) {
                this.usage("Flags may not follow commands");
            }
        }

        public abstract String getShellUsage();

        @Override
        public void usage(String errorMsg) {
            String error = "";
            if (errorMsg != null) {
                error = error + errorMsg + Shell.eol;
            }
            error = error + this.getShellUsage();
            if (this.argArray != null && Shell.checkArg(this.argArray, "-json")) {
                String operation = "";
                for (String arg : this.argArray) {
                    operation = operation + arg + " ";
                }
                CommandResult.CommandFails result = new CommandResult.CommandFails(error, ErrorMessage.NOSQL_5100, CommandResult.NO_CLEANUP_JOBS);
                boolean isJsonV1 = Shell.checkArg(this.argArray, "-json-v1");
                error = isJsonV1 ? Shell.toJsonReport(operation, result) : ShellCommandResult.toJsonReport(operation, result);
            }
            System.err.println(error);
            System.exit(1);
        }

        public boolean checkExtraArg(String arg) {
            return false;
        }

        @Override
        protected boolean checkArg(String arg) {
            if (this.checkHiddenFlags(arg)) {
                return true;
            }
            if (CommonShell.this.commandToRun == null) {
                this.checkRequiredFlag(arg);
                if ("-host".equals(arg)) {
                    CommonShell.this.storeHostname = this.nextArg(arg);
                    return true;
                }
                if ("-port".equals(arg)) {
                    CommonShell.this.storePort = Integer.parseInt(this.nextArg(arg));
                    return true;
                }
                if ("-helper-hosts".equals(arg)) {
                    this.addHelperHosts(this.nextArg(arg));
                    return true;
                }
                if ("-store".equals(arg)) {
                    CommonShell.this.kvstoreName = this.nextArg(arg);
                    return true;
                }
                if ("-username".equals(arg)) {
                    CommonShell.this.storeUser = this.nextArg(arg);
                    return true;
                }
                if ("-security".equals(arg)) {
                    CommonShell.this.storeSecurityFile = this.nextArg(arg);
                    return true;
                }
                if ("-timeout".equals(arg)) {
                    CommonShell.this.storeTimeout = this.nextIntArg(arg);
                    if (CommonShell.this.storeTimeout <= 0) {
                        this.usage("Flag " + arg + " requires a positive integer");
                    }
                    return true;
                }
                if ("-consistency".equals(arg)) {
                    String cname = this.nextArg(arg);
                    CommonShell.this.storeConsistency = CommonShell.getConsistency(cname);
                    if (CommonShell.this.storeConsistency == null) {
                        this.usage(CommandParser.getConsistencyUsage());
                    }
                    return true;
                }
                if ("-durability".equals(arg)) {
                    String dname = this.nextArg(arg);
                    CommonShell.this.storeDurability = CommonShell.getDurability(dname);
                    if (CommonShell.this.storeDurability == null) {
                        this.usage(CommandParser.getDurabilityUsage());
                    }
                    return true;
                }
                if ("-registry-open-timeout".equals(arg)) {
                    this.registryOpenTimeout = Integer.parseInt(this.nextArg(arg));
                    if (this.registryOpenTimeout <= 0) {
                        this.usage("Flag " + arg + " requires a positive integer");
                    }
                    return true;
                }
                if ("-registry-read-timeout".equals(arg)) {
                    this.registryReadTimeout = Integer.parseInt(this.nextArg(arg));
                    if (this.registryReadTimeout <= 0) {
                        this.usage("Flag " + arg + " requires a positive integer");
                    }
                    return true;
                }
                if (this.checkExtraArg(arg)) {
                    return true;
                }
            }
            if (!this.isIgnoreUnknownArg()) {
                this.addToCommand(arg);
            }
            return true;
        }

        private boolean checkHiddenFlags(String arg) {
            if ("-noconnect".equals(arg)) {
                CommonShell.this.noconnect = true;
                return true;
            }
            if ("-noprompt".equals(arg)) {
                CommonShell.this.noprompt = true;
                return true;
            }
            if ("-no-exit".equals(arg)) {
                CommonShell.this.dontExit = true;
                return true;
            }
            if (CommonShell.this.commandToRun == null && Shell.isHelpFlag(arg)) {
                this.usage(null);
            }
            if ("-verbose".equals(arg)) {
                CommonShell.this.setVerbose(true);
            } else if ("-debug".equals(arg)) {
                CommonShell.this.setDebug(true);
            } else if ("-hidden".equals(arg)) {
                CommonShell.this.setHidden(true);
            } else if ("-json".equals(arg)) {
                CommonShell.this.setJson(true);
            } else if (!this.checkExtraHiddenFlag(arg)) {
                if (!this.hasNonHiddenArg) {
                    this.hasNonHiddenArg = true;
                }
                return false;
            }
            if (CommonShell.this.commandToRun != null) {
                this.addToCommand(arg);
            }
            return true;
        }

        protected boolean checkExtraHiddenFlag(String arg) {
            return false;
        }

        private void checkRequiredFlag(String arg) {
            if (this.reqFlags == null || this.reqFlags.isEmpty()) {
                return;
            }
            if (this.reqFlags.contains(arg)) {
                this.reqFlags.remove(arg);
            }
        }

        private void addHelperHosts(String arg) {
            CommonShell.this.helperHosts = new ArrayList();
            String[] hostports = arg.split(",");
            CommonShell.this.helperHosts.addAll(Arrays.asList(hostports));
        }

        private void addToCommand(String arg) {
            if (CommonShell.this.commandToRun == null) {
                CommonShell.this.commandToRun = new String[this.getNRemainingArgs() + 1];
            }
            CommonShell.this.commandToRun[((CommonShell)CommonShell.this).nextCommandIdx++] = arg;
        }

        @Override
        public String getHostname() {
            return CommonShell.this.storeHostname;
        }

        @Override
        public int getRegistryPort() {
            return CommonShell.this.storePort;
        }

        @Override
        public String getStoreName() {
            return CommonShell.this.kvstoreName;
        }

        @Override
        public String getUserName() {
            return CommonShell.this.storeUser;
        }

        @Override
        public String getSecurityFile() {
            return CommonShell.this.storeSecurityFile;
        }

        public List<String> getHelperHosts() {
            return CommonShell.this.helperHosts;
        }
    }
}

