/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.util.shell;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.time.Instant;
import oracle.kv.util.shell.Shell;

public class FileHistoryProxy
implements InvocationHandler {
    private static final String ADD_METHOD = "add";
    private final Object obj;
    private final String[] maskFlags;

    public static Object create(Object obj, String[] maskFlags) {
        return Proxy.newProxyInstance(obj.getClass().getClassLoader(), obj.getClass().getInterfaces(), (InvocationHandler)new FileHistoryProxy(obj, maskFlags));
    }

    private FileHistoryProxy(Object obj, String[] maskFlags) {
        this.obj = obj;
        assert (maskFlags != null && maskFlags.length > 0);
        this.maskFlags = maskFlags;
    }

    @Override
    public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
        if (this.isAddMethod(m) && args != null && args.length > 0) {
            int idx = args.length - 1;
            args[idx] = Shell.toHistoryLine((String)args[idx], this.maskFlags);
        }
        return m.invoke(this.obj, args);
    }

    private boolean isAddMethod(Method m) {
        return m.getName().equals(ADD_METHOD) && m.getParameterCount() == 1 && m.getParameterTypes()[0] == String.class || m.getParameterCount() == 2 && m.getParameterTypes()[0] == Instant.class && m.getParameterTypes()[1] == String.class;
    }
}

