/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.util.shell;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.kv.FaultException;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldValue;
import oracle.kv.table.Row;
import oracle.kv.table.Table;
import oracle.kv.table.TableAPI;
import oracle.kv.table.WriteOptions;

public class LoadTableUtils {
    private static final char LEFT_CURLY_BRACE = '{';
    private static final char RIGHT_CURLY_BRACE = '}';
    private static final char DOUBLE_QUOTE = '\"';
    private static final char ESCAPE = '\\';

    public static Map<String, Long> loadJsonFromFile(TableAPI tableImpl, String fileName, WriteOptions options) throws IllegalArgumentException, IOException, FaultException {
        return LoadTableUtils.loadJsonFromFile(tableImpl, null, fileName, options);
    }

    public static Map<String, Long> loadJsonFromFile(TableAPI tableImpl, Table table, String fileName, WriteOptions options) throws IllegalArgumentException, IOException, FaultException {
        return new Loader(tableImpl).loadJsonToTables(table, fileName, options, true);
    }

    public static Map<String, Long> loadCSVFromFile(TableAPI tableImpl, String fileName, WriteOptions options) throws IllegalArgumentException, IOException, FaultException {
        return LoadTableUtils.loadCSVFromFile(tableImpl, null, fileName, options);
    }

    public static Map<String, Long> loadCSVFromFile(TableAPI tableImpl, Table table, String fileName, WriteOptions options) throws IllegalArgumentException, IOException, RuntimeException {
        return new Loader(tableImpl).loadCSVToTables(table, fileName, options, true);
    }

    public static class Loader {
        private final TableAPI tableImpl;

        public Loader(TableAPI tableImpl) {
            this.tableImpl = tableImpl;
        }

        public Map<String, Long> loadJsonToTables(Table table, String fileName, WriteOptions options, boolean exitOnFailure) throws IllegalArgumentException, IOException, FaultException {
            return this.loadRecordsFromFile(table, fileName, Type.JSON, options, false, exitOnFailure);
        }

        public long loadJsonToTable(Table table, String fileName, WriteOptions options, boolean exitOnFailure) throws IllegalArgumentException, IOException, FaultException {
            Map<String, Long> results = this.loadRecordsFromFile(table, fileName, Type.JSON, options, true, exitOnFailure);
            if (results.isEmpty()) {
                return 0L;
            }
            String tableName = table.getFullName();
            assert (results.containsKey(tableName));
            return results.get(tableName);
        }

        public Map<String, Long> loadCSVToTables(Table table, String fileName, WriteOptions options, boolean exitOnFailure) throws IllegalArgumentException, IOException, FaultException {
            return this.loadRecordsFromFile(table, fileName, Type.CSV, options, false, exitOnFailure);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<String, Long> loadRecordsFromFile(Table table, String fileName, Type type, WriteOptions options, boolean targetTableOnly, boolean exitOnFailure) throws IllegalArgumentException, IOException, FaultException {
            assert (!targetTableOnly || table != null);
            if (!new File(fileName).exists()) {
                throw new FileNotFoundException("File not found: " + fileName);
            }
            if (type == Type.CSV) {
                for (String fname : table.getFields()) {
                    FieldDef fdef = table.getField(fname);
                    if (!fdef.isComplex()) continue;
                    String fmt = "The table \"%s\" contains a complex field \"%s\" that cannot be imported as CSV format";
                    throw new IllegalArgumentException(String.format("The table \"%s\" contains a complex field \"%s\" that cannot be imported as CSV format", table.getFullName(), fname));
                }
            }
            BufferedReader br = null;
            try {
                String line;
                Table target = table;
                Row row = null;
                StringBuilder buffer = new StringBuilder();
                long nLoaded = 0L;
                long nLine = 0L;
                int nCurlyBrace = 0;
                boolean skipLine = false;
                HashMap<String, Long> result = new HashMap<String, Long>();
                br = new BufferedReader(new FileReader(fileName));
                while ((line = br.readLine()) != null) {
                    String rowLine;
                    ++nLine;
                    if (this.isComment(line)) continue;
                    String name = Loader.parseTableName(line);
                    if (name != null) {
                        if (targetTableOnly) {
                            skipLine = !target.getFullName().equalsIgnoreCase(name);
                            continue;
                        }
                        Table newTable = this.tableImpl.getTable(name);
                        if (newTable != null) {
                            if (target != null) {
                                Loader.tallyCount(result, target, nLoaded);
                                nLoaded = 0L;
                            }
                            target = newTable;
                            skipLine = false;
                            continue;
                        }
                        if (exitOnFailure) {
                            String fmt = "Table %s (at line %s) not found.";
                            throw new IllegalArgumentException(String.format("Table %s (at line %s) not found.", name, nLine));
                        }
                        skipLine = true;
                        continue;
                    }
                    if (skipLine) continue;
                    if (target == null) {
                        String fmt = "Missing table specification \"Table: <name>\" before record at line %d of %s";
                        throw new IllegalArgumentException(String.format("Missing table specification \"Table: <name>\" before record at line %d of %s", nLine, fileName));
                    }
                    if (type == Type.JSON) {
                        buffer.append(line);
                        if ((nCurlyBrace += Loader.getUnmatchedCurlyBraces(line)) != 0) continue;
                        rowLine = buffer.toString().trim();
                        if (!this.isValidJsonString(rowLine) && exitOnFailure) {
                            String fmt = "Invalid JSON string at line %d of %s: %s";
                            throw new IllegalArgumentException(String.format("Invalid JSON string at line %d of %s: %s", nLine, fileName, rowLine));
                        }
                        buffer.setLength(0);
                    } else {
                        rowLine = line;
                    }
                    try {
                        row = this.createRow(target, rowLine, type);
                        if (this.doPut(this.tableImpl, row, options)) {
                            ++nLoaded;
                            continue;
                        }
                        if (!exitOnFailure) continue;
                        break;
                    }
                    catch (RuntimeException rte) {
                        if (!exitOnFailure) continue;
                        String fmt = "Failed to import JSON row at line %d of file, %s: " + rte.getMessage();
                        throw new RuntimeException(String.format(fmt, nLine, fileName), rte);
                    }
                }
                if (buffer.length() > 0) {
                    assert (type == Type.JSON);
                    if (exitOnFailure) {
                        throw new IllegalArgumentException("Invalid JSON string: " + buffer.toString());
                    }
                }
                if (target != null) {
                    Loader.tallyCount(result, target, nLoaded);
                }
                HashMap<String, Long> hashMap = result;
                return hashMap;
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }

        private Row createRow(Table table, String str, Type type) {
            if (type == Type.JSON) {
                return this.createRowFromJson(table, str);
            }
            return this.createRowFromCSV(table, str);
        }

        public Row createRowFromJson(Table table, String str) {
            return table.createRowFromJson(str, false);
        }

        public Row createRowFromCSV(Table table, String str) {
            List<String> fnames;
            String[] values = Loader.splitCSVValues(str);
            if (values.length != (fnames = table.getFields()).size()) {
                String fmt = "Invalid record for table %s, the number of values is expected to be %d but %d: %s";
                throw new IllegalArgumentException(String.format("Invalid record for table %s, the number of values is expected to be %d but %d: %s", table.getFullName(), fnames.size(), values.length, str));
            }
            Row row = table.createRow();
            for (int i = 0; i < values.length; ++i) {
                String sval = values[i];
                String fname = fnames.get(i);
                FieldDef fdef = table.getField(fname);
                assert (!fdef.isComplex());
                if (Loader.isCSVNullValue(sval)) {
                    row.putNull(fname);
                    continue;
                }
                if (fdef.isString() || fdef.isEnum()) {
                    sval = Loader.trimQuotes(sval);
                }
                FieldValue fval = FieldDefImpl.createValueFromString(sval, fdef);
                row.put(fname, fval);
            }
            return row;
        }

        public boolean doPut(TableAPI tableAPIImpl, Row row, WriteOptions wro) {
            return tableAPIImpl.put(row, null, wro) != null;
        }

        private static void tallyCount(Map<String, Long> result, Table table, long count) {
            if (table == null || count == 0L) {
                return;
            }
            String name = table.getFullName();
            if (result.containsKey(name)) {
                long total = result.get(name) + count;
                result.put(name, total);
            } else {
                result.put(name, count);
            }
        }

        private boolean isComment(String line) {
            String str = line.trim();
            if (str.length() == 0) {
                return true;
            }
            int commentIdx = str.indexOf("#");
            return commentIdx == 0;
        }

        private static String parseTableName(String line) {
            String[] tokens = new String[]{"table", ":"};
            String str = line.trim();
            for (String token : tokens) {
                if (!str.toLowerCase().startsWith(token)) {
                    return null;
                }
                str = str.substring(token.length()).trim();
            }
            return str;
        }

        private static boolean isCSVNullValue(String value) {
            return value.isEmpty();
        }

        private static String[] splitCSVValues(String line) {
            String tline = line.trim();
            String[] values = tline.split(",(?=([^\"]*\"[^\"]*\")*[^\"]*$)", -1);
            for (int i = 0; i < values.length; ++i) {
                values[i] = values[i].trim();
            }
            return values;
        }

        private static String trimQuotes(String value) {
            String str = value.trim();
            if (str.startsWith("\"") && str.endsWith("\"")) {
                str = str.substring(1, str.length() - 1);
            }
            return str;
        }

        private static int getUnmatchedCurlyBraces(String line) {
            int cnt = 0;
            boolean inQuotes = false;
            char prev = '\u0000';
            for (int i = 0; i < line.length(); ++i) {
                char ch = line.charAt(i);
                switch (ch) {
                    case '{': {
                        if (inQuotes) break;
                        ++cnt;
                        break;
                    }
                    case '}': {
                        if (inQuotes) break;
                        --cnt;
                        break;
                    }
                    case '\"': {
                        if (prev == '\\') break;
                        inQuotes = !inQuotes;
                        break;
                    }
                }
                prev = ch;
            }
            return cnt;
        }

        private boolean isValidJsonString(String str) {
            assert (str != null && !str.isEmpty());
            if (str.indexOf(123) != 0) {
                return false;
            }
            return str.lastIndexOf(125) == str.length() - 1;
        }
    }

    private static enum Type {
        JSON,
        CSV;

    }
}

