/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.util.shell;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.TimeUnit;
import oracle.kv.KVSecurityException;
import oracle.kv.impl.admin.CommandJsonUtils;
import oracle.kv.impl.admin.CommandResult;
import oracle.kv.impl.util.CommandParser;
import oracle.kv.impl.util.JsonUtils;
import oracle.kv.util.ErrorMessage;
import oracle.kv.util.shell.CommandNotFoundException;
import oracle.kv.util.shell.CommandWithSubs;
import oracle.kv.util.shell.ShellArgumentException;
import oracle.kv.util.shell.ShellCommand;
import oracle.kv.util.shell.ShellCommandResult;
import oracle.kv.util.shell.ShellException;
import oracle.kv.util.shell.ShellHelpException;
import oracle.kv.util.shell.ShellInputReader;
import oracle.kv.util.shell.ShellUsageException;

public abstract class Shell {
    protected final InputStream input;
    protected final PrintStream output;
    private ShellInputReader inputReader = null;
    protected final CommandHistory history;
    protected int exitCode;
    protected boolean showDeprecated = false;
    private VariablesMap shellVariables = null;
    protected Stack<ShellCommand> stCurrentCommands = null;
    protected boolean isSecured = false;
    private final Timer timer;
    private ShellCommand generalCommand = null;
    public static final String tab = "\t";
    public static final String eol = System.getProperty("line.separator");
    public static final String eolt = eol + "\t";
    public static final String INCLUDE_DEPRECATED_FLAG = "-include-deprecated";
    public static final int EXIT_OK = 0;
    public static final int EXIT_USAGE = 64;
    public static final int EXIT_INPUTERR = 65;
    public static final int EXIT_UNKNOWN = 1;
    public static final int EXIT_NOPERM = 77;
    private static final char MASK = '*';
    private boolean verbose = false;
    private boolean debug = false;
    private boolean hidden = false;
    private boolean globalVerbose = false;
    private boolean globalDebug = false;
    private boolean globalHidden = false;
    protected boolean globalJson = false;
    protected boolean json = false;
    protected boolean jsonV1 = false;
    private boolean timing = false;
    private boolean terminate = false;
    private static final char LINE_TERMINATOR = ';';
    private static final char LINE_JOINER = '\\';
    public static final String COMMENT_MARK = "#";
    private final boolean disableJlineEventDesignator;
    private final String[] maskFlags;

    public abstract List<? extends ShellCommand> getCommands();

    public abstract String getPrompt();

    public abstract String getUsageHeader();

    public abstract void init();

    public abstract void shutdown();

    public Shell(InputStream input, PrintStream output) {
        this(input, output, true);
    }

    public Shell(InputStream input, PrintStream output, boolean disableJlineEventDesignator) {
        this(input, output, disableJlineEventDesignator, null);
    }

    public Shell(InputStream input, PrintStream output, boolean disableJlineEventDesignator, String[] maskFlags) {
        this.input = input;
        this.output = output;
        this.history = new CommandHistory();
        this.stCurrentCommands = new Stack();
        this.shellVariables = new VariablesMap();
        this.timer = new Timer();
        this.disableJlineEventDesignator = disableJlineEventDesignator;
        this.maskFlags = maskFlags;
    }

    public String getUsage() {
        String usage = this.getUsageHeader();
        for (ShellCommand shellCommand : this.getCommands()) {
            String help;
            if (!this.getHidden() && shellCommand.isHidden() || !this.showDeprecated() && shellCommand.isDeprecated() || (help = shellCommand.getCommandName()) == null) continue;
            usage = usage + tab + help + eol;
        }
        return usage;
    }

    public void setShowDeprecated(boolean showDeprecated) {
        this.showDeprecated = showDeprecated;
    }

    public boolean showDeprecated() {
        return this.showDeprecated;
    }

    public void prompt() {
        String prompt = this.getPrompt();
        if (prompt != null) {
            this.output.print(prompt);
        }
    }

    public void pushCurrentCommand(ShellCommand command) {
        this.stCurrentCommands.push(command);
    }

    public ShellCommand getCurrentCommand() {
        if (this.stCurrentCommands.size() > 0) {
            return this.stCurrentCommands.peek();
        }
        return null;
    }

    public void popCurrentCommand() {
        this.stCurrentCommands.pop();
    }

    public String getCurrentCommandPropmt() {
        ShellCommand command = this.getCurrentCommand();
        if (command == null) {
            return null;
        }
        Iterator it = this.stCurrentCommands.iterator();
        StringBuilder sb = new StringBuilder();
        while (it.hasNext()) {
            ShellCommand cmd = (ShellCommand)it.next();
            if (cmd.getPrompt() == null) continue;
            if (sb.length() > 0) {
                sb.append(".");
            }
            sb.append(cmd.getPrompt());
        }
        if (sb.length() > 0) {
            sb.append("-> ");
        }
        return sb.toString();
    }

    public void addVariable(String name, Object value) {
        this.shellVariables.add(name, value);
    }

    public Object getVariable(String name) {
        return this.shellVariables.get(name);
    }

    public Set<Map.Entry<String, Object>> getAllVariables() {
        return this.shellVariables.getAll();
    }

    public void removeVariable(String name) {
        this.shellVariables.remove(name);
    }

    public void removeAllVariables() {
        this.shellVariables.reset();
    }

    public boolean doRetry() {
        return false;
    }

    public boolean handleShellException(String line, ShellException se) {
        if (this.doRetry()) {
            return true;
        }
        CommandResult cmdResult = se.getCommandResult();
        if (se instanceof ShellHelpException) {
            this.history.add(line, null);
            this.displayResultReport(line, cmdResult, ((ShellHelpException)se).getVerboseHelpMessage());
            this.exitCode = 64;
            return false;
        }
        if (se instanceof ShellUsageException) {
            this.history.add(line, null);
            ShellUsageException sue = (ShellUsageException)se;
            this.displayResultReport(line, cmdResult, sue.getMessage() + System.getProperty("line.separator") + sue.getVerboseHelpMessage());
            this.exitCode = 64;
            return false;
        }
        if (se instanceof ShellArgumentException) {
            this.history.add(line, null);
            this.displayResultReport(line, cmdResult, se.getMessage());
            this.exitCode = 65;
            return false;
        }
        this.history.add(line, se);
        String message = "Error handling command " + line + ": " + se.getMessage();
        this.exitCode = 1;
        this.displayResultReport(line, cmdResult, message);
        if (this.getDebug()) {
            se.printStackTrace(this.output);
        }
        return false;
    }

    public void handleUnknownException(String line, Exception e) {
        this.history.add(line, e);
        this.exitCode = 1;
        CommandResult.CommandFails cmdResult = new CommandResult.CommandFails(e.getMessage(), ErrorMessage.NOSQL_5500, CommandResult.NO_CLEANUP_JOBS);
        this.displayResultReport(line, cmdResult, "Unknown Exception: " + e.getClass());
        if (this.getDebug()) {
            e.printStackTrace(this.output);
        }
    }

    public boolean handleKVSecurityException(String line, KVSecurityException kvse) {
        this.history.add(line, kvse);
        CommandResult.CommandFails cmdResult = new CommandResult.CommandFails(kvse.getMessage(), ErrorMessage.NOSQL_5100, CommandResult.NO_CLEANUP_JOBS);
        this.displayResultReport(line, cmdResult, "Error handling command " + line + ": " + kvse.getMessage());
        if (this.getDebug()) {
            kvse.printStackTrace(this.output);
        }
        this.exitCode = 77;
        return false;
    }

    public void verboseOutput(String msg) {
        if (this.verbose || this.globalVerbose) {
            this.output.println(msg);
        }
    }

    public void setTerminate() {
        this.terminate = true;
    }

    public boolean getTerminate() {
        return this.terminate;
    }

    public void setGeneralCommand(ShellCommand command) {
        this.generalCommand = command;
    }

    private ShellCommand getGeneralCommand() {
        return this.generalCommand;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loop() {
        block15: {
            try {
                this.inputReader = new ShellInputReader(this);
                this.inputReader.setDefaultPrompt(this.getPrompt());
                CommandLinesParser clp = new CommandLinesParser(this);
                while (!this.terminate) {
                    String promptDef = this.inputReader.getDefaultPrompt();
                    boolean multiLineInput = false;
                    do {
                        String line;
                        String prompt = this.getCurrentCommandPropmt();
                        if (multiLineInput) {
                            int len = prompt != null ? prompt.length() : promptDef.length();
                            prompt = String.format("%" + len + "s", "-> ");
                        }
                        try {
                            line = this.inputReader.readLine(prompt);
                        }
                        catch (IOException ioe) {
                            this.echo("Exception reading input: " + ioe + eol);
                            continue;
                        }
                        if (line == null) {
                            if (multiLineInput) {
                                clp.reset();
                                this.output.println();
                                break;
                            }
                            break block15;
                        }
                        try {
                            clp.appendLine(line);
                        }
                        catch (Exception e) {
                            String[] commands = clp.getCommands();
                            assert (commands.length == 1);
                            this.handleExecuteException(commands[0], e);
                            clp.reset();
                            break;
                        }
                        if (multiLineInput) continue;
                        multiLineInput = true;
                    } while (!clp.complete());
                    String[] commands = clp.getCommands();
                    if (commands != null) {
                        for (String command : commands) {
                            this.execute(command);
                        }
                    }
                    clp.reset();
                }
            }
            finally {
                this.inputReader.shutdown();
                this.shutdown();
            }
        }
    }

    public void println(String msg) {
        this.output.println(msg);
    }

    public void execute(String line) {
        if ((line = line.trim()).length() == 0) {
            return;
        }
        try {
            this.runLine(line);
        }
        catch (Exception e) {
            this.handleExecuteException(line, e);
        }
    }

    private void handleExecuteException(String command, Exception e) {
        block6: {
            try {
                if (e instanceof KVSecurityException) {
                    KVSecurityException kvse = (KVSecurityException)e;
                    if (this.handleKVSecurityException(command, kvse)) {
                        this.runLine(command);
                    }
                    break block6;
                }
                throw e;
            }
            catch (ShellException se) {
                if (this.handleShellException(command, (ShellException)e)) {
                    this.execute(command);
                }
            }
            catch (Exception ex) {
                this.handleUnknownException(command, ex);
            }
        }
    }

    public ShellCommand findCommand(String commandName) {
        for (ShellCommand shellCommand : this.getCommands()) {
            if (!shellCommand.matches(commandName)) continue;
            return shellCommand;
        }
        return null;
    }

    public static String[] extractArg(String[] args, String arg) {
        String[] retArgs = new String[args.length - 1];
        int i = 0;
        for (String s : args) {
            if (arg.equals(s)) continue;
            retArgs[i++] = s;
        }
        return retArgs;
    }

    public String[] checkCommonFlags(String[] args) {
        this.verbose = false;
        this.debug = false;
        this.hidden = false;
        if (Shell.checkArg(args, "-verbose")) {
            this.verbose = true;
            args = Shell.extractArg(args, "-verbose");
        }
        if (Shell.checkArg(args, "-debug")) {
            this.debug = true;
            args = Shell.extractArg(args, "-debug");
        }
        if (Shell.checkArg(args, "-hidden")) {
            this.hidden = true;
            args = Shell.extractArg(args, "-hidden");
        }
        return args;
    }

    protected String[] checkJson(String[] args) throws ShellException {
        this.json = false;
        this.jsonV1 = false;
        if (args == null || args.length == 0) {
            return args;
        }
        ShellCommand command = this.findCommand(args[0]);
        if (command != null && command.overrideJsonFlag()) {
            return args;
        }
        String[] retArgs = args;
        this.json = Shell.checkArg(args, "-json");
        this.jsonV1 = Shell.checkArg(args, "-json-v1");
        if (this.json && this.jsonV1) {
            throw new ShellArgumentException("cannot specify -json and -json-v1 together");
        }
        if (this.json) {
            retArgs = Shell.extractArg(args, "-json");
        } else if (this.jsonV1) {
            retArgs = Shell.extractArg(args, "-json-v1");
        }
        return retArgs;
    }

    public String[] parseLine(String line) {
        return this.parseLine(line, false);
    }

    protected String[] parseLine(String line, boolean checkQuotesMatch) {
        ArrayList<String> words = new ArrayList<String>();
        StreamTokenizer st = new StreamTokenizer(new StringReader(this.adjustLineToParse(line)));
        st.resetSyntax();
        st.whitespaceChars(0, 32);
        st.wordChars(33, 255);
        st.quoteChar(34);
        st.quoteChar(39);
        st.commentChar(35);
        try {
            while (true) {
                int tokenType;
                if ((tokenType = st.nextToken()) == -3) {
                    words.add(st.sval);
                    continue;
                }
                if (tokenType == 39 || tokenType == 34) {
                    String sVal = st.sval;
                    words.add(sVal);
                    if (words.size() <= 1 || !checkQuotesMatch) continue;
                    if (st.nextToken() == -1) {
                        String quote = String.valueOf((char)tokenType);
                        if (sVal.length() == 0 || !line.endsWith(quote)) {
                            throw new RuntimeException("Except to found " + quote + " after " + st.sval + ", but not found");
                        }
                    }
                    st.pushBack();
                    continue;
                }
                if (tokenType == -2) {
                    this.echo("Unexpected numeric token!" + eol);
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
        }
        return words.toArray(new String[words.size()]);
    }

    private String adjustLineToParse(String line) {
        StringBuilder sb = new StringBuilder(line);
        boolean inQuotes = false;
        char quote = '\u0000';
        int pos = 0;
        for (int i = 0; i < line.length(); ++i) {
            char ch = line.charAt(i);
            if (!inQuotes) {
                if (ch == '\'' || ch == '\"') {
                    quote = ch;
                    inQuotes = true;
                }
            } else if (ch == quote) {
                inQuotes = false;
            } else if (ch == '\n') {
                sb.insert(pos++, '\\');
            }
            ++pos;
        }
        return sb.toString();
    }

    public void runLine(String line) throws ShellException {
        this.runLine(line, false);
    }

    private void runLine(String line, boolean checkQuotesMatch) throws ShellException {
        this.exitCode = 0;
        if (line.length() > 0 && !Shell.isComment(line)) {
            String result;
            String[] splitArgs;
            try {
                splitArgs = this.parseLine(line, checkQuotesMatch);
            }
            catch (RuntimeException re) {
                throw new ParseLineException(re.getMessage());
            }
            String commandName = splitArgs[0];
            boolean timerEnabled = this.getTimer();
            if (timerEnabled) {
                this.timer.begin();
            }
            if ((result = this.run(commandName, splitArgs, line)) != null) {
                this.output.println(result);
            }
            if (timerEnabled) {
                this.timer.end();
                this.output.println(this.timer.toString());
            }
            this.history.add(line, null);
        }
    }

    public String run(String commandName, String[] args) throws ShellException {
        return this.run(commandName, args, null);
    }

    protected String run(String commandName, String[] args, String line) throws ShellException {
        ShellCommand command = null;
        String[] cmdArgs = null;
        command = this.getCurrentCommand();
        if (command != null) {
            cmdArgs = new String[args.length + 1];
            cmdArgs[0] = command.getCommandName();
            System.arraycopy(args, 0, cmdArgs, 1, args.length);
        } else {
            command = this.findCommand(commandName);
            cmdArgs = args;
        }
        ShellCommand genCommand = this.getGeneralCommand();
        cmdArgs = this.checkJson(cmdArgs);
        if (command != null) {
            cmdArgs = this.checkCommonFlags(cmdArgs);
            try {
                String result = command.execute(cmdArgs, this, line);
                this.exitCode = command.getExitCode();
                return result;
            }
            catch (CommandNotFoundException cnfe) {
                if (genCommand == null) {
                    throw cnfe;
                }
            }
        } else if (genCommand == null) {
            throw new ShellArgumentException("Could not find command: " + commandName + eol + this.getUsage());
        }
        String cmdLine = line != null ? line : this.joinWithSpace(args);
        String result = genCommand.execute(new String[]{cmdLine}, this);
        this.exitCode = genCommand.getExitCode();
        return result;
    }

    private String joinWithSpace(String[] args) {
        StringBuilder sb = new StringBuilder();
        for (String arg : args) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(arg);
        }
        return sb.toString();
    }

    public boolean getVerbose() {
        return this.verbose || this.globalVerbose;
    }

    public void setVerbose(boolean val) {
        this.globalVerbose = val;
    }

    public boolean toggleVerbose() {
        this.globalVerbose = !this.globalVerbose;
        return this.globalVerbose;
    }

    public boolean getDebug() {
        return this.debug || this.globalDebug;
    }

    void setDebug(boolean val) {
        this.globalDebug = val;
    }

    public boolean toggleDebug() {
        this.globalDebug = !this.globalDebug;
        return this.globalDebug;
    }

    public boolean getHidden() {
        return this.hidden || this.globalHidden;
    }

    protected void setHidden(boolean val) {
        this.globalHidden = val;
    }

    protected boolean toggleHidden() {
        this.globalHidden = !this.globalHidden;
        return this.globalHidden;
    }

    public boolean getJson() {
        return this.json || this.globalJson || this.jsonV1;
    }

    public boolean getJsonV1() {
        return this.jsonV1;
    }

    public void setJson(boolean val) {
        this.globalJson = val;
    }

    public PrintStream getOutput() {
        return this.output;
    }

    public ShellInputReader getInput() {
        return this.inputReader;
    }

    public void setTimer(boolean val) {
        this.timing = val;
    }

    public boolean getTimer() {
        return this.timing;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public CommandHistory getHistory() {
        return this.history;
    }

    public static String nextArg(String[] args, int index, ShellCommand cmd) throws ShellException {
        if (++index < args.length) {
            return args[index];
        }
        throw new ShellUsageException("Flag " + args[index - 1] + " requires an argument", cmd, true);
    }

    public void unknownArgument(String arg, ShellCommand command) throws ShellException {
        String msg = "Unknown argument: " + arg;
        throw new ShellUsageException(msg, command);
    }

    public void badArgCount(ShellCommand command) throws ShellException {
        String msg = "Incorrect number of arguments for command: " + command.getCommandName();
        throw new ShellUsageException(msg, command, true);
    }

    public void badArgUsage(String arg, String info, ShellCommand command) throws ShellException {
        String msg = "Invalid usage of the " + arg + " argument to the command: " + command.getCommandName();
        if (info != null && !info.isEmpty()) {
            msg = msg + " - " + info;
        }
        throw new ShellUsageException(msg, command);
    }

    public void requiredArg(String arg, ShellCommand command) throws ShellException {
        String msg = "Missing required argument" + (arg != null ? " (" + arg + ")" : "") + " for command: " + command.getCommandName();
        throw new ShellUsageException(msg, command, true);
    }

    public void displayResultReport(String command, CommandResult cmdResult, String nonJsonDesc) {
        if (this.getJsonV1()) {
            this.output.println(Shell.toJsonReport(command, cmdResult));
            return;
        }
        if (this.getJson()) {
            this.output.println(ShellCommandResult.toJsonReport(command, cmdResult));
            return;
        }
        this.output.println(nonJsonDesc);
    }

    public boolean isJlineEventDesignatorDisabled() {
        return this.disableJlineEventDesignator;
    }

    public String[] getMaskFlags() {
        return this.maskFlags;
    }

    public static String makeWhiteSpace(int indent) {
        String ret = "";
        for (int i = 0; i < indent; ++i) {
            ret = ret + " ";
        }
        return ret;
    }

    public static String getCommandSyntax(ShellCommand sc) {
        return sc.getCommandSyntax();
    }

    public static String getCommandDescription(ShellCommand sc) {
        return sc.getCommandDescription();
    }

    public static void checkHelp(String[] args, ShellCommand command) throws ShellException {
        for (String s : args) {
            if (!Shell.isHelpFlag(s)) continue;
            throw new ShellHelpException(command);
        }
    }

    static boolean isHelpFlag(String flag) {
        String sl = flag.toLowerCase();
        return sl.equals("-help") || sl.equals("help") || sl.equals("?") || sl.equals("-?");
    }

    public static boolean checkArg(String[] args, String arg) {
        for (String s : args) {
            String sl = s.toLowerCase();
            if (!sl.equals(arg)) continue;
            return true;
        }
        return false;
    }

    public static String getArg(String[] args, String arg) {
        boolean returnNext = false;
        for (String s : args) {
            if (returnNext) {
                return s;
            }
            String sl = s.toLowerCase();
            if (!sl.equals(arg)) continue;
            returnNext = true;
        }
        return null;
    }

    public static boolean matches(String inputName, String commandName) {
        return Shell.matches(inputName, commandName, 0);
    }

    public static boolean matches(String inputName, String commandName, int prefixMatchLength) {
        if (inputName.length() < prefixMatchLength) {
            return false;
        }
        if (prefixMatchLength > 0) {
            String match = inputName.toLowerCase();
            return commandName.toLowerCase().startsWith(match);
        }
        return commandName.toLowerCase().equals(inputName.toLowerCase());
    }

    public static String toJsonReport(String command, CommandResult cmdResult) {
        try {
            return CommandJsonUtils.getJsonResultString((String)command, (CommandResult)cmdResult);
        }
        catch (IOException e) {
            return "{" + eolt + "\"operation\" : \"create json output\"," + eolt + "\"return_code\" : 5500," + eolt + "\"description\" : \"IOException in generating JSON format result: " + e.getMessage() + "\"," + eolt + "\"cmd_cleanup_job\" : []" + eolt + "}";
        }
    }

    public static boolean isComment(String line) {
        return line.startsWith(COMMENT_MARK);
    }

    public void echo(String msg) {
        if (!this.getJson()) {
            this.output.print(msg);
        }
    }

    static String toHistoryLine(String line, String[] maskFlags) {
        assert (line != null);
        if (line.length() == 0 || maskFlags == null) {
            return line;
        }
        StringBuilder sb = new StringBuilder();
        String s = line;
        for (String flag : maskFlags) {
            boolean ignoreCase = !flag.startsWith("-");
            flag = " " + flag + " ";
            int pos = 0;
            while (pos < s.length() && (pos = Shell.findString(s, flag, pos, ignoreCase)) >= 0) {
                if ((pos += flag.length()) >= s.length()) continue;
                sb.setLength(0);
                pos = Shell.maskWord(sb, s, pos);
                s = sb.toString();
            }
        }
        return s;
    }

    private static int findString(String line, String str, int fromIndex, boolean ignoreCase) {
        return ignoreCase ? line.toLowerCase().indexOf(str.toLowerCase(), fromIndex) : line.indexOf(str, fromIndex);
    }

    private static int maskWord(StringBuilder sb, String s, int index) {
        sb.append(s.substring(0, index));
        char stop = s.charAt(index);
        if (stop == '\'' || stop == '\"') {
            sb.append(stop);
            ++index;
        } else {
            stop = ' ';
        }
        while (index < s.length()) {
            char ch;
            if ((ch = s.charAt(index++)) == stop || index == s.length() && ch == ';') {
                if (ch == '\'' || ch == '\"') {
                    sb.append(ch);
                    break;
                }
                --index;
                break;
            }
            sb.append('*');
        }
        int nextFrom = sb.length();
        if (index < s.length()) {
            sb.append(s.substring(index));
        }
        return nextFrom;
    }

    private static class Timer {
        private long time = 0L;

        Timer() {
        }

        void begin() {
            this.time = this.getWallClockTime();
        }

        void end() {
            this.time = this.getWallClockTime() - this.time;
        }

        private long getWallClockTime() {
            return System.currentTimeMillis();
        }

        public String toString() {
            String fmt = "\nTime: %,dsec %dms";
            long sec = TimeUnit.SECONDS.convert(this.time, TimeUnit.MILLISECONDS);
            long ms = this.time - TimeUnit.MILLISECONDS.convert(sec, TimeUnit.SECONDS);
            return String.format("\nTime: %,dsec %dms", sec, ms);
        }
    }

    private static class CommandLinesParser {
        private static String HELP_COMMAND = "?";
        private final Shell shell;
        private final StringBuilder sb;
        private ParseState state;

        CommandLinesParser(Shell shell) {
            this.shell = shell;
            this.sb = new StringBuilder();
            this.state = ParseState.SINGLE_LINE;
        }

        void appendLine(String line) throws Exception {
            boolean endWithTerm;
            String command = line.trim();
            if (command.length() == 0) {
                if (this.state == ParseState.SINGLE_LINE) {
                    this.state = ParseState.PARSE_DONE_EXECUTED;
                }
                return;
            }
            if (command.equalsIgnoreCase(HELP_COMMAND)) {
                this.sb.append(" ");
                this.sb.append(HELP_COMMAND);
                this.state = ParseState.PARSE_DONE;
                return;
            }
            char ending = command.charAt(command.length() - 1);
            boolean endWithCont = ending == '\\';
            boolean bl = endWithTerm = ending == ';';
            if (endWithCont && !(command = command.substring(0, command.length() - 1)).endsWith(" ")) {
                command = command + " ";
            }
            if (this.state == ParseState.MULTI_LINE_TERM) {
                this.sb.append("\n");
            }
            this.sb.append(command);
            if (endWithTerm) {
                this.state = ParseState.PARSE_DONE;
                return;
            }
            String cmdToExecute = null;
            switch (this.state) {
                case SINGLE_LINE: {
                    if (endWithCont) {
                        this.state = ParseState.MULTI_LINE_CONT;
                        break;
                    }
                    String[] commands = this.parseCommandLines(this.sb.toString());
                    if (commands.length > 1) {
                        this.state = ParseState.MULTI_LINE_TERM;
                        break;
                    }
                    cmdToExecute = commands[0];
                    break;
                }
                case MULTI_LINE_CONT: {
                    if (endWithCont) break;
                    String[] commands = this.parseCommandLines(this.sb.toString());
                    if (commands.length > 1) {
                        this.state = ParseState.MULTI_LINE_TERM;
                        break;
                    }
                    cmdToExecute = commands[0];
                    break;
                }
            }
            if (cmdToExecute != null) {
                try {
                    boolean isCompleted = this.checkCompleted(cmdToExecute);
                    this.state = !isCompleted ? ParseState.MULTI_LINE_TERM : ParseState.PARSE_DONE_EXECUTED;
                }
                catch (Exception e) {
                    this.state = ParseState.PARSE_DONE;
                    throw e;
                }
            }
        }

        boolean complete() {
            return this.state == ParseState.PARSE_DONE || this.state == ParseState.PARSE_DONE_EXECUTED;
        }

        String[] getCommands() {
            return this.getCommands(true);
        }

        String[] getCommands(boolean parseDone) {
            if (!parseDone || this.state == ParseState.PARSE_DONE) {
                return this.parseCommandLines(this.sb.toString());
            }
            return null;
        }

        void reset() {
            this.state = ParseState.SINGLE_LINE;
            this.sb.setLength(0);
        }

        boolean hasCommand() {
            return this.sb.length() > 0;
        }

        private boolean checkCompleted(String command) throws Exception {
            if (Shell.isComment(command)) {
                return true;
            }
            if (this.isMultilineCommand(command)) {
                return false;
            }
            try {
                this.shell.runLine(command, true);
                return true;
            }
            catch (ShellException se) {
                if (se instanceof ParseLineException) {
                    return false;
                }
                if (se instanceof ShellUsageException && ((ShellUsageException)se).requireArgument()) {
                    return false;
                }
                throw se;
            }
            catch (Exception e) {
                throw e;
            }
        }

        private boolean isMultilineCommand(String command) {
            ShellCommand cmd;
            String[] commandArgs = command.split(" ");
            int iArg = 0;
            if ((cmd = this.shell.findCommand(commandArgs[iArg++])) != null) {
                if (cmd instanceof CommandWithSubs) {
                    if (commandArgs.length == 1) {
                        return false;
                    }
                    if ((cmd = ((CommandWithSubs)cmd).findCommand(commandArgs[iArg++])) == null) {
                        return false;
                    }
                }
                if (cmd.isMultilineInput()) {
                    return iArg >= commandArgs.length || !Shell.isHelpFlag(commandArgs[iArg]);
                }
                return false;
            }
            return this.shell.getCurrentCommand() == null && this.shell.getGeneralCommand() != null && this.shell.getGeneralCommand().isMultilineInput();
        }

        private String[] parseCommandLines(String line) {
            String pattern = ";(?=(?:[^'\"]|\"[^\"]*\"|'[^']*')*$)";
            return line.trim().replaceAll(";+$", "").split(pattern);
        }

        private static enum ParseState {
            SINGLE_LINE,
            MULTI_LINE_CONT,
            MULTI_LINE_TERM,
            PARSE_DONE_EXECUTED,
            PARSE_DONE;

        }
    }

    public static class VariablesMap
    implements Cloneable {
        private final HashMap<String, Object> variablesMap = new HashMap();

        public void add(String name, Object value) {
            this.variablesMap.put(name, value);
        }

        public Object get(String name) {
            return this.variablesMap.get(name);
        }

        public Set<Map.Entry<String, Object>> getAll() {
            return this.variablesMap.entrySet();
        }

        public void remove(String name) {
            if (this.variablesMap.containsKey(name)) {
                this.variablesMap.remove(name);
            }
        }

        public int size() {
            return this.variablesMap.size();
        }

        public void reset() {
            this.variablesMap.clear();
        }

        public VariablesMap clone() {
            VariablesMap map = new VariablesMap();
            for (Map.Entry<String, Object> entry : this.variablesMap.entrySet()) {
                map.add(entry.getKey(), entry.getValue());
            }
            return map;
        }

        public String toString() {
            String retString = "";
            for (Map.Entry<String, Object> entry : this.variablesMap.entrySet()) {
                retString = retString + Shell.tab + entry.getKey() + ": " + entry.getValue() + eol;
            }
            return retString;
        }
    }

    public static class CommandComparator
    implements Comparator<ShellCommand> {
        @Override
        public int compare(ShellCommand o1, ShellCommand o2) {
            return o1.getCommandName().compareTo(o2.getCommandName());
        }
    }

    class CommandHistoryElement {
        String command;
        Exception exception;

        public CommandHistoryElement(String command, Exception exception) {
            this.command = command;
            this.exception = exception;
        }

        public String getCommand() {
            return this.command;
        }

        public Exception getException() {
            return this.exception;
        }
    }

    public class CommandHistory {
        private final List<CommandHistoryElement> history1 = new ArrayList<CommandHistoryElement>(100);

        public void add(String command, Exception e) {
            String line = Shell.toHistoryLine(command, Shell.this.getMaskFlags());
            this.history1.add(new CommandHistoryElement(line, e));
        }

        public CommandHistoryElement get(int which) {
            if (this.history1.size() > which) {
                return this.history1.get(which);
            }
            Shell.this.output.println("No such command in history at offset " + which);
            return null;
        }

        public int getSize() {
            return this.history1.size();
        }

        public String dump(int from, int to) {
            from = Math.min(from, this.history1.size());
            to = Math.min(to, this.history1.size() - 1);
            String hist = "";
            for (int i = from; i <= to; ++i) {
                hist = hist + this.dumpCommand(i, false);
            }
            return hist;
        }

        public boolean commandFaulted(int command) {
            CommandHistoryElement cmd = this.history1.get(command);
            return cmd.getException() != null;
        }

        public String dumpCommand(int command, boolean withFault) {
            CommandHistoryElement cmd = this.history1.get(command);
            String res = "";
            res = cmd.getCommand();
            if (withFault && cmd.getException() != null) {
                ByteArrayOutputStream b = new ByteArrayOutputStream();
                cmd.getException().printStackTrace(new PrintWriter(b, true));
                res = res + eolt + b.toString();
            }
            return command + 1 + " " + res + eol;
        }

        public ObjectNode dumpCommandJson(int command, boolean withFault) {
            ObjectNode top = JsonUtils.createObjectNode();
            CommandHistoryElement cmd = this.history1.get(command);
            String res = "";
            res = cmd.getCommand();
            top.put("index", command + 1);
            top.put("name", res);
            if (withFault && cmd.getException() != null) {
                ByteArrayOutputStream b = new ByteArrayOutputStream();
                cmd.getException().printStackTrace(new PrintWriter(b, true));
                top.put("exceptionStack", b.toString());
            }
            return top;
        }

        public String dumpFaultingCommands(int from, int to) {
            from = Math.min(from, this.history1.size());
            to = Math.min(to, this.history1.size() - 1);
            String hist = "";
            for (int i = from; i <= to; ++i) {
                CommandHistoryElement cmd = this.history1.get(i);
                Exception e = cmd.getException();
                if (e == null) continue;
                String res = "";
                res = cmd.getCommand();
                hist = hist + (i + 1) + " " + res + ": " + e.getClass() + eol;
            }
            return hist;
        }

        public ObjectNode dumpFaultingCommandsJson(int from, int to) {
            ObjectNode top = JsonUtils.createObjectNode();
            from = Math.min(from, this.history1.size());
            to = Math.min(to, this.history1.size() - 1);
            ArrayNode faultCommandArray = top.putArray("faultCommands");
            for (int i = from; i <= to; ++i) {
                CommandHistoryElement cmd = this.history1.get(i);
                Exception e = cmd.getException();
                if (e == null) continue;
                String res = "";
                res = cmd.getCommand();
                ObjectNode faultNode = JsonUtils.createObjectNode();
                faultNode.put("index", i + 1);
                faultNode.put("name", res);
                faultNode.put("exceptionClass", e.getClass().toString());
                faultCommandArray.add((JsonNode)faultNode);
            }
            return top;
        }

        public Exception getLastException() {
            for (int i = this.history1.size() - 1; i >= 0; --i) {
                CommandHistoryElement cmd = this.history1.get(i);
                if (cmd.getException() == null) continue;
                return cmd.getException();
            }
            return null;
        }

        public String dumpLastFault() {
            for (int i = this.history1.size() - 1; i >= 0; --i) {
                CommandHistoryElement cmd = this.history1.get(i);
                if (cmd.getException() == null) continue;
                return this.dumpCommand(i, true);
            }
            return "";
        }

        public ObjectNode dumpLastFaultJson() {
            for (int i = this.history1.size() - 1; i >= 0; --i) {
                CommandHistoryElement cmd = this.history1.get(i);
                if (cmd.getException() == null) continue;
                return this.dumpCommandJson(i, true);
            }
            return null;
        }

        public void clear() {
            this.history1.clear();
        }
    }

    public static class ExitCommand
    extends ShellCommand {
        public ExitCommand() {
            super("exit", 2);
        }

        @Override
        protected boolean matches(String commandName) {
            return super.matches(commandName) || Shell.matches(commandName, "quit", 2);
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            shell.setTerminate();
            return "";
        }

        @Override
        public ShellCommandResult executeJsonOutput(String[] args, Shell shell) throws ShellException {
            shell.setTerminate();
            ShellCommandResult scr = ShellCommandResult.getDefault("exit");
            scr.setDescription("exiting shell");
            return scr;
        }

        @Override
        protected String getCommandSyntax() {
            return "exit | quit " + CommandParser.optional("-json");
        }

        @Override
        protected String getCommandDescription() {
            return "Exit the interactive command shell.";
        }
    }

    public static class HelpCommand
    extends ShellCommand {
        public HelpCommand() {
            super("help", 2);
        }

        @Override
        protected boolean matches(String commandName) {
            return "?".equals(commandName) || super.matches(commandName);
        }

        public String[] checkForDeprecatedFlag(String[] args, Shell shell) {
            String[] retArgs = args;
            shell.setShowDeprecated(false);
            if (Shell.checkArg(args, Shell.INCLUDE_DEPRECATED_FLAG)) {
                shell.setShowDeprecated(true);
                retArgs = Shell.extractArg(args, Shell.INCLUDE_DEPRECATED_FLAG);
            }
            return retArgs;
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            if ((args = this.checkForDeprecatedFlag(args, shell)).length == 1) {
                return shell.getUsage();
            }
            String commandName = args[1];
            ShellCommand command = shell.findCommand(commandName);
            if (command != null) {
                return command.getHelp(Arrays.copyOfRange(args, 1, args.length), shell);
            }
            return "Could not find command: " + commandName + eol + shell.getUsage();
        }

        @Override
        public ShellCommandResult executeJsonOutput(String[] args, Shell shell) throws ShellException {
            ShellCommandResult scr = ShellCommandResult.getDefault("help");
            scr.setDescription(this.execute(args, shell));
            return scr;
        }

        @Override
        protected String getCommandSyntax() {
            return "help [command [sub-command]] [-include-deprecated] " + CommandParser.optional("-json");
        }

        @Override
        protected String getCommandDescription() {
            return "Print help messages.  With no arguments the top-level shell commands" + eolt + "are listed.  With additional commands and sub-commands, additional" + eolt + "detail is provided. Will list only those commands that are not" + eolt + "deprecated. To list the deprecated commands as well, use the" + eolt + Shell.INCLUDE_DEPRECATED_FLAG + " flag.";
        }
    }

    public static class LoadCommand
    extends ShellCommand {
        public LoadCommand() {
            super("load", 3);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            Shell.checkHelp(args, this);
            String path = null;
            for (int i = 1; i < args.length; ++i) {
                String arg = args[i];
                if ("-file".equals(arg)) {
                    path = Shell.nextArg(args, i++, this);
                    continue;
                }
                shell.unknownArgument(arg, this);
            }
            if (path == null) {
                shell.requiredArg("-file", this);
            }
            InputStreamReader fr = null;
            BufferedReader br = null;
            String retString = null;
            try {
                String[] commands;
                String line;
                CommandLinesParser clp = new CommandLinesParser(shell);
                fr = new FileReader(path);
                br = new BufferedReader(fr);
                while ((line = br.readLine()) != null && !shell.getTerminate() && shell.getExitCode() == 0) {
                    try {
                        if (line.trim().isEmpty()) {
                            clp.appendLine(String.valueOf(';'));
                        } else {
                            clp.appendLine(line);
                        }
                    }
                    catch (Exception e) {
                        String[] commands2 = clp.getCommands();
                        assert (commands2.length == 1);
                        String msg = this.handleExecuteException(shell, commands2[0], e);
                        if (msg != null) {
                            retString = msg;
                            break;
                        }
                        clp.reset();
                        continue;
                    }
                    if (!clp.complete()) continue;
                    commands = clp.getCommands();
                    if (commands != null && (retString = this.executeCommands(shell, commands)) != null) break;
                    clp.reset();
                }
                if (retString == null && clp.hasCommand()) {
                    commands = clp.getCommands(false);
                    assert (commands != null);
                    retString = this.executeCommands(shell, commands);
                }
                this.exitCode = shell.getExitCode();
            }
            catch (IOException ioe) {
                this.exitCode = 65;
                String msg = "Failed to load file: " + path;
                if (!shell.getJson()) {
                    String commands = msg;
                    return commands;
                }
                CommandResult.CommandFails cmdResult = new CommandResult.CommandFails(msg, ErrorMessage.NOSQL_5100, CommandResult.NO_CLEANUP_JOBS);
                String string = Shell.toJsonReport(this.getCommandName(), cmdResult);
                return string;
            }
            finally {
                if (fr != null) {
                    try {
                        fr.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            if (shell.getJson()) {
                return "";
            }
            return retString == null ? "" : retString;
        }

        private String executeCommands(Shell shell, String[] commands) {
            for (String cmd : commands) {
                cmd = cmd.trim();
                try {
                    shell.runLine(cmd);
                }
                catch (Exception e) {
                    String msg = this.handleExecuteException(shell, cmd, e);
                    if (msg == null) continue;
                    return msg;
                }
            }
            return null;
        }

        private String handleExecuteException(Shell shell, String command, Exception e) {
            if (e instanceof ShellException) {
                if (!shell.handleShellException(command, (ShellException)e)) {
                    return "Script error in line \"" + command + "\", ending execution";
                }
                return null;
            }
            shell.handleUnknownException(command, e);
            return "";
        }

        @Override
        protected String getCommandSyntax() {
            return "load -file <path to file>";
        }

        @Override
        protected String getCommandDescription() {
            return "Load the named file and interpret its contents as a script of commands" + eolt + "to be executed.  If any command in the script fails execution will end.";
        }
    }

    protected class ParseLineException
    extends ShellException {
        private static final long serialVersionUID = 1L;

        public ParseLineException(String msg) {
            super(msg);
        }
    }
}

