/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.util.shell;

import java.rmi.RemoteException;
import java.util.Set;
import oracle.kv.impl.admin.CommandJsonUtils;
import oracle.kv.impl.admin.CommandServiceAPI;
import oracle.kv.impl.admin.client.CommandUtils;
import oracle.kv.impl.topo.AdminId;
import oracle.kv.impl.topo.ArbNodeId;
import oracle.kv.impl.topo.DatacenterId;
import oracle.kv.impl.topo.DatacenterType;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.util.shell.Shell;
import oracle.kv.util.shell.ShellArgumentException;
import oracle.kv.util.shell.ShellCommandResult;
import oracle.kv.util.shell.ShellException;
import oracle.kv.util.shell.ShellUsageException;

public abstract class ShellCommand
implements Cloneable {
    protected static final String eol = Shell.eol;
    protected static final String eolt = Shell.eolt;
    protected final String name;
    protected final int prefixMatchLength;
    protected Shell.VariablesMap cmdVariables = null;
    protected int exitCode = 0;
    private String prompt = null;
    private String cmdLine = null;
    protected boolean overrideJsonFlag = false;

    protected ShellCommand(String name, int prefixMatchLength) {
        assert (name.length() >= prefixMatchLength);
        this.name = name;
        this.prefixMatchLength = prefixMatchLength;
        this.cmdVariables = new Shell.VariablesMap();
    }

    protected boolean isHidden() {
        return false;
    }

    protected boolean isDeprecated() {
        return false;
    }

    public String getCommandName() {
        return this.name;
    }

    protected String getCommandSyntax() {
        return this.getCommandName();
    }

    protected abstract String getCommandDescription();

    protected boolean matches(String commandName) {
        return Shell.matches(commandName, this.name, this.prefixMatchLength);
    }

    public abstract String execute(String[] var1, Shell var2) throws ShellException;

    public String execute(String[] args, Shell shell, String line) throws ShellException {
        if (line != null && line.length() > args[0].length()) {
            this.cmdLine = line.substring(args[0].length()).trim();
        }
        return this.execute(args, shell);
    }

    public String getCommandLine() {
        return this.cmdLine != null ? this.cmdLine : "";
    }

    protected String getHelp(String[] args, Shell shell) {
        return this.getVerboseHelp();
    }

    protected String getVerboseHelp() {
        return this.getBriefHelp() + eolt + this.getCommandDescription();
    }

    protected String getBriefHelp() {
        return "Usage: " + this.getCommandSyntax();
    }

    public void setPrompt(String myPrompt) {
        this.prompt = myPrompt;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public ShellCommand clone() {
        try {
            ShellCommand cmd = (ShellCommand)super.clone();
            cmd.cmdVariables = this.cmdVariables.clone();
            return cmd;
        }
        catch (CloneNotSupportedException neverHappens) {
            return null;
        }
    }

    public void addVariable(String varName, Object value) {
        this.cmdVariables.add(varName, value);
    }

    public void removeVariable(String varName) {
        this.cmdVariables.remove(varName);
    }

    public void clearVariables() {
        this.cmdVariables.reset();
    }

    public Object getVariable(String varName) {
        return this.cmdVariables.get(varName);
    }

    public void invalidArgument(String arg) throws ShellException {
        String msg = "Invalid argument: " + arg + eolt + this.getBriefHelp();
        throw new ShellArgumentException(msg);
    }

    public int parseInt(String arg) throws ShellException {
        try {
            return Integer.parseInt(arg);
        }
        catch (NumberFormatException nfe) {
            this.invalidArgument(arg);
            return 0;
        }
    }

    public int parseUnsignedInt(String arg) throws ShellException {
        int value = this.parseInt(arg);
        if (value < 0) {
            this.invalidArgument(arg);
        }
        return value;
    }

    public long parseLong(String arg) throws ShellException {
        try {
            return Long.parseLong(arg);
        }
        catch (NumberFormatException nfe) {
            this.invalidArgument(arg);
            return 0L;
        }
    }

    public long parseUnsignedLong(String arg) throws ShellException {
        long value = this.parseLong(arg);
        if (value < 0L) {
            this.invalidArgument(arg);
        }
        return value;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public boolean overrideJsonFlag() {
        return this.overrideJsonFlag;
    }

    protected void validateRepNodes(CommandServiceAPI cs, Set<RepNodeId> rnids) throws RemoteException, ShellException {
        for (RepNodeId rnid : rnids) {
            CommandUtils.ensureRepNodeExists((RepNodeId)rnid, (CommandServiceAPI)cs, (ShellCommand)this);
        }
    }

    protected StorageNodeId parseSnid(String idString) throws ShellException {
        try {
            return StorageNodeId.parse(idString);
        }
        catch (IllegalArgumentException ignored) {
            throw new ShellUsageException("Invalid storage node ID: " + idString, this);
        }
    }

    protected DatacenterId parseDatacenterId(String idString) throws ShellException {
        try {
            return DatacenterId.parse(idString);
        }
        catch (IllegalArgumentException ignored) {
            throw new ShellUsageException("Invalid zone ID: " + idString, this);
        }
    }

    protected RepGroupId parseShardId(String idString) throws ShellException {
        try {
            return RepGroupId.parse(idString);
        }
        catch (IllegalArgumentException ignored) {
            throw new ShellUsageException("Invalid shard ID: " + idString, this);
        }
    }

    protected RepNodeId parseRnid(String idString) throws ShellException {
        try {
            return RepNodeId.parse(idString);
        }
        catch (IllegalArgumentException ignored) {
            throw new ShellUsageException("Invalid RepNode ID: " + idString, this);
        }
    }

    protected ArbNodeId parseAnid(String idString) throws ShellException {
        try {
            return ArbNodeId.parse(idString);
        }
        catch (IllegalArgumentException ignored) {
            throw new ShellUsageException("Invalid ArbNode ID: " + idString, this);
        }
    }

    protected AdminId parseAdminid(String idString) throws ShellException {
        try {
            return AdminId.parse(idString);
        }
        catch (IllegalArgumentException ignored) {
            throw new ShellUsageException("Invalid Admin ID: " + idString, this);
        }
    }

    protected DatacenterType parseDatacenterType(String string) throws ShellException {
        try {
            return DatacenterType.valueOf(string.toUpperCase());
        }
        catch (IllegalArgumentException ignored) {
            throw new ShellUsageException("Invalid zone type: " + string, this);
        }
    }

    protected boolean isMultilineInput() {
        return false;
    }

    public ShellCommandResult executeJsonOutput(String[] args, Shell shell) throws ShellException {
        throw new ShellException("JSON output does not suppport.");
    }

    protected ShellCommandResult filterJsonResult(String result) throws ShellException {
        return (ShellCommandResult)CommandJsonUtils.handleConversionFailure(() -> ShellCommandResult.filterJsonV1Result(result));
    }

    public static abstract class ShellCommandJsonConvert
    extends ShellCommand {
        public ShellCommandJsonConvert(String name, int prefixMatchLength) {
            super(name, prefixMatchLength);
        }

        @Override
        public ShellCommandResult executeJsonOutput(String[] args, Shell shell) throws ShellException {
            return this.filterJsonResult(this.execute(args, shell));
        }
    }

    public static interface Executor<R> {
        public R commonExecute(String[] var1, Shell var2) throws ShellException;
    }
}

