/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.util.shell;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import oracle.kv.impl.admin.CommandJsonUtils;
import oracle.kv.impl.admin.CommandResult;
import oracle.kv.impl.util.JsonUtils;
import oracle.kv.util.ErrorMessage;
import oracle.kv.util.shell.Shell;

public class ShellCommandResult {
    public static final String SUCCESS_MESSAGE = "Operation ends successfully";
    public static final String CONVERSION_FAILURE_MESSAGE = "Fail to convert JSON string";
    public static final String UNSUPPORTED_MESSAGE = "JSON output does not suppport.";
    private String operation;
    private int returnCode;
    private String description;
    private ObjectNode returnValue;

    public ShellCommandResult() {
    }

    public ShellCommandResult(String operation, int returnCode, String description, ObjectNode returnValue) {
        this.operation = operation;
        this.returnCode = returnCode;
        this.description = description;
        this.returnValue = returnValue;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public void setReturnCode(int returnCode) {
        this.returnCode = returnCode;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ObjectNode getReturnValue() {
        return this.returnValue;
    }

    public void setReturnValue(ObjectNode returnValue) {
        this.returnValue = returnValue;
    }

    public String convertToJson() throws IOException {
        ObjectWriter ow = JsonUtils.createWriter(true);
        return ow.writeValueAsString((Object)this);
    }

    public String getConversionErrorJsonResult(Exception e) {
        return "{" + Shell.eolt + "\"operation\" : \"" + this.getOperation() + "\"," + Shell.eolt + "\"returnCode\" : 5500," + Shell.eolt + "\"description\" : \"Exception in generating JSON format result: " + e.getMessage() + "\"," + Shell.eolt + "\"returnValue\" : " + null + Shell.eolt + "}";
    }

    public static ShellCommandResult getDefault(String operaionName) {
        ShellCommandResult scr = new ShellCommandResult();
        scr.setOperation(operaionName);
        scr.setReturnCode(ErrorMessage.NOSQL_5000.getValue());
        scr.setDescription(SUCCESS_MESSAGE);
        return scr;
    }

    public static ShellCommandResult filterJsonV1Result(String input) throws IOException {
        ShellCommandResult scr = new ShellCommandResult();
        ObjectNode v1Result = CommandJsonUtils.readObjectValue((String)input);
        JsonNode operation = v1Result.remove("operation");
        JsonNode returnCode = v1Result.remove("return_code");
        JsonNode description = v1Result.remove("description");
        JsonNode returnValue = v1Result.remove("return_value");
        v1Result.remove("cmd_cleanup_job");
        if (operation == null || returnCode == null || description == null) {
            throw new IOException("Fail to convert JSON result, one of following fields is null: operation, return_code, description");
        }
        scr.setOperation(operation.asText());
        scr.setReturnCode(returnCode.asInt());
        scr.setDescription(description.asText());
        if (returnValue != null) {
            if (!(returnValue instanceof ObjectNode)) {
                throw new IOException("Fail to convert return value, return value is not instance of ObjectNode");
            }
            ObjectNode v1ReturnValue = (ObjectNode)returnValue;
            ObjectNode convertedNode = ShellCommandResult.convertFields(v1ReturnValue);
            Iterator iter = convertedNode.fields();
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                v1Result.set((String)entry.getKey(), (JsonNode)entry.getValue());
            }
        }
        scr.setReturnValue(ShellCommandResult.convertFields(v1Result));
        return scr;
    }

    private static ObjectNode convertFields(ObjectNode v1Node) throws IOException {
        ObjectNode result = JsonUtils.createObjectNode();
        Iterator iter = v1Node.fields();
        while (iter.hasNext()) {
            ObjectNode innerNode;
            Map.Entry entry = (Map.Entry)iter.next();
            String key = (String)entry.getKey();
            String resultKey = ShellCommandResult.translateV1Key(key);
            if (entry.getValue() instanceof ObjectNode) {
                innerNode = (ObjectNode)entry.getValue();
                result.set(resultKey, (JsonNode)ShellCommandResult.convertFields(innerNode));
                continue;
            }
            if (entry.getValue() instanceof ArrayNode) {
                innerNode = (ArrayNode)entry.getValue();
                result.set(resultKey, (JsonNode)ShellCommandResult.convertFields((ArrayNode)innerNode));
                continue;
            }
            result.set(resultKey, (JsonNode)entry.getValue());
        }
        return result;
    }

    private static ArrayNode convertFields(ArrayNode v1Node) throws IOException {
        ArrayNode resultNode = JsonUtils.createArrayNode();
        Iterator iter = v1Node.elements();
        while (iter.hasNext()) {
            ObjectNode innerNode;
            JsonNode element = (JsonNode)iter.next();
            if (element instanceof ObjectNode) {
                innerNode = (ObjectNode)element;
                resultNode.add((JsonNode)ShellCommandResult.convertFields(innerNode));
                continue;
            }
            if (element instanceof ArrayNode) {
                innerNode = (ArrayNode)element;
                resultNode.add((JsonNode)ShellCommandResult.convertFields((ArrayNode)innerNode));
                continue;
            }
            resultNode.add(element);
        }
        return resultNode;
    }

    private static String translateV1Key(String key) throws IOException {
        int index = key.indexOf("_");
        if (index == -1) {
            return key;
        }
        if (key.startsWith("_") || key.endsWith("_")) {
            throw new IOException("Unexpected result. Fail to convert key: " + key);
        }
        String firstComp = key.substring(0, index);
        String upperCase = key.substring(index + 1, index + 2).toUpperCase();
        String lastComp = upperCase + key.substring(index + 2);
        return firstComp + ShellCommandResult.translateV1Key(lastComp);
    }

    public static String toJsonReport(String command, CommandResult cmdResult) {
        try {
            ShellCommandResult scr = new ShellCommandResult();
            scr.setOperation(command);
            scr.setDescription(cmdResult.getDescription());
            scr.setReturnCode(cmdResult.getErrorCode());
            String returnValue = cmdResult.getReturnValue();
            if (returnValue != null) {
                scr.setReturnValue(CommandJsonUtils.readObjectValue((String)returnValue));
            }
            return scr.convertToJson();
        }
        catch (IOException e) {
            return "{" + Shell.eolt + "\"operation\" : \"" + command + "\"," + Shell.eolt + "\"returnCode\" : 5500," + Shell.eolt + "\"description\" : \"Exception in generating JSON format result: " + e.getMessage() + "\"," + Shell.eolt + "\"returnValue\" : " + cmdResult.getReturnValue() + Shell.eolt + "}";
        }
    }
}

