/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.util.shell;

import oracle.kv.impl.admin.CommandResult;
import oracle.kv.util.ErrorMessage;

public class ShellException
extends Exception {
    private static final long serialVersionUID = 1L;
    private static final CommandResult DEFAULT_CMDFAILS = new CommandResult.CommandFails("Shell command error", ErrorMessage.NOSQL_5100, CommandResult.NO_CLEANUP_JOBS);
    private final CommandResult cmdResult;

    private ShellException(String msg, CommandResult cmdResult) {
        super(msg);
        this.cmdResult = cmdResult;
    }

    public ShellException() {
        this.cmdResult = DEFAULT_CMDFAILS;
    }

    public ShellException(String msg) {
        this(msg, new CommandResult.CommandFails(msg, ErrorMessage.NOSQL_5100, CommandResult.NO_CLEANUP_JOBS));
    }

    public ShellException(String msg, Throwable cause) {
        super(msg, cause);
        this.cmdResult = new CommandResult.CommandFails(msg, ErrorMessage.NOSQL_5100, CommandResult.NO_CLEANUP_JOBS);
    }

    public ShellException(String msg, ErrorMessage errorMsg, String[] cleanupJobs) {
        this(msg, new CommandResult.CommandFails(msg, errorMsg, cleanupJobs));
    }

    public ShellException(String msg, Throwable cause, ErrorMessage errorMsg, String[] cleanupJobs) {
        super(msg, cause);
        this.cmdResult = new CommandResult.CommandFails(msg, errorMsg, cleanupJobs);
    }

    public CommandResult getCommandResult() {
        return this.cmdResult;
    }
}

