/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.util.shell;

import java.io.BufferedReader;
import java.io.Console;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.StringTokenizer;
import oracle.kv.util.shell.FileHistoryProxy;
import oracle.kv.util.shell.Shell;

public class ShellInputReader {
    private Method readLineMeth;
    private Method readLineWithMaskMeth;
    private Method setVariableMeth;
    private Method setOptMeth;
    private String histFileVar;
    private String histFileSizeVar;
    private Method getHeightMeth;
    private Method closeMeth;
    private Method resumeMeth;
    private Method pauseMeth;
    private Method isPausedMeth;
    private Method sizeMeth;
    private Method getMeth;
    private Method saveMeth;
    private boolean isTermPaused;
    private Class<?> userInterruptException;
    private Class<?> endOfFileException;
    private static final int TERMINAL_HEIGHT_DEFAULT = 25;
    private static final String PROP_JLINE_DISABLE = "oracle.kv.shell.jline.disable";
    private static final String PROP_HISTORY_FILE = "oracle.kv.shell.history.file";
    private static final String PROP_HISTORY_SIZE = "oracle.kv.shell.history.size";
    private Object jReaderObj = null;
    private Object jFileHistoryObj = null;
    private Object jTermObj = null;
    private BufferedReader inputReader = null;
    private PrintStream output = null;
    private String prompt = "";

    public ShellInputReader(InputStream input, PrintStream output) {
        this(input, output, null, true, null);
    }

    public ShellInputReader(Shell shell) {
        this(shell.input, shell.output, ShellInputReader.getHistoryFile(shell), shell.isJlineEventDesignatorDisabled(), shell.getMaskFlags());
        this.loadCommandHistory(shell);
    }

    public ShellInputReader(InputStream input, PrintStream output, File historyFile, boolean disableExpandEvents, String[] maskFlags) {
        this.initInputReader(input, output, historyFile, disableExpandEvents, maskFlags);
        this.output = output;
    }

    private void initInputReader(InputStream input, PrintStream output1, File historyFile, boolean disableExpandEvents, String[] maskFlags) {
        block9: {
            if (!this.isJlineCompatiblePlatform()) {
                this.inputReader = new BufferedReader(new InputStreamReader(input));
                return;
            }
            try {
                Enum[] constants;
                boolean createSysTerm;
                Class<?> readerBuilder = Class.forName("org.jline.reader.LineReaderBuilder");
                Class<?> reader = Class.forName("org.jline.reader.LineReader");
                Class<?> termBuilder = Class.forName("org.jline.terminal.TerminalBuilder");
                Class<?> term = Class.forName("org.jline.terminal.Terminal");
                Class<?> dumbTerm = Class.forName("org.jline.terminal.impl.DumbTerminal");
                Class<?> history = Class.forName("org.jline.reader.History");
                Class<?> defaultHistory = Class.forName("org.jline.reader.impl.history.DefaultHistory");
                Class<?> readerOpt = Class.forName("org.jline.reader.LineReader$Option");
                this.userInterruptException = Class.forName("org.jline.reader.UserInterruptException");
                this.endOfFileException = Class.forName("org.jline.reader.EndOfFileException");
                Method tbBuilder = termBuilder.getMethod("builder", new Class[0]);
                Method tbBuild = termBuilder.getMethod("build", new Class[0]);
                Method tbSystem = termBuilder.getMethod("system", Boolean.TYPE);
                Method tbPaused = termBuilder.getMethod("paused", Boolean.TYPE);
                this.getHeightMeth = term.getMethod("getHeight", new Class[0]);
                this.closeMeth = term.getMethod("close", new Class[0]);
                this.resumeMeth = term.getMethod("resume", new Class[0]);
                this.pauseMeth = term.getMethod("pause", new Class[0]);
                this.isPausedMeth = term.getMethod("paused", new Class[0]);
                Method lrbBuilder = readerBuilder.getMethod("builder", new Class[0]);
                Method lrbBuild = readerBuilder.getMethod("build", new Class[0]);
                Method lrbTerm = readerBuilder.getMethod("terminal", term);
                Method lrbHistory = readerBuilder.getMethod("history", history);
                this.readLineMeth = reader.getMethod("readLine", String.class);
                this.readLineWithMaskMeth = reader.getMethod("readLine", String.class, Character.class);
                this.setVariableMeth = reader.getMethod("setVariable", String.class, Object.class);
                this.setOptMeth = reader.getMethod("setOpt", readerOpt);
                this.sizeMeth = defaultHistory.getMethod("size", new Class[0]);
                this.getMeth = defaultHistory.getMethod("get", Integer.TYPE);
                this.saveMeth = defaultHistory.getMethod("save", new Class[0]);
                Object termBuilderObj = tbBuilder.invoke(null, new Object[0]);
                boolean bl = createSysTerm = System.in == input && System.out == output1;
                if (createSysTerm) {
                    termBuilderObj = tbSystem.invoke(termBuilderObj, true);
                    termBuilderObj = tbPaused.invoke(termBuilderObj, true);
                    this.jTermObj = tbBuild.invoke(termBuilderObj, new Object[0]);
                } else {
                    Constructor<?> dumbTermCtor = dumbTerm.getConstructor(InputStream.class, OutputStream.class);
                    this.jTermObj = dumbTermCtor.newInstance(input, output1);
                    this.pauseMeth.invoke(this.jTermObj, new Object[0]);
                }
                this.isTermPaused = (Boolean)this.isPausedMeth.invoke(this.jTermObj, new Object[0]);
                Object lrbObj = lrbBuilder.invoke(null, new Object[0]);
                lrbObj = lrbTerm.invoke(lrbObj, this.jTermObj);
                if (historyFile != null) {
                    Constructor<?> histCtor = defaultHistory.getConstructor(new Class[0]);
                    this.jFileHistoryObj = histCtor.newInstance(new Object[0]);
                    Object historyObj = maskFlags == null ? this.jFileHistoryObj : FileHistoryProxy.create(this.jFileHistoryObj, maskFlags);
                    lrbObj = lrbHistory.invoke(lrbObj, historyObj);
                }
                this.jReaderObj = lrbBuild.invoke(lrbObj, new Object[0]);
                if (historyFile != null) {
                    Field histFile = reader.getField("HISTORY_FILE");
                    Field histFileSize = reader.getField("HISTORY_FILE_SIZE");
                    this.histFileVar = (String)histFile.get(this.jReaderObj);
                    this.histFileSizeVar = (String)histFileSize.get(this.jReaderObj);
                    this.setReaderVariable(this.histFileVar, historyFile.getAbsolutePath());
                    this.setHistoryFileSize();
                }
                if (!disableExpandEvents) break block9;
                for (Enum e : constants = (Enum[])readerOpt.getEnumConstants()) {
                    if (!"DISABLE_EVENT_EXPANSION".equals(e.name())) continue;
                    Object option = Enum.valueOf(readerOpt, e.name());
                    this.setReaderOption((Enum<?>)option);
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.jReaderObj == null) {
            this.inputReader = new BufferedReader(new InputStreamReader(input));
        }
    }

    private void setReaderVariable(String name, Object value) {
        if (this.jReaderObj != null && this.setVariableMeth != null) {
            try {
                this.invokeMethod(this.jReaderObj, this.setVariableMeth, new Object[]{name, value});
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void setReaderOption(Enum<?> option) {
        if (this.jReaderObj != null && this.setOptMeth != null) {
            try {
                this.invokeMethod(this.jReaderObj, this.setOptMeth, new Object[]{option});
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void resumeTerminal() {
        if (this.jTermObj != null && this.resumeMeth != null) {
            try {
                this.invokeMethod(this.jTermObj, this.resumeMeth, null);
                this.isTermPaused = false;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void loadCommandHistory(Shell shell) {
        if (this.jFileHistoryObj == null) {
            return;
        }
        Shell.CommandHistory history = shell.getHistory();
        try {
            int size = this.getHistorySize();
            if (size == 0) {
                return;
            }
            for (int i = 0; i < size; ++i) {
                history.add(this.getHistoryCommand(i), null);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private int getHistorySize() throws IOException {
        if (this.jFileHistoryObj != null && this.sizeMeth != null) {
            return (Integer)this.invokeMethod(this.jFileHistoryObj, this.sizeMeth, null);
        }
        return 0;
    }

    private String getHistoryCommand(int index) throws IOException {
        if (this.jFileHistoryObj != null && this.getMeth != null) {
            return (String)this.invokeMethod(this.jFileHistoryObj, this.getMeth, new Object[]{index});
        }
        return "";
    }

    private static File getHistoryFile(Shell shell) {
        String path = System.getProperty(PROP_HISTORY_FILE);
        File file = null;
        file = path != null ? new File(path) : new File(System.getProperty("user.home"), ".jline3-" + shell.getClass().getName() + ".history");
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                shell.verboseOutput("Failed to create the command line history file: " + file.getAbsolutePath() + ", command history will be stored in memory.");
                return null;
            }
        } else if (!file.canRead() || !file.canWrite()) {
            shell.verboseOutput("Cannot access the command line history file: " + file.getAbsolutePath() + ", command history will be stored in memory.");
            return null;
        }
        return file;
    }

    private void setHistoryFileSize() {
        int maxSize;
        String historySize = System.getProperty(PROP_HISTORY_SIZE);
        if (historySize == null) {
            return;
        }
        try {
            maxSize = Integer.valueOf(historySize);
        }
        catch (NumberFormatException nfe) {
            return;
        }
        if (this.histFileSizeVar != null) {
            this.setReaderVariable(this.histFileSizeVar, maxSize);
        }
    }

    public void shutdown() {
        if (this.jTermObj != null && this.closeMeth != null) {
            try {
                this.invokeMethod(this.jTermObj, this.closeMeth, null);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.jFileHistoryObj != null && this.saveMeth != null) {
            try {
                this.invokeMethod(this.jFileHistoryObj, this.saveMeth, null);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private boolean isJlineCompatiblePlatform() {
        if (Boolean.getBoolean(PROP_JLINE_DISABLE)) {
            return false;
        }
        String os = System.getProperty("os.name").toLowerCase();
        return os.indexOf("windows") == -1;
    }

    public void setDefaultPrompt(String prompt) {
        this.prompt = prompt;
    }

    public String getDefaultPrompt() {
        return this.prompt;
    }

    public String readLine() throws IOException {
        return this.readLine(null);
    }

    public String readLine(String promptString) throws IOException {
        String promptStr;
        String string = promptStr = promptString != null ? promptString : this.prompt;
        if (this.isTermPaused) {
            this.resumeTerminal();
        }
        if (this.jReaderObj != null && this.readLineMeth != null) {
            return (String)this.invokeMethod(this.jReaderObj, this.readLineMeth, new Object[]{promptStr});
        }
        if (promptStr != null) {
            this.output.print(promptStr);
        }
        return this.inputReader.readLine();
    }

    public char[] readPassword(String promptString) throws IOException {
        String pwdPrompt;
        String input = null;
        String string = pwdPrompt = promptString != null ? promptString : this.prompt;
        if (this.isTermPaused) {
            this.resumeTerminal();
        }
        if (this.jReaderObj != null && this.readLineWithMaskMeth != null) {
            input = (String)this.invokeMethod(this.jReaderObj, this.readLineWithMaskMeth, new Object[]{pwdPrompt, Character.valueOf('\u0000')});
            return input == null ? null : input.toCharArray();
        }
        Console console = System.console();
        if (console != null) {
            return console.readPassword(pwdPrompt, new Object[0]);
        }
        this.output.print(pwdPrompt);
        input = this.inputReader.readLine();
        return input == null ? null : input.toCharArray();
    }

    public int getTerminalHeight() {
        if (this.jTermObj != null && this.getHeightMeth != null) {
            try {
                return (Integer)this.invokeMethod(this.jTermObj, this.getHeightMeth, null);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.getTermHeightImpl();
    }

    private Object invokeMethod(Object obj, Method method, Object[] args) throws IOException {
        String name = method.getName();
        try {
            return method.invoke(obj, args);
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            String clsName = method.getDeclaringClass().getSimpleName();
            String msg = String.format("Failed to invoke %s.%s.", clsName, name);
            throw new IOException(msg, ex);
        }
        catch (InvocationTargetException ite) {
            Throwable cause = ite.getCause();
            if (cause == null) {
                throw new IOException(ite);
            }
            if (obj == this.jReaderObj && "readLine".equals(name)) {
                if (cause instanceof IOError) {
                    this.isTermPaused = true;
                } else if (this.userInterruptException.isInstance(cause) || this.endOfFileException.isInstance(cause)) {
                    return null;
                }
            }
            throw new IOException(cause.getMessage(), cause);
        }
    }

    private int getTermHeightImpl() {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.indexOf("windows") != -1) {
            return 25;
        }
        int height = this.getUnixTermHeight();
        if (height == -1) {
            height = 25;
        }
        return height;
    }

    private int getUnixTermHeight() {
        String ttyProps = null;
        String name = "rows";
        try {
            ttyProps = this.getTermSttyProps();
            if (ttyProps != null && ttyProps.length() > 0) {
                return this.getTermSttyPropValue(ttyProps, "rows");
            }
        }
        catch (IOException iOException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return -1;
    }

    private String getTermSttyProps() throws IOException, InterruptedException {
        String[] cmd = new String[]{"/bin/sh", "-c", "stty -a </dev/tty"};
        Process proc = Runtime.getRuntime().exec(cmd);
        String s = null;
        StringBuilder sb = new StringBuilder();
        BufferedReader stdInput = new BufferedReader(new InputStreamReader(proc.getInputStream()));
        while ((s = stdInput.readLine()) != null) {
            sb.append(s);
        }
        BufferedReader stdError = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
        while ((s = stdError.readLine()) != null) {
            sb.append(s);
        }
        proc.waitFor();
        return sb.toString();
    }

    private int getTermSttyPropValue(String props, String name) {
        StringTokenizer tokenizer = new StringTokenizer(props, ";\n");
        while (tokenizer.hasMoreTokens()) {
            String str = tokenizer.nextToken().trim();
            if (str.startsWith(name)) {
                return Integer.parseInt(str.substring(name.length() + 1, str.length()));
            }
            if (!str.endsWith(name)) continue;
            return Integer.parseInt(str.substring(0, str.length() - name.length() - 1));
        }
        return 0;
    }
}

