/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.util.shell;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import oracle.kv.impl.admin.client.POST;
import oracle.kv.impl.util.CommandParser;
import oracle.kv.util.shell.CommandWithSubs;
import oracle.kv.util.shell.Shell;
import oracle.kv.util.shell.ShellArgumentException;
import oracle.kv.util.shell.ShellCommand;
import oracle.kv.util.shell.ShellCommandResult;
import oracle.kv.util.shell.ShellException;

public class ShowCommandBase
extends CommandWithSubs {
    public static final String COMMAND = "show";
    static final String OVERVIEW = "Encapsulates commands that display the state of the store and its components.";

    public ShowCommandBase(List<? extends CommandWithSubs.SubCommand> subs) {
        super(subs, COMMAND, 2, 2);
    }

    @Override
    protected String getCommandOverview() {
        return OVERVIEW;
    }

    @POST
    public static final class ShowFaults
    extends CommandWithSubs.SubCommand {
        static final String NAME = "faults";
        private static final String COMMAND_DESC = "-command <index>";
        static final String SYNTAX = "show faults " + CommandParser.optional("-last") + " " + CommandParser.optional("-command <index>") + " " + CommandParser.getJsonUsage();
        static final String DESCRIPTION = "Displays faulting commands.  By default all available faulting commands" + eolt + "are displayed.  Individual fault details can be displayed using the" + eolt + "-last" + " and " + "-command" + " flags.";

        public ShowFaults() {
            super(NAME, 3);
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            return (String)new ShowFaultExecutor<String>(){

                @Override
                public String indexFaultResult(Shell.CommandHistory history, int index) throws ShellException {
                    return history.dumpCommand(index, true);
                }

                @Override
                public String lastFaultResult(Shell.CommandHistory history) throws ShellException {
                    return history.dumpLastFault();
                }

                @Override
                public String multiFaultResult(Shell.CommandHistory history, int from, int to) throws ShellException {
                    return history.dumpFaultingCommands(from, to);
                }
            }.commonExecute(args, shell);
        }

        @Override
        public ShellCommandResult executeJsonOutput(String[] args, Shell shell) throws ShellException {
            final ShellCommandResult scr = ShellCommandResult.getDefault("show fault");
            return (ShellCommandResult)new ShowFaultExecutor<ShellCommandResult>(){

                @Override
                public ShellCommandResult multiFaultResult(Shell.CommandHistory history, int from, int to) throws ShellException {
                    scr.setReturnValue(history.dumpFaultingCommandsJson(from, to));
                    return scr;
                }

                @Override
                public ShellCommandResult indexFaultResult(Shell.CommandHistory history, int index) throws ShellException {
                    scr.setReturnValue(history.dumpCommandJson(index, true));
                    return scr;
                }

                @Override
                public ShellCommandResult lastFaultResult(Shell.CommandHistory history) throws ShellException {
                    ObjectNode lastFault = history.dumpLastFaultJson();
                    if (lastFault == null) {
                        throw new ShellArgumentException("no command fault.");
                    }
                    scr.setReturnValue(lastFault);
                    return scr;
                }
            }.commonExecute(args, shell);
        }

        private int toZeroBasedIndex(int index) {
            return index > 0 ? index - 1 : 0;
        }

        @Override
        protected String getCommandSyntax() {
            return SYNTAX;
        }

        @Override
        protected String getCommandDescription() {
            return DESCRIPTION;
        }

        private abstract class ShowFaultExecutor<T>
        implements ShellCommand.Executor<T> {
            private ShowFaultExecutor() {
            }

            @Override
            public T commonExecute(String[] args, Shell shell) throws ShellException {
                Shell.CommandHistory history = shell.getHistory();
                boolean from = false;
                int to = history.getSize();
                if (args.length > 1) {
                    String arg = args[1];
                    if ("-last".equals(arg)) {
                        return this.lastFaultResult(history);
                    }
                    if ("-command".equals(arg)) {
                        String faultString = Shell.nextArg(args, 1, ShowFaults.this);
                        try {
                            int fault = Integer.parseInt(faultString);
                            int idxFault = ShowFaults.this.toZeroBasedIndex(fault);
                            if (idxFault < 0 || idxFault >= history.getSize()) {
                                throw new ShellArgumentException("Index out of range: " + fault + "" + ShellCommand.eolt + ShowFaults.this.getBriefHelp());
                            }
                            if (history.commandFaulted(idxFault)) {
                                return this.indexFaultResult(history, idxFault);
                            }
                            throw new ShellArgumentException("Command " + fault + " did not fault");
                        }
                        catch (IllegalArgumentException e) {
                            ShowFaults.this.invalidArgument(faultString);
                        }
                    } else {
                        shell.unknownArgument(arg, ShowFaults.this);
                    }
                }
                return this.multiFaultResult(history, 0, to);
            }

            public abstract T indexFaultResult(Shell.CommandHistory var1, int var2) throws ShellException;

            public abstract T lastFaultResult(Shell.CommandHistory var1) throws ShellException;

            public abstract T multiFaultResult(Shell.CommandHistory var1, int var2, int var3) throws ShellException;
        }
    }
}

