/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfinternal.model.dvt.util.transform;

import oracle.adf.model.dvt.util.transform.MemberInterface;
import oracle.adf.model.dvt.util.transform.MemberInterfaceAbstractImpl;
import oracle.adf.model.dvt.util.transform.TransformException;
import oracle.adfinternal.model.dvt.util.transform.TransformRuntimeException;
import oracle.javatools.annotations.Concealed;

@Concealed
class CollapseableMemberImpl
extends MemberInterfaceAbstractImpl {
    private boolean m_collapsed;
    private MemberInterface.AggregatePosition m_pos = MemberInterface.AggregatePosition.NONE;
    private final MemberInterface m_memberInt;

    public CollapseableMemberImpl(MemberInterface member) {
        this.m_memberInt = member;
    }

    private CollapseableMemberImpl(MemberInterface member, boolean collapsed, MemberInterface.AggregatePosition pos) {
        this(member);
        this.setCollapsed(collapsed, pos);
    }

    public Object clone() throws CloneNotSupportedException {
        CollapseableMemberImpl newObj = new CollapseableMemberImpl(this.m_memberInt, this.m_collapsed, this.m_pos);
        return newObj;
    }

    @Override
    public String getValue() {
        try {
            return this.m_memberInt.getValue();
        }
        catch (TransformException e) {
            throw new TransformRuntimeException(e);
        }
    }

    @Override
    public Object getMetadata(String type) throws TransformException {
        if (type.equals("memberMetadataIsCollapsed")) {
            return this.m_collapsed;
        }
        if (type.equals("memberMetadataAggPosition")) {
            if (!this.m_collapsed) {
                return this.m_pos;
            }
            return MemberInterface.AggregatePosition.NONE;
        }
        return this.m_memberInt.getMetadata(type);
    }

    protected void setCollapsed(boolean collapsed, MemberInterface.AggregatePosition pos) {
        this.m_collapsed = collapsed;
        this.m_pos = pos;
    }
}

