/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfinternal.model.dvt.util.transform;

import oracle.adf.model.dvt.util.transform.BaseProjection;
import oracle.adf.model.dvt.util.transform.LayerInterface;
import oracle.adf.model.dvt.util.transform.MemberInterface;
import oracle.adf.model.dvt.util.transform.TransformException;
import oracle.adf.model.dvt.util.transform.TreeNode;
import oracle.adfinternal.model.dvt.util.transform.BaseNode;
import oracle.adfinternal.model.dvt.util.transform.EdgeTreeBasedCubicDataAccess;
import oracle.adfinternal.model.dvt.util.transform.EdgeTreeImpl;
import oracle.adfinternal.model.dvt.util.transform.EdgeTreeNodeImpl;
import oracle.adfinternal.model.dvt.util.transform.GetSlice;
import oracle.adfinternal.model.dvt.util.transform.TransformUtils;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.LayerSortInfo;
import oracle.dss.util.SliceOutOfRangeException;
import oracle.javatools.annotations.Concealed;

@Concealed
class TreeBasedEdgeTree
extends EdgeTreeImpl {
    private final LayerInterface[] m_layerInfo;
    private final long m_extent;

    public TreeBasedEdgeTree(BaseNode[] nodes, int edge, BaseProjection projection, String measDim, String[] measList, boolean noCollapseLeaves, long extent, EdgeTreeBasedCubicDataAccess da) throws TransformException {
        super(nodes, edge, projection, measDim, measList, noCollapseLeaves, da, extent);
        this.m_extent = extent;
        this.m_layerInfo = new LayerInterface[nodes.length];
    }

    @Override
    public void release() {
        super.release();
    }

    @Override
    public long getExtent() throws TransformException {
        if (this.m_extent > -1L) {
            return this.m_extent;
        }
        return super.getExtent();
    }

    public LayerInterface getLayerInfo(int layer) throws LayerOutOfRangeException, SliceOutOfRangeException, TransformException {
        this.checkLayerRange(layer);
        if (this.m_layerInfo[layer] != null) {
            return this.m_layerInfo[layer];
        }
        this.getNode(layer, 0L, GetSlice.GET_TO_SLICE);
        return this.m_layerInfo[layer];
    }

    public LayerInterface[] getLayers() {
        return this.m_layerInfo;
    }

    protected boolean isAggregateNodeType(TreeNode node) throws TransformException {
        String nodeLayer = node.getLayer().getValue();
        if (nodeLayer.equals(this.getLayout()[this.getEdge()][this.getLayout()[this.getEdge()].length - 1])) {
            return false;
        }
        TreeNode firstChild = node.getFirstChild();
        if (firstChild == null) {
            return true;
        }
        try {
            int[] val = TransformUtils.getLayerAndEdge(firstChild.getLayer().getValue(), this.getLayout());
            if (val == null || val.length < 1) {
                return false;
            }
            return this.getEdge() != val[0];
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            return false;
        }
    }

    public EdgeTreeNodeImpl addNode(TreeNode node, EdgeTreeNodeImpl myParent, EdgeTreeNodeImpl preMadeNode, boolean alwaysAdd, LayerSortInfo sortInfo) throws TransformException {
        EdgeTreeNodeImpl etn;
        LayerInterface layerInfo = node.getLayer();
        String layerName = layerInfo.getValue();
        this.addToLayerList(layerName, layerInfo);
        EdgeTreeNodeImpl parentNode = null;
        if (myParent != null && myParent.getEdge() == this.getEdge()) {
            parentNode = myParent;
        }
        EdgeTreeNodeImpl edgeTreeNodeImpl = etn = preMadeNode != null ? preMadeNode : this.getEdgeTreeNode(this.isAggregateNodeType(node), parentNode, node.getMember(), node, layerName);
        if (parentNode != null) {
            etn = parentNode.addChild(etn, node, null, false, alwaysAdd, false, true, sortInfo);
        }
        return etn;
    }

    @Override
    protected EdgeTreeNodeImpl getEdgeTreeNode(boolean isAggregateNodeType, EdgeTreeNodeImpl parentNode, MemberInterface member, TreeNode node, String layerName) throws TransformException {
        return new EdgeTreeNodeImpl(this, isAggregateNodeType, parentNode, member, layerName);
    }

    private void addToLayerList(String layerName, LayerInterface layerInfo) throws TransformException {
        for (int i = 0; i < this.getLayerList().length; ++i) {
            if (!layerName.equals(this.getLayerList()[i].getName())) continue;
            this.m_layerInfo[i] = layerInfo;
        }
    }
}

