/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.builders;

import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ListCellRenderer;
import oracle.javatools.ui.builders.BuiltCombo;
import oracle.javatools.ui.builders.BuiltComboImpl;
import oracle.javatools.ui.combo.CheckComboText;
import oracle.javatools.util.ListenableCollection;
import oracle.javatools.util.ListenableHashSet;

public class ComboBuilder<T> {
    private ComboInstructions instructions = new ComboInstructions();

    public BuiltCombo<T> build() {
        if (this.instructions.editable && this.instructions.checkedItems != null) {
            throw new IllegalStateException("Checkable and Editable properties are incompatible.");
        }
        if (!this.instructions.editable && this.instructions.promptText != null) {
            throw new IllegalStateException("Prompt text only works for editable combo boxes.");
        }
        return new BuiltComboImpl(this.instructions);
    }

    public void setModel(T[] items) {
        for (T item : items) {
            this.instructions.items.add(item);
        }
    }

    public void setModel(List<? extends T> items) {
        this.instructions.items.addAll(items);
    }

    public void setLabel(String labelText) {
        this.instructions.labelText = labelText;
    }

    public void setHint(String hintText) {
        this.instructions.hintText = hintText;
    }

    public void setPrompt(String promptText) {
        this.instructions.promptText = promptText;
    }

    public void setRenderer(ListCellRenderer renderer) {
        this.instructions.renderer = renderer;
    }

    public void setRenderUsingMethod(String methodName) {
        this.instructions.renderUsingMethod = methodName;
    }

    public void setVisibleRows(int visibleRows) {
        this.instructions.visibleRows = visibleRows;
    }

    public void setSelection(T selection) {
        this.instructions.selection = selection;
    }

    public void setEditable(boolean editable) {
        this.instructions.editable = editable;
    }

    public ListenableCollection<T> setCheckable(Collection<T> initiallyCheckedItems) {
        return this.setCheckable(initiallyCheckedItems, null);
    }

    public ListenableCollection<T> setCheckable(Collection<T> initiallyCheckedItems, CheckComboText<T> checkComboText) {
        this.instructions.checkedItems = initiallyCheckedItems == null ? new ListenableHashSet() : new ListenableHashSet(initiallyCheckedItems);
        this.instructions.checkComboText = checkComboText;
        return this.instructions.checkedItems;
    }

    public void addActionListener(ActionListener actionListener) {
        this.instructions.actionListeners.add(actionListener);
    }

    public void setActions(Action ... actions) {
        for (Action action : actions) {
            this.instructions.primaryActions.add(action);
        }
    }

    public void setActionsSecondary(Action ... actions) {
        this.setActionsSecondary((String)null, (Icon)null, actions);
    }

    public void setActionsSecondary(String secondaryActionsText, Icon secondaryActionsIcon, Action ... actions) {
        this.instructions.secondaryActionsText = secondaryActionsText;
        this.instructions.secondaryActionsIcon = secondaryActionsIcon;
        for (Action action : actions) {
            this.instructions.secondaryActions.add(action);
        }
    }

    final class ComboInstructions {
        List<T> items = new ArrayList();
        String labelText;
        String hintText;
        String promptText;
        ListCellRenderer renderer;
        int visibleRows = -1;
        String renderUsingMethod;
        T selection;
        boolean editable = false;
        ListenableCollection<T> checkedItems;
        List<ActionListener> actionListeners = new ArrayList<ActionListener>();
        List<Action> primaryActions = new ArrayList<Action>();
        List<Action> secondaryActions = new ArrayList<Action>();
        String secondaryActionsText = null;
        Icon secondaryActionsIcon = null;
        CheckComboText checkComboText = null;

        ComboInstructions() {
        }
    }
}

