/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.internal;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import oracle.javatools.ui.datatips.DataTip;
import oracle.javatools.ui.datatips.TableCustomizer;
import oracle.javatools.ui.treetable.TreeTableModel;

final class UICDataTipDemoPanel
extends JPanel {
    private JScrollPane jScrollPane1 = new JScrollPane();
    private JTextArea jTextArea1 = new JTextArea();
    private DataTip dataTip;
    private JFrame frame;

    public UICDataTipDemoPanel(JFrame frame) {
        try {
            this.frame = frame;
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.jScrollPane1.getViewport().add((Component)this.jTextArea1, null);
        this.add((Component)this.jScrollPane1, "Center");
        this.add((Component)new JLabel("Press control-D to see a data tip"), "North");
        this.jTextArea1.setText("A DataTip is a popup component that displays a hierarchy of information.\n\nPress Control-D to see an example DataTip displaying data on the planets of the Solar System.\nThe data is revealed one level at a time in a compact floating table. The user can click on the familiar tree expand collapse icons to see information on children of an object. Levels are overlayed and reveal data in a compact form floating above other components in the editor, so they can be positioned next to the objects and controls  which they are displaying data about.\n\n\nData Tips are dismissed by pressing Escape or by moving the focus away from them.Keyboard navigation is via the arrow keys with the addition of 'ctrl' to move up and down the hierarchy.\n\nInternally the DataTip uses a form of TreeTableModel and standard JTable renderers so it's easy to customize to suit many situations.\n\nYada yada yada....");
        this.jTextArea1.setFont(Font.getFont("Serif"));
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setWrapStyleWord(true);
        String DATATIP = "DATATIP";
        this.jTextArea1.getInputMap(2).put(KeyStroke.getKeyStroke(68, 128, false), "DATATIP");
        this.jTextArea1.getActionMap().put("DATATIP", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UICDataTipDemoPanel.this.datatip();
            }
        });
    }

    private void datatip() {
        if (this.dataTip != null) {
            this.dataTip.setVisible(false);
        }
        Point p = MouseInfo.getPointerInfo().getLocation();
        this.dataTip = new DataTip(this.frame, new TestTreeTableModel());
        this.dataTip.setTableCustomizer(new TableCustomizer(){

            @Override
            public void customizeTable(JTable table, Object node) {
            }
        });
        this.dataTip.setLocationRectangle(new Rectangle(p.x, p.y, 50, 16));
        this.dataTip.setVisible(true);
    }

    private static class ColumnTreeNode
    extends DefaultMutableTreeNode {
        private String type;

        public ColumnTreeNode(Object object, String type) {
            super(object);
            this.type = type;
        }

        public Object getColumnData(int column) {
            switch (column) {
                case 0: {
                    return this.getUserObject().toString();
                }
                case 1: {
                    return this.type;
                }
                case 2: {
                    return this.getUserObject().toString() + ".jpg";
                }
            }
            return "";
        }

        void setType(String type) {
            this.type = type;
        }

        String getType() {
            return this.type;
        }
    }

    private static class TestTreeTableModel
    implements TreeTableModel {
        private DefaultMutableTreeNode root = this.buildTree();

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int column) {
            return "Column " + column;
        }

        @Override
        public Class getColumnClass(int column) {
            return String.class;
        }

        @Override
        public Object getValueAt(Object node, int column) {
            return ((ColumnTreeNode)node).getColumnData(column);
        }

        @Override
        public boolean isCellEditable(Object node, int column) {
            return column == 1;
        }

        @Override
        public void setValueAt(Object aValue, Object node, int column) {
            if (column == 1) {
                ((ColumnTreeNode)node).setType(aValue.toString());
            }
        }

        @Override
        public Object getRoot() {
            return this.root;
        }

        @Override
        public Object getChild(Object parent, int index) {
            return ((DefaultMutableTreeNode)parent).getChildAt(index);
        }

        @Override
        public int getChildCount(Object parent) {
            return ((DefaultMutableTreeNode)parent).getChildCount();
        }

        @Override
        public boolean isLeaf(Object node) {
            return this.getChildCount(node) == 0;
        }

        @Override
        public void valueForPathChanged(TreePath path, Object newValue) {
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            return ((DefaultMutableTreeNode)parent).getIndex((DefaultMutableTreeNode)child);
        }

        @Override
        public void addTreeModelListener(TreeModelListener l) {
        }

        @Override
        public void removeTreeModelListener(TreeModelListener l) {
        }

        private DefaultMutableTreeNode buildTree() {
            ColumnTreeNode sunNode = new ColumnTreeNode((Object)"The Sun", "Star");
            try {
                InputStream is = this.getClass().getResourceAsStream("DemoData.txt");
                BufferedReader br = new BufferedReader(new InputStreamReader(is));
                String line = br.readLine();
                while (line != null) {
                    StringTokenizer t = new StringTokenizer(line, "|");
                    String planet = t.nextToken();
                    ColumnTreeNode planetNode = new ColumnTreeNode((Object)planet, "Planet");
                    sunNode.add(planetNode);
                    while (t.hasMoreTokens()) {
                        String moon = t.nextToken();
                        StringTokenizer moonT = new StringTokenizer(moon, "&");
                        String city = moonT.nextToken();
                        ColumnTreeNode moonNode = new ColumnTreeNode((Object)city, "Moon");
                        planetNode.add(moonNode);
                        while (moonT.hasMoreTokens()) {
                            city = moonT.nextToken();
                            ColumnTreeNode cityNode = new ColumnTreeNode((Object)city, "Moonbase");
                            moonNode.add(cityNode);
                        }
                    }
                    line = br.readLine();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ColumnTreeNode rootNode = new ColumnTreeNode((Object)"Root node", "");
            rootNode.add(sunNode);
            return rootNode;
        }
    }
}

