/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.plaf;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ButtonUI;
import oracle.bali.ewt.olaf2.OracleButtonUI;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.themes.Themes;

public class IconicButtonUI
extends OracleButtonUI {
    private PropertyChangeListener _pcl;
    public static final String CLIENT_PROPERTY_ACTIVE = "iconicButtonUIActive";
    public static final String CLIENT_PROPERTY_NO_BACKGROUND = "iconicButtonNoBackground";
    public static final String ACTION_PROPERTY_TINY = "tinyButton";
    private static Insets insets = new Insets(0, 0, 0, 0);

    public static void install(AbstractButton button) {
        if (Themes.isThemed()) {
            button.setUI((ButtonUI)((Object)new IconicButtonUI()));
        } else {
            button.setMargin(new Insets(0, 0, 0, 0));
        }
    }

    private boolean isTinyButton(AbstractButton b) {
        if (b == null) {
            return false;
        }
        Action a = b.getAction();
        if (a == null) {
            return false;
        }
        Boolean tiny = (Boolean)a.getValue(ACTION_PROPERTY_TINY);
        return tiny == null ? false : tiny;
    }

    public void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        if (Themes.isThemed()) {
            b.setMargin(null);
            if (this.isTinyButton(b)) {
                b.setBorder(new EmptyBorder(2, 3, 1, 3));
            } else {
                insets = Themes.getActiveTheme().getPartProperties("toolbarbuttoniconic").getInsets("outermargin");
                b.setBorder(new EmptyBorder(insets));
            }
        } else {
            b.setBorder(null);
            b.setMargin(null);
        }
        b.setBorderPainted(false);
        b.setOpaque(false);
        b.setRolloverEnabled(true);
        b.setFocusPainted(true);
        IconicButtonUI.updateCursor(b);
    }

    public static void updateCursor(AbstractButton b) {
        if (b == null) {
            throw new NullPointerException("b is null");
        }
        Boolean active = (Boolean)b.getClientProperty(CLIENT_PROPERTY_ACTIVE);
        boolean isActive = active == null ? false : active;
        b.setCursor(b.isEnabled() && isActive ? Cursor.getPredefinedCursor(12) : Cursor.getPredefinedCursor(0));
    }

    public void installListeners(AbstractButton b) {
        try {
            this._pcl = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    IconicButtonUI.updateCursor((AbstractButton)evt.getSource());
                }
            };
            b.addPropertyChangeListener("enabled", this._pcl);
        }
        finally {
            super.installListeners(b);
        }
    }

    public void uninstallListeners(AbstractButton b) {
        try {
            b.removePropertyChangeListener("enabled", this._pcl);
        }
        finally {
            super.uninstallListeners(b);
        }
    }

    public void paint(Graphics g, JComponent c) {
        if (Themes.isThemed() && c.getClientProperty(CLIENT_PROPERTY_NO_BACKGROUND) != Boolean.TRUE) {
            this.paintThemeBackground(g, c);
        }
        super.paint(g, c);
    }

    protected void paintThemeBackground(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        String state = "normal";
        if (this.isTextOnly(b)) {
            state = "over";
        }
        if (b.getModel().isSelected() || b.getModel().isArmed() && b.getModel().isPressed()) {
            state = "down";
        } else if (b.getModel().isRollover()) {
            state = "over";
        }
        Themes.getActiveTheme().getStateProperties("toolbarbuttoniconic.edge1", state).getPainter("bg").paint(g, 0, 0, c.getWidth(), c.getHeight());
        Themes.getActiveTheme().getStateProperties("toolbarbuttoniconic.edge2", state).getPainter("bg").paint(g, 0, 0, c.getWidth() - 1, c.getHeight());
        Themes.getActiveTheme().getStateProperties("toolbarbuttoniconic.edge3", state).getPainter("bg").paint(g, IconicButtonUI.insets.left, 0, c.getWidth() - IconicButtonUI.insets.left - IconicButtonUI.insets.right, c.getHeight());
        Themes.getActiveTheme().getStateProperties("toolbarbuttoniconic.edge4", state).getPainter("bg").paint(g, IconicButtonUI.insets.left, 0, c.getWidth() - IconicButtonUI.insets.left - IconicButtonUI.insets.right, c.getHeight());
        Themes.getActiveTheme().getStateProperties("toolbarbuttoniconic.center", state).getPainter("bg").paint(g.create(), IconicButtonUI.insets.left, IconicButtonUI.insets.top, c.getWidth() - IconicButtonUI.insets.left - IconicButtonUI.insets.right, c.getHeight() - IconicButtonUI.insets.top - IconicButtonUI.insets.bottom);
    }

    protected void paintButtonPressed(Graphics g, AbstractButton b) {
        if (!Themes.isThemed()) {
            super.paintButtonPressed(g, b);
        }
    }

    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        Insets insets;
        int x;
        boolean isDefault = b instanceof JButton && ((JButton)b).isDefaultButton();
        int y = x = isDefault ? 3 : 2;
        int width = b.getWidth() - x * 2;
        int height = b.getHeight() - y * 2;
        if (b.getBorder() != null && (insets = b.getBorder().getBorderInsets(b)) != null) {
            x = insets.left;
            y = insets.top;
            width = b.getWidth() - insets.left - insets.right;
            height = b.getHeight() - insets.top - insets.bottom;
            if (insets.left > 1) {
                --x;
                ++width;
            }
            if (insets.right > 1) {
                ++width;
            }
            if (insets.top > 1) {
                --y;
                ++height;
            }
            if (insets.bottom > 1) {
                ++height;
            }
        }
        g.setColor(this.getFocusColor());
        g.drawRect(x, y, width - 1, height - 1);
    }

    private boolean isTextOnly(AbstractButton button) {
        return button.getIcon() == null && button.getText() != null && button.getText().length() > 0 && this.isAncestorOfControlBar(button);
    }

    private boolean isAncestorOfControlBar(Component c) {
        if (c == null) {
            return false;
        }
        if (c instanceof ControlBar) {
            return true;
        }
        return this.isAncestorOfControlBar(c.getParent());
    }
}

