/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.plaf.theme;

import com.jgoodies.looks.plastic.PlasticToolBarUI;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.ComponentUI;
import oracle.javatools.ui.plaf.theme.ThemedToolBar;
import oracle.javatools.ui.plaf.theme.ThemedToolBarButtonUI;
import oracle.javatools.ui.plaf.theme.ThemedToolBarComboUI;
import oracle.javatools.ui.themes.Painter;
import oracle.javatools.ui.themes.Themes;

public class ThemedToolBarUI
extends PlasticToolBarUI {
    public static final String PROPERTY_TOOLBAR_PRIMARY = "isPrimary";
    public static final String PROPERTY_TOOLBAR_SECONDARY = "isSecondary";
    @Deprecated
    public static final String PROPERTY_TOOLBAR_ACTIVE = "isActive";

    public static ComponentUI createUI(JComponent toolbar) {
        return new ThemedToolBarUI();
    }

    protected void setBorderToRollover(Component c) {
        if (!Themes.isThemed()) {
            super.setBorderToRollover(c);
        } else if (c instanceof AbstractButton) {
            if (c instanceof JCheckBox || c instanceof JRadioButton) {
                super.setBorderToRollover(c);
            } else {
                ((AbstractButton)c).setUI((ButtonUI)((Object)new ThemedToolBarButtonUI()));
            }
        } else if (c instanceof JComboBox) {
            ((JComboBox)c).setUI((ComboBoxUI)((Object)new ThemedToolBarComboUI()));
        }
    }

    protected Border createRolloverBorder() {
        if (Themes.isThemed()) {
            return new EmptyBorder(Themes.getActiveTheme().getPartProperties("toolbarbutton").getInsets("outermargin"));
        }
        return super.createRolloverBorder();
    }

    protected Border createNonRolloverBorder() {
        if (Themes.isThemed()) {
            return new EmptyBorder(Themes.getActiveTheme().getPartProperties("toolbarbutton").getInsets("contentmargin"));
        }
        return super.createNonRolloverBorder();
    }

    public void update(Graphics g, JComponent c) {
        boolean themedPrimary;
        super.update(g, c);
        Object primaryProp = c.getClientProperty(PROPERTY_TOOLBAR_PRIMARY);
        Object secondaryProp = c.getClientProperty(PROPERTY_TOOLBAR_SECONDARY);
        boolean bl = themedPrimary = c instanceof ThemedToolBar && ((ThemedToolBar)((Object)c)).isPrimaryToolbar();
        if (themedPrimary || primaryProp == Boolean.TRUE) {
            String state = "primary";
            this.paintToolbar(g, c, state);
        } else if (secondaryProp == Boolean.TRUE) {
            String state = "secondary";
            this.paintToolbar(g, c, state);
        }
    }

    private void paintToolbar(Graphics g, JComponent c, String state) {
        Painter p = Themes.getActiveTheme().getStateProperties("toolbar", state).getPainter("bg");
        p.paint(g, 0, 0, c.getWidth(), c.getHeight());
        p = Themes.getActiveTheme().getStateProperties("toolbaredge1", state).getPainter("bg");
        p.paint(g, 0, 0, c.getWidth(), c.getHeight());
        p = Themes.getActiveTheme().getStateProperties("toolbaredge2", state).getPainter("bg");
        p.paint(g, 0, 0, c.getWidth(), c.getHeight());
    }
}

