/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.tree;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import oracle.javatools.ui.tree.TreeMouseClickHandler;

public class TreeMouseAdapter
extends MouseAdapter {
    JTree myTree;
    int pressedRow;
    long pressedTime;
    static final int BOUNCE_TIME = 150;

    public TreeMouseAdapter(JTree tree) {
        this.myTree = tree;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.pressedTime = e.getWhen();
        this.pressedRow = this.myTree.getRowForLocation(e.getX(), e.getY());
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        TreePath selPath;
        Object node;
        if (this.pressedRow == -1) {
            this.pressedTime = -1L;
            return;
        }
        long releasedTime = e.getWhen();
        int releasedRow = this.myTree.getRowForLocation(e.getX(), e.getY());
        long diffTime = releasedTime - this.pressedTime;
        if ((this.pressedRow == releasedRow || diffTime <= 150L) && (node = (selPath = this.myTree.getPathForRow(this.pressedRow)).getLastPathComponent()) instanceof TreeMouseClickHandler) {
            ((TreeMouseClickHandler)node).handleMouseClick();
            this.myTree.revalidate();
            this.myTree.repaint();
        }
    }
}

