/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.plsql;

import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.token.Token;
import oracle.javatools.db.token.Tokenizer;

public class PlSqlTokenizer {
    private static final Collection<String> s_twoCharOperators = Collections.unmodifiableCollection(Arrays.asList(":=", "=>", "||", "**", "<<", ">>", "..", "<>", "!=", "~=", "^=", "<=", ">="));
    private static final String DOUBLE_SLASH = "//";
    private Tokenizer m_tokenizer;

    PlSqlTokenizer(String string, String ... stringArray) {
        if (string != null) {
            Tokenizer.Config config = new Tokenizer.Config();
            config.setSource(string);
            config.setFactory(new DefaultTokenFactory());
            config.addTokens(Token.Type.PUNCTUATION, PlSqlTokenizer.getTwoCharOperators());
            if (stringArray != null && stringArray.length > 0) {
                config.addTokens(Token.Type.USER_TOKEN, Arrays.asList(stringArray));
            }
            this.m_tokenizer = new Tokenizer(config);
        }
    }

    @Deprecated
    public int getLineNumber(int n) {
        return -1;
    }

    final PlSqlToken getStartMarker() {
        return (PlSqlToken)(this.m_tokenizer == null ? null : this.m_tokenizer.getStartMarker());
    }

    final PlSqlToken getEndMarker() {
        return (PlSqlToken)(this.m_tokenizer == null ? null : this.m_tokenizer.getEndMarker());
    }

    final PlSqlToken getFirst() {
        return (PlSqlToken)(this.m_tokenizer == null ? null : this.m_tokenizer.getFirst());
    }

    public static PlSqlToken tokenize(String string, String ... stringArray) {
        return PlSqlTokenizer.tokenize(string, null, null, stringArray);
    }

    public static PlSqlToken tokenize(String string, Tokenizer.TokenFactory tokenFactory) {
        return PlSqlTokenizer.tokenize(string, null, tokenFactory, new String[0]);
    }

    public static PlSqlToken tokenize(Reader reader) {
        return PlSqlTokenizer.tokenize(reader, null, null, new String[0]);
    }

    public static PlSqlToken tokenize(Reader reader, Integer n) {
        return PlSqlTokenizer.tokenize(reader, n, null, new String[0]);
    }

    public static Collection<String> getTwoCharOperators() {
        return s_twoCharOperators;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PlSqlToken tokenize(String string, Integer n, Tokenizer.TokenFactory tokenFactory, String ... stringArray) {
        PlSqlToken plSqlToken = null;
        if (string != null) {
            try (StringReader stringReader = new StringReader(string);){
                plSqlToken = PlSqlTokenizer.tokenize(stringReader, n, tokenFactory, stringArray);
            }
        }
        return plSqlToken;
    }

    public static PlSqlToken tokenize(Reader reader, Integer n, Tokenizer.TokenFactory tokenFactory, String ... stringArray) {
        PlSqlToken plSqlToken = null;
        if (reader != null) {
            Tokenizer.Config config = new Tokenizer.Config();
            config.setReader(reader);
            config.setMaxTokens(n);
            if (tokenFactory != null) {
                config.setFactory(tokenFactory);
            } else {
                config.setFactory(new DefaultTokenFactory());
            }
            config.addTokens(Token.Type.PUNCTUATION, PlSqlTokenizer.getTwoCharOperators());
            if (stringArray != null && stringArray.length > 0) {
                config.addTokens(Token.Type.USER_TOKEN, Arrays.asList(stringArray));
            }
            Tokenizer tokenizer = new Tokenizer(config);
            plSqlToken = (PlSqlToken)tokenizer.getFirst();
        }
        return plSqlToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static PlSqlToken tokenizeJava(String string) {
        PlSqlToken plSqlToken = null;
        if (string != null) {
            try (StringReader stringReader = new StringReader(string);){
                Tokenizer.Config config = new Tokenizer.Config();
                config.setReader(stringReader);
                config.setSingleLineCommentStart(DOUBLE_SLASH);
                config.setFactory(new DefaultTokenFactory());
                Tokenizer tokenizer = new Tokenizer(config);
                plSqlToken = (PlSqlToken)tokenizer.getStartMarker().getNextToken();
            }
        }
        return plSqlToken;
    }

    private static class DefaultTokenFactory
    implements Tokenizer.TokenFactory {
        private DefaultTokenFactory() {
        }

        @Override
        public Token createToken(Token.Type type, int n, Token token) {
            return new PlSqlToken(type, n, (PlSqlToken)token);
        }

        @Override
        public void setEnd(Token token, int n) {
            token.setEnd(n);
        }
    }
}

