/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.spi.profilesupport;

import javax.ide.util.MetaClass;
import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ide.resource.ModelArb;
import oracle.jdeveloper.deploy.Profile;
import oracle.jdeveloper.deploy.spi.profilesupport.ProfileInfo;

public class DefaultProfileInfo
implements ProfileInfo {
    private MetaClass<Profile> profileMetaClass;
    private Class<Profile> profileClass;
    private String id;
    private boolean applicationLevel;
    private boolean projectLevel;
    private String shortLabel;
    private String longLabel;
    private Icon icon;
    private String tooltip;
    private String description;

    protected DefaultProfileInfo() {
    }

    public DefaultProfileInfo(MetaClass<Profile> profileMetaClass, String id, boolean appLevel, boolean projectLevel, String shortLabel, String longLabel, String tooltip, Icon icon) {
        this.setProfileMetaClass(profileMetaClass);
        this.setId(id);
        this.setApplicationLevel(appLevel);
        this.setProjectLevel(projectLevel);
        this.setShortLabel(shortLabel);
        this.setLongLabel(longLabel);
        this.setToolTipText(tooltip);
        this.setIcon(icon);
    }

    protected void setApplicationLevel(boolean applicationLevel) {
        this.applicationLevel = applicationLevel;
    }

    @Override
    public boolean isApplicationLevel() {
        return this.applicationLevel;
    }

    protected void setProjectLevel(boolean projectLevel) {
        this.projectLevel = projectLevel;
    }

    @Override
    public boolean isProjectLevel() {
        return this.projectLevel;
    }

    protected void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        if (this.id != null) {
            return this.id;
        }
        return this.getProfileClassName();
    }

    @Override
    public String getProfileClassName() {
        return this.getProfileMetaClass() == null ? null : this.getProfileMetaClass().getClassName();
    }

    protected void setProfileMetaClass(MetaClass<Profile> profileMetaClass) {
        this.profileMetaClass = profileMetaClass;
        this.profileClass = null;
    }

    public MetaClass<Profile> getProfileMetaClass() {
        return this.profileMetaClass;
    }

    @Override
    public synchronized Class<Profile> getProfileClass() {
        if (this.profileClass == null && this.profileMetaClass != null) {
            try {
                this.profileClass = this.profileMetaClass.toClass();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                this.profileMetaClass = null;
            }
        }
        return this.profileClass;
    }

    @Override
    public boolean isAvailable(Context context) {
        if (context.getProject() != null) {
            return this.isProjectLevel();
        }
        if (context.getWorkspace() != null) {
            return this.isApplicationLevel();
        }
        return !this.isProjectLevel() && !this.isApplicationLevel();
    }

    protected void setShortLabel(String shortLabel) {
        this.shortLabel = shortLabel;
    }

    public String getShortLabel() {
        return this.shortLabel;
    }

    protected void setLongLabel(String longLabel) {
        this.longLabel = longLabel;
    }

    public String getLongLabel() {
        return this.longLabel;
    }

    protected void setIcon(Icon icon) {
        this.icon = icon;
    }

    public Icon getIcon() {
        if (this.icon == null) {
            return ModelArb.getIcon((int)15);
        }
        return this.icon;
    }

    protected void setToolTipText(String tooltip) {
        this.tooltip = tooltip;
    }

    public String getToolTipText() {
        return this.tooltip;
    }
}

