/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.hook;

import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import oracle.jdeveloper.deploy.meta.MetadataException;
import oracle.jdeveloper.deploy.meta.Platform;
import oracle.jdeveloper.deploy.meta.PlatformRegistry;
import oracle.jdeveloper.deploy.meta.PlatformType;
import oracle.jdevimpl.deploy.hook.BaseElementVisitor;

public class PlatformDefinitionsHandler
extends BaseElementVisitor {
    static final ElementName EN_PLATFORM_DEFINITIONS = PlatformDefinitionsHandler.e("platform-definitions");
    static final ElementName EN_PLATFORM = PlatformDefinitionsHandler.e("platform");
    static final String ATTR_PLATFORM_TYPE = "type";
    static final String ATTR_PLATFORM_VERSION = "version";
    static final String ATTR_PLATFORM_ISDEFAULT = "default";
    static final String ATTR_PLATFORM_SHORTLABEL = "short-label";
    static final String ATTR_PLATFORM_LONGLABEL = "long-label";

    public void start(ElementStartContext context) {
        ElementName name;
        if (EN_PLATFORM_DEFINITIONS.equals((Object)context.getElementName())) {
            context.registerChildVisitor(EN_PLATFORM, (ElementVisitor)this);
        } else if (EN_PLATFORM.equals((Object)context.getElementName()) && EN_PLATFORM.equals((Object)(name = context.getElementName()))) {
            String type = context.getAttributeValue(ATTR_PLATFORM_TYPE);
            assert (type != null && !type.isEmpty());
            String version = context.getAttributeValue(ATTR_PLATFORM_VERSION);
            assert (version != null && !version.isEmpty());
            boolean isDefault = Boolean.parseBoolean(context.getAttributeValue(ATTR_PLATFORM_ISDEFAULT));
            String shortLabel = context.getAttributeValue(ATTR_PLATFORM_SHORTLABEL);
            String longLabel = context.getAttributeValue(ATTR_PLATFORM_LONGLABEL);
            PlatformType ptype = PlatformType.valueOf(type.trim());
            Platform platform = new Platform(ptype, version, longLabel, shortLabel);
            PlatformRegistry.registerPlatform(platform);
            if (isDefault) {
                try {
                    PlatformRegistry.setDefaultPlatform(platform);
                }
                catch (MetadataException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

