/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import java.lang.reflect.Executable;
import java.sql.SQLRecoverableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import java.util.logging.Logger;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.ucp.ConnectionAffinityCallback;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.admin.UniversalConnectionPoolManagerBase;
import oracle.ucp.common.AffinityContext;
import oracle.ucp.common.Applicator;
import oracle.ucp.common.Clock;
import oracle.ucp.common.ConnectionSource;
import oracle.ucp.common.CoreConnection;
import oracle.ucp.common.Counter;
import oracle.ucp.common.Instantiator;
import oracle.ucp.common.Limits;
import oracle.ucp.common.PeakIntegerCounter;
import oracle.ucp.common.Policies;
import oracle.ucp.common.Selector;
import oracle.ucp.common.Selectors;
import oracle.ucp.common.ServiceMember;
import oracle.ucp.common.waitfreepool.Factory;
import oracle.ucp.common.waitfreepool.Pool;
import oracle.ucp.common.waitfreepool.PoolIterator;
import oracle.ucp.common.waitfreepool.SkipList;
import oracle.ucp.common.waitfreepool.SkipListTuple;
import oracle.ucp.common.waitfreepool.kdtree.KDTree;
import oracle.ucp.common.waitfreepool.kdtree.Point;
import oracle.ucp.common.waitfreepool.kdtree.Range;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.util.TaskHandle;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.UCPTaskBase;
import oracle.ucp.util.Util;

@DefaultLogger(value="oracle.ucp.common")
@Supports(value={Feature.CHECK_IN, Feature.CHECK_OUT})
public final class Core {
    private final Pool<CoreConnection> waitFreePool = Factory.create();
    private Instantiator instantiator = new Instantiator(this.waitFreePool);
    private final AtomicReference<WFPTree> wfpTree = new AtomicReference<WFPTree>(WFPTree.seed());
    private static final boolean isAffinityStrict;
    private final Map<DRange, Boolean> skipListBuilds = new ConcurrentHashMap<DRange, Boolean>();
    private final Semaphore skipListBuildsSemaphore = new Semaphore(3);
    private Set<String> knownServices = ConcurrentHashMap.newKeySet();
    private AtomicReference<ConnectionSource> connectionSource = new AtomicReference<ConnectionSource>(ConnectionSource.IDLE);
    private AtomicReference<Limits> limits = new AtomicReference<Limits>(Limits.DEFAULT);
    private AtomicReference<Policies> policies = new AtomicReference<1>(new Policies(){
        private final IllegalStateException err = new IllegalStateException("policies are not set up yet");
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;

        @Override
        public ConnectionRetrievalInfo getMostPopularCri() {
            throw this.err;
        }

        @Override
        public boolean isCriUnpopular(ConnectionRetrievalInfo cri) {
            throw this.err;
        }

        static {
            try {
                $$$methodRef$$$2 = 1.class.getDeclaredConstructor(Core.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$1 = 1.class.getDeclaredMethod("isCriUnpopular", ConnectionRetrievalInfo.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$0 = 1.class.getDeclaredMethod("getMostPopularCri", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        }
    });
    private final AtomicLong emptyBorrows = new AtomicLong(0L);
    private final AtomicLong totalBorrows = new AtomicLong(0L);
    private AtomicInteger pendingAvailableGrows = new AtomicInteger();
    private AtomicInteger pendingBorrowedGrows = new AtomicInteger();
    private AtomicBoolean noMoreGrows = new AtomicBoolean(false);
    private ReentrantLock stoppingLock = new ReentrantLock();
    private Condition stoppingCondition = this.stoppingLock.newCondition();
    private AtomicLong repurposeCount = new AtomicLong(0L);
    private ReentrantLock handlersLock = new ReentrantLock();
    private static final Selector markedAlready;
    private static final long MAKE_ROOM_POSTPONEMENT = 120L;
    private volatile long notAvailTS = Clock.clock();
    private AtomicBoolean cleanUselessInProgress = new AtomicBoolean(false);
    private static final long INITIALIZE_TIMEOUT = 1000L;
    private final AtomicBoolean adjusterEnabled = new AtomicBoolean(false);
    private final AtomicBoolean adjusterBusy = new AtomicBoolean(false);
    private static final int HARVESTING_ATTEMPTS = 5;
    AtomicBoolean keepOverMinimum = new AtomicBoolean(false);
    private PeakIntegerCounter peakConnectionsCount = new PeakIntegerCounter();
    public static final int ADJUST_MIN_LIMIT_ATTEMPTS = 10;
    public static final int BEST_INSTANCE_CREATION_ATTEMPTS = 3;
    public static final long ADJUST_MIN_LIMIT_DELAY = 2000L;
    private static final Collection<Core> coreInstances;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;
    private static Executable $$$methodRef$$$44;
    private static Logger $$$loggerRef$$$44;
    private static Executable $$$methodRef$$$45;
    private static Logger $$$loggerRef$$$45;
    private static Executable $$$methodRef$$$46;
    private static Logger $$$loggerRef$$$46;
    private static Executable $$$methodRef$$$47;
    private static Logger $$$loggerRef$$$47;
    private static Executable $$$methodRef$$$48;
    private static Logger $$$loggerRef$$$48;
    private static Executable $$$methodRef$$$49;
    private static Logger $$$loggerRef$$$49;
    private static Executable $$$methodRef$$$50;
    private static Logger $$$loggerRef$$$50;
    private static Executable $$$methodRef$$$51;
    private static Logger $$$loggerRef$$$51;
    private static Executable $$$methodRef$$$52;
    private static Logger $$$loggerRef$$$52;
    private static Executable $$$methodRef$$$53;
    private static Logger $$$loggerRef$$$53;
    private static Executable $$$methodRef$$$54;
    private static Logger $$$loggerRef$$$54;
    private static Executable $$$methodRef$$$55;
    private static Logger $$$loggerRef$$$55;
    private static Executable $$$methodRef$$$56;
    private static Logger $$$loggerRef$$$56;
    private static Executable $$$methodRef$$$57;
    private static Logger $$$loggerRef$$$57;
    private static Executable $$$methodRef$$$58;
    private static Logger $$$loggerRef$$$58;
    private static Executable $$$methodRef$$$59;
    private static Logger $$$loggerRef$$$59;
    private static Executable $$$methodRef$$$60;
    private static Logger $$$loggerRef$$$60;
    private static Executable $$$methodRef$$$61;
    private static Logger $$$loggerRef$$$61;
    private static Executable $$$methodRef$$$62;
    private static Logger $$$loggerRef$$$62;
    private static Executable $$$methodRef$$$63;
    private static Logger $$$loggerRef$$$63;
    private static Executable $$$methodRef$$$64;
    private static Logger $$$loggerRef$$$64;
    private static Executable $$$methodRef$$$65;
    private static Logger $$$loggerRef$$$65;
    private static Executable $$$methodRef$$$66;
    private static Logger $$$loggerRef$$$66;
    private static Executable $$$methodRef$$$67;
    private static Logger $$$loggerRef$$$67;
    private static Executable $$$methodRef$$$68;
    private static Logger $$$loggerRef$$$68;
    private static Executable $$$methodRef$$$69;
    private static Logger $$$loggerRef$$$69;
    private static Executable $$$methodRef$$$70;
    private static Logger $$$loggerRef$$$70;
    private static Executable $$$methodRef$$$71;
    private static Logger $$$loggerRef$$$71;
    private static Executable $$$methodRef$$$72;
    private static Logger $$$loggerRef$$$72;
    private static Executable $$$methodRef$$$73;
    private static Logger $$$loggerRef$$$73;
    private static Executable $$$methodRef$$$74;
    private static Logger $$$loggerRef$$$74;
    private static Executable $$$methodRef$$$75;
    private static Logger $$$loggerRef$$$75;
    private static Executable $$$methodRef$$$76;
    private static Logger $$$loggerRef$$$76;
    private static Executable $$$methodRef$$$77;
    private static Logger $$$loggerRef$$$77;
    private static Executable $$$methodRef$$$78;
    private static Logger $$$loggerRef$$$78;
    private static Executable $$$methodRef$$$79;
    private static Logger $$$loggerRef$$$79;
    private static Executable $$$methodRef$$$80;
    private static Logger $$$loggerRef$$$80;
    private static Executable $$$methodRef$$$81;
    private static Logger $$$loggerRef$$$81;
    private static Executable $$$methodRef$$$82;
    private static Logger $$$loggerRef$$$82;
    private static Executable $$$methodRef$$$83;
    private static Logger $$$loggerRef$$$83;
    private static Executable $$$methodRef$$$84;
    private static Logger $$$loggerRef$$$84;
    private static Executable $$$methodRef$$$85;
    private static Logger $$$loggerRef$$$85;
    private static Executable $$$methodRef$$$86;
    private static Logger $$$loggerRef$$$86;
    private static Executable $$$methodRef$$$87;
    private static Logger $$$loggerRef$$$87;
    private static Executable $$$methodRef$$$88;
    private static Logger $$$loggerRef$$$88;
    private static Executable $$$methodRef$$$89;
    private static Logger $$$loggerRef$$$89;
    private static Executable $$$methodRef$$$90;
    private static Logger $$$loggerRef$$$90;
    private static Executable $$$methodRef$$$91;
    private static Logger $$$loggerRef$$$91;
    private static Executable $$$methodRef$$$92;
    private static Logger $$$loggerRef$$$92;
    private static Executable $$$methodRef$$$93;
    private static Logger $$$loggerRef$$$93;
    private static Executable $$$methodRef$$$94;
    private static Logger $$$loggerRef$$$94;
    private static Executable $$$methodRef$$$95;
    private static Logger $$$loggerRef$$$95;
    private static Executable $$$methodRef$$$96;
    private static Logger $$$loggerRef$$$96;
    private static Executable $$$methodRef$$$97;
    private static Logger $$$loggerRef$$$97;
    private static Executable $$$methodRef$$$98;
    private static Logger $$$loggerRef$$$98;
    private static Executable $$$methodRef$$$99;
    private static Logger $$$loggerRef$$$99;
    private static Executable $$$methodRef$$$100;
    private static Logger $$$loggerRef$$$100;
    private static Executable $$$methodRef$$$101;
    private static Logger $$$loggerRef$$$101;
    private static Executable $$$methodRef$$$102;
    private static Logger $$$loggerRef$$$102;
    private static Executable $$$methodRef$$$103;
    private static Logger $$$loggerRef$$$103;
    private static Executable $$$methodRef$$$104;
    private static Logger $$$loggerRef$$$104;
    private static Executable $$$methodRef$$$105;
    private static Logger $$$loggerRef$$$105;
    private static Executable $$$methodRef$$$106;
    private static Logger $$$loggerRef$$$106;
    private static Executable $$$methodRef$$$107;
    private static Logger $$$loggerRef$$$107;
    private static Executable $$$methodRef$$$108;
    private static Logger $$$loggerRef$$$108;
    private static Executable $$$methodRef$$$109;
    private static Logger $$$loggerRef$$$109;
    private static Executable $$$methodRef$$$110;
    private static Logger $$$loggerRef$$$110;
    private static Executable $$$methodRef$$$111;
    private static Logger $$$loggerRef$$$111;
    private static Executable $$$methodRef$$$112;
    private static Logger $$$loggerRef$$$112;
    private static Executable $$$methodRef$$$113;
    private static Logger $$$loggerRef$$$113;
    private static Executable $$$methodRef$$$114;
    private static Logger $$$loggerRef$$$114;
    private static Executable $$$methodRef$$$115;
    private static Logger $$$loggerRef$$$115;
    private static Executable $$$methodRef$$$116;
    private static Logger $$$loggerRef$$$116;
    private static Executable $$$methodRef$$$117;
    private static Logger $$$loggerRef$$$117;
    private static Executable $$$methodRef$$$118;
    private static Logger $$$loggerRef$$$118;
    private static Executable $$$methodRef$$$119;
    private static Logger $$$loggerRef$$$119;
    private static Executable $$$methodRef$$$120;
    private static Logger $$$loggerRef$$$120;
    private static Executable $$$methodRef$$$121;
    private static Logger $$$loggerRef$$$121;
    private static Executable $$$methodRef$$$122;
    private static Logger $$$loggerRef$$$122;

    void clearWFPTree() {
        this.wfpTree.set(WFPTree.seed());
        this.skipListBuilds.clear();
    }

    Core() {
        coreInstances.add(this);
        ClioSupport.ilogFinest(null, null, null, null, this.toString() + " core object to watch pending grows added");
    }

    private void put(CoreConnection conn) {
        this.waitFreePool.put(((Instantiator.Connection)conn).register());
        this.clearWFPTree();
        conn.serviceMember().serviceRef.buildDistributionTable();
        Properties labels = conn.cri().getLabels();
        if (null != labels && !labels.isEmpty()) {
            this.connectionSource().labeledCount().incrementAndGet();
        }
        int totalCount = this.totalCount().get();
        this.peakConnectionsCount.update(totalCount);
        if (totalCount + this.pendingBorrowedGrows.get() + this.pendingAvailableGrows.get() >= this.limits().getMin()) {
            this.keepOverMinimum.set(true);
        }
    }

    void forEach(Applicator applicator) {
        this.forSome(Selectors.EVERY, applicator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<CoreConnection> split(Selector selector) {
        ArrayList<CoreConnection> connections = new ArrayList<CoreConnection>();
        PoolIterator<CoreConnection> it = this.waitFreePool.poolIterator(true);
        try {
            while (it.hasNext()) {
                CoreConnection connection = (CoreConnection)it.next();
                if (!selector.selected(connection)) continue;
                it.remove();
                ((Instantiator.Connection)connection).unregister();
                this.clearWFPTree();
                connection.serviceMember().serviceRef.buildDistributionTable();
                connections.add(connection);
            }
        }
        finally {
            it.release();
        }
        return connections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forSome(Selector selector, Applicator applicator, Supplier<PoolIterator<CoreConnection>>[] suppliers) {
        for (Supplier<PoolIterator<CoreConnection>> supplier : suppliers) {
            PoolIterator<CoreConnection> it = supplier.get();
            try {
                while (it.hasNext()) {
                    CoreConnection conn = (CoreConnection)it.next();
                    if (!selector.selected(conn)) continue;
                    applicator.apply(conn);
                }
            }
            finally {
                it.release();
            }
        }
    }

    private void forSome(Selector selector, Applicator applicator, Supplier<PoolIterator<CoreConnection>> supplier) {
        this.forSome(selector, applicator, new Supplier[]{supplier});
    }

    private void forSome(Selector selector, Applicator applicator) {
        this.forSome(selector, applicator, () -> this.waitFreePool.poolIterator(true));
    }

    private static Range[] searchCriteria(String serviceName) {
        return Core.searchCriteria(serviceName, null, 0, 0);
    }

    private static Range[] searchCriteria(String serviceName, Properties reqLabels, int lowCost, int highCost) {
        return new Range[]{new Range((Comparable)((Object)serviceName)), new Range((Comparable)((Object)(null == reqLabels ? "" : reqLabels.toString()))), new Range(Integer.valueOf(lowCost), Integer.valueOf(highCost))};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SkipList<CoreConnection> prepareSkipList(String serviceName) {
        Range[] sc = Core.searchCriteria(serviceName);
        List skipLists = this.wfpTree.get().search(sc);
        if (skipLists.size() > 0) {
            return (SkipList)skipLists.get(0).getData();
        }
        if (null == this.skipListBuilds.putIfAbsent(new DRange(sc), Boolean.TRUE)) {
            KDTree[] skipList = new KDTree[]{null};
            try {
                this.skipListBuildsSemaphore.acquire();
                this.waitFreePool.buildSkipLists(new SkipListTuple<CoreConnection>(p -> p.serviceName().equals(serviceName), p -> {
                    skipList[0] = new WFPTree((SkipList)p, serviceName, "", 0);
                    this.wfpTree.get().merge(skipList[0]);
                }));
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.skipListBuildsSemaphore.release();
            }
            return (SkipList)skipList[0].getData();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SkipList<CoreConnection> preparePerfectCostSkipList(String serviceName, Properties reqLabels) {
        if (null == reqLabels) {
            return this.prepareSkipList(serviceName);
        }
        Range[] sc = Core.searchCriteria(serviceName, reqLabels, 0, 0);
        List skipLists = this.wfpTree.get().search(sc);
        if (skipLists.size() > 0) {
            return (SkipList)skipLists.get(0).getData();
        }
        if (null == this.skipListBuilds.putIfAbsent(new DRange(sc), Boolean.TRUE)) {
            KDTree[] skipList = new KDTree[]{null};
            try {
                this.skipListBuildsSemaphore.acquire();
                this.waitFreePool.buildSkipLists(new SkipListTuple<CoreConnection>(p -> p.serviceName().equals(serviceName) && 0 == p.labelingCost(reqLabels), p -> {
                    skipList[0] = new WFPTree((SkipList)p, serviceName, reqLabels.toString(), 0);
                    this.wfpTree.get().merge(skipList[0]);
                }));
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.skipListBuildsSemaphore.release();
            }
            return (SkipList)skipList[0].getData();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SkipList<CoreConnection> prepareAcceptableCostSkipList(String serviceName, Properties reqLabels) {
        if (null == reqLabels) {
            return this.prepareSkipList(serviceName);
        }
        Range[] sc = Core.searchCriteria(serviceName, reqLabels, 1, 0x7FFFFFFE);
        List skipLists = this.wfpTree.get().search(sc);
        if (skipLists.size() > 0) {
            return (SkipList)skipLists.get(0).getData();
        }
        if (null == this.skipListBuilds.putIfAbsent(new DRange(sc), Boolean.TRUE)) {
            KDTree[] skipList = new KDTree[]{null};
            try {
                this.skipListBuildsSemaphore.acquire();
                this.waitFreePool.buildSkipLists(new SkipListTuple<CoreConnection>(p -> {
                    int cost = p.labelingCost(reqLabels);
                    return p.serviceName().equals(serviceName) && cost > 0 && cost < Integer.MAX_VALUE;
                }, p -> {
                    skipList[0] = new WFPTree((SkipList)p, serviceName, reqLabels.toString(), 1);
                    this.wfpTree.get().merge(skipList[0]);
                }));
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.skipListBuildsSemaphore.release();
            }
            return (SkipList)skipList[0].getData();
        }
        return null;
    }

    private Supplier<SkipList<CoreConnection>>[] costSuppliers(String serviceName, Properties reqLabels) {
        return new Supplier[]{() -> this.preparePerfectCostSkipList(serviceName, reqLabels), () -> this.prepareAcceptableCostSkipList(serviceName, reqLabels)};
    }

    private Supplier<SkipList<CoreConnection>>[] serviceSuppliers(String serviceName) {
        return new Supplier[]{() -> this.prepareSkipList(serviceName)};
    }

    private Supplier<PoolIterator<CoreConnection>>[] poolIterators(Supplier<SkipList<CoreConnection>>[] suppliers, boolean revisit) {
        Supplier[] iters = new Supplier[suppliers.length];
        for (int i = 0; i < iters.length; ++i) {
            Supplier<SkipList<CoreConnection>> supplier = suppliers[i];
            iters[i] = () -> {
                SkipList list = (SkipList)supplier.get();
                return null == list ? this.waitFreePool.poolIterator(revisit) : list.poolIterator(revisit);
            };
        }
        return iters;
    }

    private Supplier<PoolIterator<CoreConnection>> servicePoolIterator(String serviceName, boolean revisit) {
        return this.poolIterators(this.serviceSuppliers(serviceName), revisit)[0];
    }

    private Supplier<PoolIterator<CoreConnection>>[] costPoolIterators(String serviceName, Properties reqLabels, boolean revisit) {
        return this.poolIterators(this.costSuppliers(serviceName, reqLabels), revisit);
    }

    private static Selector serviceSelector(String serviceName) {
        return conn -> conn.serviceName().equals(serviceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forFirst(Selector selector, Applicator applicator, Supplier<PoolIterator<CoreConnection>>[] suppliers) {
        for (Supplier<PoolIterator<CoreConnection>> supplier : suppliers) {
            PoolIterator<CoreConnection> it = supplier.get();
            try {
                while (it.hasNext()) {
                    CoreConnection conn = (CoreConnection)it.next();
                    if (!selector.selected(conn)) continue;
                    applicator.apply(conn);
                    return;
                }
            }
            finally {
                it.release();
            }
        }
    }

    private void forFirst(Selector selector, Applicator applicator, Supplier<PoolIterator<CoreConnection>> supplier) {
        this.forFirst(selector, applicator, new Supplier[]{supplier});
    }

    private void forFirst(Selector selector, Applicator applicator) {
        this.forFirst(selector, applicator, () -> this.waitFreePool.poolIterator(true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoreConnection retrieveFirst(Selector selector) {
        CoreConnection found = null;
        PoolIterator<CoreConnection> it = this.waitFreePool.poolIterator(true);
        try {
            while (it.hasNext()) {
                CoreConnection conn = (CoreConnection)it.next();
                if (!selector.selected(conn)) continue;
                it.remove();
                ((Instantiator.Connection)conn).unregister();
                this.clearWFPTree();
                conn.serviceMember().serviceRef.buildDistributionTable();
                Properties labels = conn.cri().getLabels();
                if (null != labels && !labels.isEmpty()) {
                    this.connectionSource().labeledCount().decrementAndGet();
                }
                found = conn;
                break;
            }
        }
        finally {
            it.release();
        }
        return found;
    }

    private void registerService(String serviceName) {
        this.knownServices.add(serviceName);
        ConnectionSource.FailoverCallback failoverCallback = this.prepareFailoverHandler(serviceName);
        ConnectionSource.RebalanceCallback rebalanceCallback = this.prepareRebalanceHandler(serviceName);
        this.connectionSource().registerService(this.instantiator, serviceName, failoverCallback, rebalanceCallback);
    }

    final void plugConnectionSource(ConnectionSource connectionSource) {
        if (connectionSource == null) {
            throw new IllegalArgumentException("null connectionSource");
        }
        this.connectionSource.set(connectionSource);
    }

    public ConnectionSource connectionSource() {
        return this.connectionSource.get();
    }

    final void plugLimits(Limits limits) {
        if (limits == null) {
            throw new IllegalArgumentException("null limits");
        }
        this.limits.set(limits);
    }

    private Limits limits() {
        return this.limits.get();
    }

    final void plugPolicies(Policies policies) {
        if (policies == null) {
            throw new IllegalArgumentException("null policies");
        }
        this.policies.set(policies);
    }

    private Policies policies() {
        return this.policies.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Supports(value={Feature.CHECK_OUT})
    final CoreConnection borrow(ConnectionRetrievalInfo cri, ConnectionAffinityCallback callback, long timeout) {
        CoreConnection conn = null;
        try {
            conn = this.helpBorrow(cri, callback, timeout);
        }
        finally {
            this.totalBorrows.incrementAndGet();
            if (conn != null) {
                try {
                    conn.onBorrow(cri);
                }
                catch (UniversalConnectionPoolException e) {
                    ClioSupport.ilogThrowing(null, null, null, null, e);
                }
            } else {
                this.emptyBorrows.incrementAndGet();
                if (0L == this.emptyBorrows.get() % 1000L) {
                    ClioSupport.ilogFinest(null, null, null, null, "permits=" + this.connectionSource().getBorrowSemaphore(cri).availablePermits() + ", borrows: empty/total= " + (float)this.emptyBorrows.get() / (float)this.totalBorrows.get() * 100.0f + "%");
                }
            }
        }
        return conn;
    }

    @Supports(value={Feature.CHECK_OUT})
    private CoreConnection helpBorrow(final ConnectionRetrievalInfo cri, ConnectionAffinityCallback callback, final long timeout) {
        boolean[] perfectMatch = new boolean[]{false};
        CoreConnection[] selectedConn = new CoreConnection[]{null};
        final CoreConnection[] currentConn = new CoreConnection[]{null};
        ConnectionSource cs = this.connectionSource();
        String serviceName = cs.serviceName(cri);
        Properties reqLabels = cri.getLabels();
        Comparator<CoreConnection> costComparator = cs.costComparator(reqLabels);
        Selector perfectCostSelector = cs.perfectCostSelector(reqLabels);
        Selector wrongCostSelector = cs.wrongCostSelector(reqLabels);
        Selector keyBasedSelector = Selectors.or(cs.routingKeyBasedBorrowSelector(cri, true), cs.routingKeyBasedBorrowSelector(cri, false));
        Selector appropAvailBalancedSelector = conn -> {
            if (conn.closed() || conn.bad()) {
                this.cleanUselessAsynch();
                return false;
            }
            if (!conn.available()) {
                return false;
            }
            if (!conn.cri().equalsIncludingPassword(cri)) {
                return false;
            }
            boolean loadBalanced = cs.loadBalancedBorrowSelector(cri, callback).selected(conn);
            if (wrongCostSelector.selected(conn)) {
                return false;
            }
            if (perfectCostSelector.selected(conn)) {
                perfectMatch[0] = loadBalanced;
                return perfectMatch[0];
            }
            CoreConnection sc = selectedConn[0];
            return loadBalanced && (null == sc || costComparator.compare(conn, sc) < 0);
        };
        Selector appropAvailSelector = conn -> {
            if (conn.closed() || conn.bad()) {
                this.cleanUselessAsynch();
                return false;
            }
            if (!conn.available()) {
                return false;
            }
            if (!conn.cri().equalsIncludingPassword(cri)) {
                return false;
            }
            if (wrongCostSelector.selected(conn)) {
                return false;
            }
            if (perfectCostSelector.selected(conn)) {
                perfectMatch[0] = true;
                return true;
            }
            CoreConnection sc = selectedConn[0];
            return null == sc || costComparator.compare(conn, sc) < 0;
        };
        final Core outerThis = this;
        final class ForFirstCaller {
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;

            ForFirstCaller() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void forFirst(Selector selector, Supplier<PoolIterator<CoreConnection>>[] suppliers) {
                CoreConnection[] conn1 = new CoreConnection[]{null};
                try {
                    Core.this.connectionSource().getBorrowSemaphore(cri).tryAcquire(timeout, TimeUnit.MILLISECONDS);
                    outerThis.forFirst(selector, p -> {
                        p.makeUnavailable();
                        conn1[0] = p;
                    }, suppliers);
                }
                catch (InterruptedException e) {
                    ClioSupport.ilogThrowing(null, null, null, null, e);
                }
                finally {
                    if (null != conn1[0]) {
                        currentConn[0] = conn1[0];
                    }
                }
            }

            static {
                try {
                    $$$methodRef$$$3 = ForFirstCaller.class.getDeclaredConstructor(Core.class, ConnectionRetrievalInfo.class, Long.TYPE, Core.class, CoreConnection[].class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$2 = ForFirstCaller.class.getDeclaredMethod("access$100", ForFirstCaller.class, Selector.class, Supplier[].class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$1 = ForFirstCaller.class.getDeclaredMethod("lambda$forFirst$0", CoreConnection[].class, CoreConnection.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = ForFirstCaller.class.getDeclaredMethod("forFirst", Selector.class, Supplier[].class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        }
        ForFirstCaller ffc = new ForFirstCaller();
        do {
            boolean dbAffinity;
            currentConn[0] = null;
            Selector balancedSelector = cs.isShardedDatabase() || cs.isRacDataAffinityEnabled() ? Selectors.and(appropAvailBalancedSelector, Core.serviceSelector(serviceName), keyBasedSelector) : Selectors.and(appropAvailBalancedSelector, Core.serviceSelector(serviceName));
            Selector unBalancedSelector = cs.isShardedDatabase() || cs.isRacDataAffinityEnabled() ? Selectors.and(appropAvailSelector, Core.serviceSelector(serviceName), keyBasedSelector) : Selectors.and(appropAvailSelector, Core.serviceSelector(serviceName));
            boolean bl = dbAffinity = null != callback && ConnectionAffinityCallback.AffinityPolicy.DATA_BASED_AFFINITY == callback.getAffinityPolicy();
            if (cs.failoverEnabled() || dbAffinity) {
                ffc.forFirst(balancedSelector, this.costPoolIterators(serviceName, reqLabels, false));
                if (null == currentConn[0]) {
                    if (cs.isRacDataAffinityEnabled()) {
                        ffc.forFirst(unBalancedSelector, this.costPoolIterators(serviceName, reqLabels, false));
                        if (null == currentConn[0] && !isAffinityStrict) {
                            ffc.forFirst(Selectors.and(appropAvailBalancedSelector, Core.serviceSelector(serviceName)), this.costPoolIterators(serviceName, reqLabels, false));
                        }
                    } else if (!dbAffinity || !isAffinityStrict) {
                        ffc.forFirst(unBalancedSelector, this.costPoolIterators(serviceName, reqLabels, false));
                    }
                } else if (null != callback) {
                    ConnectionAffinityCallback.AffinityPolicy policy = callback.getAffinityPolicy();
                    if (callback.getConnectionAffinityContext() == null) {
                        ServiceMember chosenConnInstance = currentConn[0].serviceMember();
                        if (ConnectionAffinityCallback.AffinityPolicy.WEBSESSION_BASED_AFFINITY == policy && chosenConnInstance.affined() || ConnectionAffinityCallback.AffinityPolicy.TRANSACTION_BASED_AFFINITY == policy) {
                            ClioSupport.ilogFinest(null, null, null, null, String.format("Updating affinity context with instance %s", chosenConnInstance.name()));
                            callback.setConnectionAffinityContext(new AffinityContext(chosenConnInstance.service(), chosenConnInstance.database(), chosenConnInstance.name(), policy));
                        }
                    }
                }
            } else {
                ffc.forFirst(unBalancedSelector, this.costPoolIterators(serviceName, reqLabels, false));
            }
            if (null == currentConn[0]) {
                if (cs.failoverEnabled() && selectedConn[0] != null) {
                    this.updateRLBStats(selectedConn[0].serviceMember());
                }
                return selectedConn[0];
            }
            CoreConnection connToReturn = selectedConn[0];
            selectedConn[0] = currentConn[0];
            if (null == connToReturn) continue;
            connToReturn.makeAvailable();
        } while (!perfectMatch[0]);
        if (cs.failoverEnabled() && currentConn[0] != null) {
            this.updateRLBStats(currentConn[0].serviceMember());
        }
        return currentConn[0];
    }

    @Supports(value={Feature.POOL_STATISTICS})
    private void updateRLBStats(ServiceMember serviceMember) {
        if (serviceMember.violatingRLBAdvisory()) {
            serviceMember.lbStats.onFailedLbBorrowed();
            serviceMember.serviceRef.lbStats.onFailedLbBorrowed();
        } else {
            serviceMember.lbStats.onSuccessfulLbBorrowed();
            serviceMember.serviceRef.lbStats.onSuccessfulLbBorrowed();
        }
    }

    @Supports(value={Feature.CHECK_IN})
    final void reclaim(CoreConnection conn) {
        if (conn.available()) {
            return;
        }
        boolean replaceOnReturn = false;
        if (conn.normal()) {
            if (conn.reusable()) {
                try {
                    conn.onReturn();
                }
                catch (UniversalConnectionPoolException e) {
                    ClioSupport.ilogThrowing(null, null, null, null, e);
                }
                conn.makeAvailable();
                return;
            }
            if (!conn.markedCloseOnReturn()) {
                replaceOnReturn = true;
            }
        } else if (conn.markedToReplace()) {
            replaceOnReturn = true;
        }
        this.retrieve(conn);
        conn.abort();
        conn.close();
        if (replaceOnReturn) {
            this.growAvailableAsynch(conn.cri());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final CoreConnection growBorrowed(ConnectionRetrievalInfo cri, ConnectionAffinityCallback callback, long timeToRetry) throws UniversalConnectionPoolException {
        CoreConnection connection = null;
        int total = this.totalCount().get() + this.pendingAvailableGrows.get() + this.pendingBorrowedGrows.incrementAndGet();
        try {
            int retries = 5;
            String serviceName = this.connectionSource().serviceName(cri);
            for (int i = 0; i < 5; ++i) {
                if (this.noMoreGrows.get()) {
                    CoreConnection coreConnection = null;
                    return coreConnection;
                }
                if (this.connectionSource().isMultitenantDatabase() && total > this.limits().getMin() && total > this.limits().getRepurposeThreshold() && (connection = this.tryRepurpose(cri)) != null) {
                    this.repurposeCount.getAndIncrement();
                } else {
                    if (!this.connectionSource().isServiceRegistered(serviceName)) {
                        this.registerService(serviceName);
                    }
                    if (total > this.limits().getMax()) {
                        if (this.makeRoom(cri)) {
                            connection = this.connectionSource().create(cri, callback, EnumSet.of(ConnectionSource.CreateMode.USE_BEST_INSTANCE), timeToRetry);
                            if (connection == null) continue;
                        }
                    } else {
                        connection = this.connectionSource().create(cri, callback, EnumSet.of(ConnectionSource.CreateMode.USE_BEST_INSTANCE), timeToRetry);
                    }
                }
                break;
            }
        }
        finally {
            if (null != connection) {
                try {
                    connection.onBorrow(cri);
                }
                catch (UniversalConnectionPoolException e) {
                    ClioSupport.ilogThrowing(null, null, null, null, e);
                }
                connection.makeUnavailable();
                this.put(connection);
            }
            this.pendingBorrowedGrows.getAndDecrement();
            if (this.noMoreGrows.get() && this.pendingBorrowedGrows.get() + this.pendingAvailableGrows.get() == 0) {
                try {
                    this.stoppingLock.lock();
                    this.stoppingCondition.signal();
                }
                finally {
                    this.stoppingLock.unlock();
                }
            }
        }
        if (null != connection) {
            ClioSupport.ilogFinest(null, null, null, null, "connection=" + connection);
        }
        return connection;
    }

    @Supports(value={Feature.HIGH_AVAILABILITY})
    private ConnectionSource.FailoverCallback prepareFailoverHandler(final String serviceName) {
        return new ConnectionSource.FailoverCallback(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ConnectionSource.FailoverCallback.Result handle(Selector cleanupSelector, Selector markupSelector, boolean isGracefulDraining, boolean restoreAfterCleanup) {
                Core.this.handlersLock.lock();
                try {
                    ConnectionSource.FailoverCallback.Result result = this.handleHelper(cleanupSelector, markupSelector, isGracefulDraining, restoreAfterCleanup);
                    return result;
                }
                finally {
                    Core.this.handlersLock.unlock();
                }
            }

            private ConnectionSource.FailoverCallback.Result handleHelper(Selector cleanupSelector, Selector markupSelector, boolean isGracefulDraining, boolean restoreAfterCleanup) {
                CoreConnection conn2;
                int count = 0;
                ConnectionSource.FailoverCallback.Result.ResultType resultType = ConnectionSource.FailoverCallback.Result.ResultType.FAILURE;
                int avail = Core.this.availableCount();
                int borrowed = Core.this.borrowedCount();
                int availMarkedDown = 0;
                int borrowedMarkedDown = 0;
                int[] availClosed = new int[]{0};
                int[] borrowedClosed = new int[]{0};
                int[] opened = new int[]{0};
                while (null != (conn2 = Core.this.retrieveFirst(Selectors.and(Core.serviceSelector(serviceName), cleanupSelector)))) {
                    if (Core.this.connectionSource().isReplayable() && !conn2.available()) {
                        conn2.markReconnecting();
                        Core.this.put(conn2);
                    } else {
                        conn2.abort();
                        conn2.close();
                        if (restoreAfterCleanup) {
                            try {
                                Core.this.growAvailable(conn2.cri());
                                opened[0] = opened[0] + 1;
                            }
                            catch (UniversalConnectionPoolException e) {
                                ClioSupport.ilogThrowing(null, null, null, null, e);
                            }
                        }
                    }
                    if (conn2.available()) {
                        availClosed[0] = availClosed[0] + 1;
                    } else {
                        borrowedClosed[0] = borrowedClosed[0] + 1;
                    }
                    ++count;
                }
                if (count > 0) {
                    ClioSupport.ilogFinest(null, null, null, null, String.format("FF: cleaned up %d connections", count));
                }
                count = 0;
                while (true) {
                    boolean[] marked = new boolean[]{false};
                    boolean[] av = new boolean[]{false};
                    Core.this.forFirst(Selectors.and(Selectors.not(markedAlready), Core.serviceSelector(serviceName), markupSelector), conn -> {
                        if (isGracefulDraining) {
                            conn.markCloseOnReturn();
                        } else {
                            conn.markToReplace();
                        }
                        marked[0] = true;
                        av[0] = conn.available();
                    }, Core.this.servicePoolIterator(serviceName, true));
                    if (!marked[0]) break;
                    ++count;
                    if (av[0]) {
                        ++availMarkedDown;
                        continue;
                    }
                    ++borrowedMarkedDown;
                    borrowedClosed[0] = borrowedClosed[0] + 1;
                }
                if (count > 0) {
                    ClioSupport.ilogFinest(null, null, null, null, String.format("FF: marked to-replace %d connections", count));
                }
                int beforeAvail = Core.this.availableCount();
                int beforeBorrowed = Core.this.borrowedCount();
                ConnectionSource.FailoverCallback.Result result = new ConnectionSource.FailoverCallback.Result();
                result.type = ConnectionSource.FailoverCallback.Result.ResultType.SUCCESS;
                result.availConns = Core.this.availableCount();
                result.borrowedConns = Core.this.borrowedCount();
                result.availOpened = opened[0] + Core.this.availableCount() > beforeAvail ? Core.this.availableCount() - beforeAvail : 0;
                result.availClosed = availClosed[0] + (beforeAvail > Core.this.availableCount() ? beforeAvail - Core.this.availableCount() : 0);
                result.borrowedClosed = borrowedClosed[0] + (beforeBorrowed > Core.this.borrowedCount() ? beforeBorrowed - Core.this.borrowedCount() : 0);
                Core.this.kickAdjuster();
                return result;
            }

            static {
                try {
                    $$$methodRef$$$3 = 2.class.getDeclaredConstructor(Core.class, String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$2 = 2.class.getDeclaredMethod("lambda$handleHelper$0", Boolean.TYPE, boolean[].class, boolean[].class, CoreConnection.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$1 = 2.class.getDeclaredMethod("handleHelper", Selector.class, Selector.class, Boolean.TYPE, Boolean.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 2.class.getDeclaredMethod("handle", Selector.class, Selector.class, Boolean.TYPE, Boolean.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
    }

    @Supports(value={Feature.LOAD_BALANCING})
    private ConnectionSource.RebalanceCallback prepareRebalanceHandler(final String serviceName) {
        return new ConnectionSource.RebalanceCallback(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            @Override
            public ConnectionSource.RebalanceCallback.Result handle(final Selector cleanupSelector, final Selector markupSelector) {
                final ConnectionSource.RebalanceCallback.Result res = new ConnectionSource.RebalanceCallback.Result();
                UniversalConnectionPoolManagerBase.getTaskManager().submitTask(new UCPTaskBase<Object>(){
                    private static Executable $$$methodRef$$$0;
                    private static Logger $$$loggerRef$$$0;
                    private static Executable $$$methodRef$$$1;
                    private static Logger $$$loggerRef$$$1;
                    private static Executable $$$methodRef$$$2;
                    private static Logger $$$loggerRef$$$2;
                    private static Executable $$$methodRef$$$3;
                    private static Logger $$$loggerRef$$$3;
                    private static Executable $$$methodRef$$$4;
                    private static Logger $$$loggerRef$$$4;
                    private static Executable $$$methodRef$$$5;
                    private static Logger $$$loggerRef$$$5;

                    @Override
                    public void run() {
                        if (!Core.this.handlersLock.tryLock()) {
                            return;
                        }
                        try {
                            this.runHelper();
                        }
                        finally {
                            Core.this.handlersLock.unlock();
                        }
                    }

                    private void runHelper() {
                        int maxLimit = Math.max(1, (Core.this.totalCount().get() + Core.this.pendingBorrowedGrows.get() + Core.this.pendingAvailableGrows.get()) * 15 / 100);
                        int[] count = new int[]{0};
                        while (count[0] < maxLimit) {
                            if (res.terminate.get()) {
                                return;
                            }
                            CoreConnection conn2 = Core.this.retrieveFirst(Selectors.and(Core.serviceSelector(serviceName), conn1 -> {
                                boolean gravitate;
                                block1: {
                                    gravitate = false;
                                    if (!cleanupSelector.selected(conn1)) break block1;
                                    ServiceMember inst = conn1.serviceMember();
                                    int delta = inst.connsToRebalance.get();
                                    if (delta < 0 && inst.connsToRebalance.compareAndSet(delta, delta + 1)) {
                                        gravitate = true;
                                    }
                                }
                                return gravitate;
                            }));
                            if (null == conn2) break;
                            conn2.abort();
                            conn2.close();
                            try {
                                Core.this.growAvailable(conn2.cri());
                            }
                            catch (UniversalConnectionPoolException e) {
                                ClioSupport.ilogThrowing(null, null, null, null, e);
                            }
                            count[0] = count[0] + 1;
                        }
                        Core.this.forSome(Selectors.and(Core.serviceSelector(serviceName), conn -> {
                            boolean gravitate;
                            block3: {
                                if (count[0] >= maxLimit) {
                                    return false;
                                }
                                if (res2.terminate.get()) {
                                    return false;
                                }
                                gravitate = false;
                                if (!markupSelector.selected(conn)) break block3;
                                ServiceMember inst = conn.serviceMember();
                                int delta = inst.connsToRebalance.get();
                                if (delta < 0 && inst.connsToRebalance.compareAndSet(delta, delta + 1)) {
                                    gravitate = true;
                                }
                            }
                            return gravitate;
                        }), conn -> {
                            conn.markToReplace();
                            count[0] = count[0] + 1;
                        }, Core.this.servicePoolIterator(serviceName, true));
                        if (count[0] > 0) {
                            ClioSupport.ilogFine(null, null, null, null, String.format("rebalanced %d connection(s)", count[0]));
                        }
                        for (int j = Core.this.totalCount().get() + Core.this.pendingBorrowedGrows.get() + Core.this.pendingAvailableGrows.get(); j < Core.this.getEffectiveMinPoolSize(); ++j) {
                            if (res.terminate.get()) {
                                return;
                            }
                            try {
                                Core.this.growAvailable(Core.this.policies().getMostPopularCri(), true);
                                ClioSupport.ilogFinest(null, null, null, null, "grew up one connection to reach the minimum");
                                continue;
                            }
                            catch (UniversalConnectionPoolException e) {
                                ClioSupport.ilogThrowing(null, null, null, null, e);
                                break;
                            }
                        }
                        if (res.terminate.get()) {
                            return;
                        }
                        Core.this.adjustMaxLimit();
                    }

                    static {
                        try {
                            $$$methodRef$$$5 = 1.class.getDeclaredConstructor(3.class, ConnectionSource.RebalanceCallback.Result.class, Selector.class, Selector.class);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                        try {
                            $$$methodRef$$$4 = 1.class.getDeclaredMethod("lambda$runHelper$0", Selector.class, CoreConnection.class);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                        try {
                            $$$methodRef$$$3 = 1.class.getDeclaredMethod("lambda$runHelper$1", int[].class, Integer.TYPE, ConnectionSource.RebalanceCallback.Result.class, Selector.class, CoreConnection.class);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                        try {
                            $$$methodRef$$$2 = 1.class.getDeclaredMethod("lambda$runHelper$2", int[].class, CoreConnection.class);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                        try {
                            $$$methodRef$$$1 = 1.class.getDeclaredMethod("runHelper", new Class[0]);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                        try {
                            $$$methodRef$$$0 = 1.class.getDeclaredMethod("run", new Class[0]);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    }
                });
                return res;
            }

            static {
                try {
                    $$$methodRef$$$1 = 3.class.getDeclaredConstructor(Core.class, String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 3.class.getDeclaredMethod("handle", Selector.class, Selector.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
    }

    private CoreConnection tryRepurpose(ConnectionRetrievalInfo cri) {
        String serviceName = this.connectionSource().serviceName(cri);
        if (!this.connectionSource().isServiceRegistered(serviceName)) {
            return null;
        }
        if (this.knownServices.size() > 0) {
            CoreConnection toRepurpose;
            for (String targetServiceName : this.knownServices) {
                if (serviceName != null && serviceName.equals(targetServiceName) || (toRepurpose = this.retrieveFirst(Selectors.and(Core.serviceSelector(targetServiceName), this.connectionSource().serviceBasedRepurposeSelector(cri, true)))) == null) continue;
                if (toRepurpose.repurpose(cri)) {
                    return toRepurpose;
                }
                toRepurpose.abort();
                toRepurpose.close();
                return null;
            }
            for (String targetServiceName : this.knownServices) {
                if (serviceName != null && serviceName.equals(targetServiceName) || (toRepurpose = this.retrieveFirst(Selectors.and(Core.serviceSelector(targetServiceName), this.connectionSource().serviceBasedRepurposeSelector(cri, false)))) == null) continue;
                if (toRepurpose.repurpose(cri)) {
                    return toRepurpose;
                }
                toRepurpose.abort();
                toRepurpose.close();
                return null;
            }
        }
        return null;
    }

    private boolean holdOverMakingRoom() {
        if (this.availableCount() == 0) {
            this.notAvailTS = Clock.clock();
            return true;
        }
        return Clock.clock() - this.notAvailTS < 120L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean makeRoom(ConnectionRetrievalInfo cri) {
        this.adjusterEnabled.set(false);
        try {
            if (this.holdOverMakingRoom()) {
                boolean bl = false;
                return bl;
            }
            ClioSupport.ilogFinest(null, null, null, null, "about to do an expensive make room traversal");
            CoreConnection toClose = this.retrieveFirst(conn -> {
                if (!conn.available()) {
                    return false;
                }
                if (conn.closed() || conn.bad()) {
                    return true;
                }
                return this.policies().isCriUnpopular(conn.cri());
            });
            if (toClose != null) {
                toClose.abort();
                toClose.close();
                ClioSupport.ilogFinest(null, null, null, null, "connection closed");
                boolean bl = true;
                return bl;
            }
            if (this.holdOverMakingRoom()) {
                boolean bl = false;
                return bl;
            }
            ClioSupport.ilogFinest(null, null, null, null, "about to do an expensive make room traversal");
            CoreConnection toClose2 = this.retrieveFirst(Selectors.and(this.connectionSource().availableConnectionsSelector(), Selectors.or(Selectors.not(this.connectionSource().matchingCriSelector(cri)), Selectors.not(this.connectionSource().routingKeyBasedBorrowSelector(cri, false)), this.connectionSource().wrongCostSelector(cri.getLabels()))));
            if (null != toClose2) {
                toClose2.abort();
                toClose2.close();
                ClioSupport.ilogFinest(null, null, null, null, "connection closed");
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.adjusterEnabled.set(true);
        }
    }

    boolean uselessConnsCleanerInProgress() {
        return this.cleanUselessInProgress.get();
    }

    private void cleanUselessAsynch() {
        if (this.cleanUselessInProgress.compareAndSet(false, true)) {
            try {
                UniversalConnectionPoolManagerBase.getTaskManager().submitTask(new UCPTaskBase<Object>(){
                    private static Executable $$$methodRef$$$0;
                    private static Logger $$$loggerRef$$$0;
                    private static Executable $$$methodRef$$$1;
                    private static Logger $$$loggerRef$$$1;

                    @Override
                    public void run() {
                        Core.this.cleanUseless();
                    }

                    static {
                        try {
                            $$$methodRef$$$1 = 4.class.getDeclaredConstructor(Core.class);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                        try {
                            $$$methodRef$$$0 = 4.class.getDeclaredMethod("run", new Class[0]);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    }
                });
            }
            catch (RuntimeException e) {
                this.cleanUselessInProgress.set(false);
            }
        }
    }

    private void cleanUseless() {
        try {
            for (CoreConnection toClean : this.split(conn -> conn.available() && (conn.closed() || conn.bad()))) {
                if (!toClean.bad()) continue;
                toClean.abort();
                toClean.close();
            }
        }
        finally {
            this.cleanUselessInProgress.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void growAvailable(ConnectionRetrievalInfo cri, boolean useBestInstance) throws UniversalConnectionPoolException {
        CoreConnection conn = null;
        int total = this.totalCount().get() + this.pendingBorrowedGrows.get() + this.pendingAvailableGrows.incrementAndGet();
        try {
            if (total > this.limits().getMax()) {
                return;
            }
            if (this.noMoreGrows.get()) {
                return;
            }
            conn = this.connectionSource().create(cri, null, useBestInstance ? EnumSet.of(ConnectionSource.CreateMode.USE_BEST_INSTANCE) : EnumSet.noneOf(ConnectionSource.CreateMode.class), 0L);
            if (conn == null) {
                return;
            }
            conn.makeAvailable();
            ClioSupport.ilogFinest(null, null, null, null, "conn=" + conn);
            this.put(conn);
        }
        finally {
            this.pendingAvailableGrows.getAndDecrement();
            if (this.noMoreGrows.get() && this.pendingBorrowedGrows.get() + this.pendingAvailableGrows.get() == 0) {
                try {
                    this.stoppingLock.lock();
                    this.stoppingCondition.signal();
                }
                finally {
                    this.stoppingLock.unlock();
                }
            }
        }
    }

    private void growAvailable(ConnectionRetrievalInfo cri) throws UniversalConnectionPoolException {
        this.growAvailable(cri, true);
    }

    final void growAvailableAsynch(final ConnectionRetrievalInfo cri) {
        UniversalConnectionPoolManagerBase.getTaskManager().submitTask(new UCPTaskBase<Object>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            @Override
            public void run() {
                try {
                    Core.this.growAvailable(cri);
                }
                catch (UniversalConnectionPoolException e) {
                    ClioSupport.ilogThrowing(null, null, null, null, e);
                }
            }

            static {
                try {
                    $$$methodRef$$$1 = 5.class.getDeclaredConstructor(Core.class, ConnectionRetrievalInfo.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 5.class.getDeclaredMethod("run", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void initialize() throws UniversalConnectionPoolException {
        this.adjusterEnabled.set(false);
        final boolean[] succeeded = new boolean[]{true};
        final Throwable[] cause = new Throwable[]{null};
        try {
            int initPoolSize = Math.min(Math.min(this.limits().getInitial(), this.limits().getMax()), this.limits().getMaxPerService());
            final AtomicInteger connsToCreate = new AtomicInteger();
            UCPTaskBase<Boolean> task = new UCPTaskBase<Boolean>(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;
                private static Executable $$$methodRef$$$2;
                private static Logger $$$loggerRef$$$2;

                @Override
                public Boolean call() {
                    ClioSupport.ilogFinest(null, null, null, null, "launching init thread");
                    while (connsToCreate.getAndDecrement() > 0) {
                        try {
                            CoreConnection conn;
                            ConnectionRetrievalInfo defaultCri = Core.this.connectionSource().defaultCri();
                            String defaultSvcName = Core.this.connectionSource().serviceName(defaultCri);
                            if (!Core.this.connectionSource().isServiceRegistered(defaultSvcName)) {
                                Core.this.registerService(defaultSvcName);
                            }
                            if (null != (conn = Core.this.connectionSource().create(Core.this.policies().getMostPopularCri(), null, EnumSet.of(ConnectionSource.CreateMode.USE_BEST_INSTANCE), 1000L))) {
                                conn.makeAvailable();
                                Core.this.put(conn);
                                ClioSupport.ilogFinest(null, null, null, null, String.format("connection %s successfully created", conn.toString()));
                                continue;
                            }
                            ClioSupport.ilogWarning(null, null, null, null, "connection not created");
                        }
                        catch (UniversalConnectionPoolException e) {
                            ClioSupport.ilogThrowing(null, null, null, null, e);
                            if (e.getCause() instanceof SQLRecoverableException) continue;
                            ClioSupport.ilogFinest(null, null, null, null, "failure");
                            succeeded[0] = false;
                            cause[0] = e;
                            break;
                        }
                    }
                    return succeeded[0];
                }

                static {
                    try {
                        $$$methodRef$$$2 = 6.class.getDeclaredConstructor(Core.class, AtomicInteger.class, boolean[].class, Throwable[].class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    try {
                        $$$methodRef$$$1 = 6.class.getDeclaredMethod("call", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    try {
                        $$$methodRef$$$0 = 6.class.getDeclaredMethod("call", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                }
            };
            try {
                connsToCreate.set(initPoolSize > 0 ? 1 : 0);
                if (!((Boolean)task.call()).booleanValue()) {
                    UCPErrorHandler.throwUniversalConnectionPoolException(66, new IllegalStateException("unable to start connection creation task", cause[0]));
                }
                int maxInitThreads = Util.getMaxInitThreads();
                int initThreads = Math.min(Math.max(0, maxInitThreads), Math.max(0, initPoolSize));
                ClioSupport.ilogFinest(null, null, null, null, String.format("initPoolSize=%d, maxInitThreads=%d, initThreads=%d", initPoolSize, maxInitThreads, initThreads));
                connsToCreate.set(initPoolSize - 1);
                TaskHandle[] handles = new TaskHandle[initThreads];
                for (int i = 0; i < handles.length; ++i) {
                    handles[i] = UniversalConnectionPoolManagerBase.getTaskManager().submitTask(task);
                }
                for (TaskHandle handle : handles) {
                    succeeded[0] = succeeded[0] && (Boolean)handle.get(0L) != false;
                }
            }
            catch (Exception e) {
                ClioSupport.ilogThrowing(null, null, null, null, e);
                UCPErrorHandler.throwUniversalConnectionPoolException(66, e);
            }
        }
        finally {
            this.adjusterEnabled.set(true);
        }
        if (succeeded[0]) {
            return;
        }
        UCPErrorHandler.throwUniversalConnectionPoolException(66, cause[0].getCause());
    }

    final void closeAvailableInactive(long inactivityTimeout) {
        if (inactivityTimeout == 0L) {
            return;
        }
        for (CoreConnection conn2 : this.split(Selectors.and(this.connectionSource().inactiveConnectionsSelector(inactivityTimeout), conn -> !this.idle() || this.totalCount().get() > this.limits().getMin()))) {
            conn2.abort();
            conn2.close();
        }
        this.kickAdjuster();
    }

    final void reduce(ConnectionRetrievalInfo cri) {
        CoreConnection conn = this.retrieveFirst(p -> p.available() && this.totalCount().get() > this.limits().getMin());
        if (null != conn) {
            conn.close();
        }
        this.kickAdjuster();
    }

    private boolean idle() {
        return this.borrowedCount() == 0 || this.pendingGrowsCount() == 0;
    }

    final void replaceNonReusable() {
        this.adjusterEnabled.set(false);
        try {
            this.split(conn -> {
                if (!(conn.reusable() || this.idle() && this.totalCount().get() <= this.limits().getMin())) {
                    if (conn.available()) {
                        conn.abort();
                        conn.close();
                        return true;
                    }
                    conn.markToReplace();
                    return false;
                }
                return false;
            });
        }
        finally {
            this.adjusterEnabled.set(true);
            this.kickAdjuster();
        }
    }

    final void replaceAvailable() throws UniversalConnectionPoolException {
        this.replaceAvailable(false);
    }

    final void replaceInvalidAvailable() throws UniversalConnectionPoolException {
        this.replaceAvailable(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceAvailable(final boolean invalidOnly) throws UniversalConnectionPoolException {
        this.adjusterEnabled.set(false);
        try {
            List<CoreConnection> closedConns = this.split(new Selector(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;

                @Override
                public boolean selected(CoreConnection connection) {
                    if (!connection.available()) {
                        connection.markToReplace();
                        return false;
                    }
                    if (invalidOnly && connection.valid()) {
                        return false;
                    }
                    connection.abort();
                    connection.close();
                    return true;
                }

                static {
                    try {
                        $$$methodRef$$$1 = 7.class.getDeclaredConstructor(Core.class, Boolean.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    try {
                        $$$methodRef$$$0 = 7.class.getDeclaredMethod("selected", CoreConnection.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                }
            });
            for (CoreConnection connection : closedConns) {
                this.growAvailable(connection.cri());
            }
        }
        finally {
            this.adjusterEnabled.set(true);
        }
    }

    void kickAdjuster() {
        if (!this.adjusterEnabled.get()) {
            return;
        }
        if (this.adjusterBusy.compareAndSet(false, true)) {
            UniversalConnectionPoolManagerBase.getTaskManager().submitTask(new UCPTaskBase<Object>(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;

                @Override
                public void run() {
                    try {
                        Core.this.adjustLimits();
                    }
                    finally {
                        Core.this.adjusterBusy.set(false);
                    }
                }

                static {
                    try {
                        $$$methodRef$$$1 = 8.class.getDeclaredConstructor(Core.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    try {
                        $$$methodRef$$$0 = 8.class.getDeclaredMethod("run", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                }
            });
        }
    }

    int pendingAvailableGrows() {
        return this.pendingAvailableGrows.get();
    }

    @Supports(value={Feature.ABANDONED_CONN_TIMEOUT})
    final void returnAbandoned(int abandonedTimeout) {
        this.forSome(this.connectionSource().abandonedConnectionsSelector(abandonedTimeout), new Applicator(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            @Override
            public void apply(CoreConnection conn) {
                conn.handleTimeout();
                conn.makeAvailable();
            }

            static {
                try {
                    $$$methodRef$$$1 = 9.class.getDeclaredConstructor(Core.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 9.class.getDeclaredMethod("apply", CoreConnection.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        });
    }

    @Supports(value={Feature.TTL_CONN_TIMEOUT})
    final void returnTTLed(int timeoutTTLed) {
        this.forSome(this.connectionSource().ttlConnectionsSelector(timeoutTTLed), new Applicator(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            @Override
            public void apply(CoreConnection conn) {
                conn.handleTimeout();
                conn.makeAvailable();
            }

            static {
                try {
                    $$$methodRef$$$1 = 10.class.getDeclaredConstructor(Core.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 10.class.getDeclaredMethod("apply", CoreConnection.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        });
    }

    @Supports(value={Feature.CONN_HARVESTING})
    final void harvest(int triggerCount, int maxCount) {
        if (triggerCount >= 0 && triggerCount < Integer.MAX_VALUE && this.availableCount() <= triggerCount) {
            final int[] requestedConns = new int[]{maxCount};
            UniversalConnectionPoolManagerBase.getTaskManager().submitTask(new UCPTaskBase<Object>(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;
                private static Executable $$$methodRef$$$2;
                private static Logger $$$loggerRef$$$2;
                private static Executable $$$methodRef$$$3;
                private static Logger $$$loggerRef$$$3;

                @Override
                public void run() {
                    block0: for (int i = 0; i < 5 * requestedConns[0] && requestedConns[0] > 0; ++i) {
                        final long[] oldestLastAccessedTime = new long[]{Clock.clock()};
                        final boolean[] exhausted = new boolean[]{true};
                        Core.this.forSome(Selectors.and(Selectors.not(Core.this.connectionSource().availableConnectionsSelector()), Core.this.connectionSource().harvestableConnectionSelector()), new Applicator(){
                            private static Executable $$$methodRef$$$0;
                            private static Logger $$$loggerRef$$$0;
                            private static Executable $$$methodRef$$$1;
                            private static Logger $$$loggerRef$$$1;

                            @Override
                            public void apply(CoreConnection conn) {
                                long lastAccessedTime = conn.lastAccessedTime();
                                if (lastAccessedTime < oldestLastAccessedTime[0]) {
                                    oldestLastAccessedTime[0] = lastAccessedTime;
                                    exhausted[0] = false;
                                }
                            }

                            static {
                                try {
                                    $$$methodRef$$$1 = 1.class.getDeclaredConstructor(11.class, long[].class, boolean[].class);
                                }
                                catch (Throwable throwable) {}
                                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                                try {
                                    $$$methodRef$$$0 = 1.class.getDeclaredMethod("apply", CoreConnection.class);
                                }
                                catch (Throwable throwable) {}
                                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                            }
                        });
                        if (exhausted[0]) break;
                        for (String poolServiceName : Core.this.knownServices) {
                            if (requestedConns[0] <= 0) continue block0;
                            Core.this.forSome(Selectors.and(Core.serviceSelector(poolServiceName), Selectors.not(Core.this.connectionSource().availableConnectionsSelector()), Core.this.connectionSource().harvestableConnectionSelector(), conn -> requestedConns[0] > 0), conn -> {
                                if (conn.lastAccessedTime() <= oldestLastAccessedTime[0]) {
                                    conn.cleanupToHarvest();
                                    conn.makeAvailable();
                                    requestedConns2[0] = requestedConns[0] - 1;
                                }
                            }, Core.this.servicePoolIterator(poolServiceName, true));
                        }
                    }
                }

                static {
                    try {
                        $$$methodRef$$$3 = 11.class.getDeclaredConstructor(Core.class, int[].class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    try {
                        $$$methodRef$$$2 = 11.class.getDeclaredMethod("lambda$run$0", int[].class, CoreConnection.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    try {
                        $$$methodRef$$$1 = 11.class.getDeclaredMethod("lambda$run$1", long[].class, int[].class, CoreConnection.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    try {
                        $$$methodRef$$$0 = 11.class.getDeclaredMethod("run", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                }
            });
        }
    }

    final boolean retrieve(CoreConnection conn) {
        return null != this.retrieveFirst(Selectors.and(Core.serviceSelector(conn.serviceName()), selectedConnection -> {
            if (conn.available()) {
                return false;
            }
            return conn == selectedConnection;
        }));
    }

    final CoreConnection findSpecificConnection(Object physicalConn) {
        final CoreConnection[] selectedConn = new CoreConnection[]{null};
        Selector borrowedSelector = Selectors.not(this.connectionSource().availableConnectionsSelector());
        Selector physConnSelector = this.connectionSource().physicalConnectionSelector(physicalConn);
        this.forFirst(Selectors.and(borrowedSelector, physConnSelector), new Applicator(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            @Override
            public void apply(CoreConnection conn) {
                selectedConn[0] = conn;
            }

            static {
                try {
                    $$$methodRef$$$1 = 12.class.getDeclaredConstructor(Core.class, CoreConnection[].class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 12.class.getDeclaredMethod("apply", CoreConnection.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        });
        return selectedConn[0];
    }

    private void waitForPendingGrowsToFinish() {
        this.noMoreGrows.set(true);
        while (this.pendingAvailableGrows.get() + this.pendingBorrowedGrows.get() > 0) {
            try {
                this.stoppingLock.lock();
                this.stoppingCondition.await(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                ClioSupport.ilogWarning(null, null, null, null, "interrupted while waiting for pending grows to finish");
                break;
            }
            finally {
                this.stoppingLock.unlock();
            }
        }
    }

    private void enablePendingGrows() {
        this.noMoreGrows.set(false);
    }

    final void closeAll() {
        this.keepOverMinimum.set(false);
        this.peakConnectionsCount.reset();
        this.split(new Selector(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            @Override
            public boolean selected(CoreConnection connection) {
                connection.abort();
                connection.close();
                return true;
            }

            static {
                try {
                    $$$methodRef$$$1 = 13.class.getDeclaredConstructor(Core.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 13.class.getDeclaredMethod("selected", CoreConnection.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        });
    }

    void adjustLimits() {
        this.adjustMinLimit(10);
        this.adjustMaxLimit();
    }

    private int getEffectiveMinPoolSize() {
        return this.keepOverMinimum.get() ? this.limits().getMin() : this.peakConnectionsCount.get();
    }

    void adjustMinLimit(final int attempts) {
        Policies policies = this.policies();
        while (this.totalCount().get() + this.pendingBorrowedGrows.get() + this.pendingAvailableGrows.get() < this.getEffectiveMinPoolSize()) {
            try {
                ClioSupport.ilogFine(null, null, null, null, "growing...");
                this.growAvailable(policies.getMostPopularCri(), attempts < 3);
                ClioSupport.ilogFine(null, null, null, null, "grew up 1 connection to reach the minimum");
            }
            catch (UniversalConnectionPoolException e) {
                ClioSupport.ilogThrowing(null, null, null, null, e);
                break;
            }
        }
        if (this.totalCount().get() + this.pendingBorrowedGrows.get() + this.pendingAvailableGrows.get() < this.getEffectiveMinPoolSize() && attempts > 0) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                ClioSupport.ilogThrowing(null, null, null, null, e);
            }
            UniversalConnectionPoolManagerBase.getTaskManager().submitTask(new UCPTaskBase<Object>(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;

                @Override
                public void run() {
                    Core.this.adjustMinLimit(attempts - 1);
                }

                static {
                    try {
                        $$$methodRef$$$1 = 14.class.getDeclaredConstructor(Core.class, Integer.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    try {
                        $$$methodRef$$$0 = 14.class.getDeclaredMethod("run", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                }
            });
        }
    }

    void adjustMaxLimit() {
        final Limits limits = this.limits();
        for (CoreConnection connection : this.split(new Selector(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            @Override
            public boolean selected(CoreConnection conn) {
                if (!conn.available()) {
                    return false;
                }
                return Core.this.totalCount().get() > limits.getMax();
            }

            static {
                try {
                    $$$methodRef$$$1 = 15.class.getDeclaredConstructor(Core.class, Limits.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 15.class.getDeclaredMethod("selected", CoreConnection.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        })) {
            connection.abort();
            connection.close();
            ClioSupport.ilogFine(null, null, null, null, "closed one connection to stay under max limit");
        }
    }

    private Counter totalCount() {
        return this.connectionSource().totalCount();
    }

    private int borrowedCount() {
        return this.connectionSource().borrowedCount().get();
    }

    int availableCount() {
        return this.totalCount().get() - this.borrowedCount();
    }

    public long repurposeCount() {
        return this.repurposeCount.get();
    }

    void start(ConnectionRetrievalInfo cri) throws UniversalConnectionPoolException {
        this.enablePendingGrows();
        ConnectionSource cs = this.connectionSource();
        cs.start(cri);
        final ConnectionRetrievalInfo defaultCri = cs.defaultCri();
        this.plugPolicies(new Policies(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            public ConnectionRetrievalInfo getMostPopularCri() {
                return defaultCri;
            }

            @Override
            public boolean isCriUnpopular(ConnectionRetrievalInfo cri) {
                return !defaultCri.equalsIncludingPassword(cri);
            }

            static {
                try {
                    $$$methodRef$$$2 = 16.class.getDeclaredConstructor(Core.class, ConnectionRetrievalInfo.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$1 = 16.class.getDeclaredMethod("isCriUnpopular", ConnectionRetrievalInfo.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 16.class.getDeclaredMethod("getMostPopularCri", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        });
    }

    void stop() {
        this.waitForPendingGrowsToFinish();
        this.closeAll();
        this.connectionSource().stop();
        this.knownServices.clear();
    }

    boolean available(ConnectionRetrievalInfo cri) {
        ConnectionSource cs = this.connectionSource();
        if (!cs.validateCri(cri)) {
            return false;
        }
        return cs.available(cri);
    }

    int pendingGrowsCount() {
        return this.pendingBorrowedGrows.get() + this.pendingAvailableGrows.get();
    }

    boolean noMoreGrows() {
        return this.noMoreGrows.get();
    }

    static {
        try {
            $$$methodRef$$$122 = Core.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$122 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$121 = Core.class.getDeclaredMethod("access$2400", Core.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$121 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$120 = Core.class.getDeclaredMethod("access$2300", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$120 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$119 = Core.class.getDeclaredMethod("access$2200", Core.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$119 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$118 = Core.class.getDeclaredMethod("access$2100", Core.class, Selector.class, Applicator.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$118 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$117 = Core.class.getDeclaredMethod("access$2000", Core.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$117 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$116 = Core.class.getDeclaredMethod("access$1900", Core.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$116 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$115 = Core.class.getDeclaredMethod("access$1800", Core.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$115 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$114 = Core.class.getDeclaredMethod("access$1700", Core.class, ConnectionRetrievalInfo.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$114 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$113 = Core.class.getDeclaredMethod("access$1600", Core.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$113 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$112 = Core.class.getDeclaredMethod("access$1500", Core.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$112 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$111 = Core.class.getDeclaredMethod("access$1400", Core.class, Selector.class, Applicator.class, Supplier.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$111 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$110 = Core.class.getDeclaredMethod("access$1300", Core.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$110 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$109 = Core.class.getDeclaredMethod("access$1200", Core.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$109 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$108 = Core.class.getDeclaredMethod("access$1100", Core.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$108 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$107 = Core.class.getDeclaredMethod("access$1000", Core.class, Selector.class, Applicator.class, Supplier.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$107 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$106 = Core.class.getDeclaredMethod("access$900", Core.class, String.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$106 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$105 = Core.class.getDeclaredMethod("access$800", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$105 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$104 = Core.class.getDeclaredMethod("access$700", Core.class, ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$104 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$103 = Core.class.getDeclaredMethod("access$600", Core.class, CoreConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$103 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$102 = Core.class.getDeclaredMethod("access$500", Core.class, Selector.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$102 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$101 = Core.class.getDeclaredMethod("access$400", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$101 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$100 = Core.class.getDeclaredMethod("access$300", Core.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$100 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$99 = Core.class.getDeclaredMethod("access$200", Core.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$99 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$98 = Core.class.getDeclaredMethod("access$000", Core.class, Selector.class, Applicator.class, Supplier[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$98 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$97 = Core.class.getDeclaredMethod("lambda$forSome$0", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$97 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$96 = Core.class.getDeclaredMethod("lambda$prepareSkipList$1", String.class, CoreConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$96 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$95 = Core.class.getDeclaredMethod("lambda$prepareSkipList$2", KDTree[].class, String.class, SkipList.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$95 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$94 = Core.class.getDeclaredMethod("lambda$preparePerfectCostSkipList$3", String.class, Properties.class, CoreConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$94 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$93 = Core.class.getDeclaredMethod("lambda$preparePerfectCostSkipList$4", KDTree[].class, String.class, Properties.class, SkipList.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$93 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$92 = Core.class.getDeclaredMethod("lambda$prepareAcceptableCostSkipList$5", Properties.class, String.class, CoreConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$92 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$91 = Core.class.getDeclaredMethod("lambda$prepareAcceptableCostSkipList$6", KDTree[].class, String.class, Properties.class, SkipList.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$91 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$90 = Core.class.getDeclaredMethod("lambda$costSuppliers$7", String.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$90 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$89 = Core.class.getDeclaredMethod("lambda$costSuppliers$8", String.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$89 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$88 = Core.class.getDeclaredMethod("lambda$serviceSuppliers$9", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$88 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$87 = Core.class.getDeclaredMethod("lambda$poolIterators$10", Supplier.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$87 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$86 = Core.class.getDeclaredMethod("lambda$serviceSelector$11", String.class, CoreConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$86 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$85 = Core.class.getDeclaredMethod("lambda$forFirst$12", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$85 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$84 = Core.class.getDeclaredMethod("lambda$helpBorrow$13", ConnectionRetrievalInfo.class, ConnectionSource.class, ConnectionAffinityCallback.class, Selector.class, Selector.class, boolean[].class, CoreConnection[].class, Comparator.class, CoreConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$84 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$83 = Core.class.getDeclaredMethod("lambda$helpBorrow$14", ConnectionRetrievalInfo.class, Selector.class, Selector.class, boolean[].class, CoreConnection[].class, Comparator.class, CoreConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$83 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$82 = Core.class.getDeclaredMethod("lambda$static$15", CoreConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$82 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$81 = Core.class.getDeclaredMethod("lambda$makeRoom$16", CoreConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$81 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$80 = Core.class.getDeclaredMethod("lambda$cleanUseless$17", CoreConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$80 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$79 = Core.class.getDeclaredMethod("lambda$closeAvailableInactive$18", CoreConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$79 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$78 = Core.class.getDeclaredMethod("lambda$reduce$19", CoreConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$78 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$77 = Core.class.getDeclaredMethod("lambda$replaceNonReusable$20", CoreConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$77 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$76 = Core.class.getDeclaredMethod("lambda$retrieve$21", CoreConnection.class, CoreConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$76 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$75 = Core.class.getDeclaredMethod("noMoreGrows", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$75 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$74 = Core.class.getDeclaredMethod("pendingGrowsCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$74 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$73 = Core.class.getDeclaredMethod("available", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$73 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$72 = Core.class.getDeclaredMethod("stop", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$72 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$71 = Core.class.getDeclaredMethod("start", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$71 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$70 = Core.class.getDeclaredMethod("repurposeCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$70 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$69 = Core.class.getDeclaredMethod("availableCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$69 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$68 = Core.class.getDeclaredMethod("borrowedCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$68 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$67 = Core.class.getDeclaredMethod("totalCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$67 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$66 = Core.class.getDeclaredMethod("adjustMaxLimit", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$66 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$65 = Core.class.getDeclaredMethod("adjustMinLimit", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$65 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$64 = Core.class.getDeclaredMethod("getEffectiveMinPoolSize", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$64 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$63 = Core.class.getDeclaredMethod("adjustLimits", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$63 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$62 = Core.class.getDeclaredMethod("closeAll", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$62 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$61 = Core.class.getDeclaredMethod("enablePendingGrows", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$61 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$60 = Core.class.getDeclaredMethod("waitForPendingGrowsToFinish", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$60 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$59 = Core.class.getDeclaredMethod("findSpecificConnection", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$59 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$58 = Core.class.getDeclaredMethod("retrieve", CoreConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$58 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$57 = Core.class.getDeclaredMethod("harvest", Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$57 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$56 = Core.class.getDeclaredMethod("returnTTLed", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$56 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$55 = Core.class.getDeclaredMethod("returnAbandoned", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$55 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$54 = Core.class.getDeclaredMethod("pendingAvailableGrows", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$54 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$53 = Core.class.getDeclaredMethod("kickAdjuster", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$53 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$52 = Core.class.getDeclaredMethod("replaceAvailable", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$52 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$51 = Core.class.getDeclaredMethod("replaceInvalidAvailable", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$51 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$50 = Core.class.getDeclaredMethod("replaceAvailable", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$50 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$49 = Core.class.getDeclaredMethod("replaceNonReusable", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$49 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$48 = Core.class.getDeclaredMethod("idle", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$48 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$47 = Core.class.getDeclaredMethod("reduce", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$47 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$46 = Core.class.getDeclaredMethod("closeAvailableInactive", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$46 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$45 = Core.class.getDeclaredMethod("initialize", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$44 = Core.class.getDeclaredMethod("growAvailableAsynch", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$43 = Core.class.getDeclaredMethod("growAvailable", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$42 = Core.class.getDeclaredMethod("growAvailable", ConnectionRetrievalInfo.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$41 = Core.class.getDeclaredMethod("cleanUseless", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$40 = Core.class.getDeclaredMethod("cleanUselessAsynch", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$39 = Core.class.getDeclaredMethod("uselessConnsCleanerInProgress", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$38 = Core.class.getDeclaredMethod("makeRoom", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$37 = Core.class.getDeclaredMethod("holdOverMakingRoom", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$36 = Core.class.getDeclaredMethod("tryRepurpose", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$35 = Core.class.getDeclaredMethod("prepareRebalanceHandler", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$34 = Core.class.getDeclaredMethod("prepareFailoverHandler", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$33 = Core.class.getDeclaredMethod("growBorrowed", ConnectionRetrievalInfo.class, ConnectionAffinityCallback.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$32 = Core.class.getDeclaredMethod("reclaim", CoreConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$31 = Core.class.getDeclaredMethod("updateRLBStats", ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$30 = Core.class.getDeclaredMethod("helpBorrow", ConnectionRetrievalInfo.class, ConnectionAffinityCallback.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$29 = Core.class.getDeclaredMethod("borrow", ConnectionRetrievalInfo.class, ConnectionAffinityCallback.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$28 = Core.class.getDeclaredMethod("policies", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$27 = Core.class.getDeclaredMethod("plugPolicies", Policies.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$26 = Core.class.getDeclaredMethod("limits", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$25 = Core.class.getDeclaredMethod("plugLimits", Limits.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$24 = Core.class.getDeclaredMethod("connectionSource", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$23 = Core.class.getDeclaredMethod("plugConnectionSource", ConnectionSource.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$22 = Core.class.getDeclaredMethod("registerService", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$21 = Core.class.getDeclaredMethod("retrieveFirst", Selector.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$20 = Core.class.getDeclaredMethod("forFirst", Selector.class, Applicator.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$19 = Core.class.getDeclaredMethod("forFirst", Selector.class, Applicator.class, Supplier.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$18 = Core.class.getDeclaredMethod("forFirst", Selector.class, Applicator.class, Supplier[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$17 = Core.class.getDeclaredMethod("serviceSelector", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$16 = Core.class.getDeclaredMethod("costPoolIterators", String.class, Properties.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$15 = Core.class.getDeclaredMethod("servicePoolIterator", String.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$14 = Core.class.getDeclaredMethod("poolIterators", Supplier[].class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$13 = Core.class.getDeclaredMethod("serviceSuppliers", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$12 = Core.class.getDeclaredMethod("costSuppliers", String.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$11 = Core.class.getDeclaredMethod("prepareAcceptableCostSkipList", String.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$10 = Core.class.getDeclaredMethod("preparePerfectCostSkipList", String.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$9 = Core.class.getDeclaredMethod("prepareSkipList", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$8 = Core.class.getDeclaredMethod("searchCriteria", String.class, Properties.class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$7 = Core.class.getDeclaredMethod("searchCriteria", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$6 = Core.class.getDeclaredMethod("forSome", Selector.class, Applicator.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$5 = Core.class.getDeclaredMethod("forSome", Selector.class, Applicator.class, Supplier.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$4 = Core.class.getDeclaredMethod("forSome", Selector.class, Applicator.class, Supplier[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$3 = Core.class.getDeclaredMethod("split", Selector.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$2 = Core.class.getDeclaredMethod("forEach", Applicator.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$1 = Core.class.getDeclaredMethod("put", CoreConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$0 = Core.class.getDeclaredMethod("clearWFPTree", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        isAffinityStrict = Util.isAffinityStrict();
        markedAlready = conn -> conn.markedCloseOnReturn() || conn.markedToReplace();
        coreInstances = new ConcurrentLinkedQueue<Core>();
        Runtime.getRuntime().addShutdownHook(new Thread(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            public void run() {
                coreInstances.forEach(p -> {
                    ((Core)p).waitForPendingGrowsToFinish();
                    ClioSupport.ilogFinest(null, null, null, null, p.toString() + ": pending grows finished gracefully");
                });
                ClioSupport.ilogFinest(null, null, null, null, "control thread stopped");
            }

            static {
                try {
                    $$$methodRef$$$2 = 17.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$1 = 17.class.getDeclaredMethod("lambda$run$0", Core.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 17.class.getDeclaredMethod("run", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        });
    }

    private static class DRange {
        private final Range[] range;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;

        DRange(Range[] range) {
            this.range = range;
        }

        public boolean equals(Object that) {
            if (that instanceof DRange) {
                return Arrays.deepEquals(this.range, ((DRange)that).range);
            }
            return false;
        }

        public int hashCode() {
            return Arrays.deepHashCode(this.range);
        }

        static {
            try {
                $$$methodRef$$$2 = DRange.class.getDeclaredConstructor(Range[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$1 = DRange.class.getDeclaredMethod("hashCode", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$0 = DRange.class.getDeclaredMethod("equals", Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        }
    }

    private static class WFPTree
    extends KDTree<SkipList<CoreConnection>> {
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;

        WFPTree(SkipList skipList, String service, String label, int cost) {
            this(skipList, new Point(new Comparable[]{service, label, Integer.valueOf(cost)}));
        }

        WFPTree(SkipList skipList, Point point) {
            super(skipList, point);
        }

        static WFPTree seed() {
            return new WFPTree(null, "", "", Integer.MAX_VALUE);
        }

        static {
            try {
                $$$methodRef$$$2 = WFPTree.class.getDeclaredConstructor(SkipList.class, Point.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$1 = WFPTree.class.getDeclaredConstructor(SkipList.class, String.class, String.class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$0 = WFPTree.class.getDeclaredMethod("seed", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        }
    }
}

