/*
 * Decompiled with CFR 0.152.
 */
package liquibase.command.core;

import java.io.PrintStream;
import java.util.Set;
import liquibase.CatalogAndSchema;
import liquibase.command.AbstractCommand;
import liquibase.command.CommandResult;
import liquibase.command.CommandValidationErrors;
import liquibase.command.core.SnapshotCommand;
import liquibase.database.Database;
import liquibase.database.ObjectQuotingStrategy;
import liquibase.diff.DiffGeneratorFactory;
import liquibase.diff.DiffResult;
import liquibase.diff.compare.CompareControl;
import liquibase.diff.output.ObjectChangeFilter;
import liquibase.diff.output.report.DiffToReport;
import liquibase.exception.DatabaseException;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.InvalidExampleException;
import liquibase.snapshot.SnapshotControl;
import liquibase.snapshot.SnapshotGeneratorFactory;
import liquibase.snapshot.SnapshotListener;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.DatabaseObjectFactory;
import liquibase.util.StringUtils;

public class DiffCommand
extends AbstractCommand<CommandResult> {
    private Database referenceDatabase;
    private Database targetDatabase;
    private Class<? extends DatabaseObject>[] snapshotTypes;
    private PrintStream outputStream;
    private SnapshotListener snapshotListener;
    private SnapshotControl referenceSnapshotControl;
    private SnapshotControl targetSnapshotControl;
    private ObjectChangeFilter objectChangeFilter;
    private CompareControl compareControl;

    @Override
    public String getName() {
        return "diff";
    }

    @Override
    public CommandValidationErrors validate() {
        return new CommandValidationErrors(this);
    }

    public Database getReferenceDatabase() {
        return this.referenceDatabase;
    }

    public DiffCommand setReferenceDatabase(Database referenceDatabase) {
        this.referenceDatabase = referenceDatabase;
        return this;
    }

    public Database getTargetDatabase() {
        return this.targetDatabase;
    }

    public DiffCommand setTargetDatabase(Database targetDatabase) {
        this.targetDatabase = targetDatabase;
        return this;
    }

    public Class<? extends DatabaseObject>[] getSnapshotTypes() {
        return this.snapshotTypes;
    }

    public DiffCommand setSnapshotTypes(String ... snapshotTypes) {
        if (snapshotTypes == null || snapshotTypes.length == 0 || snapshotTypes[0] == null) {
            this.snapshotTypes = null;
            return this;
        }
        Set<Class<? extends DatabaseObject>> types = DatabaseObjectFactory.getInstance().parseTypes(StringUtils.join(snapshotTypes, ","));
        this.snapshotTypes = new Class[types.size()];
        int i = 0;
        for (Class<? extends DatabaseObject> type : types) {
            this.snapshotTypes[i++] = type;
        }
        return this;
    }

    public DiffCommand setSnapshotTypes(Class<? extends DatabaseObject> ... snapshotTypes) {
        this.snapshotTypes = snapshotTypes;
        return this;
    }

    public PrintStream getOutputStream() {
        return this.outputStream;
    }

    public DiffCommand setOutputStream(PrintStream outputStream) {
        this.outputStream = outputStream;
        return this;
    }

    public SnapshotControl getReferenceSnapshotControl() {
        return this.referenceSnapshotControl;
    }

    public DiffCommand setReferenceSnapshotControl(SnapshotControl referenceSnapshotControl) {
        this.referenceSnapshotControl = referenceSnapshotControl;
        return this;
    }

    public SnapshotControl getTargetSnapshotControl() {
        return this.targetSnapshotControl;
    }

    public DiffCommand setTargetSnapshotControl(SnapshotControl targetSnapshotControl) {
        this.targetSnapshotControl = targetSnapshotControl;
        return this;
    }

    public SnapshotListener getSnapshotListener() {
        return this.snapshotListener;
    }

    public DiffCommand setSnapshotListener(SnapshotListener snapshotListener) {
        this.snapshotListener = snapshotListener;
        return this;
    }

    public CompareControl getCompareControl() {
        return this.compareControl;
    }

    public DiffCommand setCompareControl(CompareControl compareControl) {
        this.compareControl = compareControl;
        return this;
    }

    @Override
    protected CommandResult run() throws Exception {
        SnapshotCommand.logUnsupportedDatabase(this.getReferenceDatabase(), this.getClass());
        DiffResult diffResult = this.createDiffResult();
        new DiffToReport(diffResult, this.outputStream).print();
        return new CommandResult("OK");
    }

    protected DiffResult createDiffResult() throws DatabaseException, InvalidExampleException {
        DatabaseSnapshot referenceSnapshot = this.createReferenceSnapshot();
        DatabaseSnapshot targetSnapshot = this.createTargetSnapshot();
        referenceSnapshot.setSchemaComparisons(this.compareControl.getSchemaComparisons());
        if (targetSnapshot != null) {
            targetSnapshot.setSchemaComparisons(this.compareControl.getSchemaComparisons());
        }
        return DiffGeneratorFactory.getInstance().compare(referenceSnapshot, targetSnapshot, this.compareControl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DatabaseSnapshot createTargetSnapshot() throws DatabaseException, InvalidExampleException {
        CatalogAndSchema[] schemas;
        if (this.compareControl == null || this.compareControl.getSchemaComparisons() == null) {
            schemas = new CatalogAndSchema[]{this.targetDatabase.getDefaultSchema()};
        } else {
            schemas = new CatalogAndSchema[this.compareControl.getSchemaComparisons().length];
            int i = 0;
            for (CompareControl.SchemaComparison comparison : this.compareControl.getSchemaComparisons()) {
                CatalogAndSchema schema = this.targetDatabase.supportsSchemas() ? new CatalogAndSchema(this.targetDatabase.getDefaultCatalogName(), comparison.getComparisonSchema().getSchemaName()) : new CatalogAndSchema(comparison.getComparisonSchema().getSchemaName(), comparison.getComparisonSchema().getSchemaName());
                schemas[i++] = schema;
            }
        }
        SnapshotControl snapshotControl = this.getTargetSnapshotControl();
        if (snapshotControl == null) {
            snapshotControl = new SnapshotControl(this.targetDatabase, this.snapshotTypes);
        }
        if (this.getSnapshotListener() != null) {
            snapshotControl.setSnapshotListener(this.getSnapshotListener());
        }
        ObjectQuotingStrategy originalStrategy = this.targetDatabase.getObjectQuotingStrategy();
        try {
            this.targetDatabase.setObjectQuotingStrategy(ObjectQuotingStrategy.QUOTE_ALL_OBJECTS);
            DatabaseSnapshot databaseSnapshot = SnapshotGeneratorFactory.getInstance().createSnapshot(schemas, this.targetDatabase, snapshotControl);
            return databaseSnapshot;
        }
        finally {
            this.targetDatabase.setObjectQuotingStrategy(originalStrategy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DatabaseSnapshot createReferenceSnapshot() throws DatabaseException, InvalidExampleException {
        CatalogAndSchema[] schemas;
        if (this.compareControl == null || this.compareControl.getSchemaComparisons() == null) {
            schemas = new CatalogAndSchema[]{this.targetDatabase.getDefaultSchema()};
        } else {
            schemas = new CatalogAndSchema[this.compareControl.getSchemaComparisons().length];
            int i = 0;
            for (CompareControl.SchemaComparison comparison : this.compareControl.getSchemaComparisons()) {
                CatalogAndSchema schema = this.referenceDatabase.supportsSchemas() ? new CatalogAndSchema(this.referenceDatabase.getDefaultCatalogName(), comparison.getReferenceSchema().getSchemaName()) : new CatalogAndSchema(comparison.getReferenceSchema().getSchemaName(), comparison.getReferenceSchema().getSchemaName());
                schemas[i++] = schema;
            }
        }
        SnapshotControl snapshotControl = this.getReferenceSnapshotControl();
        if (snapshotControl == null) {
            snapshotControl = new SnapshotControl(this.referenceDatabase, this.objectChangeFilter, this.snapshotTypes);
        }
        if (this.getSnapshotListener() != null) {
            snapshotControl.setSnapshotListener(this.getSnapshotListener());
        }
        ObjectQuotingStrategy originalStrategy = this.referenceDatabase.getObjectQuotingStrategy();
        try {
            this.referenceDatabase.setObjectQuotingStrategy(ObjectQuotingStrategy.QUOTE_ALL_OBJECTS);
            DatabaseSnapshot databaseSnapshot = SnapshotGeneratorFactory.getInstance().createSnapshot(schemas, this.referenceDatabase, snapshotControl);
            return databaseSnapshot;
        }
        finally {
            this.referenceDatabase.setObjectQuotingStrategy(originalStrategy);
        }
    }

    public DiffCommand setObjectChangeFilter(ObjectChangeFilter objectChangeFilter) {
        this.objectChangeFilter = objectChangeFilter;
        return this;
    }
}

