/*
 * Decompiled with CFR 0.152.
 */
package liquibase.license;

import liquibase.license.LicenseService;
import liquibase.logging.LogService;
import liquibase.logging.Logger;
import liquibase.servicelocator.ServiceLocator;

public class LicenseServiceFactory {
    private static final Logger LOG = LogService.getLog(LicenseServiceFactory.class);
    private LicenseService licenseService;
    private static LicenseServiceFactory INSTANCE = new LicenseServiceFactory();

    private LicenseServiceFactory() {
    }

    public static LicenseServiceFactory getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new LicenseServiceFactory();
        }
        return INSTANCE;
    }

    public LicenseService getLicenseService() {
        if (this.licenseService != null) {
            return this.licenseService;
        }
        Class<LicenseService>[] classes = ServiceLocator.getInstance().findClasses(LicenseService.class);
        if (classes.length > 0) {
            try {
                int highPriority = -1;
                for (Class<LicenseService> clazz : classes) {
                    LicenseService test = clazz.newInstance();
                    int priority = test.getPriority();
                    LOG.debug(String.format("Found an implementation of LicenseService named '%s' with priority %d", test.getClass().getName(), priority));
                    if (priority <= highPriority || priority <= 0) continue;
                    highPriority = priority;
                    this.licenseService = test;
                }
            }
            catch (Throwable e) {
                LOG.severe("Unable to instantiate LicenseService", e);
            }
        }
        return this.licenseService;
    }
}

