/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import oracle.ide.Context;
import oracle.ide.model.Locatable;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.compare.StreamDecoder;
import oracle.jdeveloper.patch.PatchUtil;
import oracle.jdeveloper.vcs.spi.VCSFile;
import oracle.jdeveloper.vcs.spi.VCSFileContentProvider;
import oracle.jdeveloper.vcs.spi.VCSModifiedFile;
import oracle.jdeveloper.vcs.spi.VCSRevision;
import oracle.jdeveloper.vcs.util.VCSContextUtils;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdevimpl.vcs.svn.SVNClientInteraction;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.SVNURLInfoCache;
import oracle.jdevimpl.vcs.svn.StatusMapping;
import oracle.jdevimpl.vcs.svn.nav.SVNRepositoryNavigatorAPI;
import oracle.jdevimpl.vcs.svn.res.Resource;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.ISVNLogMessageChangePath;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNDiffSummary;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.wc.ISVNStatusHandler;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusClient;
import org.tmatesoft.svn.core.wc.SVNStatusType;

public class SVNFileContentProvider
extends VCSFileContentProvider {
    public String getRevision(URL url) throws Exception {
        try {
            ISVNClientAdapter client = SVNUtil.getClientAdapter(SVNRepositoryNavigatorAPI.CLIENT_CONTEXT);
            SVNUrl sUrl = SVNURLInfoCache.getInstance().getURL(url);
            SVNClientInteraction.getInstance().beginInteraction(client, SVNUtil.resolveRepository(sUrl));
            ISVNInfo info = client.getInfo(sUrl);
            if (info != null) {
                String string = info.getLastChangedRevision().toString();
                return string;
            }
        }
        catch (SVNException e) {
            SVNProfile.getQualifiedLogger(((Object)((Object)this)).getClass().getName()).severe(e.getMessage());
            throw new Exception(Resource.format("ERROR_GET_REVISION", URLFileSystem.getPlatformPathName((URL)url)));
        }
        catch (IOException e) {
            SVNProfile.getQualifiedLogger(((Object)((Object)this)).getClass().getName()).severe(e.getMessage());
            throw new Exception(Resource.format("ERROR_GET_REVISION", URLFileSystem.getPlatformPathName((URL)url)));
        }
        finally {
            SVNClientInteraction.getInstance().endInteraction();
        }
        return null;
    }

    public Collection<VCSRevision> getRevisions(Map<String, String> params, String fromRevision, int maxCount) throws Exception {
        try {
            ISVNClientAdapter client = SVNUtil.getClientAdapter(SVNRepositoryNavigatorAPI.CLIENT_CONTEXT);
            SVNRevision svnRevision = SVNRevision.getRevision((String)fromRevision);
            SVNUrl sUrl = new SVNUrl(params.get("url"));
            SVNClientInteraction.getInstance().beginInteraction(client, SVNUtil.resolveRepository(sUrl));
            ISVNLogMessage[] msg = client.getLogMessages(sUrl, svnRevision, svnRevision);
            URL url = this.getCommonURL(params.get("url"), msg);
            if (url != null) {
                SVNUrl sUrlCm = new SVNUrl(url.toString());
                long limit = maxCount;
                ISVNLogMessage[] logs = client.getLogMessages(sUrlCm, svnRevision, svnRevision, (SVNRevision)new SVNRevision.Number(0L), true, false, limit);
                ArrayList<VCSRevision> revs = new ArrayList<VCSRevision>();
                for (ISVNLogMessage log : logs) {
                    VCSRevision rev = new VCSRevision();
                    rev.setRevision(log.getRevision().toString());
                    rev.setComments(log.getMessage());
                    rev.setAuthor(log.getAuthor());
                    rev.setRevisonTime(log.getTimeMillis());
                    revs.add(rev);
                }
                ArrayList<VCSRevision> arrayList = revs;
                return arrayList;
            }
        }
        catch (SVNClientException e) {
            SVNProfile.getQualifiedLogger(((Object)((Object)this)).getClass().getName()).severe(e.getMessage());
            throw e;
        }
        finally {
            SVNClientInteraction.getInstance().endInteraction();
        }
        return Collections.EMPTY_LIST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<VCSFile> getFiles(Map<String, String> params, String fromRevision, String toRevision) throws Exception {
        ArrayList<VCSFile> files = new ArrayList<VCSFile>();
        SVNSummary summ = this.getDifferences(params, fromRevision, toRevision);
        URL reposUrl = null;
        for (SVNDiffSummary sum : summ._diffSumm) {
            URL fileURL = URLFactory.newURL((URL)summ._commonURL, (String)sum.getPath());
            InputStream from = null;
            InputStream base = null;
            try {
                from = this.getInputStream(fileURL, fromRevision);
                if (sum.getDiffKind().equals((Object)SVNDiffSummary.SVNDiffKind.MODIFIED)) {
                    base = this.getInputStream(fileURL, toRevision);
                }
                if (from == null) {
                    throw new Exception(Resource.format("CONTENT_NOT_FOUND", fromRevision, URLFileSystem.getPlatformPathName((URL)fileURL)));
                }
                ByteArrayOutputStream bFrom = this.getContent(from);
                VCSFile file = new VCSFile();
                file.setContent(bFrom.toByteArray());
                if (base != null) {
                    byte[] diff = PatchUtil.generatePatch((InputStream)base, (InputStream)new ByteArrayInputStream(bFrom.toByteArray()), (String)URLFileSystem.getSuffix((URL)fileURL), (String)StreamDecoder.getDefaultEncoding((URL)fileURL));
                    file.setDiff(diff);
                } else {
                    file.setNew(true);
                }
                if (reposUrl == null) {
                    reposUrl = this.getRepositoryUrl(fileURL);
                }
                file.setRevision(fromRevision);
                file.setRemotePath(fileURL.toString().substring(reposUrl.toString().length()));
                files.add(file);
                this.closeIo(from);
                this.closeIo(base);
            }
            catch (Throwable throwable) {
                this.closeIo(from);
                this.closeIo(base);
                throw throwable;
            }
        }
        return files;
    }

    public Collection<VCSModifiedFile> getModifiedFiles(Context context, Map<String, String> metadata) throws Exception {
        Locatable[] locs = VCSContextUtils.getContextLocatables((Context)context);
        if (locs == null || locs.length == 0) {
            return Collections.emptyList();
        }
        URL workUrl = SVNUtil.resolveWorkingCopy(locs[0].getURL());
        final ArrayList statuses = new ArrayList();
        ISVNStatusHandler handler = new ISVNStatusHandler(){

            public void handleStatus(SVNStatus status) {
                if (status.isVersioned() && status.getNodeStatus() != SVNStatusType.STATUS_NORMAL && status.getKind() != SVNNodeKind.DIR) {
                    statuses.add(status);
                }
            }
        };
        ArrayList changelist = new ArrayList();
        this.getClient().doStatus(SVNUtil.toFile(workUrl), null, SVNDepth.INFINITY, false, true, true, false, handler, changelist);
        if (statuses.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<VCSModifiedFile> modFiles = new ArrayList<VCSModifiedFile>();
        for (SVNStatus status : statuses) {
            String description = StatusMapping.getVCSStatus(status.getContentsStatus()).getOverlay().getToolTipText();
            VCSModifiedFile mFile = new VCSModifiedFile();
            mFile.setUrl(status.getFile().toURI().toURL());
            mFile.setStatus(description);
            if (status.getContentsStatus() == SVNStatusType.STATUS_ADDED) {
                mFile.setNewFile(true);
            } else if (status.getContentsStatus() == SVNStatusType.STATUS_DELETED) {
                mFile.setDeletedFile(true);
            }
            modFiles.add(mFile);
        }
        return modFiles;
    }

    private void closeIo(InputStream io) {
        if (io != null) {
            try {
                io.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL getRepositoryUrl(URL fileURL) throws SVNClientException, MalformedURLException {
        ISVNClientAdapter client = SVNUtil.getClientAdapter(SVNRepositoryNavigatorAPI.CLIENT_CONTEXT);
        try {
            SVNClientInteraction.getInstance().beginInteraction(client, SVNUtil.resolveRepository(new SVNUrl(fileURL.toString())));
            SVNUrl svnurl = new SVNUrl(fileURL.toString());
            SVNClientInteraction.getInstance().beginInteraction(client, SVNUtil.resolveRepository(svnurl));
            ISVNInfo info = client.getInfo(svnurl);
            SVNUrl reposUrl = info.getRepository();
            URL uRL = URLFactory.newURL((String)reposUrl.toString());
            return uRL;
        }
        finally {
            SVNClientInteraction.getInstance().endInteraction();
        }
    }

    private SVNSummary getDifferences(Map<String, String> params, String fromRevision, String toRevision) throws SVNClientException, MalformedURLException, ParseException {
        ISVNClientAdapter client = SVNUtil.getClientAdapter(SVNRepositoryNavigatorAPI.CLIENT_CONTEXT);
        try {
            SVNSummary summary = new SVNSummary();
            summary._fromRevision = SVNRevision.getRevision((String)fromRevision);
            summary._toRevision = SVNRevision.getRevision((String)toRevision);
            SVNUrl sUrl = new SVNUrl(params.get("url"));
            SVNClientInteraction.getInstance().beginInteraction(client, SVNUtil.resolveRepository(sUrl));
            ISVNLogMessage[] msg = client.getLogMessages(sUrl, summary._fromRevision, summary._fromRevision);
            summary._commonURL = this.getCommonURL(params.get("url"), msg);
            SVNSummary.access$002(summary, client.diffSummarize(new SVNUrl(summary._commonURL.toString()), summary._fromRevision, summary._fromRevision, summary._toRevision, 100, true));
            SVNSummary sVNSummary = summary;
            return sVNSummary;
        }
        catch (SVNClientException e) {
            SVNProfile.getQualifiedLogger(((Object)((Object)this)).getClass().getName()).severe(e.getMessage());
            throw e;
        }
        finally {
            SVNClientInteraction.getInstance().endInteraction();
        }
    }

    public InputStream getInputStream(URL url, String revision) throws IOException {
        try {
            ISVNClientAdapter client = SVNUtil.getClientAdapter(SVNRepositoryNavigatorAPI.CLIENT_CONTEXT);
            long curRev = SVNURLInfoCache.getInstance().getRevision(url);
            SVNUrl sUrl = SVNURLInfoCache.getInstance().getURL(url);
            SVNRevision sRevision = null;
            if (sUrl == null) {
                sUrl = new SVNUrl(url.toString());
            }
            sRevision = revision.equals("previous") ? SVNRevision.getRevision((String)Long.toString(curRev)) : SVNRevision.getRevision((String)revision);
            SVNClientInteraction.getInstance().beginInteraction(client, SVNUtil.resolveRepository(sUrl));
            InputStream inputStream = client.getContent(sUrl, sRevision);
            return inputStream;
        }
        catch (SVNClientException e) {
            SVNProfile.getQualifiedLogger(((Object)((Object)this)).getClass().getName()).severe(e.getMessage());
            if (revision.equals("previous")) {
                InputStream inputStream = null;
                return inputStream;
            }
            throw new IOException(e);
        }
        catch (SVNException e) {
            SVNProfile.getQualifiedLogger(((Object)((Object)this)).getClass().getName()).severe(e.getMessage());
            if (revision.equals("previous")) {
                InputStream inputStream = null;
                return inputStream;
            }
            throw new IOException(e);
        }
        catch (ParseException e) {
            SVNProfile.getQualifiedLogger(((Object)((Object)this)).getClass().getName()).severe(e.getMessage());
            throw new IOException(e);
        }
        finally {
            SVNClientInteraction.getInstance().endInteraction();
        }
    }

    private URL getCommonURL(String spec, ISVNLogMessage[] isvnLogMessages) {
        URL url = URLFactory.newURL((String)spec);
        ArrayList<URL> urls = new ArrayList<URL>();
        for (ISVNLogMessage msg : isvnLogMessages) {
            for (ISVNLogMessageChangePath paths : msg.getChangedPaths()) {
                int pos = 0;
                URL chURL = null;
                while (pos >= 0) {
                    String chPath = url.getPath().substring(pos, url.getPath().length());
                    if (paths.getPath().startsWith(chPath)) {
                        String tPath = url.getPath();
                        chURL = URLFactory.newURL((String)url.getProtocol(), (String)url.getUserInfo(), (String)url.getHost(), (int)url.getPort(), (String)(tPath.substring(0, tPath.length() - chPath.length()) + paths), (String)url.getQuery(), (String)url.getRef());
                        break;
                    }
                    pos = url.getPath().indexOf(47, pos + 1);
                }
                if (chURL == null) {
                    chURL = URLFactory.newURL((URL)url, (String)paths.getPath());
                }
                urls.add(chURL);
            }
        }
        URL[] parents = VCSFileSystemUtils.getParentURLs((URL[])urls.toArray(new URL[0]));
        if (parents.length > 0) {
            return parents[0];
        }
        return null;
    }

    protected SVNStatusClient getClient() {
        return SVNUtil.getStatusClient();
    }

    private static class SVNSummary {
        private SVNRevision _fromRevision;
        private SVNRevision _toRevision;
        private URL _commonURL;
        private SVNDiffSummary[] _diffSumm;

        private SVNSummary() {
        }

        static /* synthetic */ SVNDiffSummary[] access$002(SVNSummary x0, SVNDiffSummary[] x1) {
            x0._diffSumm = x1;
            return x1;
        }
    }
}

