/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import oracle.ide.config.Preferences;
import oracle.ide.layout.ViewId;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogPage;
import oracle.ide.log.MessagePage;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdevimpl.vcs.svn.prefs.SVNEnvironmentPrefs;
import oracle.jdevimpl.vcs.svn.res.Resource;

public class SVNMessagePage
extends MessagePage {
    private static boolean QUIET_MODE = false;
    private static SVNMessagePage _page;

    private SVNMessagePage(ViewId viewId, Icon icon, boolean addPage, boolean showStyledText) {
        super(viewId, icon, addPage, showStyledText);
    }

    public static final SVNMessagePage getInstance() {
        if (_page == null) {
            _page = new SVNMessagePage(new ViewId(Resource.get("SVN_CONSOLE_VIEWID"), Resource.get("SVN_CONSOLE_NAME")), null, false, true);
            SVNMessagePage.load(_page);
        }
        return _page;
    }

    public static final void load(final MessagePage page) {
        boolean showSvnConsole = SVNEnvironmentPrefs.getInstance((PropertyStorage)Preferences.getPreferences()).getShowSVNConsole();
        if (page != null && showSvnConsole) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LogManager.getLogManager().addPage((LogPage)page);
                    page.activate();
                    page.show();
                }
            });
        }
    }

    public static final void unload() {
        if (_page != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    _page.close();
                    _page.deactivate();
                }
            });
            LogManager.getLogManager().removePage((LogPage)_page);
            _page = null;
        }
    }

    public void close() {
        this.setQuietMode(MessageDialog.confirm((Component)VCSWindowUtils.getCurrentWindow(), (Object)Resource.get("SVN_CONSOLE_QUIET_MSG"), (String)Resource.get("SVN_CONSOLE_QUIET_TITLE"), null));
        super.close();
    }

    public void setQuietMode(boolean quietMode) {
        SVNEnvironmentPrefs.getInstance((PropertyStorage)Preferences.getPreferences()).setShowSVNConsole(!quietMode);
        QUIET_MODE = quietMode;
    }

    public boolean isQuietMode() {
        boolean showSvnConsole = SVNEnvironmentPrefs.getInstance((PropertyStorage)Preferences.getPreferences()).getShowSVNConsole();
        QUIET_MODE = !showSvnConsole;
        return QUIET_MODE;
    }

    public void log(Object msg) {
        if (this.isQuietMode()) {
            super.logQuietly(msg);
        } else {
            super.log(msg);
        }
    }
}

