/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.compare;

import java.io.File;
import oracle.javatools.compare.algorithm.EditableContributor;
import oracle.javatools.compare.algorithm.list.CompareList;
import oracle.javatools.compare.algorithm.list.CompareListItem;
import oracle.javatools.compare.algorithm.list.ListCompareContributor;
import oracle.jdevimpl.vcs.svn.SVNClientInteraction;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.adapter.OISVNClientAdapter;
import oracle.jdevimpl.vcs.svn.compare.SVNComparableProperty;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.repos.SVNRepositoryManager;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNProperty;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SVNPropertiesCompareContributor
extends ListCompareContributor
implements EditableContributor {
    private SVNUrl _url;
    private File _file;
    private SVNRevision _revision;
    private boolean _editable;

    public SVNPropertiesCompareContributor(File file, SVNRevision revision) {
        this(file, revision, false);
    }

    public SVNPropertiesCompareContributor(File file, SVNRevision revision, boolean editable) {
        this._file = file;
        this._revision = revision;
        this._editable = editable;
    }

    public SVNPropertiesCompareContributor(SVNUrl url, SVNRevision revision) {
        this(url, revision, false);
    }

    public SVNPropertiesCompareContributor(SVNUrl url, SVNRevision revision, boolean editable) {
        this._url = url;
        this._revision = revision;
        this._editable = editable;
    }

    protected final CompareList getCompareListImpl() {
        int i;
        ISVNProperty[] properties;
        if (this._revision == null) {
            return new CompareList();
        }
        if (SVNRepositoryManager.getInstance().isEmpty()) {
            return new CompareList();
        }
        CompareList propertiesCompareList = null;
        if (this._url != null) {
            properties = this.getPropertiesAdapter(this._url, this._revision);
            propertiesCompareList = new CompareList();
            for (i = 0; i < properties.length; ++i) {
                propertiesCompareList.appendItem((CompareListItem)new SVNComparableProperty(properties[i].getName(), properties[i].getValue()));
            }
        }
        if (this._file != null) {
            properties = this.getPropertiesAdapter(this._file, this._revision);
            propertiesCompareList = new CompareList();
            for (i = 0; i < properties.length; ++i) {
                propertiesCompareList.appendItem((CompareListItem)new SVNComparableProperty(properties[i].getName(), properties[i].getValue()));
            }
        }
        return propertiesCompareList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ISVNProperty[] getPropertiesAdapter(SVNUrl url, SVNRevision revision) {
        try {
            ISVNProperty[] properties;
            OISVNClientAdapter osvnClient = SVNUtil.getIdeOISVNClientAdapter();
            SVNRepositoryInfo repoInfo = SVNUtil.resolveRepository(url);
            SVNClientInteraction.getInstance().beginInteraction(osvnClient, repoInfo);
            ISVNProperty[] iSVNPropertyArray = properties = osvnClient.getProperties(url, revision);
            return iSVNPropertyArray;
        }
        catch (SVNClientException e) {
            SVNProfile.getQualifiedLogger(((Object)((Object)this)).getClass().getName()).severe(e.getMessage());
            ISVNProperty[] iSVNPropertyArray = new ISVNProperty[]{};
            return iSVNPropertyArray;
        }
        finally {
            SVNClientInteraction.getInstance().endInteraction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ISVNProperty[] getPropertiesAdapter(File file, SVNRevision revision) {
        try {
            ISVNProperty[] properties;
            OISVNClientAdapter osvnClient = SVNUtil.getIdeOISVNClientAdapter();
            SVNRepositoryInfo repoInfo = SVNUtil.getFirstAssociatedRepository(SVNUtil.toURL(file));
            SVNClientInteraction.getInstance().beginInteraction(osvnClient, repoInfo);
            ISVNProperty[] iSVNPropertyArray = properties = osvnClient.getProperties(file, revision);
            return iSVNPropertyArray;
        }
        catch (Exception e) {
            SVNProfile.getQualifiedLogger(((Object)((Object)this)).getClass().getName()).severe(e.getMessage());
            ISVNProperty[] iSVNPropertyArray = new ISVNProperty[]{};
            return iSVNPropertyArray;
        }
        finally {
            SVNClientInteraction.getInstance().endInteraction();
        }
    }

    public String getLongLabel() {
        String label = "";
        if (this._url != null) {
            label = SVNUtil.getCompareIdentifier(SVNUtil.getPath(this._url), this._revision);
        }
        if (this._file != null) {
            label = this._file.toString();
        }
        return label;
    }

    public String getShortLabel() {
        String label = "";
        if (this._url != null) {
            label = SVNUtil.getCompareIdentifier(this._url.getLastPathSegment(), this._revision);
        }
        if (this._file != null) {
            label = this._file.getName();
        }
        return label;
    }

    public boolean isEditable() {
        return this._editable;
    }

    public boolean isModified() {
        return this.getCompareList().isModified();
    }
}

