/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.imp;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.logging.Level;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import oracle.bali.ewt.wizard.WizardDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.net.DefaultNameGenerator;
import oracle.ide.net.NameGenerator;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.CommitListener;
import oracle.ide.util.Namespace;
import oracle.ide.wizard.FSM;
import oracle.ide.wizard.FSMBuilder;
import oracle.ide.wizard.FSMInvalidException;
import oracle.ide.wizard.FSMWizard;
import oracle.ide.wizard.Step;
import oracle.ide.wizard.WelcomePanel;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.javatools.util.SwingUtils;
import oracle.jdeveloper.vcs.cache.Depth;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfileRegistry;
import oracle.jdeveloper.vcs.spi.VCSCancelException;
import oracle.jdeveloper.vcs.spi.VCSCancellable;
import oracle.jdeveloper.vcs.spi.VCSControlCache;
import oracle.jdeveloper.vcs.spi.VCSFileEventSender;
import oracle.jdeveloper.vcs.spi.VCSImportBackupHelper;
import oracle.jdeveloper.vcs.util.VCSIgnoreFilters;
import oracle.jdeveloper.vcs.util.VCSImport;
import oracle.jdeveloper.vcs.util.VCSProcessUtils;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdevimpl.vcs.generic.util.DirectoryCopier;
import oracle.jdevimpl.vcs.generic.util.NewFilesHandler;
import oracle.jdevimpl.vcs.generic.util.PatternURLFilter;
import oracle.jdevimpl.vcs.generic.util.VCSDirectoryWatcher;
import oracle.jdevimpl.vcs.generic.util.VCSGenericUtil;
import oracle.jdevimpl.vcs.svn.SVNOperationLogger;
import oracle.jdevimpl.vcs.svn.imp.DestinationPanel;
import oracle.jdevimpl.vcs.svn.imp.FiltersPanel;
import oracle.jdevimpl.vcs.svn.imp.OthersPanel;
import oracle.jdevimpl.vcs.svn.imp.SVNImportModel;
import oracle.jdevimpl.vcs.svn.imp.SourcePanel;
import oracle.jdevimpl.vcs.svn.imp.SummaryPanel;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.repos.SVNRepositoryManager;
import oracle.jdevimpl.vcs.svn.res.Resource;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNBasicClient;
import org.tmatesoft.svn.core.wc.SVNCommitClient;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;

public final class SVNImportWizard {
    static final String DATA_KEY = SVNImportWizard.class.getName() + ".importModel";
    private static final String LAST_REPOS_KEY = SVNImportWizard.class.getName() + ".lastRepos";
    private static final Object FSM_STATE_DESTINATION = new Object();
    private static final Object FSM_STATE_SOURCE = new Object();
    private static final Object FSM_STATE_FILTERS = new Object();
    private static final Object FSM_STATE_OTHERS = new Object();
    private static final Object FSM_STATE_SUMMARY = new Object();
    private final VCSProfile _profile = VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.subversion");
    private IndeterminateProgressMonitor _progress = null;

    public boolean runWizard(Component parent, final Context context) {
        if (!SVNUtil.ensureRepositoryConnection(context)) {
            return false;
        }
        final Namespace ns = new Namespace();
        ns.put(DATA_KEY, (Object)this.createModel(context));
        FSMWizard wizard = new FSMWizard(this.createFSM(), ns);
        wizard.setWelcomePageAdded(true);
        wizard.setFinishPageAdded(true);
        wizard.setWizardTitle(Resource.get("IMPORT_WIZARD_TITLE"));
        wizard.setRoadmapVisible(true);
        wizard.setLogoImage(VCSImport.getWizardImage().getImage());
        wizard.setHeaderGradientBackground(new Color[]{new Color(-1), new Color(-3219482)});
        final WizardDialog wd = this.createWizardDialog(wizard, parent);
        wizard.addCommitListener(new CommitListener(){

            public void checkCommit(ApplyEvent event) {
            }

            public void commit(ApplyEvent event) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        if (!SVNImportWizard.this.commitWizard((SVNImportModel)ns.get(DATA_KEY), context)) {
                            return;
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                wd.dispose();
                            }
                        });
                    }
                }, "svn-import-wizard-thread").start();
            }

            public void rollback(ApplyEvent event) {
            }

            public void cancel(ApplyEvent event) {
            }
        });
        return WizardLauncher.runDialog((JDialog)wd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean commitWizard(SVNImportModel model, Context context) {
        URL importSource = model.getSourceDirectory();
        if (!URLFileSystem.exists((URL)importSource)) {
            MessageDialog.error((Component)VCSWindowUtils.getCurrentWindow(), (Object)Resource.format("IMPORT_OP_ERROR_MSG_SOURCENOTEXIST", URLFileSystem.getPlatformPathName((URL)importSource)), (String)Resource.get("IMPORT_OP_ERROR_TITLE_IMPORTING"), null);
            return false;
        }
        if (SVNUtil.isWorkingCopy(importSource)) {
            MessageDialog.error((Component)VCSWindowUtils.getCurrentWindow(), (Object)Resource.format("IMPORT_OP_ERROR_MSG_VERSIONED", URLFileSystem.getPlatformPathName((URL)importSource)), (String)Resource.get("IMPORT_OP_ERROR_TITLE_VERSIONED"), null);
            return false;
        }
        this._progress = new IndeterminateProgressMonitor((Component)Ide.getMainWindow(), Resource.get("IMPORT_OP_PROGRESS_TITLE"));
        this._progress.setCancellable(true);
        this._progress.setCloseOnFinish(true);
        this._progress.setMillisToPopup(0);
        this._progress.start();
        Ide.getDTCache().putString(LAST_REPOS_KEY, model.getRepository().getURL().toString());
        VCSCancellable cancellable = new VCSCancellable(){

            public boolean isCancelled() {
                return SVNImportWizard.this._progress.isCancelled();
            }
        };
        try {
            this.setProgressMessage(Resource.get("IMPORT_OP_PROGRESS_COPYING"));
            URL filteredSourceDir = this.prepareImportSources(model, cancellable);
            this.setProgressMessage(Resource.get("IMPORT_OP_PROGRESS_IMPORTING"));
            boolean success = this.executeImport(model, filteredSourceDir, cancellable);
            if (success && model.getCheckout()) {
                URL importSource2 = model.getSourceDirectory();
                this.setProgressMessage(Resource.get("IMPORT_OP_PROGRESS_BACKUP"));
                URL backup = this.backupAndCloseNodes(importSource2, cancellable);
                VCSDirectoryWatcher watcher = new VCSDirectoryWatcher(importSource2);
                this.setProgressMessage(Resource.get("IMPORT_OP_PROGRESS_CHECKOUT"));
                watcher.beginWatch();
                this.executeCheckout(model.getDestinationUrl(), model.getRepository(), importSource2, cancellable);
                watcher.endWatch();
                this.openNewFiles(watcher, context);
                this._profile.getPolicyStatusCache().clear(new URL[]{importSource2}, Depth.INFINITY);
                this.postInvoke(importSource2);
            }
            boolean bl = true;
            return bl;
        }
        catch (VCSCancelException vcsce) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.progressFinish();
        }
    }

    private void postInvoke(URL target) {
        VCSFileEventSender.fireFileStructureChanged((URL[])new URL[]{target});
        VCSControlCache.getInstance().fireControlStateChanged(this._profile.getID());
    }

    private void openNewFiles(final VCSDirectoryWatcher watcher, final Context context) {
        final NewFilesHandler nfh = new NewFilesHandler(watcher, "oracle.jdeveloper.subversion");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Element elm = context.getElement();
                    String name = "";
                    if (elm instanceof Locatable) {
                        URL url = ((Locatable)elm).getURL();
                        name = URLFileSystem.getName((URL)url);
                    }
                    if (VCSProcessUtils.productHandleNewFiles()) {
                        nfh.handleNewFiles(context, name);
                    }
                }
                catch (Exception exception) {
                    SVNImportWizard.this.progressFinish();
                    SVNImportWizard.this._profile.getLogger().warning(exception.getMessage());
                    ExceptionDialog.showExceptionDialog((Component)VCSWindowUtils.getCurrentWindow(), (Throwable)exception, (String)Resource.get("IMPORT_OP_ERROR_TITLE_OPENNEW"), (String)Resource.format("IMPORT_OP_ERROR_MSG_OPENNEW", URLFileSystem.getPlatformPathName((URL)watcher.getWatchedDirectory())), (String)"f1_svnimpopennewerror_html");
                }
            }
        });
    }

    private void executeCheckout(SVNURL source, SVNRepositoryInfo repos, URL target, VCSCancellable cancellable) throws VCSCancelException {
        if (cancellable.isCancelled()) {
            throw new VCSCancelException();
        }
        SVNUpdateClient client = null;
        try {
            client = SVNUtil.getUpdateClient(repos);
            SVNOperationLogger.getInstance().beginOperation((SVNBasicClient)client, repos);
            client.doCheckout(source, SVNUtil.toFile(target), SVNRevision.HEAD, SVNRevision.HEAD, SVNDepth.INFINITY, true);
        }
        catch (SVNException ce) {
            this._profile.getLogger().warning(ce.getMessage());
            ExceptionDialog.showExceptionDialog((Window)VCSWindowUtils.getCurrentWindow(), (Exception)((Object)ce), (String)Resource.get("IMPORT_OP_ERROR_TITLE_CHECKOUT"), (String)Resource.format("IMPORT_OP_ERROR_MSG_CHECKOUT", source.toString()));
            throw new VCSCancelException();
        }
        finally {
            if (client != null) {
                SVNOperationLogger.getInstance().endOperation();
            }
        }
    }

    private URL backupAndCloseNodes(final URL dir, VCSCancellable cancellable) throws VCSCancelException {
        VCSImportBackupHelper backupHelper = new VCSImportBackupHelper(dir){

            protected URL generateBackupDirectoryURL(URL directoryUrl) {
                String name = URLFileSystem.getFileName((URL)directoryUrl) + ".svn-import-backup/";
                URL backupDir = URLFactory.newUniqueURL((URL)URLFileSystem.getParent((URL)directoryUrl), (NameGenerator)new DefaultNameGenerator(name, null));
                return URLFactory.newDirURL((URL)backupDir, (String)"/");
            }

            protected void createBackupDirectory(URL backupDirectoryUrl) throws Exception {
                if (!URLFileSystem.mkdirs((URL)backupDirectoryUrl)) {
                    SVNImportWizard.this.progressFinish();
                    MessageDialog.error((Component)VCSWindowUtils.getCurrentWindow(), (Object)Resource.format("IMPORT_OP_ERROR_MSG_BACKUPDIR", URLFileSystem.getPlatformPathName((URL)backupDirectoryUrl), URLFileSystem.getPlatformPathName((URL)URLFileSystem.getParent((URL)dir))), (String)Resource.get("IMPORT_OP_ERROR_TITLE_BACKUP"), (String)"f1_svnimpbackupdirerror_html");
                    throw new VCSCancelException();
                }
            }

            protected boolean confirmRetryBackupAfterFailure(URL url) {
                return MessageDialog.confirm((Component)VCSWindowUtils.getCurrentWindow(), (Object)Resource.format("IMPORT_OP_ERROR_MSG_BACKUPURL", URLFileSystem.getPlatformPathName((URL)url)), (String)Resource.get("IMPORT_OP_ERROR_TITLE_BACKUPURL"), (String)"f1_svnimpconfirmbackupretry_html", (boolean)false, (String)Resource.get("IMPORT_OP_ERROR_BACKUPURL_RETRY_YES"), (String)UIManager.getString("OptionPane.cancelButtonText"));
            }

            protected void removeNodes(Node[] nodes) throws Exception {
                try {
                    super.removeNodes(nodes);
                }
                catch (Exception exception) {
                    SVNImportWizard.this.progressFinish();
                    SVNImportWizard.this._profile.getLogger().warning(exception.getMessage());
                    ExceptionDialog.showExceptionDialog((Window)VCSWindowUtils.getCurrentWindow(), (Exception)exception, (String)Resource.get("IMPORT_OP_ERROR_MSG_REMOVENODE"));
                    throw new VCSCancelException();
                }
            }

            protected void closeNodes(Node[] nodes) throws Exception {
                try {
                    super.closeNodes(nodes);
                }
                catch (Exception exception) {
                    SVNImportWizard.this.progressFinish();
                    SVNImportWizard.this._profile.getLogger().warning(exception.getMessage());
                    ExceptionDialog.showExceptionDialog((Window)VCSWindowUtils.getCurrentWindow(), (Exception)exception, (String)Resource.get("IMPORT_OP_ERROR_MSG_CLOSENODE"));
                    throw new VCSCancelException();
                }
            }
        };
        try {
            URL backupDirectoryUrl = backupHelper.backupDirectoryFiles(cancellable);
            if (cancellable.isCancelled() || backupDirectoryUrl == null) {
                throw new VCSCancelException();
            }
            return backupDirectoryUrl;
        }
        catch (VCSCancelException vcsce) {
            throw vcsce;
        }
        catch (Exception e) {
            throw new VCSCancelException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeImport(SVNImportModel model, URL filteredSourceDir, VCSCancellable cancellable) throws VCSCancelException {
        if (cancellable.isCancelled()) {
            throw new VCSCancelException();
        }
        SVNCommitClient client = null;
        try {
            client = SVNUtil.getCommitClient(model.getRepository());
            SVNOperationLogger.getInstance().beginOperation((SVNBasicClient)client, model.getRepository());
            String comment = model.getComment();
            client.doImport(SVNUtil.toFile(filteredSourceDir), model.getDestinationUrl(), comment != null ? comment : "", null, false, false, model.getRecursive() ? SVNDepth.INFINITY : SVNDepth.IMMEDIATES);
        }
        catch (SVNException ce) {
            this.progressFinish();
            this._profile.getLogger().warning(ce.getMessage());
            ExceptionDialog.showExceptionDialog((Component)VCSWindowUtils.getCurrentWindow(), (Throwable)ce, (String)Resource.get("IMPORT_OP_ERROR_TITLE_IMPORTING"), (String)Resource.format("IMPORT_OP_ERROR_MSG_IMPORTING", model.getDestinationUrl().toString()), (String)"f1_svnimpimporterror_html");
            boolean bl = false;
            return bl;
        }
        finally {
            if (client != null) {
                SVNOperationLogger.getInstance().endOperation();
            }
        }
        return true;
    }

    private URL prepareImportSources(SVNImportModel model, VCSCancellable cancellable) throws VCSCancelException {
        URL sourceDir = model.getSourceDirectory();
        String name = URLFileSystem.getFileName((URL)sourceDir) + ".svn-import-workarea/";
        URL filteredSourceDir = URLFactory.newUniqueURL((URL)URLFileSystem.getParent((URL)sourceDir), (NameGenerator)new DefaultNameGenerator(name, null));
        if (!URLFileSystem.mkdirs((URL)(filteredSourceDir = URLFactory.newDirURL((URL)filteredSourceDir, (String)"/")))) {
            this.progressFinish();
            MessageDialog.error((Component)VCSWindowUtils.getCurrentWindow(), (Object)Resource.format("IMPORT_OP_ERROR_MSG_STAGEDIR", URLFileSystem.getPlatformPathName((URL)filteredSourceDir), URLFileSystem.getPlatformPathName((URL)URLFileSystem.getParent((URL)filteredSourceDir))), (String)Resource.get("IMPORT_OP_ERROR_TITLE_COPYING"), (String)"f1_svnimpfilterdirerror_htm553l");
            throw new VCSCancelException();
        }
        DirectoryCopier copier = null;
        try {
            copier = new DirectoryCopier(sourceDir, filteredSourceDir, (URLFilter)new PatternURLFilter(model.getFilters()), cancellable, true);
        }
        catch (IllegalArgumentException iae) {
            this._profile.getLogger().warning(iae.getMessage());
            MessageDialog.error((Component)VCSWindowUtils.getCurrentWindow(), (Object)Resource.format("IMPORT_OP_ERROR_MSG_COPYING", URLFileSystem.getPlatformPathName((URL)filteredSourceDir), URLFileSystem.getPlatformPathName((URL)sourceDir)), (String)Resource.get("IMPORT_OP_ERROR_TITLE_COPYING"), (String)"f1_svnimpcopyerror_html");
        }
        if (cancellable.isCancelled()) {
            throw new VCSCancelException();
        }
        try {
            if (copier != null) {
                copier.performCopy();
            }
            return filteredSourceDir;
        }
        catch (IOException ioe) {
            this.progressFinish();
            this._profile.getLogger().warning(ioe.getMessage());
            MessageDialog.error((Component)VCSWindowUtils.getCurrentWindow(), (Object)Resource.format("IMPORT_OP_ERROR_MSG_COPYING", URLFileSystem.getPlatformPathName((URL)filteredSourceDir), URLFileSystem.getPlatformPathName((URL)sourceDir)), (String)Resource.get("IMPORT_OP_ERROR_TITLE_COPYING"), (String)"f1_svnimpcopyerror_html");
            throw new VCSCancelException();
        }
    }

    private WizardDialog createWizardDialog(FSMWizard wizard, Component parent) {
        Dialog dialog = SwingUtils.getAncestorDialog((Component)parent);
        if (dialog != null) {
            return wizard.getDialog(dialog);
        }
        return wizard.getDialog(SwingUtils.getAncestorFrame((Component)parent));
    }

    private SVNImportModel createModel(Context context) {
        SVNRepositoryInfo defaultRepos;
        SVNImportModel model = new SVNImportModel();
        Collection<SVNRepositoryInfo> c = SVNRepositoryManager.getInstance().list();
        SVNRepositoryInfo repos = defaultRepos = c.iterator().next();
        String lastRepos = Ide.getDTCache().getString(LAST_REPOS_KEY);
        if (lastRepos != null) {
            try {
                SVNRepositoryInfo resolvedRepos = SVNUtil.resolveRepository(new SVNUrl(lastRepos));
                if (resolvedRepos != null) {
                    repos = resolvedRepos;
                }
            }
            catch (MalformedURLException mfue) {
                this._profile.getLogger().log(Level.WARNING, "malformed svn url for last import target", mfue);
            }
        }
        model.setRepository(repos);
        model.setSourceDirectory(VCSGenericUtil.getContextDirectoryURL((Context)context, (VCSProfile)this._profile));
        Collection filters = VCSIgnoreFilters.getAllIgnoreFilters();
        filters.add("**/deploy/**");
        model.setFilters(filters);
        model.setRecursive(true);
        model.setCheckout(true);
        return model;
    }

    private FSM createFSM() {
        FSMBuilder builder = new FSMBuilder();
        Step step = WelcomePanel.newStep((String)Resource.get("IMPORT_WIZARD_TITLE"), (String)Resource.get("IMPORT_WIZARD_HEADER"), (String)Resource.get("IMPORT_WIZARD_WELCOME_TEXT"), (String)(this.getClass().getName() + ".skipWelcome"), (String)"f1_svnimpwelcome_html");
        builder.newStartState(step, FSM_STATE_DESTINATION);
        step = new Step(Resource.get("IMPORT_WIZARD_DESTINATION_TITLE"), DestinationPanel.class, "f1_svnimpdestination_html");
        builder.newState(FSM_STATE_DESTINATION, step, FSM_STATE_SOURCE);
        step = new Step(Resource.get("IMPORT_WIZARD_SOURCE_TITLE"), SourcePanel.class, "f1_svnimpsource_html");
        builder.newState(FSM_STATE_SOURCE, step, FSM_STATE_FILTERS);
        step = new Step(Resource.get("IMPORT_WIZARD_FILTERS_TITLE"), FiltersPanel.class, "f1_svnimpfilters_html");
        builder.newState(FSM_STATE_FILTERS, step, FSM_STATE_OTHERS);
        step = new Step(Resource.get("IMPORT_WIZARD_OTHERS_TITLE"), OthersPanel.class, "f1_svnimpoptions_html");
        builder.newState(FSM_STATE_OTHERS, step, FSM_STATE_SUMMARY);
        step = new Step(Resource.get("IMPORT_WIZARD_SUMMARY_TITLE"), SummaryPanel.class, "f1_svnimpsummary_html");
        builder.newFinalState(FSM_STATE_SUMMARY, step);
        try {
            return builder.getFSM();
        }
        catch (FSMInvalidException fsmie) {
            this._profile.getLogger().warning(fsmie.getMessage());
            fsmie.printStackTrace();
            assert (false) : "Unexpected FSMInvalidException";
            return null;
        }
    }

    private void setProgressMessage(String message) {
        if (this._progress != null && this._progress.getPanel() != null) {
            this._progress.getPanel().setMessage(message);
        }
    }

    private void progressFinish() {
        if (this._progress != null) {
            this._progress.finish();
        }
    }
}

