/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette;

import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import oracle.ide.palette.PaletteLoader;
import oracle.ideimpl.palette.model.Addin;
import oracle.ideimpl.palette.model.Item;
import oracle.ideimpl.palette.model.Page;
import oracle.ideimpl.palette.palettexml.PaletteXML;

public class PaletteLoaderImpl
implements PaletteLoader {
    @Override
    public void loadPaletteItems(URL xmlURL, URL propURL) {
        try {
            Properties props = new Properties();
            props.load(propURL.openStream());
            PaletteXML.loadPaletteXml(xmlURL);
            int numItems = Integer.parseInt(props.getProperty("NumItems"));
            for (int i = 0; i < numItems; ++i) {
                String page = props.getProperty("Item" + i + ".page");
                String pageIcon = props.getProperty("Item" + i + ".pageicon");
                String longLabel = props.getProperty("Item" + i + ".longLabel");
                String shortLabel = props.getProperty("Item" + i + ".shortLabel");
                String type = props.getProperty("Item" + i + ".type");
                String info = props.getProperty("Item" + i + ".info");
                String icon = props.getProperty("Item" + i + ".icon");
                String editor = props.getProperty("Item" + i + ".editor");
                String library = props.getProperty("Item" + i + ".library");
                String canRemoveItem = props.getProperty("Item" + i + ".canRemove");
                String codeSnippet = props.getProperty("Item" + i + ".codeSnippet");
                String unsorted = props.getProperty("Item" + i + ".unsorted");
                String technologyScope = props.getProperty("Item" + i + ".technologyScope");
                String draggable = props.getProperty("Item" + i + ".draggable");
                String pageType = props.getProperty("Item" + i + ".page.type");
                String multiType = props.getProperty("Item" + i + ".page.showForTypes");
                String view = props.getProperty("Item" + i + ".page.view");
                String canRemove = props.getProperty("Item" + i + ".page.canRemove");
                String canShow = props.getProperty("Item" + i + ".page.canShow");
                String helpable = props.getProperty("Item" + i + ".helpable");
                String pageTechScope = props.getProperty("Item" + i + ".page.technologyScope");
                String paletteContext = props.getProperty("Item" + i + ".page.paletteContext");
                Item newItem = new Item();
                newItem.setLongLabel(longLabel);
                newItem.setShortLabel(shortLabel);
                newItem.setType(type);
                newItem.setInfo(info);
                newItem.setIcon(icon);
                newItem.setEditor(editor);
                if (canRemoveItem == null || canRemoveItem.equalsIgnoreCase("true")) {
                    newItem.setCanRemove(true);
                } else if (canRemoveItem.equalsIgnoreCase("false")) {
                    newItem.setCanRemove(false);
                }
                if (unsorted != null) {
                    // empty if block
                }
                if (helpable != null) {
                    newItem.setHelpable(helpable);
                }
                if (library != null) {
                    newItem.setLibrary(library);
                }
                if (codeSnippet != null) {
                    newItem.setCodeSnippet(codeSnippet);
                }
                Page palettePage = null;
                Page[] pages = PaletteXML.getPalette().getPage();
                for (int j = 0; j < pages.length; ++j) {
                    if (!pages[j].getName().equalsIgnoreCase(page)) continue;
                    palettePage = pages[j];
                }
                if (palettePage == null) {
                    palettePage = new Page();
                    PaletteXML.addPage(palettePage);
                }
                if (pageType != null) {
                    palettePage.setType(pageType.trim());
                }
                if (view != null) {
                    palettePage.setView(view.trim());
                }
                if (pageIcon != null) {
                    palettePage.setIcon(pageIcon);
                }
                if (canRemove != null) {
                    palettePage.setCanRemove(new Boolean(canRemove));
                }
                if (multiType != null) {
                    palettePage.setShowForTypes(multiType);
                }
                if (canShow != null) {
                    palettePage.setCanShow(canShow);
                }
                if (pageTechScope != null) {
                    palettePage.setTechnologyScope(pageTechScope);
                }
                if (paletteContext != null) {
                    palettePage.setPaletteContext(paletteContext);
                }
                if (technologyScope != null) {
                    palettePage.setTechnologyScope(technologyScope);
                }
                if (draggable != null) {
                    boolean b = Boolean.getBoolean(draggable);
                    palettePage.setDraggable(b);
                }
                palettePage.setName(page);
                PaletteXML.addItem(page, newItem);
            }
            int numJspLibraries = 0;
            if (props.getProperty("NumJspLibraries") != null) {
                numJspLibraries = Integer.parseInt(props.getProperty("NumJspLibraries"));
            }
            if (numJspLibraries > 0) {
                System.err.println("JSP libraries are not registered via palette.xml file any more!");
            }
            int numAddins = 0;
            if (props.getProperty("NumOfAddins") != null) {
                numAddins = Integer.parseInt(props.getProperty("NumOfAddins"));
            }
            for (int k = 0; k < numAddins; ++k) {
                Addin addin = new Addin();
                String label = props.getProperty("Addin" + k + ".label");
                String classname = props.getProperty("Addin" + k + ".classname");
                addin.setLabel(label);
                addin.setClassName(classname);
                PaletteXML.addAddin(addin);
            }
            try {
                PaletteXML.savePaletteXml();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        catch (IOException ioEx) {
            ioEx.printStackTrace();
            System.exit(1);
        }
    }
}

