/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.actions;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.hcs.HCSArb;
import oracle.hcs.actions.ActionConfirmPanel;
import oracle.hcs.av.calcs.DependenciesTableModel;
import oracle.hcs.av.model.AVBaseMeasure;
import oracle.hcs.av.model.AVCalculatedMeasure;
import oracle.hcs.av.model.AnalyticView;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.table.GenericTable;

public class ConfirmDropMeasurePanel
extends ActionConfirmPanel {
    private GenericTable measuresTable;
    private DefaultTableModel deleteTableModel;
    private List<AVBaseMeasure> measures;
    private List<AVBaseMeasure> dependencies;
    private GenericTable dependenciesTable;
    private DependenciesTableModel tableModel;
    private JCheckBox cascadeDelete;
    private boolean droppingCalcMeasures;
    private String owner;

    public ConfirmDropMeasurePanel(List<AVBaseMeasure> list, String string) {
        this.dependencies = list;
        this.owner = string;
        this.initComponents();
        this.layoutComponents();
    }

    public ConfirmDropMeasurePanel(List<AVBaseMeasure> list, List<AVBaseMeasure> list2, String string) {
        this.dependencies = list2;
        this.measures = list;
        this.owner = string;
        this.initComponents();
        this.layoutComponents();
    }

    private void initComponents() {
        if (this.measures != null && !this.measures.isEmpty() && this.measures.get(0) instanceof AVCalculatedMeasure) {
            this.droppingCalcMeasures = true;
        }
        this.deleteTableModel = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        this.deleteTableModel.addColumn(HCSArb.getString("DROP_MEASURE_NAME_COLUMN"));
        this.deleteTableModel.addColumn(HCSArb.getString("DROP_MEASURE_TYPE_COLUMN"));
        this.deleteTableModel.addColumn(HCSArb.getString("DROP_MEASURE_CAPTION_COLUMN"));
        this.deleteTableModel.addColumn(HCSArb.getString("DROP_MEASURE_DESCRIPTION_COLUMN"));
        if (this.droppingCalcMeasures) {
            this.deleteTableModel.addColumn(HCSArb.getString("DROP_MEASURE_EXPRESSION_COLUMN"));
        }
        this.measuresTable = new GenericTable((TableModel)this.deleteTableModel);
        this.tableModel = new DependenciesTableModel();
        this.dependenciesTable = new GenericTable((TableModel)this.tableModel);
        this.cascadeDelete = new JCheckBox(HCSArb.getString("CASCADE_DELETE"));
        this.setupTableColumns();
        this.populateTable();
    }

    private void populateTable() {
        Object[] objectArray;
        String string;
        if (this.measures != null && !this.measures.isEmpty()) {
            for (AVBaseMeasure aVBaseMeasure : this.measures) {
                string = "";
                objectArray = null;
                if (aVBaseMeasure.isDerived()) {
                    string = HCSArb.getString("DEPENDENCIES_TABLE_MODEL_CALCULATED_MEASURE");
                    objectArray = new Object[]{aVBaseMeasure.getName(), string, aVBaseMeasure.getCaption(), aVBaseMeasure.getDescription(), aVBaseMeasure.getExpression()};
                } else {
                    string = HCSArb.getString("DEPENDENCIES_TABLE_MODEL_BASE_MEASURE");
                    objectArray = new Object[]{aVBaseMeasure.getName(), string, aVBaseMeasure.getCaption(), aVBaseMeasure.getDescription()};
                }
                this.deleteTableModel.addRow(objectArray);
            }
        }
        if (this.dependencies != null && !this.dependencies.isEmpty()) {
            for (AVBaseMeasure aVBaseMeasure : this.dependencies) {
                string = "";
                string = aVBaseMeasure.isDerived() ? HCSArb.getString("DEPENDENCIES_TABLE_MODEL_CALCULATED_MEASURE") : HCSArb.getString("DEPENDENCIES_TABLE_MODEL_BASE_MEASURE");
                objectArray = null;
                AnalyticView analyticView = aVBaseMeasure.getAV();
                if (analyticView != null) {
                    String string2 = analyticView.getName();
                    objectArray = new Object[]{String.format("%s.%s", string2, aVBaseMeasure.getName()), string, aVBaseMeasure.getExpression()};
                } else {
                    objectArray = new Object[]{aVBaseMeasure.getName(), string, aVBaseMeasure.getExpression()};
                }
                this.tableModel.addRow(objectArray);
            }
        }
    }

    protected void layoutComponents() {
        this.setLayout(new GridBagLayout());
        this.cascadeDelete.setSelected(true);
        this.cascadeDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!ConfirmDropMeasurePanel.this.cascadeDelete.isSelected()) {
                    JOptionPane.showMessageDialog(null, HCSArb.getString("CASCADE_DELETE_WARNING_MSG"), HCSArb.getString("CASCADE_DELETE"), 2);
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane((Component)this.dependenciesTable);
        ComponentWithTitlebar componentWithTitlebar = new ComponentWithTitlebar();
        componentWithTitlebar.setLabel(new JLabel(HCSArb.getString("CREATE_DERIVED_MEASURE_DIALOG.DEPENDENCIES_TAB")));
        componentWithTitlebar.setComponent((JComponent)jScrollPane);
        JScrollPane jScrollPane2 = null;
        JLabel jLabel = new JLabel();
        if (this.measures != null) {
            jLabel.setText(HCSArb.getString("DROP_MEASURES_NOTIFICATION"));
            jScrollPane2 = new JScrollPane((Component)this.measuresTable);
            jScrollPane2.setVerticalScrollBarPolicy(22);
            jScrollPane2.setHorizontalScrollBarPolicy(32);
        } else {
            jLabel.setText(HCSArb.getString("DROP_AV_EDIT_CALCMEASURE_DEPENDENCIES_NOTIFICATION"));
        }
        int n = 0;
        JLabel jLabel2 = new JLabel(HCSArb.getString("DROP_DIALOG_OWNER_LABEL"));
        jLabel2.setName("lblOwner");
        this.add((Component)jLabel2, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 13, 1, new Insets(5, 5, 5, 0), 0, 0));
        JTextField jTextField = new JTextField();
        jTextField.setText(this.owner);
        jTextField.setEnabled(false);
        jTextField.setName("ownerName");
        jTextField.setMinimumSize(new Dimension(300, 20));
        this.add((Component)jTextField, new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 17, 1, new Insets(5, 5, 7, 5), 0, 0));
        this.add((Component)jLabel, new GridBagConstraints(0, ++n, 2, 1, 0.5, 0.0, 13, 1, new Insets(0, 5, 5, 5), 0, 0));
        if (jScrollPane2 != null) {
            ComponentWithTitlebar componentWithTitlebar2 = new ComponentWithTitlebar();
            componentWithTitlebar2.setLabel(new JLabel(HCSArb.get("MEASURES.TITLE")));
            componentWithTitlebar2.setComponent((JComponent)jScrollPane2);
            this.add((Component)componentWithTitlebar2, new GridBagConstraints(0, ++n, 2, 1, 0.0, 1.0, 13, 1, new Insets(0, 5, 5, 5), 0, 0));
        }
        this.add((Component)this.cascadeDelete, new GridBagConstraints(0, ++n, 2, 1, 0.0, 0.0, 13, 1, new Insets(0, 5, 5, 5), 0, 0));
        ++n;
        if (this.dependencies != null && !this.dependencies.isEmpty()) {
            this.add((Component)new JLabel(HCSArb.getString("DROP_CALCMEASURE_DEPENDENCIES_NOTIFICATION")), new GridBagConstraints(0, n, 2, 1, 0.0, 0.0, 13, 1, new Insets(5, 5, 5, 5), 0, 0));
        }
        int n2 = ++n;
        ++n;
        this.add((Component)componentWithTitlebar, new GridBagConstraints(0, n2, 2, 1, 1.0, 1.0, 13, 1, new Insets(0, 5, 5, 5), 0, 0));
    }

    private void setupTableColumns() {
        this.measuresTable.setAutoResizeMode(0);
        TableColumn tableColumn = this.measuresTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(200);
        tableColumn = this.measuresTable.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(150);
        tableColumn = this.measuresTable.getColumnModel().getColumn(2);
        tableColumn.setPreferredWidth(200);
        tableColumn = this.measuresTable.getColumnModel().getColumn(3);
        tableColumn.setPreferredWidth(200);
        if (this.droppingCalcMeasures) {
            tableColumn = this.measuresTable.getColumnModel().getColumn(4);
            tableColumn.setPreferredWidth(600);
        }
        this.dependenciesTable.setAutoResizeMode(0);
        this.dependenciesTable.setColumnSelectorAvailable(false);
        tableColumn = this.dependenciesTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(220);
        tableColumn = this.dependenciesTable.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(150);
        tableColumn = this.dependenciesTable.getColumnModel().getColumn(2);
        tableColumn.setPreferredWidth(450);
    }

    protected GenericTable getDependenciesTable() {
        return this.dependenciesTable;
    }

    protected List<AVBaseMeasure> getDependencies() {
        return this.dependencies;
    }

    @Override
    public boolean isCascadeActionToDependendentObjects() {
        return this.cascadeDelete.isSelected();
    }
}

