/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.av.panels;

import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.hcs.HCSArb;
import oracle.hcs.av.model.AVCalculatedMeasure;
import oracle.hcs.av.model.AnalyticView;
import oracle.hcs.av.panels.AVCalcMeasureObjectEditorPanel;
import oracle.hcs.db.panels.BaseChildTableEditorPanel;
import oracle.ide.Ide;
import oracle.ide.db.PropertyDisplayRegistry;
import oracle.ideimpl.db.panels.ChildObjectEditorPanel;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.table.GenericTable;

public class AVCalcMeasureTableEditorPanel<C extends AVCalculatedMeasure, P extends AnalyticView>
extends BaseChildTableEditorPanel<C, P> {
    private final int MEASURE_NAME_COLUMN = 0;
    private final int DEFAULT_MEASURE_COLUMN = 3;
    private static final String HELP_ID = "hcs_calc_object";
    private MyCellEditor myCellEditor;

    public AVCalcMeasureTableEditorPanel() {
        super("AVCalcMeasureTablePanel");
        this.init();
    }

    public AVCalcMeasureTableEditorPanel(String string) {
        super(string);
        this.init();
    }

    protected boolean useSplitter() {
        return true;
    }

    protected JComponent createSplitPane(Component component, Component component2) {
        JSplitPane jSplitPane = new JSplitPane(this.isHorizontalSplit() ? 1 : 0, component, component2);
        jSplitPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        jSplitPane.setDividerLocation(275);
        return jSplitPane;
    }

    @Override
    protected void init() {
        this.setNameColumnIndex(0);
        PropertyDisplayRegistry propertyDisplayRegistry = PropertyDisplayRegistry.getInstance();
        propertyDisplayRegistry.registerDisplayName("calculatedMeasures", HCSArb.getString("AV_CALCULATED_MEASURES"));
    }

    protected String getChildProperty() {
        return "calculatedMeasures";
    }

    protected Class getChildClass() {
        return AVCalculatedMeasure.class;
    }

    protected ChildObjectEditorPanel createChildPanel() {
        return new AVCalcMeasureObjectEditorPanel();
    }

    @Override
    protected void initialiseComponents() {
        super.initialiseComponents();
        this.myCellEditor = new MyCellEditor();
        GenericTable genericTable = this.getWrapperTable();
        TableColumnModel tableColumnModel = genericTable.getColumnModel();
        int n = this.getNameColumnIndex();
        TableColumn tableColumn = tableColumnModel.getColumn(n);
        tableColumn.setCellEditor(this.myCellEditor);
        int n2 = this.getDescriptionColumnIndex();
        TableColumn tableColumn2 = tableColumnModel.getColumn(n2);
        tableColumn2.setCellEditor(this.myCellEditor);
        int n3 = this.getCaptionColumnIndex();
        TableColumn tableColumn3 = tableColumnModel.getColumn(n3);
        tableColumn3.setCellEditor(this.myCellEditor);
    }

    @Override
    public C newChild() {
        AVCalculatedMeasure aVCalculatedMeasure = (AVCalculatedMeasure)super.newChild();
        aVCalculatedMeasure.generateDescriptions();
        aVCalculatedMeasure.setMeasureExpression("1");
        aVCalculatedMeasure.setMeasureFormat("$9,999.99");
        ((AnalyticView)this.getUpdatedObject()).addCalculatedMeasure(aVCalculatedMeasure);
        return (C)aVCalculatedMeasure;
    }

    class MyCellEditor
    extends BaseChildTableEditorPanel.MyBaseCellEditor {
        public MyCellEditor() {
            super(AVCalcMeasureTableEditorPanel.this);
        }

        @Override
        public boolean stopCellEditing() {
            int n = AVCalcMeasureTableEditorPanel.this.getNameColumnIndex();
            TableColumnModel tableColumnModel = this.jtable.getColumnModel();
            TableColumn tableColumn = tableColumnModel.getColumn(this.column);
            int n2 = tableColumn.getModelIndex();
            if (n2 == n) {
                String string;
                boolean bl = true;
                String string2 = null;
                AnalyticView analyticView = ((AVCalculatedMeasure)this.abstractChildObjectWithDesc).getAV();
                String string3 = this.abstractChildObjectWithDesc.getName();
                String string4 = this.cellTextField.getText();
                try {
                    AVCalcMeasureTableEditorPanel.this.prov.validateName("CALCULATED_MEASURE2", string4);
                }
                catch (InvalidNameException invalidNameException) {
                    string2 = invalidNameException.getMessage();
                    bl = false;
                }
                if (bl && analyticView.findMeasure(string = AVCalcMeasureTableEditorPanel.this.prov.getInternalName(string4)) != null && !string.equals(string3)) {
                    string2 = HCSArb.format("AV_MEASURE_ERROR_DUPLICATE_NAME", string);
                    bl = false;
                }
                if (!bl) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)string2, (String)HCSArb.get("AV_MEASURE_NAME_ERROR_TITLE"), null);
                    this.cellTextField.setText(string3);
                    return bl;
                }
                AVCalcMeasureTableEditorPanel.this.upcaseNameFlag = true;
            }
            return super.stopCellEditing();
        }
    }
}

