/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.av.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import oracle.dbtools.raptor.utils.Connections;
import oracle.hcs.av.AVInitializer;
import oracle.hcs.av.AVPanelLibrary;
import oracle.hcs.av.model.AVBaseMeasure;
import oracle.hcs.av.model.AVDimensionality;
import oracle.hcs.av.model.AVHierarchy;
import oracle.hcs.av.model.AVMeasure;
import oracle.hcs.av.model.AnalyticView;
import oracle.hcs.av.model.cache.AVCacheLevelGroup;
import oracle.hcs.av.model.cache.AVCacheLevelGroupDimHierLevel;
import oracle.hcs.av.model.cache.AVCacheMeasureGroup;
import oracle.hcs.av.model.cache.AVCacheMeasureProviderContext;
import oracle.hcs.av.panels.AVDimensionalityTablePanel;
import oracle.hcs.db.DBStringUtils;
import oracle.hcs.db.HCSMetadataCache;
import oracle.hcs.db.IdentifierElement;
import oracle.hcs.db.model.AbstractChildObjectWithDesc;
import oracle.hcs.db.panels.GeneralBaseSourceEditorPanel;
import oracle.hcs.db.source.Column;
import oracle.hcs.db.source.ColumnIdentifier;
import oracle.hcs.db.source.DatabaseSource;
import oracle.hcs.db.source.Table;
import oracle.hcs.dimension.model.AttributeDimension;
import oracle.hcs.hierarchy.model.Hierarchy;
import oracle.hcs.hierarchy.model.HierarchyLevel;
import oracle.hcs.metadata.HCSSchema;
import oracle.hcs.util.UIStringUtils;
import oracle.ide.db.components.ComponentFactory;
import oracle.ide.db.panels.PanelLibrary;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.javatools.db.AbstractChildDBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.ora.OracleDatabaseImpl;

public class AVGeneralPanel
extends GeneralBaseSourceEditorPanel<AnalyticView> {
    private static final Logger LOG = Logger.getLogger(AVGeneralPanel.class.getName());
    private List<AttributeDimension> allDimensions;
    private List<Hierarchy> allHierarchies;
    private boolean m_initialized;
    private AVDimensionalityTablePanel dimensionsPanel;
    public static final String ALL_DIMENSIONS = "dimensions";
    public static final String ALL_HIERARCHIES = "hierarchies";
    private HCSSchema schema;
    private String schemaName;
    private List<DatabaseSource> dbSources;

    public AVGeneralPanel() {
        this.layoutComponents();
        this.setDbObjectInitializer(new AVInitializer());
    }

    @Override
    protected void afterSourceChanged() {
        String string;
        String string2 = "";
        String string3 = "";
        List<DatabaseSource> list = null;
        if (this.getSource() != null) {
            string2 = this.getSource().getName();
        } else {
            string = this.getSourceTextFieldText();
            if (string != null && !string.isEmpty()) {
                if (list == null || list.size() == 0) {
                    list = this.createNonExistingSource(string);
                }
                string3 = list.get(0).getSchemaName();
                string2 = list.get(0).getName();
            }
        }
        string = ((AnalyticView)this.getUpdatedObject()).getavSourceTable();
        String string4 = ((AnalyticView)this.getUpdatedObject()).getavSourceTableOwner();
        if (string != null && !string2.equals(string) || string4 != null && !string3.equals(string4)) {
            ((AnalyticView)this.getUpdatedObject()).removeAllMeasures();
        }
        this.dimensionsPanel.setSource(this.getSource());
        this.dimensionsPanel.deriveDimensionality(this.sourceMessageLabel);
        this.dimensionsPanel.autoMap();
    }

    private String getSourceQualifiedName(String string, String string2, String string3) {
        if (!string.equals(string2)) {
            return String.format("%s.%s", DBStringUtils.externalizeName(string2), DBStringUtils.externalizeName(string3));
        }
        return string3;
    }

    @Override
    protected void sourcesCleared() {
        super.sourcesCleared();
        this.dimensionsPanel.clearMapping();
    }

    @Override
    protected DatabaseSource[] getDBObjectSources() {
        List<DatabaseSource> list;
        OracleDatabaseImpl oracleDatabaseImpl = (OracleDatabaseImpl)this.getProvider();
        String string = ((AnalyticView)this.getUpdatedObject()).getavSourceTable();
        String string2 = ((AnalyticView)this.getUpdatedObject()).getavSourceTableOwner();
        String string3 = oracleDatabaseImpl.getExternalName(string);
        String string4 = oracleDatabaseImpl.getExternalName(string2);
        Schema schema = new Schema(string4);
        if (string != null && !(list = this.getSourcesWithColumns(oracleDatabaseImpl, schema, string3)).isEmpty()) {
            DatabaseSource databaseSource = list.get(0);
            DatabaseSource[] databaseSourceArray = new DatabaseSource[]{databaseSource};
            return databaseSourceArray;
        }
        return null;
    }

    @Override
    protected void setUnknownTableSource() {
        OracleDatabaseImpl oracleDatabaseImpl = (OracleDatabaseImpl)this.getProvider();
        String string = ((AnalyticView)this.getUpdatedObject()).getavSourceTable();
        String string2 = ((AnalyticView)this.getUpdatedObject()).getavSourceTableOwner();
        String string3 = oracleDatabaseImpl.getExternalName(string);
        if (this.schemaName != null && !this.schemaName.equals(string2)) {
            string3 = String.format("%s.%s", oracleDatabaseImpl.getExternalName(string2), oracleDatabaseImpl.getExternalName(string));
        }
        this.setSourceTextField(string3);
    }

    @Override
    protected void initialisePanel() {
        super.initialisePanel();
        this.dimensionsPanel.setUpdatedObject((AnalyticView)this.getUpdatedObject());
        OracleDatabaseImpl oracleDatabaseImpl = (OracleDatabaseImpl)this.getProvider();
        if (!this.m_initialized) {
            this.m_initialized = true;
            AVCacheMeasureProviderContext aVCacheMeasureProviderContext = AVCacheMeasureProviderContext.getInstance();
            aVCacheMeasureProviderContext.setProvider(this.getProvider());
            AVPanelLibrary aVPanelLibrary = this.getAVPanelLibraryInstance();
            aVPanelLibrary.initReconcileDependencies();
            Connection connection = ((Database)this.getProvider()).getConnection();
            String string = Connections.getInstance().getConnectionName(connection);
            try {
                this.schemaName = ((AnalyticView)this.getUpdatedObject()).getSchema().getName();
                this.schema = HCSMetadataCache.getUpdatedSchema(string, this.schemaName);
            }
            catch (Exception exception) {
                LOG.log(Level.SEVERE, "Reading cache", exception);
            }
            this.allDimensions = this.schema.getDimensions();
            this.allHierarchies = this.schema.getHierarchies();
            this.getDataContext().put(ALL_DIMENSIONS, this.allDimensions);
            this.getDataContext().put(ALL_HIERARCHIES, this.allHierarchies);
            this.updateCacheLevelGroupNames(this.schema);
            this.dimensionsPanel.setProvider((DBObjectProvider)oracleDatabaseImpl);
            this.dimensionsPanel.setHierarchyDimensions(this.allDimensions);
            this.dimensionsPanel.setAllHierarchies(this.allHierarchies);
            this.dimensionsPanel.setSource(this.getSource());
            this.dimensionsPanel.setSchema(this.schema);
            this.dimensionsPanel.loadTableData();
        }
    }

    @Override
    protected void commitPanel() throws TraversalException {
        Object object;
        int n4;
        Object object2;
        Object object3;
        Object object42;
        int n2;
        Object object6;
        String string;
        Object object7;
        String string2;
        Column[] columnArray;
        AnalyticView analyticView = (AnalyticView)this.getOriginalObject();
        AnalyticView analyticView2 = (AnalyticView)this.getUpdatedObject();
        Database database = (Database)this.getProvider();
        super.commitPanel();
        this.dimensionsPanel.commitCellEdit();
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < this.dimensionsPanel.getDimensionsCount(); ++i) {
            boolean bl;
            columnArray = this.dimensionsPanel.getDimension(i);
            columnArray = UIStringUtils.stripDoubleQuotes((String)columnArray);
            string2 = this.dimensionsPanel.getDimensionAlias(i);
            string2 = UIStringUtils.stripDoubleQuotes(string2);
            boolean bl2 = this.dimensionsPanel.isDistinct(i);
            object7 = this.dimensionsPanel.getDimensionality(i);
            boolean bl3 = bl = object7.getParent() == null;
            if (bl) {
                hashMap.put(string2, true);
            }
            ((AVDimensionality)object7).setPhysicalOrder(i);
            string = this.dimensionsPanel.getDimensionKey(i);
            object6 = string.split("\\s*,\\s*");
            String[] stringArray = new String[((AbstractChildDBObject[])object6).length];
            n2 = 0;
            for (Object object42 : object6) {
                String string3;
                stringArray[n2] = string3 = database.getInternalName((String)object42);
                ++n2;
            }
            ((AVDimensionality)object7).setMapExpressions(stringArray);
            String object42 = this.dimensionsPanel.getDimensionAttribute(i);
            object3 = object42.split("\\s*,\\s*");
            object2 = new String[((String[])object3).length];
            n2 = 0;
            object42 = object3;
            n4 = ((Object)object42).length;
            for (int string9 = 0; string9 < n4; ++string9) {
                String string4;
                Object object5 = object42[string9];
                object2[n2] = string4 = database.getInternalName((String)object5);
                ++n2;
            }
            ((AVDimensionality)object7).setMappedDimensions((String[])object2);
            ((AVDimensionality)object7).setDimensionAlias(string2);
            ((AVDimensionality)object7).setDistinct(bl2);
            arrayList.add(object7);
        }
        AVDimensionality[] aVDimensionalityArray = arrayList.toArray(new AVDimensionality[arrayList.size()]);
        analyticView2.setDimensions(aVDimensionalityArray);
        columnArray = new Column[]{};
        string2 = analyticView2.getavSourceTable();
        String string5 = analyticView2.getavSourceTableOwner();
        object7 = this.getSource();
        if (object7 != null) {
            columnArray = object7.getColumns();
            String string6 = object7.getName();
            string = object7.getSchemaName();
            if (string2 != null && !string6.equals(string2) || string5 != null && !string.equals(string5)) {
                analyticView2.removeAllMeasures();
            }
            analyticView2.setavSourceTable(string6);
            analyticView2.setavSourceTableOwner(string);
        }
        List<ColumnIdentifier> list = this.dimensionsPanel.getSourceColumns();
        analyticView2.setSourceColumns(list);
        boolean bl = true;
        if (analyticView2.getMeasures().length == 0 && analyticView2.getDimensions().length > 0) {
            bl = false;
            object6 = columnArray;
            int n3 = ((AbstractChildDBObject[])object6).length;
            for (n2 = 0; n2 < n3; ++n2) {
                AbstractChildDBObject abstractChildDBObject = object6[n2];
                object3 = abstractChildDBObject.getName();
                if (this.columnMapsDimensionality((String)object3, analyticView2.getDimensions()) || !abstractChildDBObject.isNumeric()) continue;
                object2 = analyticView2.findMeasure((String)object3);
                if (object2 != null) {
                    if (!((AVBaseMeasure)object2).isDefaultMeasure()) continue;
                    bl = true;
                    continue;
                }
                object42 = analyticView2.getMeasures();
                n4 = 0;
                for (Object object8 : object42) {
                    object = ((AVMeasure)object8).getMapExpression();
                    if (object == null || !((String)object).equals(object3)) continue;
                    n4 = 1;
                    if (!((AVBaseMeasure)object8).isDefaultMeasure()) continue;
                    bl = true;
                }
                if (n4 != 0) continue;
                object2 = new AVMeasure();
                object2.setName((String)object3);
                ((AbstractChildObjectWithDesc)object2).setCaption((String)object3);
                ((AbstractChildObjectWithDesc)object2).setDescription((String)object3);
                ((AVMeasure)object2).setMapExpression((String)object3);
                ((AVBaseMeasure)object2).setMeasureFormat(null);
                analyticView2.addMeasure((AVMeasure)object2);
            }
        }
        if (!bl && (object6 = analyticView2.getMeasures()) != null && ((AbstractChildDBObject[])object6).length > 0) {
            object6[0].setDefaultMeasure(true);
            analyticView2.setDefaultMeasure(object6[0].getName());
        }
        for (AbstractChildDBObject abstractChildDBObject : analyticView2.getDimensions()) {
            object3 = UIStringUtils.stripDoubleQuotes(abstractChildDBObject.getName());
            boolean bl4 = false;
            if (abstractChildDBObject.getDimension() == null) {
                for (AttributeDimension attributeDimension : this.allDimensions) {
                    String string6 = attributeDimension.getName();
                    if (!object3.equals(string6)) continue;
                    abstractChildDBObject.setDimension(attributeDimension);
                    bl4 = true;
                }
            }
            if (!bl4 && abstractChildDBObject.getDimension() == null) {
                object42 = new AttributeDimension();
                object42.setName((String)object3);
                object42.setSchema((Schema)this.schema);
                abstractChildDBObject.setDimension((AttributeDimension)object42);
            }
            for (AVHierarchy aVHierarchy : abstractChildDBObject.getHierarchies()) {
                AttributeDimension attributeDimension;
                String string7 = abstractChildDBObject.getName();
                String string8 = aVHierarchy.getName();
                if (aVHierarchy.getHierarchy() != null) continue;
                object = this.findHierarchy(string8);
                if (object == null) {
                    Hierarchy hierarchy = new Hierarchy(this.schema, string8, string7);
                    attributeDimension = abstractChildDBObject.getDimension();
                    hierarchy.setDimension(attributeDimension);
                    aVHierarchy.setHierarchy(hierarchy);
                    continue;
                }
                AttributeDimension attributeDimension2 = ((Hierarchy)object).getDimension();
                attributeDimension = abstractChildDBObject.getDimension();
                if (attributeDimension2 == null && attributeDimension != null) {
                    ((Hierarchy)object).setDimension(attributeDimension);
                }
                aVHierarchy.setHierarchy((Hierarchy)object);
            }
            for (Hierarchy hierarchy : this.allHierarchies) {
                String string9 = hierarchy.getName();
                String string10 = hierarchy.getDimensionName();
                if (!string10.equals(object3) || string9.endsWith("_")) continue;
                AVHierarchy aVHierarchy = abstractChildDBObject.findHierarchy(string9);
                if (hashMap.get(abstractChildDBObject.getDimensionAlias()) != null && ((Boolean)hashMap.get(abstractChildDBObject.getDimensionAlias())).booleanValue()) {
                    if (aVHierarchy != null) continue;
                    aVHierarchy = new AVHierarchy(hierarchy);
                    abstractChildDBObject.addHierarchy(aVHierarchy);
                    continue;
                }
                if (aVHierarchy == null || aVHierarchy.getHierarchy() != null) continue;
                aVHierarchy.setHierarchy(hierarchy);
            }
            if (hashMap.get(abstractChildDBObject.getDimensionAlias()) == null || !((Boolean)hashMap.get(abstractChildDBObject.getDimensionAlias())).equals(Boolean.TRUE)) continue;
            object42 = null;
            int n = 0;
            for (AVHierarchy aVHierarchy : abstractChildDBObject.getHierarchies()) {
                aVHierarchy.setHierarchyIncluded(Boolean.TRUE);
                aVHierarchy.setHierarchyDefault(Boolean.FALSE);
                for (Hierarchy hierarchy : this.allHierarchies) {
                    int n3;
                    if (!aVHierarchy.getName().equals(hierarchy.getName()) || (n3 = hierarchy.getHierarchyLevels().length) <= n) continue;
                    n = n3;
                    object42 = aVHierarchy;
                }
            }
            if (object42 == null) continue;
            ((AVHierarchy)object42).setHierarchyDefault(Boolean.TRUE);
        }
        if (this.isEditing()) {
            object6 = this.getAVPanelLibraryInstance();
            ((AVPanelLibrary)object6).reconcileDependencies(database, (SystemObject)analyticView, (SystemObject)analyticView2);
        }
    }

    private List<DatabaseSource> createNonExistingSource(String string) {
        String[] stringArray = string.split(",");
        this.dbSources = new ArrayList<DatabaseSource>();
        for (String string2 : stringArray) {
            Table table = new Table(((AnalyticView)this.getUpdatedObject()).getSchema().getName(), string2, null);
            ArrayList<Column> arrayList = new ArrayList<Column>();
            Column column = new Column("COLUMN1", "N", "NUMBER");
            Column column2 = new Column("COLUMN2", "N", "NUMBER");
            arrayList.add(column);
            arrayList.add(column2);
            table.setColumns(arrayList.toArray(new Column[arrayList.size()]));
            this.dbSources.add(table);
        }
        this.setSources(this.dbSources);
        return this.dbSources;
    }

    private boolean columnMapsDimensionality(String string, AVDimensionality[] aVDimensionalityArray) {
        for (AVDimensionality aVDimensionality : aVDimensionalityArray) {
            if (aVDimensionality.getMapExpressions().length != 1 || !aVDimensionality.getMapExpressions()[0].equals(string)) continue;
            return true;
        }
        return false;
    }

    private Hierarchy findHierarchy(String string) {
        for (Hierarchy hierarchy : this.allHierarchies) {
            String string2 = hierarchy.getName();
            if (!string2.equals(string)) continue;
            return hierarchy;
        }
        return null;
    }

    private AVPanelLibrary getAVPanelLibraryInstance() {
        Namespace namespace = this.getDataContext();
        PanelLibrary panelLibrary = (PanelLibrary)namespace.find(PanelLibrary.class);
        return (AVPanelLibrary)panelLibrary;
    }

    @Override
    protected void layoutComponents() {
        super.layoutComponents();
        ComponentFactory componentFactory = this.getComponentFactory();
        componentFactory.registerComponent((Component)this.getSourceTextField(), "avSourceTable");
        this.registerDescriptionFields();
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setName("AVGeneralPanel.PNL_CONTEXT");
        int n = this.layoutDescriptionFields(jPanel);
        n = this.layoutSource(jPanel, n);
        JPanel jPanel2 = new JPanel();
        jPanel2.setName("AVGeneralPanel.PNL_DETAILS");
        jPanel2.setLayout(new GridBagLayout());
        this.dimensionsPanel = new AVDimensionalityTablePanel();
        jPanel2.add((Component)this.dimensionsPanel, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 13, 1, new Insets(5, 5, 0, 5), 0, 0));
        componentFactory.registerComponent((Component)this.dimensionsPanel, ALL_DIMENSIONS);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setName("pnlCenter");
        jPanel3.add((Component)jPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
        jPanel3.add((Component)jPanel2, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(10, 0, 0, 0), 0, 0));
        this.setLayout(new BorderLayout());
        this.add(jPanel3, "Center");
    }

    private String generateHierarchyAlias(String string, String string2, int n) {
        String string3 = string2;
        if (string2.startsWith(string + "_") && string2.endsWith("_HIER")) {
            string3 = string2.substring(0, string2.length() - 5);
            if (string3.length() > string.length() + 1) {
                string3 = string3.substring(string.length() + 1, string3.length());
            }
        } else {
            string3 = string2 + Integer.toString(n);
        }
        return string3;
    }

    private void updateCacheLevelGroupNames(HCSSchema hCSSchema) {
        AVCacheMeasureGroup[] aVCacheMeasureGroupArray;
        AnalyticView analyticView = (AnalyticView)this.getUpdatedObject();
        for (AVCacheMeasureGroup aVCacheMeasureGroup : aVCacheMeasureGroupArray = analyticView.getCacheMeasureGroups()) {
            AVCacheLevelGroup[] aVCacheLevelGroupArray;
            for (AVCacheLevelGroup aVCacheLevelGroup : aVCacheLevelGroupArray = aVCacheMeasureGroup.getCacheLevelGroups()) {
                AVCacheLevelGroupDimHierLevel[] aVCacheLevelGroupDimHierLevelArray;
                for (AVCacheLevelGroupDimHierLevel aVCacheLevelGroupDimHierLevel : aVCacheLevelGroupDimHierLevelArray = aVCacheLevelGroup.getCacheLevelGroupHierLevels()) {
                    String string;
                    Object object;
                    String string2;
                    if (aVCacheLevelGroupDimHierLevel.getCacheLevelGroupDimHierLevelState() == 3) {
                        string2 = aVCacheLevelGroupDimHierLevel.getName();
                        object = this.findDimensionAndHierarchyAliasFromLevelName(hCSSchema, analyticView, string2);
                        string = (String)object[0] + "." + (String)object[1] + "." + string2;
                        aVCacheLevelGroupDimHierLevel.setName(string);
                        continue;
                    }
                    if (aVCacheLevelGroupDimHierLevel.getCacheLevelGroupDimHierLevelState() != 2) continue;
                    string2 = aVCacheLevelGroupDimHierLevel.getName();
                    object = new IdentifierElement(string2);
                    string = ((IdentifierElement)object).getFirst();
                    String string3 = ((IdentifierElement)object).getSecond();
                    String string4 = this.findDimensionAliasFromHierarchyAliasAndLevelName(hCSSchema, analyticView, string, string3);
                    String string5 = string4 + "." + string + "." + string3;
                    aVCacheLevelGroupDimHierLevel.setName(string5);
                }
            }
        }
    }

    private String[] findDimensionAndHierarchyAliasFromLevelName(HCSSchema hCSSchema, AnalyticView analyticView, String string) {
        AVDimensionality[] aVDimensionalityArray;
        String[] stringArray = new String[2];
        for (AVDimensionality aVDimensionality : aVDimensionalityArray = analyticView.getDimensions()) {
            AVHierarchy[] aVHierarchyArray;
            String string2 = aVDimensionality.getDimensionAlias();
            for (AVHierarchy aVHierarchy : aVHierarchyArray = aVDimensionality.getHierarchies()) {
                String string3 = aVHierarchy.getHierarchyAlias();
                String string4 = aVHierarchy.getHierarchyName();
                Hierarchy hierarchy = hCSSchema.findHierarchy(string4);
                if (hierarchy == null) continue;
                for (HierarchyLevel hierarchyLevel : hierarchy.getHierarchyLevels()) {
                    if (!hierarchyLevel.getLevelName().equals(string)) continue;
                    stringArray[0] = string2;
                    stringArray[1] = string3;
                    return stringArray;
                }
            }
        }
        return stringArray;
    }

    private String findDimensionAliasFromHierarchyAliasAndLevelName(HCSSchema hCSSchema, AnalyticView analyticView, String string, String string2) {
        AVDimensionality[] aVDimensionalityArray;
        String string3 = null;
        for (AVDimensionality aVDimensionality : aVDimensionalityArray = analyticView.getDimensions()) {
            AVHierarchy[] aVHierarchyArray;
            String string4 = aVDimensionality.getDimensionAlias();
            for (AVHierarchy aVHierarchy : aVHierarchyArray = aVDimensionality.getHierarchies()) {
                Hierarchy hierarchy;
                String string5 = aVHierarchy.getHierarchyAlias();
                String string6 = aVHierarchy.getHierarchyName();
                if (!string5.equals(string) || (hierarchy = hCSSchema.findHierarchy(string6)) == null) continue;
                for (HierarchyLevel hierarchyLevel : hierarchy.getHierarchyLevels()) {
                    if (!hierarchyLevel.getLevelName().equals(string2)) continue;
                    return string4;
                }
            }
        }
        return string3;
    }
}

