/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.db.panels;

import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.hcs.HCSArb;
import oracle.hcs.db.BaseAVVerifier;
import oracle.hcs.db.model.AbstractChildObjectWithDesc;
import oracle.hcs.db.model.AbstractMappableSchemaObjectWithDesc;
import oracle.hcs.db.panels.ChildNameObjectEditorContext;
import oracle.hcs.util.UIStringUtils;
import oracle.ideimpl.db.panels.ChildTableEditorPanel;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.ui.table.GenericTable;

public abstract class BaseChildTableEditorPanel<C extends AbstractChildObjectWithDesc, P extends AbstractMappableSchemaObjectWithDesc>
extends ChildTableEditorPanel<C, P> {
    protected final int NAME_COLUMN = 0;
    protected final int CAPTION_COLUMN = 1;
    protected final int DESCRIPTION_COLUMN = 2;
    protected final int LAST_COLUMN = 2;
    private int nameColumnIndex = 0;
    private int captionColumnIndex = 1;
    private int descriptionColumnIndex = 2;
    protected DBObjectProvider prov;
    protected BaseAVVerifier verifier;
    protected boolean upcaseNameFlag;
    private int nameFieldKeyTyped = 0;
    private boolean isPanelInitialized = false;

    public BaseChildTableEditorPanel(String string) {
        super(string);
        this.init();
    }

    protected abstract void init();

    protected void initImpl(DBObjectProvider dBObjectProvider) {
        this.prov = dBObjectProvider;
    }

    protected void initialisePanel() {
        this.initImpl(this.getProvider());
        super.initialisePanel();
        if (!this.isPanelInitialized) {
            this.scrollToFirstRow();
        }
        this.isPanelInitialized = true;
    }

    protected String[] getPropertiesForRow() {
        ArrayList arrayList = new ArrayList();
        return arrayList.toArray(new String[0]);
    }

    public C newChild() {
        AbstractChildObjectWithDesc abstractChildObjectWithDesc = (AbstractChildObjectWithDesc)super.newChild();
        GenericTable genericTable = this.getWrapperTable();
        return (C)abstractChildObjectWithDesc;
    }

    protected void initialiseComponents() {
        super.initialiseComponents();
    }

    protected void initialiseTableComponents() {
        ChildTableEditorPanel.NonPropertyColumnLogic nonPropertyColumnLogic = new ChildTableEditorPanel.NonPropertyColumnLogic<C>(){

            public void setValueAt(Object object, int n, int n2) {
                BaseChildTableEditorPanel.this.setRowPropertyValue(object, n, n2);
            }

            public Object getCellValue(C c) {
                return c.getName();
            }

            public boolean isCellEditable(C c) {
                return true;
            }
        };
        ChildTableEditorPanel.NonPropertyColumnLogic nonPropertyColumnLogic2 = new ChildTableEditorPanel.NonPropertyColumnLogic<C>(){

            public void setValueAt(Object object, int n, int n2) {
                BaseChildTableEditorPanel.this.setRowPropertyValue(object, n, n2);
            }

            public Object getCellValue(C c) {
                return ((AbstractChildObjectWithDesc)c).getDescription();
            }

            public boolean isCellEditable(C c) {
                return true;
            }
        };
        ChildTableEditorPanel.NonPropertyColumnLogic nonPropertyColumnLogic3 = new ChildTableEditorPanel.NonPropertyColumnLogic<C>(){

            public void setValueAt(Object object, int n, int n2) {
                BaseChildTableEditorPanel.this.setRowPropertyValue(object, n, n2);
            }

            public Object getCellValue(C c) {
                return ((AbstractChildObjectWithDesc)c).getCaption();
            }

            public boolean isCellEditable(C c) {
                return true;
            }
        };
        this.addColumn(0, HCSArb.get("NAMESPACE_CONFLICT_PANEL_NAME_LABEL"), String.class, nonPropertyColumnLogic);
        this.addColumn(1, HCSArb.get("DESCRIPTION_PANEL_SHORT_LABEL"), String.class, nonPropertyColumnLogic3);
        this.addColumn(2, HCSArb.get("DESCRIPTION_PANEL_DESCRIPTION"), String.class, nonPropertyColumnLogic2);
    }

    protected void setRowPropertyValue(Object object, int n, int n2) {
        ChildTableEditorPanel.RowInfo rowInfo = this.getWrapperTableModel().getRow(n);
        AbstractChildObjectWithDesc abstractChildObjectWithDesc = (AbstractChildObjectWithDesc)rowInfo.getRowObject();
        switch (n2) {
            case 0: {
                String string = (String)object;
                abstractChildObjectWithDesc.setName(string);
                if (!this.upcaseNameFlag) break;
                this.updateNameToUppercase(string.toUpperCase(), n, 0);
                this.upcaseNameFlag = false;
                break;
            }
            case 1: {
                String string = (String)object;
                abstractChildObjectWithDesc.setCaption(string);
                break;
            }
            case 2: {
                String string = (String)object;
                abstractChildObjectWithDesc.setDescription(string);
            }
        }
    }

    protected void setNameColumnIndex(int n) {
        this.nameColumnIndex = n;
        this.captionColumnIndex = n + 1;
        this.descriptionColumnIndex = n + 2;
    }

    protected int getNameColumnIndex() {
        return this.nameColumnIndex;
    }

    protected int getCaptionColumnIndex() {
        return this.captionColumnIndex;
    }

    protected int getDescriptionColumnIndex() {
        return this.descriptionColumnIndex;
    }

    protected void updateNameToUppercase(String string, int n, int n2) {
        final String string2 = string;
        final int n3 = n;
        final int n4 = n2;
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(100L);
                    String string = (String)BaseChildTableEditorPanel.this.getWrapperTableModel().getValueAt(n3, n4);
                    String string22 = (String)string2;
                    if (string22 != null && string22.equalsIgnoreCase(string) && !string22.equals(string)) {
                        BaseChildTableEditorPanel.this.getWrapperTableModel().setValueAt(string2, n3, n4);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        SwingUtilities.invokeLater(thread);
    }

    protected boolean isHorizontalSplit() {
        return false;
    }

    protected boolean preserveListOrder() {
        return true;
    }

    protected void scrollToFirstRow() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                GenericTable genericTable = BaseChildTableEditorPanel.this.getWrapperTable();
                if (genericTable.getParent() instanceof JViewport) {
                    genericTable.changeSelection(0, 0, false, false);
                    genericTable.scrollToSelection();
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public class MyBaseCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        protected JTextField cellTextField = new JTextField();
        protected AbstractChildObjectWithDesc abstractChildObjectWithDesc;
        protected int row;
        protected int column;
        protected JTable jtable;
        protected KeyAdapter ka = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                BaseChildTableEditorPanel.this.nameFieldKeyTyped = keyEvent.getKeyCode();
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                if (MyBaseCellEditor.this.abstractChildObjectWithDesc == null) {
                    keyEvent.consume();
                    return;
                }
                if (keyEvent.getKeyChar() == '\u001b') {
                    return;
                }
            }
        };

        public MyBaseCellEditor() {
            this.cellTextField.addKeyListener(this.ka);
            this.cellTextField.getDocument().addDocumentListener(new DocumentListener(){

                public void common() {
                    boolean bl;
                    if (MyBaseCellEditor.this.column == BaseChildTableEditorPanel.this.getCaptionColumnIndex() && (!BaseChildTableEditorPanel.this.isEditing() || MyBaseCellEditor.this.abstractChildObjectWithDesc.isNewObject())) {
                        bl = false;
                        if (MyBaseCellEditor.this.abstractChildObjectWithDesc.getDescriptionDirty().booleanValue()) {
                            bl = true;
                        }
                        if (!bl) {
                            String string = MyBaseCellEditor.this.cellTextField.getText();
                            BaseChildTableEditorPanel.this.getWrapperTableModel().setValueAt((Object)string, MyBaseCellEditor.this.row, BaseChildTableEditorPanel.this.getDescriptionColumnIndex());
                        }
                    }
                    if (MyBaseCellEditor.this.abstractChildObjectWithDesc == null || MyBaseCellEditor.this.column != BaseChildTableEditorPanel.this.getNameColumnIndex()) {
                        return;
                    }
                    if (!BaseChildTableEditorPanel.this.isEditing() || MyBaseCellEditor.this.abstractChildObjectWithDesc.isNewObject()) {
                        String string;
                        String string2 = MyBaseCellEditor.this.cellTextField.getText();
                        boolean bl2 = false;
                        boolean bl3 = false;
                        boolean bl4 = false;
                        boolean bl5 = false;
                        if (string2 == null) {
                            return;
                        }
                        if (string2.length() == 0 && BaseChildTableEditorPanel.this.nameFieldKeyTyped != 8) {
                            return;
                        }
                        ChildNameObjectEditorContext childNameObjectEditorContext = ChildNameObjectEditorContext.getInstance();
                        int n = childNameObjectEditorContext.getEditingState();
                        if (n == 1) {
                            return;
                        }
                        String string3 = (String)BaseChildTableEditorPanel.this.getWrapperTableModel().getValueAt(MyBaseCellEditor.this.row, BaseChildTableEditorPanel.this.getDescriptionColumnIndex());
                        if (string3 == null) {
                            string3 = "";
                        }
                        if ((string = (String)BaseChildTableEditorPanel.this.getWrapperTableModel().getValueAt(MyBaseCellEditor.this.row, BaseChildTableEditorPanel.this.getCaptionColumnIndex())) == null) {
                            string = "";
                        }
                        if (BaseChildTableEditorPanel.this.nameFieldKeyTyped == 8) {
                            if (string3.length() > 0) {
                                string3 = string3.substring(0, string3.length() - 1);
                                bl3 = true;
                            }
                            if (string.length() > 0) {
                                string = string.substring(0, string.length() - 1);
                                bl2 = true;
                            }
                        } else {
                            if (string2.length() == string3.length() + 1) {
                                string3 = string3 + string2.substring(string2.length() - 1, string2.length());
                                bl5 = true;
                            }
                            if (string2.length() == string.length() + 1) {
                                string = string + string2.substring(string2.length() - 1, string2.length());
                                bl4 = true;
                            }
                        }
                        boolean bl6 = string3 != null && UIStringUtils.isObjectNameAndDescriptionEqual(string2, string3);
                        boolean bl7 = string != null && UIStringUtils.isObjectNameAndDescriptionEqual(string2, string);
                        boolean bl8 = false;
                        bl = false;
                        if (MyBaseCellEditor.this.abstractChildObjectWithDesc.getDescriptionDirty().booleanValue()) {
                            bl8 = true;
                        }
                        if (MyBaseCellEditor.this.abstractChildObjectWithDesc.getCaptionDirty().booleanValue()) {
                            bl = true;
                        }
                        if (BaseChildTableEditorPanel.this.getWrapperTableModel().getColumnCount() > 1) {
                            if (!bl7) {
                                if (!bl || string.length() == 0 && string2.length() < 2 && n == 0) {
                                    BaseChildTableEditorPanel.this.getWrapperTableModel().setValueAt((Object)UIStringUtils.convertDescription(string2), MyBaseCellEditor.this.row, BaseChildTableEditorPanel.this.getCaptionColumnIndex());
                                    MyBaseCellEditor.this.abstractChildObjectWithDesc.markCaptionDirty(false);
                                }
                            } else if (bl2 || bl4) {
                                string = UIStringUtils.convertDescription(string);
                                BaseChildTableEditorPanel.this.getWrapperTableModel().setValueAt((Object)string, MyBaseCellEditor.this.row, BaseChildTableEditorPanel.this.getCaptionColumnIndex());
                            }
                            if (!bl6) {
                                if ((!bl8 || string3.length() == 0 && string2.length() < 2 && n == 0) && !bl) {
                                    BaseChildTableEditorPanel.this.getWrapperTableModel().setValueAt((Object)UIStringUtils.convertDescription(string2), MyBaseCellEditor.this.row, BaseChildTableEditorPanel.this.getDescriptionColumnIndex());
                                    MyBaseCellEditor.this.abstractChildObjectWithDesc.markDescriptionDirty(false);
                                }
                            } else if (bl3 || bl5) {
                                string3 = UIStringUtils.convertDescription(string3);
                                BaseChildTableEditorPanel.this.getWrapperTableModel().setValueAt((Object)string3, MyBaseCellEditor.this.row, BaseChildTableEditorPanel.this.getDescriptionColumnIndex());
                            }
                        }
                    }
                    BaseChildTableEditorPanel.this.nameFieldKeyTyped = 0;
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    this.common();
                }

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    this.common();
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    this.common();
                }
            });
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.jtable = jTable;
            this.row = n;
            this.column = n2;
            ChildTableEditorPanel.RowInfo rowInfo = BaseChildTableEditorPanel.this.getWrapperTableModel().getRow(n);
            this.abstractChildObjectWithDesc = (AbstractChildObjectWithDesc)rowInfo.getRowObject();
            this.cellTextField.setText((String)object);
            return this.cellTextField;
        }

        @Override
        public Object getCellEditorValue() {
            String string = this.cellTextField.getText();
            return string;
        }

        @Override
        public boolean stopCellEditing() {
            String string;
            boolean bl;
            TableColumnModel tableColumnModel = this.jtable.getColumnModel();
            TableColumn tableColumn = tableColumnModel.getColumn(this.column);
            int n = tableColumn.getModelIndex();
            if (n == BaseChildTableEditorPanel.this.getCaptionColumnIndex()) {
                if (this.abstractChildObjectWithDesc.isNewObject()) {
                    this.abstractChildObjectWithDesc.markCaptionDirty(true);
                }
            } else if (n == BaseChildTableEditorPanel.this.getDescriptionColumnIndex() && this.abstractChildObjectWithDesc.isNewObject()) {
                this.abstractChildObjectWithDesc.markDescriptionDirty(true);
            }
            if (n == BaseChildTableEditorPanel.this.getNameColumnIndex() && (bl = UIStringUtils.isQuotedName(string = UIStringUtils.normalizeName(this.cellTextField.getText(), BaseChildTableEditorPanel.this.prov)))) {
                String string2 = this.abstractChildObjectWithDesc.getCaption();
                String string3 = this.abstractChildObjectWithDesc.getDescription();
                if (this.abstractChildObjectWithDesc.isNewObject() && !this.abstractChildObjectWithDesc.getCaptionDirty().booleanValue() && UIStringUtils.isQuotedName(string2)) {
                    string2 = UIStringUtils.stripDoubleQuotes(string2);
                    BaseChildTableEditorPanel.this.getWrapperTableModel().setValueAt((Object)string2, this.row, BaseChildTableEditorPanel.this.getCaptionColumnIndex());
                    this.abstractChildObjectWithDesc.markCaptionDirty(true);
                }
                if (this.abstractChildObjectWithDesc.isNewObject() && !this.abstractChildObjectWithDesc.getDescriptionDirty().booleanValue() && UIStringUtils.isQuotedName(string3)) {
                    string3 = UIStringUtils.stripDoubleQuotes(string3);
                    BaseChildTableEditorPanel.this.getWrapperTableModel().setValueAt((Object)string3, this.row, BaseChildTableEditorPanel.this.getDescriptionColumnIndex());
                    this.abstractChildObjectWithDesc.markDescriptionDirty(true);
                }
            }
            return super.stopCellEditing();
        }
    }
}

