/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.db.panels;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import oracle.hcs.HCSArb;
import oracle.hcs.db.IdentifierElement;
import oracle.hcs.db.model.AbstractSchemaObjectWithDesc;
import oracle.hcs.db.panels.GeneralBaseEditorPanel;
import oracle.hcs.db.source.Column;
import oracle.hcs.db.source.ColumnIdentifier;
import oracle.hcs.db.source.ColumnListRunnable;
import oracle.hcs.db.source.ColumnListWorker;
import oracle.hcs.db.source.DatabaseSource;
import oracle.hcs.db.source.SourceMetadata;
import oracle.hcs.util.SourceSelectionDialog;
import oracle.hcs.util.SourceTextField;
import oracle.hcs.util.SourceValidator;
import oracle.ide.Ide;
import oracle.ide.db.components.ComponentFactory;
import oracle.ide.dialogs.ProgressBar;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.Schema;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.javatools.dialogs.MessageDialog;

public abstract class GeneralBaseSourceEditorPanel<T extends AbstractSchemaObjectWithDesc>
extends GeneralBaseEditorPanel<T>
implements SourceValidator {
    private SourceMetadata sourceMetaData;
    private JLabel schemaLabel;
    private JLabel sourceLabel;
    private SourceTextField sourceTextField;
    protected JLabel sourceMessageLabel;
    private JButton sourceButton;
    private List<DatabaseSource> sources;
    private boolean multipleSelection;
    private final String SOURCE_QUERY_XML_FILE = "sourcequeries.xml";
    private static final String CLOB_TYPE = "CLOB";
    private static final String BLOB_TYPE = "BLOB";
    private static final String NCLOB_TYPE = "NCLOB";
    private static final String BFILE_TYPE = "BFILE";
    private static final String LONG_TYPE = "LONG";
    private static final String LONG_RAW_TYPE = "LONG RAW";

    public List<DatabaseSource> getSources() {
        return this.sources;
    }

    public DatabaseSource getSource() {
        if (this.sources != null && this.sources.size() > 0) {
            return this.sources.get(0);
        }
        return null;
    }

    protected DatabaseSource[] getDBObjectSources() {
        return null;
    }

    protected void setSourceTextField(String string) {
        this.sourceTextField.setText(string);
    }

    @Override
    protected void initialisePanel() {
        Object object;
        super.initialisePanel();
        OracleDatabaseImpl oracleDatabaseImpl = (OracleDatabaseImpl)this.getProvider();
        this.sourceMetaData = new SourceMetadata("sourcequeries.xml", oracleDatabaseImpl.getConnection());
        if (this.sources == null && (object = this.getDBObjectSources()) != null) {
            this.sources = Arrays.asList(object);
        }
        if (this.sources != null && !this.sources.isEmpty()) {
            String string;
            object = new StringBuffer();
            for (DatabaseSource databaseSource : this.sources) {
                if (((StringBuffer)object).length() > 0) {
                    ((StringBuffer)object).append(",");
                }
                string = "";
                if (!databaseSource.getSchemaName().equals(((AbstractSchemaObjectWithDesc)this.getUpdatedObject()).getSchema().getName())) {
                    string = string + databaseSource.getSchemaName() + ".";
                }
                string = string + databaseSource.getName();
                string = this.getExternalSourceName(string);
                ((StringBuffer)object).append(string);
            }
            this.sourceTextField.setText(((StringBuffer)object).toString());
            List<DatabaseSource> list = this.getSourcesWithColumns(oracleDatabaseImpl, ((StringBuffer)object).toString());
            for (int i = 0; i < this.sources.size(); ++i) {
                string = this.sources.get(i).getName();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    DatabaseSource databaseSource = (DatabaseSource)iterator.next();
                    if (!databaseSource.getName().equals(string)) continue;
                    this.sources.get(i).setColumns(databaseSource.getColumns());
                }
            }
        } else {
            this.setUnknownTableSource();
        }
    }

    protected void setUnknownTableSource() {
        this.sourceTextField.validateText();
    }

    private void setSourceText(DatabaseSource ... databaseSourceArray) {
        if (databaseSourceArray != null) {
            this.setSourceText(Arrays.asList(databaseSourceArray));
        }
    }

    private void setSourceText(List<DatabaseSource> list) {
        StringBuffer stringBuffer = new StringBuffer();
        if (list != null) {
            for (DatabaseSource databaseSource : list) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(databaseSource.getName());
            }
        }
        this.sourceTextField.setText(stringBuffer.toString());
    }

    protected String getSourceTextFieldText() {
        return this.sourceTextField.getText().trim();
    }

    public List<ColumnIdentifier> getSourceColumns(List<DatabaseSource> list) {
        this.sourceMessageLabel.setVisible(false);
        String string = ((AbstractSchemaObjectWithDesc)this.getUpdatedObject()).getSchema().getName();
        ArrayList<ColumnIdentifier> arrayList = new ArrayList<ColumnIdentifier>();
        if (list != null) {
            for (DatabaseSource databaseSource : list) {
                for (Column column : databaseSource.getColumns()) {
                    if (!this.isColumnValidDataType(column.getDataType().trim())) continue;
                    String string2 = this.getProvider().getExternalName(databaseSource.getSchemaName());
                    String string3 = this.getProvider().getExternalName(databaseSource.getName());
                    String string4 = this.getProvider().getExternalName(databaseSource.getAlias());
                    String string5 = this.getProvider().getExternalName(column.getName());
                    if (string2.equals(string)) {
                        string2 = null;
                    }
                    if (list.size() == 1) {
                        string3 = null;
                    }
                    if (string3 != null && string4 != null) {
                        string3 = null;
                    }
                    if (list.size() > 1 && string4 == null) {
                        string3 = null;
                    }
                    arrayList.add(new ColumnIdentifier(string2, string3, string4, string5, column));
                }
            }
        }
        return arrayList;
    }

    @Override
    protected void commitPanel() throws TraversalException {
        super.commitPanel();
        this.sourceMessageLabel.setVisible(false);
        this.sourceTextField.hidePopup();
        String string = this.sourceTextField.getText().trim();
        if (string.length() > 0) {
            OracleDatabaseImpl oracleDatabaseImpl = (OracleDatabaseImpl)this.getProvider();
            List<DatabaseSource> list = this.getSourcesWithColumns(oracleDatabaseImpl, string);
            if (this.sources == null || this.sources.size() == 0 || this.sources.get(0).getColumns().length == 0) {
                this.sources = list;
            } else if (this.sources.size() == list.size()) {
                if (!this.sources.containsAll(list)) {
                    this.sources = list;
                }
            } else {
                this.sources = list;
            }
        } else {
            this.sources = new ArrayList<DatabaseSource>();
        }
    }

    protected boolean isColumnValidDataType(String string) {
        return !string.equalsIgnoreCase(CLOB_TYPE) && !string.equalsIgnoreCase(BLOB_TYPE) && !string.equalsIgnoreCase(NCLOB_TYPE) && !string.equalsIgnoreCase(BFILE_TYPE) && !string.equalsIgnoreCase(LONG_TYPE) && !string.equalsIgnoreCase(LONG_RAW_TYPE);
    }

    protected void sourceChanged() {
        String string = this.sourceTextField.getText().trim();
        if (string.length() > 0) {
            OracleDatabaseImpl oracleDatabaseImpl = (OracleDatabaseImpl)this.getProvider();
            this.getSourceColumns(oracleDatabaseImpl, string);
        } else {
            this.sourcesCleared();
        }
    }

    protected abstract void afterSourceChanged();

    protected void sourcesCleared() {
        if (this.sources != null) {
            this.sources.clear();
        }
    }

    @Override
    public String getSchemaName() {
        return ((AbstractSchemaObjectWithDesc)this.getUpdatedObject()).getSchema().getName();
    }

    @Override
    public String getUpdObjectName() {
        return ((AbstractSchemaObjectWithDesc)this.getUpdatedObject()).getName();
    }

    @Override
    public String getUpdObjectType() {
        return ((AbstractSchemaObjectWithDesc)this.getUpdatedObject()).getType();
    }

    @Override
    public SourceMetadata getSourceMetadata() {
        return this.sourceMetaData;
    }

    @Override
    public boolean isMultipleSourceSupported() {
        return this.multipleSelection;
    }

    protected void layoutComponents() {
        ComponentFactory componentFactory = this.getComponentFactory();
        this.sourceTextField = new SourceTextField(this);
        this.sourceTextField.setName("sourceTextField");
        this.sourceTextField.setText("");
        this.sourceTextField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                GeneralBaseSourceEditorPanel.this.sourceChanged();
            }
        });
        this.schemaLabel = new JLabel();
        this.sourceLabel = new JLabel();
        this.getHelper().getResourceHelper().resLabel(this.sourceLabel, (Component)this.sourceTextField, HCSArb.getString("HIERARCHY_DIMENSION_SOURCE_LABEL"), "sourceField");
        this.sourceButton = new JButton(HCSArb.getString("SOURCE_BUTTON_LABEL"));
        this.sourceButton.addActionListener(actionEvent -> {
            Window window = SwingUtilities.windowForComponent((Component)((Object)this));
            List<DatabaseSource> list = SourceSelectionDialog.showDialog(window, this.sourceMetaData, this.sources, ((AbstractSchemaObjectWithDesc)this.getUpdatedObject()).getSchema().getName(), ((AbstractSchemaObjectWithDesc)this.getUpdatedObject()).getName(), ((AbstractSchemaObjectWithDesc)this.getUpdatedObject()).getType(), true, false, "av_source_selection");
            if (!(list == null || list.isEmpty() || this.sources != null && this.sources.containsAll(list))) {
                this.sources = list;
                StringBuffer stringBuffer = new StringBuffer();
                for (DatabaseSource databaseSource : this.sources) {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(",");
                    }
                    String string = "";
                    if (!databaseSource.getSchemaName().equals(((AbstractSchemaObjectWithDesc)this.getUpdatedObject()).getSchema().getName())) {
                        string = string + databaseSource.getSchemaName() + ".";
                    }
                    string = string + databaseSource.getName();
                    string = this.getExternalSourceName(string);
                    stringBuffer.append(string);
                }
                this.sourceTextField.setText(stringBuffer.toString());
                this.sourceMessageLabel.setVisible(false);
                this.sourceChanged();
            }
        });
        this.sourceMessageLabel = new JLabel();
        this.sourceMessageLabel.setVisible(false);
    }

    private String getExternalSourceName(String string) {
        if (string.indexOf(".") > 0) {
            IdentifierElement identifierElement = new IdentifierElement(string);
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < identifierElement.getCount(); ++i) {
                String string2 = this.getProvider().getExternalName(identifierElement.get(i));
                arrayList.add(string2);
            }
            string = String.join((CharSequence)".", arrayList);
            return string;
        }
        return this.getProvider().getExternalName(string);
    }

    protected int layoutSource(JPanel jPanel, int n) {
        jPanel.add((Component)this.schemaLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 12), 0, 0));
        jPanel.add((Component)this.sourceLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 12), 0, 0));
        jPanel.add((Component)this.sourceTextField, new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        jPanel.add((Component)this.sourceButton, new GridBagConstraints(2, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        jPanel.add((Component)this.sourceMessageLabel, new GridBagConstraints(1, ++n, 1, 1, 1.0, 0.0, 13, 0, new Insets(5, 0, 0, 5), 0, 0));
        return n;
    }

    protected SourceTextField getSourceTextField() {
        return this.sourceTextField;
    }

    private boolean foundSources(Schema schema, String string) {
        if (this.sources == null) {
            return false;
        }
        String[] stringArray = string.split(",");
        if (stringArray.length != this.sources.size()) {
            return false;
        }
        boolean bl = true;
        for (String string2 : stringArray) {
            boolean bl2 = false;
            for (DatabaseSource databaseSource : this.sources) {
                if (string2.contains(".")) {
                    int n = string2.indexOf(".");
                    String string3 = string2.substring(0, n);
                    if (!databaseSource.equals(string3, string2 = string2.substring(n + 1)) || databaseSource.getColumns().length <= 0) continue;
                    bl2 = true;
                    break;
                }
                if (!databaseSource.equals(schema.getName(), string2) || databaseSource.getColumns().length <= 0) continue;
                bl2 = true;
                break;
            }
            if (bl2) continue;
            bl = false;
            break;
        }
        return bl;
    }

    protected List<DatabaseSource> getSourcesWithColumns(OracleDatabaseImpl oracleDatabaseImpl, List<DatabaseSource> list, String string) {
        Schema schema = ((AbstractSchemaObjectWithDesc)this.getUpdatedObject()).getSchema();
        if (this.foundSources(schema, string)) {
            return this.sources;
        }
        List<DatabaseSource> list2 = null;
        try {
            ColumnListRunnable columnListRunnable = new ColumnListRunnable(oracleDatabaseImpl, list, schema, string);
            String string2 = HCSArb.get("FETCH_SOURCE_COLUMNS_TITLE");
            string2 = MessageFormat.format(string2, "");
            ProgressBar progressBar = new ProgressBar((Component)Ide.getMainWindow(), string2, (Runnable)columnListRunnable, true);
            progressBar.setCancelable(false);
            columnListRunnable.setProgressBar(progressBar);
            progressBar.start(HCSArb.format("FETCH_SOURCE_COLUMNS_MESSAGE", string), null);
            if (columnListRunnable.getException() != null) {
                throw columnListRunnable.getException();
            }
            list2 = columnListRunnable.getSources();
        }
        catch (Exception exception) {
            String string3 = null;
            String string4 = exception.getLocalizedMessage();
            if (string4 == null || string4.length() == 0) {
                string4 = exception.getClass().toString();
            }
            String string5 = HCSArb.get("COLUMNS_ERROR_TITLE");
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string4, (String)string5, string3);
        }
        return list2;
    }

    protected void getSourceColumns(OracleDatabaseImpl oracleDatabaseImpl, String string) {
        Schema schema = ((AbstractSchemaObjectWithDesc)this.getUpdatedObject()).getSchema();
        this.sourceMessageLabel.setText(HCSArb.format("FETCH_SOURCE_COLUMNS_MESSAGE", string));
        this.sourceMessageLabel.setVisible(true);
        ColumnListWorker columnListWorker = new ColumnListWorker(oracleDatabaseImpl, schema, string){

            @Override
            public void done() {
                try {
                    GeneralBaseSourceEditorPanel.this.sources = (List)this.get();
                    GeneralBaseSourceEditorPanel.this.sourceMessageLabel.setVisible(false);
                    GeneralBaseSourceEditorPanel.this.afterSourceChanged();
                }
                catch (Exception exception) {
                    String string = null;
                    String string2 = exception.getLocalizedMessage();
                    if (string2 == null || string2.length() == 0) {
                        string2 = exception.getClass().toString();
                    }
                    String string3 = HCSArb.get("COLUMNS_ERROR_TITLE");
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)string2, (String)string3, string);
                }
            }
        };
        columnListWorker.execute();
    }

    protected void setSources(List<DatabaseSource> list) {
        this.sources = list;
    }

    protected List<DatabaseSource> getSourcesWithColumns(OracleDatabaseImpl oracleDatabaseImpl, String string) {
        Schema schema = ((AbstractSchemaObjectWithDesc)this.getUpdatedObject()).getSchema();
        return this.getSourcesWithColumns(oracleDatabaseImpl, schema, string);
    }

    protected List<DatabaseSource> getSourcesWithColumns(OracleDatabaseImpl oracleDatabaseImpl, Schema schema, String string) {
        if (schema == null) {
            schema = ((AbstractSchemaObjectWithDesc)this.getUpdatedObject()).getSchema();
        }
        if (this.foundSources(schema, string)) {
            return this.sources;
        }
        List<DatabaseSource> list = null;
        try {
            ColumnListRunnable columnListRunnable = new ColumnListRunnable(oracleDatabaseImpl, schema, string);
            String string2 = HCSArb.get("FETCH_SOURCE_COLUMNS_TITLE");
            string2 = MessageFormat.format(string2, "");
            ProgressBar progressBar = new ProgressBar((Component)Ide.getMainWindow(), string2, (Runnable)columnListRunnable, true);
            progressBar.setCancelable(false);
            columnListRunnable.setProgressBar(progressBar);
            progressBar.start(HCSArb.format("FETCH_SOURCE_COLUMNS_MESSAGE", string), null);
            if (columnListRunnable.getException() != null) {
                throw columnListRunnable.getException();
            }
            list = columnListRunnable.getSources();
        }
        catch (Exception exception) {
            String string3 = null;
            String string4 = exception.getLocalizedMessage();
            if (string4 == null || string4.length() == 0) {
                string4 = exception.getClass().toString();
            }
            String string5 = HCSArb.get("COLUMNS_ERROR_TITLE");
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string4, (String)string5, string3);
        }
        return list;
    }

    protected void enableMultipleSourceSupport() {
        this.multipleSelection = true;
        for (ActionListener actionListener : this.sourceButton.getActionListeners()) {
            this.sourceButton.removeActionListener(actionListener);
        }
        this.sourceButton.addActionListener(actionEvent -> {
            Window window = SwingUtilities.windowForComponent((Component)((Object)this));
            List<DatabaseSource> list = SourceSelectionDialog.showDialog(window, this.sourceMetaData, this.sources, ((AbstractSchemaObjectWithDesc)this.getUpdatedObject()).getSchema().getName(), ((AbstractSchemaObjectWithDesc)this.getUpdatedObject()).getName(), ((AbstractSchemaObjectWithDesc)this.getUpdatedObject()).getType(), false, false, "av_source_selection");
            if (!(list == null || list.isEmpty() || this.sources != null && this.sources.size() == list.size() && this.sources.containsAll(list))) {
                this.sources = list;
                StringBuffer stringBuffer = new StringBuffer();
                for (DatabaseSource databaseSource : this.sources) {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(",");
                    }
                    String string = "";
                    if (!databaseSource.getSchemaName().equals(((AbstractSchemaObjectWithDesc)this.getUpdatedObject()).getSchema().getName())) {
                        string = string + databaseSource.getSchemaName() + ".";
                    }
                    string = string + databaseSource.getName();
                    string = this.getExternalSourceName(string);
                    stringBuffer.append(string);
                }
                this.sourceTextField.setText(stringBuffer.toString());
                this.sourceMessageLabel.setVisible(false);
                this.sourceChanged();
            }
        });
    }
}

