/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.dimension.panels;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.hcs.HCSArb;
import oracle.hcs.db.source.ColumnIdentifier;
import oracle.hcs.db.source.CompletionColumnMatchProvider;
import oracle.hcs.db.source.MapExpressionCellRenderer;
import oracle.hcs.dimension.model.JoinPath;
import oracle.hcs.util.CompletionCellEditor;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.completion.CompletionProvider;
import oracle.javatools.ui.completion.CompletionTextField;
import oracle.javatools.ui.table.GenericTable;

public class JoinTablePanel
extends JPanel {
    private GenericTable joinTable;
    private CustomModel tableModel;
    private JButton removeButton;
    private JButton addButton;
    private ArrayList<JoinPath> joins;
    private DBObjectProvider provider;
    private List<ColumnIdentifier> sourceColumns = new ArrayList<ColumnIdentifier>();
    private static final int JOIN_NAME = 0;
    private static final int DIMENSION_SOURCE_COLUMN_1 = 1;
    private static final int DIMENSION_SOURCE_COLUMN_2 = 2;
    private final String AND = "AND";
    private int minJoinConditions = 0;

    public JoinTablePanel() {
        this.initComponents();
        this.layoutComponents();
    }

    private void initComponents() {
        this.joins = new ArrayList();
        this.tableModel = new CustomModel();
        this.tableModel.addColumn(HCSArb.getString("ATTRIBUTE_DIMENSION_JOIN_TABLE_COLUMN_NAME_LABEL"));
        this.tableModel.addColumn(HCSArb.getString("ATTRIBUTE_DIMENSION_JOIN_TABLE_COLUMN_LABEL"));
        this.tableModel.addColumn(HCSArb.getString("ATTRIBUTE_DIMENSION_JOIN_TABLE_COLUMN_LABEL"));
        this.joinTable = new GenericTable((TableModel)this.tableModel);
        this.joinTable.setColumnSelectorAvailable(false);
    }

    private void layoutComponents() {
        this.setLayout(new GridBagLayout());
        ControlBar controlBar = new ControlBar();
        controlBar.add(Box.createRigidArea(new Dimension(5, 16)));
        controlBar.add(Box.createRigidArea(new Dimension(5, 16)));
        this.addButton = new JButton(OracleIcons.getIcon((String)"add.png"));
        this.addButton.setToolTipText(HCSArb.getString("JOIN_TABLE_ADD_TOOLTIP"));
        controlBar.add(Box.createRigidArea(new Dimension(5, 16)));
        controlBar.add((Component)this.addButton);
        this.addButton.setEnabled(true);
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object[] objectArray = new Object[]{"", "", ""};
                JoinTablePanel.this.tableModel.addRow(objectArray);
                JoinTablePanel.this.updateButtons();
            }
        });
        this.removeButton = new JButton(OracleIcons.getIcon((String)"delete.png"));
        this.removeButton.setToolTipText(HCSArb.getString("JOIN_TABLE_REMOVE_TOOLTIP"));
        controlBar.add(Box.createRigidArea(new Dimension(5, 16)));
        controlBar.add((Component)this.removeButton);
        this.removeButton.setEnabled(true);
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                if (JoinTablePanel.this.joinTable.getRowCount() > JoinTablePanel.this.minJoinConditions && (n = JoinTablePanel.this.joinTable.getSelectedRow()) >= 0) {
                    JoinTablePanel.this.tableModel.removeRow(n);
                    JoinTablePanel.this.updateButtons();
                }
            }
        });
        ComponentWithTitlebar componentWithTitlebar = new ComponentWithTitlebar();
        componentWithTitlebar.setLabel(new JLabel(HCSArb.getString("JOIN_TABLE_TITLE")));
        componentWithTitlebar.setControlBar(controlBar);
        JScrollPane jScrollPane = new JScrollPane((Component)this.joinTable);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setVerticalScrollBarPolicy(20);
        componentWithTitlebar.setComponent((JComponent)jScrollPane);
        this.add((Component)componentWithTitlebar, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.5, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    private void setTableCellEditorAndRenderer() {
        TableColumn tableColumn = this.joinTable.getColumnModel().getColumn(1);
        CompletionTextField completionTextField = new CompletionTextField();
        CompletionColumnMatchProvider completionColumnMatchProvider = new CompletionColumnMatchProvider(completionTextField.getPopupHandler().getInsightList(), this.sourceColumns);
        completionTextField.getPopupHandler().registerInsightProvider((CompletionProvider)completionColumnMatchProvider);
        tableColumn.setCellRenderer(new MapExpressionCellRenderer(string -> {
            for (ColumnIdentifier columnIdentifier : this.sourceColumns) {
                if (!columnIdentifier.getColumn().getName().equals(string)) continue;
                return columnIdentifier.getColumn();
            }
            return null;
        }));
        tableColumn.setCellEditor(new CompletionCellEditor(completionTextField, completionColumnMatchProvider));
        TableColumn tableColumn2 = this.joinTable.getColumnModel().getColumn(2);
        CompletionTextField completionTextField2 = new CompletionTextField();
        CompletionColumnMatchProvider completionColumnMatchProvider2 = new CompletionColumnMatchProvider(completionTextField2.getPopupHandler().getInsightList(), this.sourceColumns);
        completionTextField2.getPopupHandler().registerInsightProvider((CompletionProvider)completionColumnMatchProvider2);
        tableColumn2.setCellRenderer(new MapExpressionCellRenderer(string -> {
            for (ColumnIdentifier columnIdentifier : this.sourceColumns) {
                if (!columnIdentifier.getColumn().getName().equals(string)) continue;
                return columnIdentifier.getColumn();
            }
            return null;
        }));
        tableColumn2.setCellEditor(new CompletionCellEditor(completionTextField2, completionColumnMatchProvider2));
    }

    public void setJoinPaths(JoinPath[] joinPathArray, boolean bl) {
        if (bl) {
            this.tableModel.setRowCount(0);
            for (JoinPath joinPath : joinPathArray) {
                String string = joinPath.getName();
                String[] stringArray = joinPath.getCondition().split("AND");
                for (int i = 0; i < stringArray.length; ++i) {
                    String string2 = stringArray[i];
                    String[] stringArray2 = string2.split(" = ");
                    Object[] objectArray = new Object[]{string, stringArray2[0].trim(), stringArray2[1].trim()};
                    this.tableModel.addRow(objectArray);
                }
            }
        }
        this.updateButtons();
    }

    public void setMinJoinConditions(int n) {
        this.minJoinConditions = n;
    }

    public void defaultJoinConditions() {
        int n = this.tableModel.getRowCount();
        Object[] objectArray = new Object[]{"", "", ""};
        for (int i = n; i < this.minJoinConditions; ++i) {
            this.tableModel.addRow(objectArray);
        }
        this.updateButtons();
    }

    public JoinPath[] getJoinPaths() {
        this.joins.clear();
        int n = this.tableModel.getRowCount();
        for (int i = 0; i < n; ++i) {
            String[] stringArray;
            Object object2;
            StringBuffer stringBuffer = new StringBuffer();
            String string = this.provider.getInternalName((String)this.tableModel.getValueAt(i, 0));
            boolean bl = false;
            for (Object object2 : this.joins) {
                String[] stringArray2;
                stringArray = object2.getName();
                if (!string.equals(stringArray)) continue;
                stringBuffer.append(object2.getCondition());
                stringBuffer.append(" AND ");
                String string2 = (String)this.tableModel.getValueAt(i, 1);
                String string3 = this.provider.getInternalName(string2);
                if (string3.contains(".")) {
                    stringArray2 = string2.split("\\.");
                    string3 = this.provider.getInternalName(stringArray2[0]) + "." + this.provider.getInternalName(stringArray2[1]);
                }
                stringBuffer.append(string3);
                stringBuffer.append(" = ");
                string2 = (String)this.tableModel.getValueAt(i, 2);
                string3 = this.provider.getInternalName(string2);
                if (string3.contains(".")) {
                    stringArray2 = string2.split("\\.");
                    string3 = this.provider.getInternalName(stringArray2[0]) + "." + this.provider.getInternalName(stringArray2[1]);
                }
                stringBuffer.append(string3);
                object2.setCondition(stringBuffer.toString());
                bl = true;
                break;
            }
            if (bl) continue;
            Object object3 = (String)this.tableModel.getValueAt(i, 1);
            object2 = this.provider.getInternalName((String)object3);
            if (((String)object2).contains(".")) {
                stringArray = ((String)object3).split("\\.");
                object2 = this.provider.getInternalName(stringArray[0]) + "." + this.provider.getInternalName(stringArray[1]);
            }
            stringBuffer.append((String)object2);
            stringBuffer.append(" = ");
            object3 = (String)this.tableModel.getValueAt(i, 2);
            object2 = this.provider.getInternalName((String)object3);
            if (((String)object2).contains(".")) {
                stringArray = ((String)object3).split("\\.");
                object2 = this.provider.getInternalName(stringArray[0]) + "." + this.provider.getInternalName(stringArray[1]);
            }
            stringBuffer.append((String)object2);
            this.joins.add(new JoinPath(string, stringBuffer.toString()));
        }
        return this.joins.toArray(new JoinPath[this.joins.size()]);
    }

    private boolean isValidJoinCondition(int n) {
        String string = (String)this.tableModel.getValueAt(n, 0);
        String string2 = (String)this.tableModel.getValueAt(n, 1);
        String string3 = (String)this.tableModel.getValueAt(n, 2);
        return string != null && !string.isEmpty() && string2 != null && !string2.isEmpty() && string3 != null && !string3.isEmpty();
    }

    public void setProvider(DBObjectProvider dBObjectProvider) {
        this.provider = dBObjectProvider;
    }

    public void setSourceColumns(List<ColumnIdentifier> list) {
        this.sourceColumns = list;
        this.setTableCellEditorAndRenderer();
    }

    private void updateButtons() {
        int n = this.tableModel.getRowCount();
        if (n <= this.minJoinConditions) {
            this.removeButton.setEnabled(false);
        } else {
            this.removeButton.setEnabled(true);
        }
    }

    public GenericTable getTable() {
        return this.joinTable;
    }

    class CustomModel
    extends DefaultTableModel {
        final int JOIN_NAME = 0;
        final int DIMENSION_SOURCE_COLUMN_1 = 1;
        final int DIMENSION_SOURCE_COLUMN_2 = 2;

        CustomModel() {
        }

        @Override
        public Object getValueAt(int n, int n2) {
            String string = (String)super.getValueAt(n, n2);
            switch (n2) {
                case 0: {
                    return JoinTablePanel.this.provider.getExternalName(string);
                }
                case 1: 
                case 2: {
                    if (string.contains(".")) {
                        String[] stringArray = string.split("\\.");
                        string = JoinTablePanel.this.provider.getExternalName(stringArray[0].trim()) + "." + JoinTablePanel.this.provider.getExternalName(stringArray[1].trim());
                        return string;
                    }
                    return JoinTablePanel.this.provider.getExternalName(string);
                }
            }
            return string;
        }
    }
}

