/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.navigator;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Timer;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.navigator.impl.DatabaseSourceNode;
import oracle.hcs.HCSArb;
import oracle.hcs.av.model.AVBaseMeasure;
import oracle.hcs.av.model.AnalyticView;
import oracle.hcs.db.HCSMetadataCache;
import oracle.hcs.db.IdentifierElement;
import oracle.hcs.metadata.HCSSchema;
import oracle.hcs.navigator.CalculatedMeasureNode;
import oracle.hcs.syntaxbuilder.HCSSyntaxHandler;
import oracle.hcs.syntaxbuilder.HCSSyntaxParser;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;
import oracle.ide.model.Observer;
import oracle.ide.model.UpdateMessage;
import oracle.javatools.editor.BasicEditorPane;

public class CalculatedMeasureRefreshNodeListener
extends NodeListener
implements Observer {
    private static final Logger LOGGER = Logger.getLogger(CalculatedMeasureRefreshNodeListener.class.getName());
    private List<CalculatedMeasureNode> m_changedNodes = new ArrayList<CalculatedMeasureNode>();
    private Timer m_timer = new Timer(200, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CalculatedMeasureRefreshNodeListener.this.handleChangedNodes();
        }
    });
    private String connectionName;
    private String schemaName;

    public CalculatedMeasureRefreshNodeListener() {
        this.m_timer.setRepeats(false);
    }

    public void nodeOpened(NodeEvent nodeEvent) {
        DatabaseSourceNode databaseSourceNode = (DatabaseSourceNode)nodeEvent.getNode();
        databaseSourceNode.attach((Observer)this);
    }

    public void nodeClosed(NodeEvent nodeEvent) {
        DatabaseSourceNode databaseSourceNode = (DatabaseSourceNode)nodeEvent.getNode();
        databaseSourceNode.detach((Observer)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Object object, UpdateMessage updateMessage) {
        int n;
        if (object instanceof CalculatedMeasureNode && (n = updateMessage.getMessageID()) == UpdateMessage.STRUCTURE_CHANGED) {
            CalculatedMeasureNode calculatedMeasureNode = (CalculatedMeasureNode)object;
            boolean bl = calculatedMeasureNode.isDirty();
            String string = String.format("%s.%s", calculatedMeasureNode.getAVName(), calculatedMeasureNode.getMeasureName());
            this.schemaName = calculatedMeasureNode.getSchemaName();
            this.connectionName = calculatedMeasureNode.getConnectionName();
            List<CodeEditor> list = this.findCodeEditors(string);
            if (!bl && list.size() > 0) {
                List<CalculatedMeasureNode> list2 = this.m_changedNodes;
                synchronized (list2) {
                    this.m_changedNodes.add(calculatedMeasureNode);
                }
            }
            this.m_timer.restart();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleChangedNodes() {
        ArrayList<CalculatedMeasureNode> arrayList = new ArrayList<CalculatedMeasureNode>();
        List<CalculatedMeasureNode> list = this.m_changedNodes;
        synchronized (list) {
            if (this.m_changedNodes.isEmpty()) {
                return;
            }
            arrayList.addAll(this.m_changedNodes);
            this.m_changedNodes.clear();
            this.doUpdate(arrayList);
        }
    }

    private void doUpdate(final List<CalculatedMeasureNode> list) {
        RaptorTask<HCSSchema> raptorTask = new RaptorTask<HCSSchema>(HCSArb.getString("EXPRESSION_EDITOR_REFRESH_METADATA"), true, IRaptorTaskRunMode.IDE_STATUSBAR){

            protected HCSSchema doWork() {
                HCSSchema hCSSchema = null;
                try {
                    hCSSchema = HCSMetadataCache.getUpdatedSchema(CalculatedMeasureRefreshNodeListener.this.connectionName, CalculatedMeasureRefreshNodeListener.this.schemaName);
                    for (CalculatedMeasureNode calculatedMeasureNode : list) {
                        String string = String.format("%s.%s", calculatedMeasureNode.getAVName(), calculatedMeasureNode.getMeasureName());
                        List list2 = CalculatedMeasureRefreshNodeListener.this.findCodeEditors(string);
                        for (CodeEditor codeEditor : list2) {
                            AVBaseMeasure aVBaseMeasure;
                            if (codeEditor == null) continue;
                            BasicEditorPane basicEditorPane = codeEditor.getFocusedEditorPane();
                            AnalyticView analyticView = hCSSchema.findAV(calculatedMeasureNode.getAVName());
                            if (analyticView == null || basicEditorPane == null || (aVBaseMeasure = analyticView.findBaseMeasure(calculatedMeasureNode.getMeasureName())) == null) continue;
                            Properties properties = CalculatedMeasureRefreshNodeListener.this.buildProperties(calculatedMeasureNode);
                            HCSSyntaxParser hCSSyntaxParser = new HCSSyntaxParser(hCSSchema, properties);
                            String string2 = HCSSyntaxHandler.format(hCSSchema.getName(), aVBaseMeasure.getExpression());
                            String string3 = hCSSyntaxParser.formatSyntax(string2);
                            if (basicEditorPane.getText().equals(string3) || calculatedMeasureNode.isDirty()) continue;
                            if (hCSSyntaxParser.parseSyntax(string3, null)) {
                                basicEditorPane.setText(string3);
                            } else {
                                basicEditorPane.setText(string2);
                            }
                            calculatedMeasureNode.markDirty(false);
                        }
                    }
                }
                catch (Exception exception) {
                    LOGGER.log(Level.SEVERE, String.format("Error fetching metadata for Connection %s and schema %s", CalculatedMeasureRefreshNodeListener.this.connectionName, CalculatedMeasureRefreshNodeListener.this.schemaName, exception));
                }
                return null;
            }
        };
        raptorTask.setCancellable(false);
        raptorTask.setMessage(HCSArb.getString("EXPRESSION_EDITOR_REFRESH_METADATA"));
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    private List<CodeEditor> findCodeEditors(String string) {
        EditorManager editorManager = EditorManager.getEditorManager();
        List list = editorManager.getAllEditors();
        ArrayList<CodeEditor> arrayList = new ArrayList<CodeEditor>();
        IdentifierElement identifierElement = new IdentifierElement(string);
        String string2 = "";
        String string3 = "";
        if (identifierElement.getCount() == 2) {
            string2 = identifierElement.getFirst();
            string3 = identifierElement.getSecond();
        }
        for (Editor editor : list) {
            String string4 = editor.getTabLabel();
            if (!string4.equalsIgnoreCase(string3) && !string4.equalsIgnoreCase(String.format("%s.%s", string2, string3))) continue;
            arrayList.add((CodeEditor)editor);
        }
        return arrayList;
    }

    private Properties buildProperties(CalculatedMeasureNode calculatedMeasureNode) {
        Properties properties = new Properties();
        properties.setProperty("SCHEMA", calculatedMeasureNode.getSchemaName());
        properties.setProperty("CUBE", calculatedMeasureNode.getAVName());
        properties.setProperty("CONTEXT", "MEASURE_EXPRESSION");
        return properties;
    }
}

