/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.quickav;

import java.sql.Connection;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.List;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.utils.Connections;
import oracle.hcs.actions.BaseRunnable;
import oracle.hcs.quickav.QuickAVDataTableHelper;
import oracle.hcs.quickav.model.TableCol;

public class QuickAVTableAnalyzerRunnable
extends BaseRunnable {
    private final List<TableCol> columns;
    private final String query;
    private final QuickAVDataTableHelper dataTableHelper;
    private final Connection conn;

    public QuickAVTableAnalyzerRunnable(Connection connection, String string, List<TableCol> list, QuickAVDataTableHelper quickAVDataTableHelper) {
        this.conn = connection;
        this.query = string;
        this.columns = list;
        this.dataTableHelper = quickAVDataTableHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        DBUtil dBUtil = DBUtil.getInstance((Connection)this.conn);
        ResultSet resultSet = null;
        try {
            Connections.getInstance().lock(this.conn);
            HashMap hashMap = new HashMap();
            resultSet = dBUtil.executeQuery(this.query, hashMap);
            while (resultSet.next()) {
                TableCol tableCol = new TableCol();
                tableCol.setIncludeColumn(true);
                tableCol.setFieldName(resultSet.getString(1));
                tableCol.setCardinality(resultSet.getInt(2));
                tableCol.setRatio(resultSet.getBigDecimal(3));
                tableCol.setTotalRows(resultSet.getInt(4));
                tableCol.setDataType(resultSet.getString(5));
                this.columns.add(tableCol);
            }
            this.dataTableHelper.predictColumnsType(this.columns);
        }
        catch (Exception exception) {
            try {
                if (resultSet == null) return;
                DBUtil.closeResultSet(resultSet);
                return;
            }
            catch (Exception exception2) {
                return;
            }
            finally {
                Connections.getInstance().unlock(this.conn);
                this.getProgressBar().setDoneStatus();
            }
        }
        catch (Throwable throwable) {
            try {
                if (resultSet == null) throw throwable;
                DBUtil.closeResultSet(resultSet);
                throw throwable;
            }
            catch (Exception exception) {
                throw throwable;
            }
            finally {
                Connections.getInstance().unlock(this.conn);
                this.getProgressBar().setDoneStatus();
            }
        }
        try {
            if (resultSet == null) return;
            DBUtil.closeResultSet((ResultSet)resultSet);
            return;
        }
        catch (Exception exception) {
            return;
        }
        finally {
            Connections.getInstance().unlock(this.conn);
            this.getProgressBar().setDoneStatus();
        }
    }
}

