/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.syntax;

import oracle.hcs.syntax.DataObject;
import oracle.hcs.syntax.DimensionArgument;
import oracle.hcs.syntax.FunctionArgument;
import oracle.hcs.syntax.FunctionDescriptorArgument;
import oracle.hcs.syntax.UnresolvedExpression;
import oracle.hcs.syntax.ValidationContext;

public final class FunctionDescriptorDimensionArgument
extends FunctionDescriptorArgument {
    public static final int DIMENSION_LEVEL = 1;
    public static final int PRIMARY_DIMENSION = 2;
    public static final int HIERARCHY_LEVEL = 4;
    public static final int LEVEL_HIERARCHY = 8;
    public static final int VALUE_HIERARCHY = 16;
    private String m_Name = null;
    private int m_Mask = 0;

    FunctionDescriptorDimensionArgument(String string, int n, boolean bl, boolean bl2) {
        super(bl, bl2);
        this.m_Name = string;
        this.m_Mask = n;
    }

    @Override
    int validate(FunctionArgument[] functionArgumentArray, FunctionArgument[] functionArgumentArray2, ValidationContext validationContext, int n) {
        DataObject dataObject;
        FunctionArgument functionArgument = null;
        if (functionArgumentArray.length > n) {
            functionArgument = functionArgumentArray[n];
        }
        if (functionArgument instanceof UnresolvedExpression) {
            dataObject = (UnresolvedExpression)functionArgument;
            functionArgument = dataObject.resolveToDimension(validationContext, this.getMask());
        }
        if (!(functionArgument instanceof DimensionArgument)) {
            return -1;
        }
        dataObject = (DimensionArgument)validationContext.validate((DimensionArgument)functionArgument);
        functionArgumentArray2[n] = dataObject;
        return n + 1;
    }

    @Override
    public void toSyntaxInternal(StringBuffer stringBuffer) {
        stringBuffer.append(this.getArgumentName());
    }

    public String getArgumentName() {
        return this.m_Name;
    }

    public int getMask() {
        return this.m_Mask;
    }

    public static int getMinExpectedNumComponents(int n) {
        if ((n & 2) > 0) {
            return 2;
        }
        if ((n & 8) > 0 || (n & 0x10) > 0 || (n & 1) > 0) {
            return 3;
        }
        return 4;
    }

    public static int getMaxExpectedNumComponents(int n) {
        if ((n & 4) > 0) {
            return 4;
        }
        if ((n & 8) > 0 || (n & 0x10) > 0 || (n & 1) > 0) {
            return 3;
        }
        return 2;
    }
}

