/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.templates.templateview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import oracle.hcs.av.model.AVDimensionality;
import oracle.hcs.av.model.AVHierarchy;
import oracle.hcs.av.model.AnalyticView;
import oracle.hcs.dimension.model.AttributeDimension;
import oracle.hcs.metadata.HCSSchema;
import oracle.hcs.syntaxbuilder.HCSSyntaxType;
import oracle.hcs.templates.stringexpr.ParamValue;
import oracle.hcs.templates.stringexpr.ParseException;
import oracle.hcs.templates.stringexpr.StringExprParser;
import oracle.hcs.templates.templatelist.BaseTemplate;
import oracle.hcs.templates.templatelist.Template;
import oracle.hcs.templates.templatelist.TemplateGroup;
import oracle.hcs.templates.templatelist.TemplateList;
import oracle.hcs.templates.templateview.BaseTemplateHyperView;
import oracle.hcs.templates.templateview.TemplateContext;
import oracle.hcs.templates.templateview.TemplateHyperContext;
import oracle.hcs.templates.templateview.TemplateHyperParam;
import oracle.hcs.templates.templateview.TemplateHyperParamCombo;
import oracle.hcs.templates.templateview.TemplateHyperParamHierarchy;
import oracle.hcs.templates.templateview.TemplateHyperParamList;
import oracle.hcs.templates.templateview.TemplateHyperView;
import oracle.hcs.templates.templateview.TemplateMetadata;
import oracle.hcs.templates.templateview.TemplateViewNode;
import oracle.javatools.icons.OracleIcons;

public class TemplateGroupHyperView
extends BaseTemplateHyperView {
    private static final String HIERARCHY = "HIERARCHY";
    private static final Logger LOG = Logger.getLogger(TemplateGroupHyperView.class.getName());
    private static final int SPACING = 3;
    private final List<BaseTemplateHyperView> templateHyperViews = new ArrayList<BaseTemplateHyperView>();
    private boolean initialized;
    private GridBagConstraints c;
    private int depth;
    private static final int TEMPLATE_INDENT = 20;

    public TemplateGroupHyperView(BaseTemplateHyperView baseTemplateHyperView, TemplateContext templateContext, TemplateHyperContext templateHyperContext, boolean bl, TemplateGroup templateGroup, Map<String, String> map, ParamValue paramValue) throws SQLException, IOException {
        super(baseTemplateHyperView, templateContext, templateHyperContext, bl, templateGroup, templateGroup, map, paramValue);
        this.panel = new JPanel(new FlowLayout(0));
    }

    public TemplateGroupHyperView(BaseTemplateHyperView baseTemplateHyperView, TemplateContext templateContext, TemplateHyperContext templateHyperContext, boolean bl, TemplateGroup templateGroup) throws SQLException, IOException {
        this(baseTemplateHyperView, templateContext, templateHyperContext, bl, templateGroup, null, null);
    }

    private void init(Map<String, String> map) throws SQLException, IOException {
        TemplateContext templateContext = this.getTemplateContext();
        TemplateHyperContext templateHyperContext = this.getTemplateHyperContext();
        TemplateGroup templateGroup = this.getTemplateGroup();
        String string = templateGroup.getContext();
        if (!this.initialized) {
            this.initialized = true;
            if (string != null && HCSSyntaxType.ANALYTIC_VIEW.toString().equalsIgnoreCase(string)) {
                AnalyticView analyticView = templateContext.getAV();
                if (analyticView != null) {
                    int n = 0;
                    for (AVDimensionality aVDimensionality : analyticView.getDimensions()) {
                        AttributeDimension attributeDimension = aVDimensionality.getDimension();
                        AVDimensionality aVDimensionality2 = null;
                        for (AVHierarchy aVHierarchy : aVDimensionality.getHierarchies()) {
                            if (!aVHierarchy.isHierarchyDefault()) continue;
                            aVDimensionality2 = aVDimensionality;
                        }
                        HCSSchema object3 = templateContext.getSchema();
                        TemplateMetadata templateMetadata = new TemplateMetadata(object3, aVDimensionality2);
                        TemplateContext templateContext2 = new TemplateContext(templateMetadata, templateContext.getProvider());
                        templateContext2.setAV(analyticView);
                        templateMetadata.setAV(analyticView);
                        for (BaseTemplate baseTemplate : templateGroup.getTemplates()) {
                            Object object;
                            boolean bl = true;
                            String string2 = baseTemplate.getCondition();
                            if (string2 != null) {
                                try {
                                    object = StringExprParser.getParseTree(string2, attributeDimension);
                                    bl = Boolean.parseBoolean((String)object);
                                }
                                catch (ParseException parseException) {
                                    LOG.log(Level.FINE, parseException.getMessage(), parseException);
                                }
                            }
                            if (!bl) continue;
                            object = this.addTemplateView(baseTemplate, templateContext2, templateHyperContext, this.getTreeStyle(), templateGroup, map, this.getGlobalParamValue());
                            ((BaseTemplateHyperView)object).putAllParamValue("dimIndex", new Integer(n).toString());
                        }
                        ++n;
                    }
                }
            } else if (string != null && "CUBEHIERARCHIES".equalsIgnoreCase(string)) {
                AnalyticView analyticView = templateContext.getAV();
                if (analyticView != null) {
                    Set<AVHierarchy> set = templateContext.getPreselectedAVHierarchies();
                    AVDimensionality[] aVDimensionalityArray = analyticView.getDimensions();
                    HashSet hashSet = new HashSet();
                    HashSet<AVDimensionality> hashSet2 = new HashSet<AVDimensionality>();
                    for (AVHierarchy aVHierarchy : set) {
                        AVDimensionality aVDimensionality = (AVDimensionality)aVHierarchy.getParent();
                        hashSet2.add(aVDimensionality);
                    }
                    hashSet.addAll(hashSet2);
                    for (AVDimensionality string5 : aVDimensionalityArray) {
                        hashSet.add(string5);
                    }
                    int n = 0;
                    for (AVDimensionality aVDimensionality : hashSet) {
                        AttributeDimension attributeDimension = aVDimensionality.getDimension();
                        AVHierarchy[] aVHierarchyArray = aVDimensionality.getHierarchies();
                        HashSet hashSet3 = new HashSet();
                        HashSet<AVHierarchy> hashSet4 = new HashSet<AVHierarchy>();
                        for (AVHierarchy aVHierarchy : set) {
                            AVDimensionality aVDimensionality2 = (AVDimensionality)aVHierarchy.getParent();
                            if (!aVDimensionality2.equals(aVDimensionality)) continue;
                            hashSet4.add(aVHierarchy);
                        }
                        hashSet3.addAll(hashSet4);
                        for (Object object : aVHierarchyArray) {
                            hashSet3.add(object);
                        }
                        int n2 = 0;
                        for (AVHierarchy aVHierarchy : hashSet3) {
                            Object object;
                            object = templateContext.getSchema();
                            TemplateMetadata templateMetadata = new TemplateMetadata((HCSSchema)((Object)object), aVHierarchy);
                            templateMetadata.setAV(analyticView);
                            TemplateContext templateContext3 = new TemplateContext(templateMetadata, templateContext.getProvider());
                            templateContext3.setAV(analyticView);
                            for (BaseTemplate baseTemplate : templateGroup.getTemplates()) {
                                Object object2;
                                boolean bl = true;
                                String string3 = baseTemplate.getCondition();
                                if (string3 != null) {
                                    try {
                                        object2 = StringExprParser.getParseTree(string3, attributeDimension);
                                        bl = Boolean.parseBoolean((String)object2);
                                    }
                                    catch (ParseException parseException) {
                                        LOG.log(Level.FINE, parseException.getMessage(), parseException);
                                    }
                                }
                                if (!bl) continue;
                                object2 = this.addTemplateView(baseTemplate, templateContext3, templateHyperContext, this.getTreeStyle(), templateGroup, map, this.getGlobalParamValue());
                                ((BaseTemplateHyperView)object2).putAllParamValue("dimIndex", new Integer(n).toString());
                                ((BaseTemplateHyperView)object2).putAllParamValue("hierIndex", new Integer(n2).toString());
                            }
                            ++n2;
                        }
                        ++n;
                    }
                } else if (string != null && HCSSyntaxType.DIMENSION.toString().equalsIgnoreCase(string)) {
                    AttributeDimension attributeDimension = this.getTemplateContext().getBaseDimension();
                    HCSSchema hCSSchema = templateContext.getSchema();
                    TemplateContext templateContext4 = new TemplateContext(new TemplateMetadata(hCSSchema, attributeDimension), templateContext.getProvider());
                    for (BaseTemplate baseTemplate : templateGroup.getTemplates()) {
                        boolean bl = true;
                        String string4 = baseTemplate.getCondition();
                        if (string4 != null) {
                            try {
                                String string5 = StringExprParser.getParseTree(string4, attributeDimension);
                                bl = Boolean.parseBoolean(string5);
                            }
                            catch (ParseException parseException) {
                                LOG.log(Level.FINE, parseException.getMessage(), parseException);
                            }
                        }
                        if (!bl) continue;
                        this.addTemplateView(baseTemplate, templateContext4, templateHyperContext, this.getTreeStyle(), templateGroup, map, this.getGlobalParamValue());
                    }
                }
            } else {
                for (BaseTemplate baseTemplate : templateGroup.getTemplates()) {
                    String string6;
                    boolean bl = true;
                    if (baseTemplate.getStartCondition() != null && (string6 = baseTemplate.getStartCondition()) != null) {
                        String string7 = this.evaluateStringExpr(string6);
                        bl = Boolean.parseBoolean(string7);
                    }
                    if (!bl) continue;
                    this.addTemplateView(baseTemplate, templateContext, templateHyperContext, this.getTreeStyle(), templateGroup, map, this.getGlobalParamValue());
                }
                if (templateGroup.isList() && !this.getTreeStyle()) {
                    this.addTemplateView(null, templateContext, templateHyperContext, this.getTreeStyle(), templateGroup, map, this.getGlobalParamValue());
                }
            }
        }
    }

    @Override
    public Component getNodePanel() throws SQLException, IOException {
        return super.getPanel(0);
    }

    public void addTemplateNodes(DefaultMutableTreeNode object) throws SQLException, IOException {
        this.setParentNode((DefaultMutableTreeNode)object);
        if (this.getUi() != null) {
            TemplateViewNode templateViewNode = new TemplateViewNode(this);
            ((DefaultMutableTreeNode)object).add(templateViewNode);
            object = templateViewNode;
        }
        for (BaseTemplateHyperView baseTemplateHyperView : this.getAllTemplateViews()) {
            Object object2;
            if (baseTemplateHyperView instanceof TemplateHyperView) {
                object2 = new TemplateViewNode(baseTemplateHyperView);
                ((DefaultMutableTreeNode)object).add((MutableTreeNode)object2);
            }
            if (!(baseTemplateHyperView instanceof TemplateGroupHyperView)) continue;
            object2 = (TemplateGroupHyperView)baseTemplateHyperView;
            ((TemplateGroupHyperView)object2).addTemplateNodes((DefaultMutableTreeNode)object);
        }
    }

    private BaseTemplateHyperView addTemplateView(BaseTemplate baseTemplate, TemplateContext templateContext, TemplateHyperContext templateHyperContext, boolean bl, TemplateGroup templateGroup, Map<String, String> map, ParamValue paramValue) throws SQLException, IOException {
        BaseTemplateHyperView baseTemplateHyperView = this.createTemplateView(baseTemplate, templateContext, templateHyperContext, bl, templateGroup, map, paramValue);
        if (baseTemplateHyperView != null) {
            this.templateHyperViews.add(baseTemplateHyperView);
        }
        return baseTemplateHyperView;
    }

    @Override
    public BaseTemplateHyperView addNewTemplateView(BaseTemplate baseTemplate, TemplateContext templateContext, TemplateHyperContext templateHyperContext, boolean bl, TemplateGroup templateGroup, Map<String, String> map, ParamValue paramValue) throws SQLException, IOException {
        BaseTemplateHyperView baseTemplateHyperView = this.createTemplateView(baseTemplate, templateContext, templateHyperContext, bl, templateGroup, map, paramValue);
        if (baseTemplateHyperView != null) {
            BaseTemplateHyperView baseTemplateHyperView2 = null;
            if (!bl) {
                baseTemplateHyperView2 = this.templateHyperViews.get(this.templateHyperViews.size() - 1);
                this.removeTemplateView(baseTemplateHyperView2, bl);
            }
            this.templateHyperViews.add(baseTemplateHyperView);
            if (!bl) {
                this.templateHyperViews.add(baseTemplateHyperView2);
            }
            if (!bl) {
                --this.c.gridy;
                this.addTemplateToPanel(baseTemplateHyperView);
                this.addTemplateToPanel(baseTemplateHyperView2);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TemplateGroupHyperView.this.panel.revalidate();
                        TemplateGroupHyperView.this.panel.repaint();
                    }
                });
            }
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "TEMPLATE_ADDED", null, null);
            this.propertyChange(propertyChangeEvent);
        }
        return baseTemplateHyperView;
    }

    @Override
    public BaseTemplateHyperView createTemplateView(BaseTemplate baseTemplate, TemplateContext templateContext, TemplateHyperContext templateHyperContext, boolean bl, TemplateGroup templateGroup, Map<String, String> map, ParamValue paramValue) throws SQLException, IOException {
        BaseTemplateHyperView baseTemplateHyperView = null;
        if (baseTemplate instanceof Template || baseTemplate == null) {
            Template template = (Template)baseTemplate;
            baseTemplateHyperView = new TemplateHyperView(this, templateContext, templateHyperContext, bl, template, templateGroup, map, paramValue);
        } else if (baseTemplate instanceof TemplateGroup) {
            TemplateGroup templateGroup2 = (TemplateGroup)baseTemplate;
            baseTemplateHyperView = new TemplateGroupHyperView(this, templateContext, templateHyperContext, bl, templateGroup2, map, paramValue);
        }
        if (baseTemplateHyperView != null) {
            baseTemplateHyperView.addPropertyChangeListener(this);
        }
        return baseTemplateHyperView;
    }

    @Override
    public boolean removeTemplateView(BaseTemplateHyperView baseTemplateHyperView, boolean bl) {
        boolean bl2 = this.templateHyperViews.remove(baseTemplateHyperView);
        if (!bl) {
            this.panel.remove(baseTemplateHyperView.panel);
        }
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "TEMPLATE_REMOVED", null, null);
        this.propertyChange(propertyChangeEvent);
        if (!bl) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TemplateGroupHyperView.this.panel.revalidate();
                    TemplateGroupHyperView.this.panel.repaint();
                }
            });
        }
        return bl2;
    }

    @Override
    public String getName() {
        return this.getTemplateGroup().getName();
    }

    @Override
    public TemplateList getTemplateList() {
        return this.getTemplateGroup().getTemplateList();
    }

    public String getLocalizedName() {
        if (this.getTemplateHyperContext().getResources() != null && this.getTemplateList() != null) {
            return this.getTemplateHyperContext().getResources().getXLIFFResource(this.getTemplateList().getFileName(), this.getTemplateGroup().getName());
        }
        return this.getTemplateGroup().getName();
    }

    public List<TemplateHyperView> getTemplateViews() throws SQLException, IOException {
        this.init(null);
        ArrayList<TemplateHyperView> arrayList = new ArrayList<TemplateHyperView>();
        for (BaseTemplateHyperView baseTemplateHyperView : this.templateHyperViews) {
            if (!(baseTemplateHyperView instanceof TemplateHyperView)) continue;
            arrayList.add((TemplateHyperView)baseTemplateHyperView);
        }
        return arrayList;
    }

    public List<BaseTemplateHyperView> getAllTemplateViews() throws SQLException, IOException {
        this.init(null);
        if (this.templateHyperViews == null) {
            return Collections.emptyList();
        }
        return this.templateHyperViews;
    }

    @Override
    public void putGlobalAllParamValue(String string, String string2) {
        for (BaseTemplateHyperView baseTemplateHyperView : this.templateHyperViews) {
            this.putAllParamValue(string, string2);
            baseTemplateHyperView.putGlobalAllParamValue(string, string2);
        }
    }

    public void setHierarchy(String string) throws SQLException, IOException {
        TemplateHyperParam templateHyperParam = this.getHyperParamForType(HIERARCHY);
        if (templateHyperParam != null && templateHyperParam instanceof TemplateHyperParamHierarchy) {
            TemplateHyperParamHierarchy templateHyperParamHierarchy = (TemplateHyperParamHierarchy)templateHyperParam;
            templateHyperParamHierarchy.setValue(string);
        }
    }

    @Override
    protected int indexOf(BaseTemplateHyperView baseTemplateHyperView) {
        return this.templateHyperViews.indexOf(baseTemplateHyperView);
    }

    @Override
    protected String getUi() {
        return this.getTemplateGroup().getUi();
    }

    @Override
    protected Object getTemplateValue(String string) throws SQLException, IOException {
        Object object;
        String string2 = this.getTemplate().getName();
        if (string2.equals(string) && (object = this.getExpression()) == null) {
            ArrayList<BaseTemplateHyperView> arrayList = new ArrayList<BaseTemplateHyperView>();
            for (BaseTemplateHyperView baseTemplateHyperView : this.templateHyperViews) {
                if (baseTemplateHyperView.getExpression() == null) continue;
                arrayList.add(baseTemplateHyperView);
            }
            if (arrayList.size() == 0) {
                arrayList = null;
            }
            return arrayList;
        }
        for (BaseTemplateHyperView baseTemplateHyperView : this.templateHyperViews) {
            Object object2 = baseTemplateHyperView.getTemplateValue(string);
            if (object2 == null) continue;
            return object2;
        }
        return null;
    }

    @Override
    protected Object getAllParamValue(String string) {
        Object object = super.getAllParamValue(string);
        if (object == null) {
            for (BaseTemplateHyperView baseTemplateHyperView : this.templateHyperViews) {
                object = baseTemplateHyperView.getAllParamValue(string);
                if (object != null) continue;
                return object;
            }
        }
        return object;
    }

    @Override
    public int getSelectedCount() {
        if (this.getUi() == null) {
            int n = 0;
            for (BaseTemplateHyperView baseTemplateHyperView : this.templateHyperViews) {
                n += baseTemplateHyperView.getSelectedCount();
            }
            return n;
        }
        return super.getSelectedCount();
    }

    @Override
    public String getExpression() throws SQLException, IOException {
        String string = this.getTemplateGroup().getExpression();
        return this.getExpression(string);
    }

    public String getExpression(String string) throws SQLException, IOException {
        this.clearAllParamValues();
        this.buildExpressionMap(this);
        String string2 = this.getExpression(string, null);
        return string2;
    }

    private void buildExpressionMap(TemplateGroupHyperView templateGroupHyperView) throws SQLException, IOException {
        for (BaseTemplateHyperView baseTemplateHyperView : templateGroupHyperView.templateHyperViews) {
            BaseTemplateHyperView baseTemplateHyperView2;
            if (baseTemplateHyperView instanceof BaseTemplateHyperView && baseTemplateHyperView.getTemplate() != null) {
                String string;
                baseTemplateHyperView2 = baseTemplateHyperView;
                String string2 = baseTemplateHyperView.getName();
                String string3 = baseTemplateHyperView.getExpression();
                this.currentParameterValues.put(string2, string3);
                this.putAllParamValue(string2, string3);
                for (TemplateHyperParam templateHyperParam : baseTemplateHyperView2.getHyperParams()) {
                    if (!(templateHyperParam instanceof TemplateHyperParamList)) continue;
                    Object object = (TemplateHyperParamList)templateHyperParam;
                    string = ((TemplateHyperParam)object).getName();
                    String string4 = ((TemplateHyperParamList)object).getExpression();
                    this.putAllParamValue(string, string4);
                }
                Map<String, String> map = baseTemplateHyperView2.getTemplateExpressions();
                for (Object object : map.keySet()) {
                    string = (String)map.get(object);
                    this.putAllParamValue((String)object, string);
                }
            }
            if (!(baseTemplateHyperView instanceof TemplateGroupHyperView)) continue;
            baseTemplateHyperView2 = (TemplateGroupHyperView)baseTemplateHyperView;
            this.buildExpressionMap((TemplateGroupHyperView)baseTemplateHyperView2);
        }
    }

    @Override
    public boolean setupTemplateHyperParamDependencies(List<TemplateHyperParam> list) {
        boolean bl = false;
        for (TemplateHyperParam templateHyperParam : this.getHyperParams()) {
            bl = templateHyperParam.setUpDependencies(list);
            if (!(templateHyperParam instanceof TemplateHyperParamCombo)) continue;
            TemplateHyperParamCombo templateHyperParamCombo = (TemplateHyperParamCombo)templateHyperParam;
            templateHyperParamCombo.firePropertyChangeEvent();
        }
        return bl;
    }

    @Override
    public JPanel getPanel(int n) throws SQLException, IOException {
        this.depth = n;
        this.init(null);
        String string = this.getUi();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.c = new GridBagConstraints();
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.c.weightx = 1.0;
        this.c.weighty = 1.0;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.fill = 1;
        this.c.anchor = 17;
        this.c.insets = new Insets(0, 0, 0, 0);
        this.c.ipadx = 0;
        this.c.ipady = 0;
        if (string != null) {
            JPanel jPanel2;
            this.panel = jPanel2 = super.getPanel(n);
            jPanel.add((Component)jPanel2, this.c);
            ++this.c.gridy;
            ++n;
        }
        boolean bl = false;
        boolean bl2 = this.getTemplateGroup().isOrdered();
        JPanel[] jPanelArray = new JPanel[this.templateHyperViews.size()];
        int n2 = 0;
        for (BaseTemplateHyperView baseTemplateHyperView : this.templateHyperViews) {
            JPanel jPanel3 = baseTemplateHyperView.getPanel(n);
            ComponentAdapter componentAdapter = new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                }
            };
            if (jPanel3 != null) {
                JPanel jPanel4 = new JPanel(new BorderLayout(0, 0));
                jPanel4.setName("TEMPLATEGUI_CONTAINER");
                jPanel4.add(jPanel3);
                jPanel3.addComponentListener(componentAdapter);
                bl = true;
                this.c.insets.left = n * 20;
                if (bl2) {
                    JPanel jPanel5 = new JPanel();
                    jPanel5.setLayout(new BoxLayout(jPanel5, 0));
                    JLabel jLabel = new JLabel(OracleIcons.getIcon((String)"up.png"));
                    jLabel.addMouseListener(new ArrowClickHandler(n2, -1, jPanelArray, jPanel));
                    jPanel5.add(jLabel);
                    JLabel jLabel2 = new JLabel(OracleIcons.getIcon((String)"down.png"));
                    jLabel2.addMouseListener(new ArrowClickHandler(n2, 1, jPanelArray, jPanel));
                    jPanel5.add(jLabel2);
                    JPanel jPanel6 = new JPanel(new BorderLayout());
                    jPanel6.add((Component)jPanel5, "West");
                    jPanel6.add((Component)jPanel4, "Center");
                    jPanel6.add(Box.createVerticalStrut(3), "South");
                    jPanel.add((Component)jPanel6, this.c);
                } else {
                    jPanel.add((Component)jPanel3, this.c);
                }
                jPanelArray[n2++] = jPanel3;
                ++this.c.gridy;
            }
            if (!bl) continue;
            this.panel = jPanel;
        }
        return this.panel;
    }

    private void addTemplateToPanel(BaseTemplateHyperView baseTemplateHyperView) throws SQLException, IOException {
        JPanel jPanel = baseTemplateHyperView.getPanel(this.depth);
        if (jPanel != null) {
            this.c.insets.left = this.depth * 20;
            this.panel.add((Component)jPanel, this.c);
            ++this.c.gridy;
        }
    }

    private class ArrowClickHandler
    extends MouseAdapter {
        private final JPanel parent;
        private final int direction;
        private int index;
        private JPanel[] panels;

        ArrowClickHandler(int n, int n2, JPanel[] jPanelArray, JPanel jPanel) {
            this.index = n;
            this.direction = n2;
            this.panels = jPanelArray;
            this.parent = jPanel;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            int n = this.index + this.direction;
            if (n >= 0 && n < TemplateGroupHyperView.this.templateHyperViews.size()) {
                BaseTemplateHyperView baseTemplateHyperView = (BaseTemplateHyperView)TemplateGroupHyperView.this.templateHyperViews.get(n);
                JPanel jPanel = this.panels[n];
                JPanel jPanel2 = (JPanel)jPanel.getParent();
                BaseTemplateHyperView baseTemplateHyperView2 = (BaseTemplateHyperView)TemplateGroupHyperView.this.templateHyperViews.get(this.index);
                JPanel jPanel3 = this.panels[this.index];
                JPanel jPanel4 = (JPanel)jPanel3.getParent();
                TemplateGroupHyperView.this.templateHyperViews.set(this.index, baseTemplateHyperView);
                TemplateGroupHyperView.this.templateHyperViews.set(n, baseTemplateHyperView2);
                jPanel4.remove(jPanel3);
                jPanel2.remove(jPanel);
                jPanel4.add(jPanel);
                jPanel2.add(jPanel3);
                this.panels[this.index] = jPanel;
                this.panels[n] = jPanel3;
                jPanel4.validate();
                jPanel.validate();
                this.parent.revalidate();
                this.parent.getParent().revalidate();
                PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "TEMPLATE_REORDERED", null, null);
                TemplateGroupHyperView.this.propertyChange(propertyChangeEvent);
            }
        }
    }
}

