/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.templates.templateview;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import oracle.hcs.HCSArb;
import oracle.hcs.av.model.AVDimensionality;
import oracle.hcs.av.model.AVHierarchy;
import oracle.hcs.av.model.AnalyticView;
import oracle.hcs.db.model.NamedObject;
import oracle.hcs.dimension.model.AttributeDimension;
import oracle.hcs.hierarchy.model.Hierarchy;
import oracle.hcs.metadata.HCSSchema;
import oracle.hcs.syntaxbuilder.HCSSyntaxType;
import oracle.hcs.templates.syntaxparser.ParseNode;
import oracle.hcs.templates.templateview.TemplateHyperParamCombo;

public class TemplateHyperParamDimension
extends TemplateHyperParamCombo {
    private static final Logger LOG = Logger.getLogger(TemplateHyperParamDimension.class.getName());
    private static final String RESERVED_WORD_TIME = "TIME";
    private static final String DEFAULT_NAME = "dimension";
    private static final ParseNode pattern = new ParseNode("dimension", HCSSyntaxType.DIMENSION.toString(), ParseNode.PatternType.NONE);

    public TemplateHyperParamDimension() {
        this.setName(DEFAULT_NAME);
        final ListCellRenderer listCellRenderer = this.hyperCombo.getRenderer();
        this.hyperCombo.setRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                if (object != null && object instanceof AttributeDimension) {
                    AttributeDimension attributeDimension = (AttributeDimension)object;
                    object = attributeDimension.getName();
                } else if (object != null && object instanceof AVDimensionality) {
                    AVDimensionality aVDimensionality = (AVDimensionality)object;
                    object = aVDimensionality.getDimensionAlias();
                }
                return listCellRenderer.getListCellRendererComponent(jList, object, n, bl, bl2);
            }
        });
    }

    @Override
    public String getErrorMessage() {
        return HCSArb.getString("EXPRESSION_EDITOR_ERROR_NO_DIMENSION");
    }

    @Override
    public ParseNode getPattern() {
        return pattern;
    }

    @Override
    public void init() {
        Object object;
        AnalyticView analyticView = this.getTemplateContext().getAV();
        if (analyticView != null) {
            object = this.getTemplateContext().getBaseDimensionality();
            ArrayList<AVDimensionality> arrayList = new ArrayList<AVDimensionality>();
            if (object != null) {
                arrayList.add((AVDimensionality)object);
            } else {
                arrayList = Arrays.asList(analyticView.getDimensions());
            }
            this.addDimensionalities(arrayList);
        } else {
            this.addDimensions(this.getTemplateContext().getDimensions());
        }
        if (this.getComboBoxModel().getSize() > 0) {
            this.setSelectedElement(this.getComboBoxModel().getElementAt(0));
        }
        if (this.getParam() != null && (object = this.getParam().getInitialDefault()) != null) {
            this.setValue(((String)object).toUpperCase());
        }
    }

    public void addDimensions(List<AttributeDimension> list) {
        this.removeAllElements();
        for (AttributeDimension attributeDimension : list) {
            this.addElement(attributeDimension);
        }
    }

    public void addDimensionalities(List<AVDimensionality> list) {
        this.removeAllElements();
        for (AVDimensionality aVDimensionality : list) {
            this.addElement(aVDimensionality);
        }
    }

    private boolean isReadonly() {
        return this.getParam() != null && this.getParam().getContext() != null && this.getParam().getContext().equals("readonly");
    }

    @Override
    public String getExpression() {
        Object object = this.getSelectedElement();
        String string = "";
        NamedObject namedObject = null;
        if (object instanceof AttributeDimension) {
            namedObject = (AttributeDimension)object;
        } else if (object instanceof AVDimensionality) {
            namedObject = (AVDimensionality)this.getSelectedElement();
        }
        if (namedObject != null) {
            string = namedObject.getName();
        }
        if (string.equalsIgnoreCase(RESERVED_WORD_TIME)) {
            string = String.format("\"%s\"", string);
        }
        return string;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        boolean bl;
        if ("VALUE_CHANGED".equals(propertyChangeEvent.getPropertyName()) && propertyChangeEvent.getNewValue() instanceof Hierarchy) {
            Hierarchy hierarchy = (Hierarchy)propertyChangeEvent.getNewValue();
            HCSSchema hCSSchema = (HCSSchema)hierarchy.getSchema();
            String string = hierarchy.getDimensionName();
            AttributeDimension attributeDimension = hCSSchema.findDimension(string);
            AttributeDimension attributeDimension2 = (AttributeDimension)this.getValue();
            this.setSelectedDimension(attributeDimension, attributeDimension2, propertyChangeEvent);
        } else if ("VALUE_CHANGED".equals(propertyChangeEvent.getPropertyName()) && propertyChangeEvent.getNewValue() instanceof AVHierarchy) {
            AVDimensionality aVDimensionality;
            AVHierarchy aVHierarchy = (AVHierarchy)propertyChangeEvent.getNewValue();
            AVDimensionality aVDimensionality2 = aVDimensionality = (AVDimensionality)aVHierarchy.getParent();
            AVDimensionality aVDimensionality3 = (AVDimensionality)this.getValue();
            this.setSelectedDimension(aVDimensionality2, aVDimensionality3, propertyChangeEvent);
        } else if ("VALID_PROPERTY".equals(propertyChangeEvent.getPropertyName()) && !(bl = ((Boolean)propertyChangeEvent.getNewValue()).booleanValue())) {
            this.removeElement(this.getSelectedElement());
            if (this.getComboBoxModel().getSize() > 0) {
                this.setSelectedElement(this.getComboBoxModel().getElementAt(0));
            }
        }
    }

    private void setSelectedDimension(NamedObject namedObject, NamedObject namedObject2, PropertyChangeEvent propertyChangeEvent) {
        String string = null;
        if (!namedObject.equals(namedObject2)) {
            if (namedObject2 != null) {
                string = namedObject2.getName();
            }
            LOG.finest(String.format("updating dimension [new,old,source] [%s,%s,%s]", namedObject.getName(), string, propertyChangeEvent.getSource()));
            this.setSelectedElement(namedObject);
        }
    }

    @Override
    public boolean setValue(Object object) {
        if (object instanceof ParseNode) {
            Object object2;
            ParseNode parseNode = (ParseNode)object;
            String string = this.stripSchema(parseNode.getValue(), this.getTemplateContext().getSchema().getName());
            if (string.charAt(0) == '\"') {
                string = string.substring(1, string.length() - 1);
            }
            if ((object2 = this.getSelectedElement()) instanceof AttributeDimension) {
                AttributeDimension attributeDimension = (AttributeDimension)this.getSelectedElement();
                ArrayList<NamedObject> arrayList = new ArrayList<NamedObject>(this.getTemplateContext().getDimensions());
                object = this.addSelectedDimension(attributeDimension, string, arrayList);
            } else if (object2 instanceof AVDimensionality) {
                AVDimensionality aVDimensionality = (AVDimensionality)this.getSelectedElement();
                ArrayList<NamedObject> arrayList = new ArrayList<NamedObject>(Arrays.asList(this.getTemplateContext().getAV().getDimensions()));
                object = this.addSelectedDimension(aVDimensionality, string, arrayList);
            }
        }
        return super.setValue(object);
    }

    private Object addSelectedDimension(NamedObject namedObject, String string, List<NamedObject> list) {
        NamedObject namedObject2 = null;
        if (namedObject.getName().equals(string)) {
            return false;
        }
        for (NamedObject namedObject3 : list) {
            if (!namedObject3.getName().equals(string)) continue;
            namedObject2 = namedObject3;
            break;
        }
        if (this.isReadonly()) {
            this.removeAllElements();
            this.addElement(namedObject2);
        }
        return namedObject2;
    }
}

