/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.inspector.editors;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellEditor;
import oracle.bali.ewt.dateEditor.DateEditor;
import oracle.bali.inspector.PropertyEditorAdapter;
import oracle.bali.inspector.editor.EditorComponentInfo;
import oracle.bali.inspector.editor.MappedEditorFactoryInfo;
import oracle.bali.xml.gui.base.inspector.editors.EditorUtils;
import oracle.bali.xml.gui.swing.inspector.editorFactories.DateFieldEditorConfig;
import oracle.bali.xml.gui.swing.inspector.editorFactories.DateFieldEditorFactory;

public class InlineDateEditor
extends PropertyEditorAdapter
implements PropertyEditor {
    private final DateTableCellEditor _dateTableCellEditor;
    private final DateFormat _componentDateFormat;
    private final DateFormat _displayDateFormat = SimpleDateFormat.getDateInstance(2);
    private DateEditor _dateEditor;
    private String _datePattern;

    public InlineDateEditor(String datePattern) {
        super(PropertyEditorManager.findEditor(String.class));
        this._datePattern = datePattern;
        this._componentDateFormat = new SimpleDateFormat(datePattern);
        this._dateTableCellEditor = new DateTableCellEditor(this._componentDateFormat, this._displayDateFormat);
    }

    public boolean hasInPlaceEditor() {
        return true;
    }

    public TableCellEditor getInPlaceEditor(Locale locale) {
        Date parsedDate;
        try {
            parsedDate = this._componentDateFormat.parse(this.getAsText());
        }
        catch (ParseException e) {
            if ("".equals(this.getAsText())) {
                parsedDate = new Date();
            }
            return super.getInPlaceEditor(locale);
        }
        this._dateTableCellEditor.setValue(parsedDate);
        return this._dateTableCellEditor;
    }

    @Override
    public Object getValue() {
        return this.getPropertyEditor().getValue();
    }

    @Override
    public String getAsText() {
        return this.getPropertyEditor().getAsText();
    }

    @Override
    public Component getCustomEditor() {
        return this.getAdvancedEditor();
    }

    @Override
    public String getJavaInitializationString() {
        return this.getPropertyEditor().getJavaInitializationString();
    }

    @Override
    public String[] getTags() {
        return this.getPropertyEditor().getTags();
    }

    @Override
    public boolean isPaintable() {
        return this.getPropertyEditor().isPaintable();
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
        this.getPropertyEditor().paintValue(gfx, box);
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        this.getPropertyEditor().setAsText(text);
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            value = "";
        }
        this.getPropertyEditor().setValue(value);
    }

    @Override
    public boolean supportsCustomEditor() {
        return false;
    }

    public EditorComponentInfo getEditorComponentInfo() {
        if (InlineDateEditor.getFieldEditorFactory() == null) {
            return null;
        }
        DateFieldEditorConfig dfec = DateFieldEditorConfig.createDateFieldEditorConfig(this._datePattern, this._displayDateFormat);
        return EditorUtils.createEditorComponentInfo((String)"DATE_FIELD", (String)MappedEditorFactoryInfo.COMPONENT_CONFIG_INFO, (Object)dfec);
    }

    public DateFormat getDateFormat() {
        return this._componentDateFormat;
    }

    public static DateFieldEditorFactory getFieldEditorFactory() {
        return DateFieldEditorFactorySingleton.instance;
    }

    private static class DateFieldEditorFactorySingleton {
        private static final DateFieldEditorFactory instance = new DateFieldEditorFactory();

        private DateFieldEditorFactorySingleton() {
        }
    }

    private class DateTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private final DateEditor _dateEditor = new DateEditor();
        private final DateFormat _returnFormat;

        DateTableCellEditor(DateFormat returnFormat, DateFormat displayFormat) {
            this._dateEditor.setDateFormat(displayFormat);
            this._returnFormat = returnFormat;
            Border b = BorderFactory.createEmptyBorder();
            this._dateEditor.setBorder(b);
        }

        public void setValue(Date date) {
            this._dateEditor.setDate(date);
        }

        @Override
        public Object getCellEditorValue() {
            Date date = this._dateEditor.getDate();
            return this._returnFormat.format(date);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            return this._dateEditor;
        }
    }

    class DateEditorFocusListener
    implements FocusListener {
        DateEditorFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent evt) {
        }

        @Override
        public void focusLost(FocusEvent evt) {
            String dateString = InlineDateEditor.this._dateEditor.getDateString();
            if (dateString != null && dateString.length() > 0) {
                String prevValue = InlineDateEditor.this.getAsText();
                if (prevValue == null) {
                    InlineDateEditor.this.setAsText(dateString);
                } else if (!dateString.equals(prevValue)) {
                    InlineDateEditor.this.setAsText(dateString);
                }
            }
        }
    }
}

