/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.animation.timing.interpolation;

import java.lang.reflect.Method;
import org.jdesktop.animation.timing.interpolation.KeyValues;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class KeyValuesDouble
extends KeyValues<Double> {
    public KeyValuesDouble(double ... values) {
        super(values);
        for (double value : values) {
            this.values.add(value);
        }
    }

    @Override
    public Class<?> getType() {
        return Double.TYPE;
    }

    @Override
    public void setValue(Object object, Method method, int i0, int i1, float fraction) {
        double value;
        if (i0 == i1) {
            value = (Double)this.values.get(i0);
        } else {
            double v0 = (Double)this.values.get(i0);
            double v1 = (Double)this.values.get(i1);
            value = v0 + (v1 - v0) * (double)fraction;
        }
        try {
            method.invoke(object, value);
        }
        catch (Exception e) {
            System.out.println("Problem invoking method in KVDouble.setValue:" + e);
        }
    }

    @Override
    public void setValue(Object object, Method method, int index) {
        try {
            method.invoke(object, this.values.get(index));
        }
        catch (Exception e) {
            System.out.println("Problem invoking method in KVDouble.setValue:" + e);
        }
    }
}

