/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.parser.tsql;

import java.util.HashMap;
import oracle.dbtools.migration.parser.defaults.DefaultVariabletNameTranslator;
import oracle.dbtools.migration.parser.defaults.TranslatorPreferencesProvider;
import oracle.dbtools.migration.workbench.core.preferences.ConfigurationData;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;

public class TSQLVariableNameTranslator
extends DefaultVariabletNameTranslator {
    public static final String IDENTIFIER_SEPARATOR = ".";
    public static final String VARIABLE_PREFIX = "@";
    public static final String BRACKET_DELIMITER = "[]";
    public static final String ORACLE_QUOTED_DELIMITER = "\"";
    public static String PREPEND_VAR = "v_";
    public HashMap<String, String> variableNameMap = new HashMap();

    public String translateVariableName(String string) {
        if (this.variableNameMap.containsKey(string)) {
            return this.variableNameMap.get(string);
        }
        String string2 = this.translateToVarFormat(string);
        String string3 = this.prefixVarName(string2);
        string2 = string3 != null ? string3 : PREPEND_VAR + string2;
        string2 = this.collisionManage(string2);
        string2 = string2 != null ? string2 : PREPEND_VAR + string;
        this.variableNameMap.put(string, string2);
        return string2;
    }

    private String collisionManage(String string) {
        int n = 1;
        if (this.variableNameMap.containsValue(string)) {
            String string2 = string.substring(0, TranslatorPreferencesProvider.getPreferences().getIdentifierMaxLength() - ("" + n).length()) + "" + n;
            while (this.variableNameMap.containsValue(string2)) {
                string2 = string.substring(0, TranslatorPreferencesProvider.getPreferences().getIdentifierMaxLength() - ("" + ++n).length()) + "" + n;
            }
            return string2;
        }
        return string;
    }

    private String translateToVarFormat(String string) {
        String string2 = string = string.trim().startsWith(VARIABLE_PREFIX) ? string.trim().substring(1) : string.trim();
        if (string.length() > TranslatorPreferencesProvider.getPreferences().getIdentifierMaxLength()) {
            string = string.substring(0, TranslatorPreferencesProvider.getPreferences().getIdentifierMaxLength());
        }
        return string;
    }

    public String translateAliasName(String string) {
        if (string.trim().startsWith("'") && string.trim().endsWith("'")) {
            string = string.trim().substring(1, string.trim().length() - 1);
        }
        return this.translateIdentifierName(string);
    }

    public String translateInParamName(String string) {
        string = this.translateToVarFormat(string);
        return this.prefixInParamName(string);
    }

    public String prefixVarName(String string) {
        Preferences preferences = null;
        try {
            preferences = Preferences.getPreferences();
        }
        catch (Exception exception) {
            return null;
        }
        catch (Error error) {
            return null;
        }
        ConfigurationData configurationData = ConfigurationData.getInstance((PropertyStorage)preferences);
        String string2 = configurationData.getVarPrefix() + string;
        int n = string2.length();
        if (n > TranslatorPreferencesProvider.getPreferences().getIdentifierMaxLength()) {
            string2 = configurationData.getVarPrefix() + string.substring(0, TranslatorPreferencesProvider.getPreferences().getIdentifierMaxLength() - configurationData.getVarPrefix().length());
        }
        return string2;
    }

    public String prefixInParamName(String string) {
        Preferences preferences = null;
        try {
            preferences = Preferences.getPreferences();
        }
        catch (Exception exception) {
            return null;
        }
        catch (Error error) {
            return null;
        }
        ConfigurationData configurationData = ConfigurationData.getInstance((PropertyStorage)preferences);
        String string2 = configurationData.getVarPrefix() + string;
        int n = string2.length();
        if (n > TranslatorPreferencesProvider.getPreferences().getIdentifierMaxLength()) {
            string2 = configurationData.getInParamPrefix() + string.substring(0, TranslatorPreferencesProvider.getPreferences().getIdentifierMaxLength() - configurationData.getVarPrefix().length());
        }
        return string2;
    }

    public String getEmulationPackageName() {
        return "utils";
    }
}

