/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.common;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class JsonUtils {
    protected static final ObjectMapper mapper = new ObjectMapper();
    protected static final ObjectWriter writer = JsonUtils.createWriter(false);
    protected static final ObjectWriter prettyWriter = JsonUtils.createWriter(true);
    private static final String HEX = "0123456789ABCDEF";

    public static JsonParser createJsonParser(Reader reader) throws IOException {
        return JsonUtils.enableFeatures(mapper.getFactory().createParser(reader));
    }

    public static JsonParser createJsonParser(InputStream inputStream) throws IOException {
        return JsonUtils.enableFeatures(mapper.getFactory().createParser(inputStream));
    }

    private static JsonParser enableFeatures(JsonParser jsonParser) {
        jsonParser.enable(JsonParser.Feature.ALLOW_NUMERIC_LEADING_ZEROS);
        return jsonParser.enable(JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS);
    }

    public static ObjectNode createObjectNode() {
        return mapper.createObjectNode();
    }

    public static ArrayNode createArrayNode() {
        return mapper.createArrayNode();
    }

    public static ObjectWriter createWriter(boolean bl) {
        return bl ? mapper.writerWithDefaultPrettyPrinter() : mapper.writer();
    }

    public static String print(Object object) {
        try {
            return writer.writeValueAsString(object);
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new IllegalArgumentException("Unable to print object to String: " + object + ": " + jsonProcessingException);
        }
    }

    public static ObjectWriter getWriter(boolean bl) {
        return bl ? prettyWriter : writer;
    }

    public static String prettyPrint(Object object) {
        return JsonUtils.print(object, true);
    }

    public static String print(Object object, boolean bl) {
        try {
            return JsonUtils.getWriter(bl).writeValueAsString(object);
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new IllegalArgumentException("Unable to print object to String: " + object + ", error: " + jsonProcessingException);
        }
    }

    public static String getAsText(JsonNode jsonNode, String string) {
        return JsonUtils.getAsText(jsonNode, string, null);
    }

    public static String getAsText(JsonNode jsonNode, String string, String string2) {
        JsonNode jsonNode2 = jsonNode.get(string);
        if (jsonNode2 == null || !jsonNode2.isValueNode()) {
            return string2;
        }
        return jsonNode2.asText();
    }

    public static Long getLong(JsonNode jsonNode, String string) {
        JsonNode jsonNode2 = jsonNode.get(string);
        if (jsonNode2 == null || !jsonNode2.isLong()) {
            return null;
        }
        return jsonNode2.longValue();
    }

    public static Integer getInt(JsonNode jsonNode, String string) {
        JsonNode jsonNode2 = jsonNode.get(string);
        if (jsonNode2 == null || !jsonNode2.isInt()) {
            return null;
        }
        return jsonNode2.intValue();
    }

    public static Double getDouble(JsonNode jsonNode, String string) {
        JsonNode jsonNode2 = jsonNode.get(string);
        if (jsonNode2 == null || !jsonNode2.isDouble()) {
            return null;
        }
        return jsonNode2.doubleValue();
    }

    public static Boolean getBoolean(JsonNode jsonNode, String string) {
        JsonNode jsonNode2 = jsonNode.get(string);
        if (jsonNode2 == null || !jsonNode2.isBoolean()) {
            return null;
        }
        return jsonNode2.booleanValue();
    }

    public static boolean getBoolean(JsonNode jsonNode, String string, boolean bl) {
        JsonNode jsonNode2 = jsonNode.get(string);
        if (jsonNode2 == null || !jsonNode2.isBoolean()) {
            return bl;
        }
        return jsonNode2.booleanValue();
    }

    public static ObjectNode getObject(JsonNode jsonNode, String string) {
        JsonNode jsonNode2 = jsonNode.get(string);
        if (jsonNode2 == null || !jsonNode2.isObject()) {
            return null;
        }
        return (ObjectNode)jsonNode2;
    }

    public static Iterable<JsonNode> getArray(JsonNode jsonNode, String string) {
        JsonNode jsonNode2 = jsonNode.get(string);
        if (jsonNode2 == null || !jsonNode2.isArray()) {
            return Collections.emptyList();
        }
        return jsonNode2;
    }

    public static boolean jsonStringsEqual(String string, String string2) {
        Map<String, Object> map = JsonUtils.getMapFromJsonStr(string);
        Map<String, Object> map2 = JsonUtils.getMapFromJsonStr(string2);
        if (map == null) {
            return false;
        }
        return map.equals(map2);
    }

    public static Map<String, Object> getMapFromJsonStr(String string) {
        try {
            return mapper.readValue(string, HashMap.class);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static ObjectMapper getObjectMapper() {
        return mapper;
    }

    public static String convertBytesToHex(byte[] byArray) {
        char[] cArray = new char[byArray.length * 2];
        char[] cArray2 = HEX.toCharArray();
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i] & 0xFF;
            cArray[i * 2 + 1] = cArray2[n & 0xF];
            cArray[i * 2] = cArray2[n >> 4];
        }
        return new String(cArray);
    }

    public static byte[] convertHexToBytes(String string) {
        if (string.length() % 2 != 0) {
            throw new IllegalArgumentException("Invalid hex string length");
        }
        byte[] byArray = new byte[string.length() / 2];
        int n = string.length();
        for (int i = 0; i < n; i += 2) {
            int n2 = HEX.indexOf(string.charAt(i));
            int n3 = HEX.indexOf(string.charAt(i + 1));
            byArray[i / 2] = (byte)(n2 << 4 | n3);
        }
        return byArray;
    }

    public static <T> T readValue(String string, Class<T> clazz) throws IOException {
        return mapper.readValue(string, clazz);
    }

    public static <T> T readValue(InputStream inputStream, Class<T> clazz) throws IOException {
        return mapper.readValue(inputStream, clazz);
    }

    public static JsonNode readFromFile(String string) {
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(string);
            JsonNode jsonNode = mapper.readTree(fileReader);
            return jsonNode;
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Unable to read JSON from file: " + string + ": " + iOException);
        }
        finally {
            if (fileReader != null) {
                try {
                    fileReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static String encodeBase64(byte[] byArray) {
        return mapper.convertValue((Object)byArray, String.class);
    }

    public static byte[] decodeBase64(String string) {
        return mapper.convertValue((Object)string, byte[].class);
    }

    public static JsonNode createJsonNode(String string) {
        try {
            return mapper.readTree(string);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Unable to create JsonNode from string: " + string);
        }
    }

    public static JsonNode createJsonNode(InputStream inputStream) throws IOException {
        return mapper.readTree(inputStream);
    }
}

