/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphlayout.labellayout.annealing.beans.editor;

import ilog.views.IlvPoint;
import java.beans.PropertyEditorSupport;
import java.util.StringTokenizer;
import java.util.Vector;

public class IlvPointArrayEditor
extends PropertyEditorSupport {
    @Override
    public String getJavaInitializationString() {
        IlvPoint[] ilvPointArray = (IlvPoint[])this.getValue();
        if (ilvPointArray == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("new ilog.views.IlvPoint[] {");
        for (int i = 0; i < ilvPointArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(',');
            }
            if (ilvPointArray[i].x == 0.0f && ilvPointArray[i].y == 0.0f) {
                stringBuffer.append("new ilog.views.IlvPoint()");
                continue;
            }
            stringBuffer.append("new ilog.views.IlvPoint((float)" + ilvPointArray[i].x + "," + "(float)" + ilvPointArray[i].y + ")");
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    @Override
    public String getAsText() {
        IlvPoint[] ilvPointArray = (IlvPoint[])this.getValue();
        if (ilvPointArray == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer(128);
        for (int i = 0; i < ilvPointArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append('(');
            stringBuffer.append("" + ilvPointArray[i].x);
            stringBuffer.append(',');
            stringBuffer.append("" + ilvPointArray[i].y);
            stringBuffer.append(')');
        }
        return stringBuffer.toString();
    }

    @Override
    public void setAsText(String string) throws IllegalArgumentException {
        Object[] objectArray;
        if (string.trim().equals("null")) {
            this.setValue(null);
            return;
        }
        Vector<IlvPoint> vector = new Vector<IlvPoint>();
        float[] fArray = new float[2];
        int n = 4;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",()", true);
        while (stringTokenizer.hasMoreTokens()) {
            objectArray = stringTokenizer.nextToken().trim();
            if (objectArray.equals(",")) {
                ++n;
                continue;
            }
            if (objectArray.equals("(")) {
                n = 0;
                fArray[1] = 0.0f;
                fArray[0] = 0.0f;
                continue;
            }
            if (objectArray.equals(")")) {
                vector.addElement(new IlvPoint(fArray[0], fArray[1]));
                n = 3;
                continue;
            }
            if (objectArray.length() <= 0) continue;
            if (n == 0 || n == 1) {
                try {
                    fArray[n] = Float.parseFloat((String)objectArray);
                    continue;
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException("invalid point array:" + string);
                }
            }
            throw new IllegalArgumentException("invalid point array:" + string);
        }
        objectArray = new IlvPoint[vector.size()];
        vector.copyInto(objectArray);
        this.setValue(objectArray);
    }
}

