/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.symbol.compiler;

import com.sun.tools.javac.Main;
import ilog.views.IlvGraphic;
import ilog.views.graphic.IlvIcon;
import ilog.views.symbol.compiler.IlvScUtilities;
import ilog.views.symbol.compiler.IlvSymbolCompilerException;
import ilog.views.symbol.compiler.ScAbstractValueWriter;
import ilog.views.symbol.compiler.ScBeanInfo;
import ilog.views.symbol.compiler.ScExpression;
import ilog.views.symbol.compiler.ScRuleBean;
import ilog.views.symbol.compiler.ScSymbol;
import ilog.views.symbol.compiler.ScValueWriter;
import ilog.views.symbol.compiler.SymbolSorter;
import ilog.views.symbology.palettes.IlvPalette;
import ilog.views.symbology.palettes.IlvPaletteManager;
import ilog.views.symbology.palettes.IlvPaletteSymbol;
import ilog.views.symbology.palettes.internal.palettejar.Handler;
import ilog.views.util.css.parser.Rule;
import java.awt.Color;
import java.awt.Font;
import java.beans.PropertyEditor;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IlvSymbolCompiler
extends IlvScUtilities {
    private IlvPaletteManager a;
    private Hashtable<String, String> b;
    private Hashtable<String, ScValueWriter> c;
    private Hashtable<String, ArrayList<ClassValueWriter>> d;
    private DefaultWriter e;
    private Logger f;
    private String g;
    private String h = "Parameter";
    private boolean i = true;
    private boolean j = true;
    private boolean k = true;
    private boolean l = true;
    private boolean m = false;
    private boolean n = true;
    boolean o = false;
    boolean p = false;
    private static ArrayList<File> q = null;
    private static final String r = "1.0";

    public IlvSymbolCompiler() {
        this(new IlvPaletteManager());
    }

    public IlvSymbolCompiler(IlvPaletteManager ilvPaletteManager) {
        this.setPaletteManager(ilvPaletteManager);
        this.b = new Hashtable();
        this.c();
        this.mapClass("ilog.views.sdm.graphic.IlvSDMCompositeNode", "ilog.views.graphic.composite.IlvCompositeGraphic");
        this.mapClass("ilog.views.symbology.interactor.IlvPushSymbolInteractor", "ilog.views.symbol.util.interactor.IlvCompiledSymbolPushInteractor");
        this.mapClass("ilog.views.symbology.interactor.IlvDiscreteSymbolInteractor", "ilog.views.symbol.util.interactor.IlvCompiledSymbolDiscreteInteractor");
        this.mapClass("ilog.views.symbology.interactor.IlvRotationSymbolInteractor", "ilog.views.symbol.util.interactor.IlvCompiledSymbolRotationInteractor");
        this.mapClass("ilog.views.symbology.interactor.IlvHorizontalSymbolInteractor", "ilog.views.symbol.util.interactor.IlvCompiledSymbolHorizontalInteractor");
        this.mapClass("ilog.views.symbology.interactor.IlvVerticalSymbolInteractor", "ilog.views.symbol.util.interactor.IlvCompiledSymbolVerticalInteractor");
        Handler.installHandler();
    }

    private void c() {
        FloatWriter floatWriter = new FloatWriter();
        this.c = new Hashtable();
        StringWriter stringWriter = new StringWriter();
        this.a("string", stringWriter);
        this.a("int", new IntWriter());
        this.a("short", new ShortWriter());
        this.a("float", floatWriter);
        this.a("double", new DoubleWriter());
        this.a("boolean", new BooleanWriter());
        this.a("java.lang.Object", new ObjectWriter());
        this.a("java.lang.String", stringWriter);
        this.a("java.awt.geom.Point2D", new Constructor2ArgsWriter("java.awt.geom.Point2D.Double", null));
        this.a("ilog.views.IlvPoint", new Constructor2ArgsWriter("ilog.views.IlvPoint", "(float) "));
        this.a("ilog.views.graphic.composite.layout.IlvAttachmentLocation", new AttachmentLocationWriter());
        this.a("java.awt.Font", new FontWriter());
        this.a("java.awt.geom.AffineTransform", new AffineTransformWriter());
        ColorWriter colorWriter = new ColorWriter();
        this.a("java.awt.Color", colorWriter);
        this.a("java.awt.Paint", colorWriter);
        this.a("java.awt.Shape", new ShapeWriter());
        this.a("ilog.views.IlvRect", new RectWriter());
        this.a("java.awt.Insets", new InsetsWriter());
        this.a("java.net.URL", new URLWriter());
        this.d = new Hashtable();
        this.a("imageLocation", IlvIcon.class, new URLStringWriter());
        try {
            Class<?> clazz = Class.forName("ilog.views.sdm.graphic.IlvURLGraphic");
            this.a("URL", clazz, new URLStringWriter());
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        this.a("x", IlvGraphic.class, floatWriter);
        this.a("y", IlvGraphic.class, floatWriter);
        this.a("width", IlvGraphic.class, floatWriter);
        this.a("float", IlvGraphic.class, floatWriter);
    }

    public void setPaletteManager(IlvPaletteManager ilvPaletteManager) {
        this.a = ilvPaletteManager;
    }

    public IlvPaletteManager getPaletteManager() {
        return this.a;
    }

    public ClassLoader getClassLoader() {
        return this.a.getClassLoader();
    }

    public void compilePalette(IlvPalette ilvPalette, String string, String string2, String string3) throws IlvSymbolCompilerException, IOException {
        ArrayList<IlvPaletteSymbol> arrayList = IlvScUtilities.a(ilvPalette);
        this.compileSymbols(arrayList, string, string2, string3);
    }

    public void compileSymbols(ArrayList<IlvPaletteSymbol> arrayList, String string, String string2, String string3) throws IlvSymbolCompilerException, IOException {
        this.a(arrayList, string, string2, string3, null);
    }

    void a(ArrayList<IlvPaletteSymbol> arrayList, String string, String string2, String string3, ProgressListener progressListener) throws IlvSymbolCompilerException, IOException {
        SymbolSorter symbolSorter = new SymbolSorter(this);
        ArrayList<IlvPaletteSymbol> arrayList2 = symbolSorter.a(arrayList);
        String string4 = string3.replace('\\', '/');
        if (!string4.endsWith("/")) {
            string4 = string4 + "/";
        }
        IlvScUtilities.p(string4);
        this.a(string4);
        String[] stringArray = new String[6];
        int n = 0;
        int n2 = n++;
        stringArray[n2] = "-Xlint:deprecation";
        int n3 = n++;
        stringArray[n3] = "-classpath";
        stringArray[n++] = this.d();
        int n4 = n++;
        stringArray[n4] = "-d";
        stringArray[n++] = string3;
        for (IlvPaletteSymbol ilvPaletteSymbol : arrayList2) {
            ScSymbol scSymbol = this.a(ilvPaletteSymbol, string, string2);
            if (progressListener != null) {
                progressListener.progress(scSymbol);
            }
            stringArray[n] = scSymbol.x(string);
            Main.compile(stringArray);
            stringArray[n] = scSymbol.y(string);
            Main.compile(stringArray);
            scSymbol.v(string2);
        }
    }

    void a(String string) {
        if (q == null) {
            q = new ArrayList(2);
        }
        String string2 = string.replace("/", File.separator);
        File file = new File(System.getProperty("user.dir") + File.separator, string2);
        if (!this.a(file)) {
            URLClassLoader uRLClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
            Class<URLClassLoader> clazz = URLClassLoader.class;
            try {
                Class[] classArray = new Class[1];
                classArray[0] = URL.class;
                Method method = clazz.getDeclaredMethod("addURL", classArray);
                method.setAccessible(true);
                URI uRI = file.toURI();
                URL uRL = uRI.toURL();
                method.invoke((Object)uRLClassLoader, uRL);
            }
            catch (Exception exception) {
                // empty catch block
            }
            q.add(file);
        }
    }

    private boolean a(File file) {
        for (File file2 : q) {
            if (!file2.equals(file)) continue;
            return true;
        }
        return false;
    }

    private String d() {
        String string = null;
        URLClassLoader uRLClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        URL[] uRLArray = uRLClassLoader.getURLs();
        String string2 = System.getProperty("path.separator");
        for (URL uRL : uRLArray) {
            String string3 = uRL.getPath();
            if (string3.indexOf("%20") != -1) {
                string3 = string3.replaceAll("%20", "\\ ");
            }
            string = string == null ? string3 : string + string2 + string3;
        }
        return string;
    }

    public void generateSymbol(IlvPaletteSymbol ilvPaletteSymbol, String string, String string2) throws IlvSymbolCompilerException, IOException {
        this.a(ilvPaletteSymbol, string, string2);
    }

    ScSymbol a(IlvPaletteSymbol ilvPaletteSymbol, String string, String string2) throws IlvSymbolCompilerException, IOException {
        ScSymbol scSymbol = this.f(ilvPaletteSymbol);
        this.a(scSymbol, string);
        this.b(scSymbol, string);
        if (this.l) {
            scSymbol.v(string2);
        }
        return scSymbol;
    }

    private ScSymbol f(IlvPaletteSymbol ilvPaletteSymbol) throws IlvSymbolCompilerException {
        ScSymbol scSymbol = new ScSymbol(this, ilvPaletteSymbol);
        if (this.isAbstract() && !scSymbol.o()) {
            scSymbol.c(true);
        }
        scSymbol.d(this.isPublic());
        return scSymbol;
    }

    String a(ScSymbol scSymbol, String string) throws IOException, IlvSymbolCompilerException {
        String string2 = IlvSymbolCompiler.d(scSymbol, string);
        String string3 = string2 + scSymbol.getClassName() + ".java";
        FileWriter fileWriter = new FileWriter(string3);
        scSymbol.writeClass(fileWriter);
        fileWriter.flush();
        fileWriter.close();
        return string3;
    }

    String b(ScSymbol scSymbol, String string) throws IOException, IlvSymbolCompilerException {
        String string2 = IlvSymbolCompiler.d(scSymbol, string);
        ScBeanInfo scBeanInfo = new ScBeanInfo(scSymbol);
        String string3 = string2 + scBeanInfo.a() + ".java";
        FileWriter fileWriter = new FileWriter(string3);
        scBeanInfo.b(fileWriter);
        fileWriter.flush();
        fileWriter.close();
        return string3;
    }

    private static String d(ScSymbol scSymbol, String string) throws IOException {
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        string = string + scSymbol.a().getPalette().getPackageName();
        IlvScUtilities.p(string);
        return string;
    }

    public void writeSymbolClass(Writer writer, IlvPaletteSymbol ilvPaletteSymbol) throws IOException, IlvSymbolCompilerException {
        ScSymbol scSymbol = this.f(ilvPaletteSymbol);
        scSymbol.writeClass(writer);
        writer.flush();
    }

    public void mapClass(String string, String string2) {
        this.b.put(string, string2);
    }

    public String getMappedClass(String string) {
        return this.b.get(string);
    }

    void a(String string, ScValueWriter scValueWriter) {
        this.c.put(string, scValueWriter);
    }

    ScValueWriter b(String string) {
        ScValueWriter scValueWriter = this.c.get(string);
        if (scValueWriter == null) {
            if (this.e == null) {
                this.e = new DefaultWriter();
            }
            this.a(string, this.e);
            scValueWriter = this.e;
        }
        scValueWriter.setPropertyEditor(null);
        return scValueWriter;
    }

    void a(String string, Class<?> clazz, ScValueWriter scValueWriter) {
        ArrayList<ClassValueWriter> arrayList = this.d.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList();
            this.d.put(string, arrayList);
        }
        ClassValueWriter classValueWriter = new ClassValueWriter(clazz, scValueWriter);
        arrayList.add(classValueWriter);
    }

    ScValueWriter a(String string, ScRuleBean scRuleBean) {
        ArrayList<ClassValueWriter> arrayList = this.d.get(string);
        if (arrayList != null) {
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                if (!arrayList.get(i).a(scRuleBean.getKnownClass())) continue;
                return arrayList.get(i).a();
            }
        }
        return null;
    }

    void a(Level level, String string) {
        if (this.f == null) {
            this.f = Logger.getLogger("ilog.views.symbol.compiler");
        }
        this.f.log(level, string);
    }

    void a(Logger logger) {
        this.f = logger;
    }

    Logger a() {
        return this.f;
    }

    public String getParameterPrefix() {
        return this.g;
    }

    public void setParameterPrefix(String string) {
        this.g = string;
    }

    public String getParameterSuffix() {
        return this.h;
    }

    public void setParameterSuffix(String string) {
        this.h = string;
    }

    public boolean isParameterCapitalized() {
        return this.i;
    }

    public void setParameterCapitalized(boolean bl) {
        this.i = bl;
    }

    boolean b() {
        return this.j;
    }

    void a(boolean bl) {
        this.j = bl;
    }

    public boolean isGeneratingParameterChangeSupport() {
        return this.k;
    }

    public void setGeneratingParameterChangeSupport(boolean bl) {
        this.k = bl;
    }

    public boolean isExtractingResources() {
        return this.l;
    }

    public void setExtractingResources(boolean bl) {
        this.l = bl;
    }

    public String getVersion() {
        return r;
    }

    Rule[] a(IlvPaletteSymbol ilvPaletteSymbol) throws IlvSymbolCompilerException {
        return IlvScUtilities.a(this.getClassLoader(), ilvPaletteSymbol);
    }

    public boolean isAbstract() {
        return this.m;
    }

    public void setAbstract(boolean bl) {
        this.m = bl;
    }

    public boolean isPublic() {
        return this.n;
    }

    public void setPublic(boolean bl) {
        this.n = bl;
    }

    private static class ColorWriter
    extends SimpleWriter {
        private ColorWriter() {
        }

        @Override
        protected void writeConstant(Writer writer, ScSymbol scSymbol, String string, int n) throws IOException, IlvSymbolCompilerException {
            String string2 = scSymbol.getShortClassName("java.awt.Color");
            if (string.length() == 0) {
                writer.write("null");
            } else if (this.a(string)) {
                writer.write(string2 + ".decode(\"" + string + "\")");
            } else {
                ArrayList<String> arrayList = ColorWriter.b(string);
                if (arrayList != null) {
                    writer.write("new " + string2 + "(" + arrayList.get(0));
                    for (int i = 1; i < arrayList.size(); ++i) {
                        writer.write(", " + arrayList.get(i));
                    }
                    writer.write(41);
                } else {
                    writer.write("ilog.views.util.IlvColorUtil.toColor(\"" + string + "\")");
                }
            }
        }

        private boolean a(String string) {
            if (string.startsWith("#") && string.length() == 7) {
                try {
                    Integer.parseInt(string.substring(1), 16);
                    return true;
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
            return false;
        }

        private static ArrayList<String> b(String string) {
            if (string.startsWith("java.awt.Color[")) {
                ArrayList<String> arrayList = new ArrayList<String>(3);
                int n = "java.awt.Color[".length() + 2;
                int n2 = ColorWriter.a(string, n);
                arrayList.add(string.substring(n, n2));
                n = n2 + 3;
                n2 = ColorWriter.a(string, n);
                arrayList.add(string.substring(n, n2));
                n = n2 + 3;
                n2 = ColorWriter.a(string, n);
                arrayList.add(string.substring(n, n2));
                return arrayList;
            }
            if (string.indexOf(44) != -1) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                if (stringTokenizer.hasMoreTokens()) {
                    ArrayList<String> arrayList = new ArrayList<String>(4);
                    while (stringTokenizer.hasMoreTokens()) {
                        try {
                            String string2 = stringTokenizer.nextToken();
                            Float.parseFloat(string2);
                            arrayList.add(string2);
                        }
                        catch (NumberFormatException numberFormatException) {
                            return null;
                        }
                    }
                    if (arrayList.size() == 3 || arrayList.size() == 4) {
                        return arrayList;
                    }
                }
            } else if (string.charAt(0) == '#' && string.length() == 9) {
                ArrayList<String> arrayList = new ArrayList<String>(4);
                int n = Integer.parseInt(string.substring(3), 16);
                arrayList.add(new Integer(n >> 16 & 0xFF).toString());
                arrayList.add(new Integer(n >> 8 & 0xFF).toString());
                arrayList.add(new Integer(n & 0xFF).toString());
                int n3 = Integer.parseInt(string.substring(1, 3), 16);
                arrayList.add(new Integer(n3).toString());
                return arrayList;
            }
            return null;
        }

        private static int a(String string, int n) {
            int n2;
            int n3 = string.length();
            for (n2 = n; n2 < n3 && Character.isDigit(string.charAt(n2)); ++n2) {
            }
            return n2;
        }

        @Override
        protected void writeExpression(Writer writer, ScSymbol scSymbol, ScExpression scExpression, int n) throws IOException, IlvSymbolCompilerException {
            String string = scExpression.a();
            boolean bl = false;
            try {
                if (Color.class.isAssignableFrom(Class.forName(string))) {
                    scExpression.write(writer, n);
                    bl = true;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
            if (!bl) {
                String string2 = scSymbol.getShortClassName("java.awt.Color");
                writer.write(string2 + ".getColor(");
                scExpression.convertToType(writer, 1010, 14);
                writer.write(41);
            }
        }
    }

    private static class AffineTransformWriter
    extends SimpleWriter {
        private AffineTransformWriter() {
        }

        @Override
        public void writeValue(Writer writer, ScSymbol scSymbol, String string, int n) throws IOException, IlvSymbolCompilerException {
            if (string.length() != 0) {
                throw new IlvSymbolCompilerException("Not expected string value for AffineTransform: " + string);
            }
            writer.write("null");
        }

        @Override
        protected void writeConstant(Writer writer, ScSymbol scSymbol, String string, int n) throws IOException, IlvSymbolCompilerException {
        }

        @Override
        protected void writeExpression(Writer writer, ScSymbol scSymbol, ScExpression scExpression, int n) throws IOException, IlvSymbolCompilerException {
        }
    }

    private static class ObjectWriter
    extends SimpleWriter {
        private ObjectWriter() {
        }

        @Override
        protected void writeConstant(Writer writer, ScSymbol scSymbol, String string, int n) throws IOException, IlvSymbolCompilerException {
            ScExpression scExpression = new ScExpression();
            scExpression.a(scSymbol, string);
            scExpression.write(writer, n);
        }

        @Override
        protected void writeExpression(Writer writer, ScSymbol scSymbol, ScExpression scExpression, int n) throws IOException, IlvSymbolCompilerException {
            scExpression.write(writer, n);
        }
    }

    private static class FontWriter
    extends SimpleWriter {
        private FontWriter() {
        }

        @Override
        protected void writeConstant(Writer writer, ScSymbol scSymbol, String string, int n) throws IOException, IlvSymbolCompilerException {
            scSymbol.c();
            writer.write("stringToFont(");
            IlvScUtilities.a(writer, string);
            writer.write(41);
        }

        @Override
        protected void writeExpression(Writer writer, ScSymbol scSymbol, ScExpression scExpression, int n) throws IOException, IlvSymbolCompilerException {
            scSymbol.c();
            boolean bl = false;
            try {
                Class<?> clazz = Class.forName(scExpression.a());
                if (Font.class.isAssignableFrom(clazz)) {
                    bl = true;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (bl) {
                scExpression.write(writer, n);
            } else {
                writer.write("stringToFont(");
                scExpression.convertToType(writer, 1010, 14);
                writer.write(41);
            }
        }

        @Override
        public void registerImportedClasses(ScSymbol scSymbol) {
            super.registerImportedClasses(scSymbol);
            scSymbol.registerImportedClass("ilog.views.util.beans.editor.IlvFontPropertyEditor");
        }
    }

    private static class AttachmentLocationWriter
    extends SimpleWriter {
        private AttachmentLocationWriter() {
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        protected void writeConstant(Writer writer, ScSymbol scSymbol, String string, int n) throws IOException, IlvSymbolCompilerException {
            if (string != null && string.length() != 0) {
                writer.write("new ilog.views.graphic.composite.layout.internal.IlvAttachmentLocation" + string + "()");
                return;
            }
            writer.write("null");
        }

        @Override
        protected void writeExpression(Writer writer, ScSymbol scSymbol, ScExpression scExpression, int n) throws IOException, IlvSymbolCompilerException {
            throw new IlvSymbolCompilerException("Cannot convert an expression to an attachment location");
        }
    }

    private static class Constructor2ArgsWriter
    extends SimpleWriter {
        private String a;
        private String b;

        Constructor2ArgsWriter(String string, String string2) {
            this.a = string;
            this.b = string2 != null ? string2 : "";
        }

        private void a(StringTokenizer stringTokenizer, String string) throws IlvSymbolCompilerException {
            if (!stringTokenizer.hasMoreElements()) {
                throw new IlvSymbolCompilerException(this.a + ": value badly formatted:" + string);
            }
        }

        @Override
        public void writeConstant(Writer writer, ScSymbol scSymbol, String string, int n) throws IOException, IlvSymbolCompilerException {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            this.a(stringTokenizer, string);
            String string2 = stringTokenizer.nextToken();
            this.a(stringTokenizer, string);
            String string3 = stringTokenizer.nextToken();
            String string4 = scSymbol.getShortClassName(this.a);
            writer.write("new " + string4 + "(" + this.b + string2 + ", " + this.b + string3 + ")");
        }

        @Override
        protected void writeExpression(Writer writer, ScSymbol scSymbol, ScExpression scExpression, int n) throws IOException, IlvSymbolCompilerException {
            throw new IlvSymbolCompilerException("Cannot convert an expression to this type", this.a);
        }
    }

    private static class ShapeWriter
    extends SimpleWriter {
        private ShapeWriter() {
        }

        @Override
        protected void writeConstant(Writer writer, ScSymbol scSymbol, String string, int n) throws IOException, IlvSymbolCompilerException {
            scSymbol.b();
            writer.write("stringToShape(");
            IlvScUtilities.a(writer, string);
            writer.write(41);
        }

        @Override
        protected void writeExpression(Writer writer, ScSymbol scSymbol, ScExpression scExpression, int n) throws IOException, IlvSymbolCompilerException {
            scSymbol.b();
            String string = scExpression.a();
            if ("java.awt.Shape".equals(string)) {
                scExpression.write(writer, n);
            } else {
                writer.write("stringToShape(");
                scExpression.convertToType(writer, 1010, 14);
                writer.write(41);
            }
        }

        @Override
        public void registerImportedClasses(ScSymbol scSymbol) {
            super.registerImportedClasses(scSymbol);
            scSymbol.registerImportedClass("java.io.ByteArrayInputStream");
            scSymbol.registerImportedClass("ilog.views.io.IlvInputStream");
        }
    }

    static class URLWriter
    extends StringWriter {
        URL a;

        URLWriter() {
        }

        @Override
        protected void writeConstant(Writer writer, ScSymbol scSymbol, String string, int n) throws IOException {
            try {
                this.a = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                this.a = scSymbol.a().getResourceURL(string);
            }
            scSymbol.b(this.a);
            String string2 = IlvScUtilities.a(this.a);
            writer.write("getSymbolResource(");
            IlvScUtilities.a(writer, string2);
            writer.write(41);
        }

        @Override
        public void registerImportedClasses(ScSymbol scSymbol) {
            scSymbol.registerImportedClass("java.net.URL");
        }
    }

    static class URLStringWriter
    extends StringWriter {
        URLStringWriter() {
        }

        @Override
        protected void writeConstant(Writer writer, ScSymbol scSymbol, String string, int n) throws IOException {
            URL uRL = scSymbol.a().getResourceURL(string);
            scSymbol.b(uRL);
            String string2 = IlvScUtilities.a(uRL);
            writer.write("getSymbolResource(");
            IlvScUtilities.a(writer, string2);
            writer.write(").toExternalForm()");
        }

        @Override
        public void registerImportedClasses(ScSymbol scSymbol) {
            scSymbol.registerImportedClass("java.net.URL");
        }
    }

    private static class InsetsWriter
    extends SimpleWriter {
        private InsetsWriter() {
        }

        @Override
        public void registerImportedClasses(ScSymbol scSymbol) {
            scSymbol.registerImportedClass("java.awt.Insets");
        }

        @Override
        protected void writeConstant(Writer writer, ScSymbol scSymbol, String string, int n) throws IOException, IlvSymbolCompilerException {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            ArrayList<String> arrayList = new ArrayList<String>(4);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                try {
                    Integer.parseInt(string2);
                    arrayList.add(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IlvSymbolCompilerException("Bad int format for an Insets member: " + string2);
                }
            }
            if (arrayList.size() != 4) {
                throw new IlvSymbolCompilerException("Bad format for an Insets: " + string);
            }
            writer.write("new Insets(" + (String)arrayList.get(0) + ", " + (String)arrayList.get(1) + ", " + (String)arrayList.get(2) + ", " + (String)arrayList.get(3) + ")");
        }

        @Override
        protected void writeExpression(Writer writer, ScSymbol scSymbol, ScExpression scExpression, int n) throws IOException, IlvSymbolCompilerException {
            writer.write("ilog.views.symbol.util.IlvCompiledSymbolFunction.convertToInsets(");
            scExpression.convertToType(writer, 1010, 14);
            writer.write(41);
        }
    }

    private static class RectWriter
    extends SimpleWriter {
        private RectWriter() {
        }

        @Override
        public void registerImportedClasses(ScSymbol scSymbol) {
            scSymbol.registerImportedClass("ilog.views.IlvRect");
        }

        @Override
        protected void writeConstant(Writer writer, ScSymbol scSymbol, String string, int n) throws IOException, IlvSymbolCompilerException {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            ArrayList<String> arrayList = new ArrayList<String>(4);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                try {
                    Float.parseFloat(string2);
                    arrayList.add(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IlvSymbolCompilerException("Bad float format for a rectangle member: " + string2);
                }
            }
            if (arrayList.size() != 4) {
                throw new IlvSymbolCompilerException("Bad format for a rectangle: " + string);
            }
            writer.write("new IlvRect((float) " + (String)arrayList.get(0) + ", (float) " + (String)arrayList.get(1) + ", (float) " + (String)arrayList.get(2) + ", (float) " + (String)arrayList.get(3) + ")");
        }

        @Override
        protected void writeExpression(Writer writer, ScSymbol scSymbol, ScExpression scExpression, int n) throws IOException, IlvSymbolCompilerException {
            writer.write("ilog.views.symbol.util.IlvCompiledSymbolFunction.convertToRect(");
            scExpression.convertToType(writer, 1010, 14);
            writer.write(41);
        }
    }

    private static class DefaultWriter
    extends StringWriter {
        private DefaultWriter() {
        }

        @Override
        public void writeValue(Writer writer, ScSymbol scSymbol, String string, int n) throws IOException, IlvSymbolCompilerException {
            if (string.length() == 0) {
                writer.write("null");
            } else {
                writer.write("/*** UNKNOWN VALUE TYPE or NOT YET IMPLEMENTED ***/");
                super.writeValue(writer, scSymbol, string, n);
            }
        }
    }

    private static class StringWriter
    extends SimpleWriter {
        private StringWriter() {
        }

        @Override
        protected void writeConstant(Writer writer, ScSymbol scSymbol, String string, int n) throws IOException {
            IlvScUtilities.a(writer, string);
        }

        @Override
        protected void writeExpression(Writer writer, ScSymbol scSymbol, ScExpression scExpression, int n) throws IOException, IlvSymbolCompilerException {
            scExpression.convertToType(writer, 1010, n);
        }
    }

    private static class BooleanWriter
    extends SimpleWriter {
        private BooleanWriter() {
        }

        @Override
        public void writeConstant(Writer writer, ScSymbol scSymbol, String string, int n) throws IOException, IlvSymbolCompilerException {
            writer.write(string.toLowerCase(Locale.US));
        }

        @Override
        protected void writeExpression(Writer writer, ScSymbol scSymbol, ScExpression scExpression, int n) throws IOException, IlvSymbolCompilerException {
            scExpression.convertToType(writer, 1011, n);
        }
    }

    private static class DoubleWriter
    extends LiteralWriter {
        private DoubleWriter() {
        }

        @Override
        protected void writeExpression(Writer writer, ScSymbol scSymbol, ScExpression scExpression, int n) throws IOException, IlvSymbolCompilerException {
            scExpression.convertToType(writer, 1004, n);
        }
    }

    private static class FloatWriter
    extends LiteralWriter {
        private FloatWriter() {
        }

        @Override
        public void writeConstant(Writer writer, ScSymbol scSymbol, String string, int n) throws IOException, IlvSymbolCompilerException {
            if (n < 2) {
                writer.write(40);
                this.writeConstant(writer, scSymbol, string, 14);
                writer.write(41);
            } else {
                writer.write("(float) " + string);
            }
        }

        @Override
        protected void writeExpression(Writer writer, ScSymbol scSymbol, ScExpression scExpression, int n) throws IOException, IlvSymbolCompilerException {
            scExpression.convertToType(writer, 1003, n);
        }
    }

    private static class ShortWriter
    extends LiteralWriter {
        private ShortWriter() {
        }

        @Override
        public void writeConstant(Writer writer, ScSymbol scSymbol, String string, int n) throws IOException, IlvSymbolCompilerException {
            if (IlvScUtilities.d(string)) {
                if (n < 2) {
                    writer.write(40);
                    this.writeConstant(writer, scSymbol, string, 14);
                    writer.write(41);
                } else {
                    writer.write("(short) " + string);
                }
            } else {
                PropertyEditor propertyEditor = this.getPropertyEditor();
                if (propertyEditor != null) {
                    propertyEditor.setAsText(string);
                    writer.write(propertyEditor.getJavaInitializationString());
                } else {
                    throw new IlvSymbolCompilerException("Cannot convert value to short: " + string);
                }
            }
        }

        @Override
        protected void writeExpression(Writer writer, ScSymbol scSymbol, ScExpression scExpression, int n) throws IOException, IlvSymbolCompilerException {
            scExpression.convertToType(writer, 1005, n);
        }
    }

    private static class IntWriter
    extends LiteralWriter {
        private IntWriter() {
        }

        @Override
        public void writeConstant(Writer writer, ScSymbol scSymbol, String string, int n) throws IOException, IlvSymbolCompilerException {
            if (IlvScUtilities.e(string)) {
                writer.write(string);
            } else {
                PropertyEditor propertyEditor = this.getPropertyEditor();
                if (propertyEditor != null) {
                    propertyEditor.setAsText(string);
                    writer.write(propertyEditor.getJavaInitializationString());
                }
            }
        }

        @Override
        protected void writeExpression(Writer writer, ScSymbol scSymbol, ScExpression scExpression, int n) throws IOException, IlvSymbolCompilerException {
            scExpression.convertToType(writer, 1001, n);
        }
    }

    private static abstract class LiteralWriter
    extends SimpleWriter {
        private LiteralWriter() {
        }

        @Override
        public void writeConstant(Writer writer, ScSymbol scSymbol, String string, int n) throws IOException, IlvSymbolCompilerException {
            writer.write(string);
        }
    }

    private static abstract class SimpleWriter
    extends ScAbstractValueWriter {
        private SimpleWriter() {
        }

        @Override
        public void writeValue(Writer writer, ScSymbol scSymbol, String string, int n) throws IOException, IlvSymbolCompilerException {
            if (string.startsWith("@")) {
                ScExpression scExpression = new ScExpression();
                scExpression.a(scSymbol, string);
                this.writeExpression(writer, scSymbol, scExpression, n);
            } else {
                this.writeConstant(writer, scSymbol, string, n);
            }
        }

        protected abstract void writeConstant(Writer var1, ScSymbol var2, String var3, int var4) throws IOException, IlvSymbolCompilerException;

        protected abstract void writeExpression(Writer var1, ScSymbol var2, ScExpression var3, int var4) throws IOException, IlvSymbolCompilerException;
    }

    private static class ClassValueWriter {
        private Class<?> a;
        private ScValueWriter b;

        ClassValueWriter(Class<?> clazz, ScValueWriter scValueWriter) {
            this.a = clazz;
            this.b = scValueWriter;
        }

        boolean a(Class<?> clazz) {
            return this.a.isAssignableFrom(clazz);
        }

        ScValueWriter a() {
            return this.b;
        }
    }

    static interface ProgressListener {
        public void progress(ScSymbol var1);
    }
}

