/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.insight;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ListCellRenderer;
import javax.swing.text.JTextComponent;
import oracle.ide.Context;
import oracle.ide.config.Preferences;
import oracle.ide.insight.InsightContext;
import oracle.ide.insight.InsightItem;
import oracle.ide.insight.InsightModel;
import oracle.ide.insight.InsightSupport;
import oracle.ide.insight.completion.CompletionContext;
import oracle.ide.insight.completion.CompletionModel;
import oracle.ide.insight.completion.CompletionProvider;
import oracle.ide.insight.completion.DefaultCompletionSupport;
import oracle.ide.insight.completion.ui.InsightViewCustomizer;
import oracle.ide.insight.options.InsightOptions;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.icons.OracleIcons;
import oracle.jdevimpl.debugger.breakpoint.CoreBreakpoint;
import oracle.jdevimpl.debugger.insight.JavaCellRenderer;

public class BreakpointGroupProvider
implements CompletionProvider {
    private BreakpointGroupCompletionModel model;
    private Set<Character> triggers;

    public CompletionModel getModel(CompletionContext completionContext) {
        this.model = new BreakpointGroupCompletionModel();
        this.model.updateFromCompletionContext(completionContext);
        return this.model;
    }

    public CompletionModel updateModel(CompletionContext completionContext, CompletionModel d) {
        this.model = (BreakpointGroupCompletionModel)d;
        this.model.updateFromCompletionContext(completionContext);
        return this.model;
    }

    public Collection getTriggerCharacters() {
        if (this.triggers == null) {
            this.triggers = new HashSet<Character>();
            this.triggers.add(Character.valueOf('.'));
            for (int i = 0; i < 65535; ++i) {
                if (!Character.isJavaIdentifierPart((char)i)) continue;
                this.triggers.add(Character.valueOf((char)i));
            }
        }
        return this.triggers;
    }

    public boolean isExactMatch(CompletionModel d) {
        return ((BreakpointGroupCompletionModel)d).isExactMatch();
    }

    public void customizeView(InsightViewCustomizer customizer) {
        JavaCellRenderer renderer = new JavaCellRenderer(customizer);
        customizer.setRenderer((ListCellRenderer)((Object)renderer));
    }

    public String getDisplayName() {
        return "";
    }

    public InsightModel getModel(InsightContext insightContext) {
        return null;
    }

    public InsightModel updateModel(InsightContext insightContext, InsightModel lastModel) {
        return null;
    }

    static class BreakpointGroupInsightItem
    extends InsightItem {
        private String name;

        public BreakpointGroupInsightItem(String name) {
            this.name = name;
        }

        public Icon getIcon() {
            return OracleIcons.getIcon((String)"group.png");
        }

        public String getDisplayValue() {
            return this.name;
        }

        public String getName() {
            return this.name;
        }
    }

    static class BreakpointGroupCompletionModel<BreakpointInsightItem>
    implements CompletionModel {
        private CompletionContext completionContext;
        private Context ideContext;
        private Project project;
        private Workspace workspace;
        private String userInput;
        private JTextComponent textComponent;
        private boolean exactMatch = false;
        private InsightOptions options;

        BreakpointGroupCompletionModel() {
        }

        private void updateFromCompletionContext(CompletionContext context) {
            this.completionContext = context;
            if (context.getSupport() instanceof DefaultCompletionSupport) {
                InsightSupport insightSupport = this.completionContext.getSupport();
                this.textComponent = insightSupport.getTextComponent();
                this.userInput = this.textComponent.getText();
                this.ideContext = insightSupport.getContext();
                assert (this.ideContext != null);
                this.project = this.ideContext.getProject();
                this.workspace = this.ideContext.getWorkspace();
                this.options = InsightOptions.getInstance((PropertyStorage)Preferences.getPreferences());
            }
        }

        public void partialComplete() {
        }

        public String getMatchingText() {
            return this.userInput;
        }

        public List<BreakpointGroupInsightItem> getItems() {
            if (this.userInput != null) {
                return this.getMatchingItems();
            }
            return this.getBreakpointGroupNames("");
        }

        public List<BreakpointGroupInsightItem> getMatchingItems() {
            return this.getBreakpointGroupNames(this.userInput);
        }

        private List<BreakpointGroupInsightItem> getBreakpointGroupNames(String partial) {
            ArrayList<BreakpointGroupInsightItem> results = new ArrayList<BreakpointGroupInsightItem>();
            partial = partial.toLowerCase();
            boolean filterByContains = this.options.isFilterByContains();
            for (String s : this.getGroupNames()) {
                String slc = s.toLowerCase();
                if ((!filterByContains || !slc.contains(partial)) && (filterByContains || !slc.startsWith(partial))) continue;
                if (slc.equals(partial)) {
                    this.exactMatch = true;
                }
                results.add(new BreakpointGroupInsightItem(s));
            }
            return results;
        }

        private List<String> getGroupNames() {
            ArrayList<String> groupNames = new ArrayList<String>();
            List[] breakpoints = CoreBreakpoint.getBreakpoints((Workspace)this.workspace, (Project)this.project);
            int length = breakpoints.length;
            for (int i = 0; i < length; ++i) {
                for (CoreBreakpoint bp : breakpoints[i]) {
                    String groupName = bp.getGroupName();
                    if (groupName.length() <= 0 || groupNames.contains(groupName)) continue;
                    groupNames.add(groupName);
                }
            }
            return groupNames;
        }

        public InsightItem getDefaultItem() {
            return null;
        }

        public InsightModel.Result complete(InsightItem selectedItem) {
            String userInput = this.textComponent.getText();
            if (selectedItem instanceof BreakpointGroupInsightItem) {
                this.textComponent.setText(selectedItem.getName());
            }
            return InsightModel.Result.DONE;
        }

        public boolean isExactMatch() {
            return this.exactMatch;
        }
    }
}

