/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.sql;

import java.util.Hashtable;
import java.util.Locale;
import oracle.i18n.util.LocaleMapper;

public class XSULocale {
    static final int JDK_1_1_4 = 1;
    static final int JDK_1_1_6 = 2;
    static final int JDK_1_1_7 = 3;
    static final int JDK_1_1_8 = 4;
    static final int JDK_1_2_1 = 5;
    private static final int JDK_LATEST_VERSION = 5;
    private static final int JDK_VERSION_MAX_LENGTH = 5;
    private static Hashtable javaCharset2IANACharset;
    private static Hashtable ianaCharset2JAVACharset;
    private static Hashtable jdk2NlsVersion;

    public static String getIANACharset(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        try {
            return LocaleMapper.getIANACharacterSet((int)3, (String)string);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            if (javaCharset2IANACharset == null) {
                javaCharset2IANACharset = XSULocale.createJavaCharset2IANACharset();
            }
            return (String)javaCharset2IANACharset.get(string.toUpperCase(Locale.getDefault()));
        }
    }

    public static String getJavaCharset(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        try {
            return LocaleMapper.getJavaCharacterSet((int)2, (String)string);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            if (ianaCharset2JAVACharset == null) {
                ianaCharset2JAVACharset = XSULocale.createIANACharset2JAVACharset();
            }
            return (String)ianaCharset2JAVACharset.get(string.toUpperCase(Locale.getDefault()));
        }
    }

    static Hashtable createJavaCharset2IANACharset() {
        Integer n;
        String string = System.getProperty("java.version");
        if (string.length() > 5) {
            string = string.substring(0, 5);
        }
        int n2 = (n = (Integer)jdk2NlsVersion.get(string)) != null ? n : 5;
        Hashtable<String, String> hashtable = new Hashtable<String, String>(100, 1.0f);
        switch (n2) {
            case 5: {
                hashtable.put("8859_1", "ISO-8859-1");
                hashtable.put("8859_2", "ISO-8859-2");
                hashtable.put("8859_3", "ISO-8859-3");
                hashtable.put("8859_4", "ISO-8859-4");
                hashtable.put("8859_5", "ISO-8859-5");
                hashtable.put("8859_6", "ISO-8859-6");
                hashtable.put("8859_7", "ISO-8859-7");
                hashtable.put("8859_8", "ISO-8859-8");
                hashtable.put("8859_9", "ISO-8859-9");
                hashtable.put("ASCII", "ASCII");
                hashtable.put("ISO8859_1", "ISO-8859-1");
                hashtable.put("ISO8859_2", "ISO-8859-2");
                hashtable.put("ISO8859_3", "ISO-8859-3");
                hashtable.put("ISO8859_4", "ISO-8859-4");
                hashtable.put("ISO8859_5", "ISO-8859-5");
                hashtable.put("ISO8859_6", "ISO-8859-6");
                hashtable.put("ISO8859_7", "ISO-8859-7");
                hashtable.put("ISO8859_8", "ISO-8859-8");
                hashtable.put("ISO8859_9", "ISO-8859-9");
                hashtable.put("BIG5", "BIG5");
                hashtable.put("CP037", "EBCDIC");
                hashtable.put("CP273", "IBM273");
                hashtable.put("CP277", "EBCDIC-CP-DK");
                hashtable.put("CP278", "EBCDIC-CP-FI");
                hashtable.put("CP280", "EBCDIC-CP-IT");
                hashtable.put("CP284", "EBCDIC-CP-ES");
                hashtable.put("CP285", "EBCDIC-CP-GB");
                hashtable.put("CP297", "EBCDIC-CP-FR");
                hashtable.put("CP420", "EBCDIC-CP-AR1");
                hashtable.put("CP424", "EBCDIC-CP-HP");
                hashtable.put("CP500", "EBCDIC-CP-BE");
                hashtable.put("CP437", "IBM437");
                hashtable.put("CP775", "IBM775");
                hashtable.put("CP850", "IBM850");
                hashtable.put("CP852", "IBM852");
                hashtable.put("CP855", "IBM855");
                hashtable.put("CP857", "IBM857");
                hashtable.put("CP860", "IBM860");
                hashtable.put("CP861", "IBM861");
                hashtable.put("CP862", "IBM862");
                hashtable.put("CP863", "IBM863");
                hashtable.put("CP864", "IBM864");
                hashtable.put("CP865", "IBM865");
                hashtable.put("CP866", "IBM866");
                hashtable.put("CP868", "IBM868");
                hashtable.put("CP869", "IBM869");
                hashtable.put("CP870", "EBCDIC-CP-ROECE");
                hashtable.put("CP871", "EBCDIC-CP-IS");
                hashtable.put("CP918", "EBCDIC-CP-AR2");
                hashtable.put("CP1026", "IBM1026");
                hashtable.put("CP1250", "WINDOWS-1250");
                hashtable.put("CP1251", "WINDOWS-1251");
                hashtable.put("CP1252", "WINDOWS-1252");
                hashtable.put("CP1253", "WINDOWS-1253");
                hashtable.put("CP1254", "WINDOWS-1254");
                hashtable.put("CP1255", "WINDOWS-1255");
                hashtable.put("CP1256", "WINDOWS-1256");
                hashtable.put("CP1257", "WINDOWS-1257");
                hashtable.put("CP1258", "WINDOWS-1258");
                hashtable.put("EUC_CN", "GB2312");
                hashtable.put("EUC_JP", "EUC-JP");
                hashtable.put("EUC_TW", "EUC-TW");
                hashtable.put("EUC_KR", "KS_C_5601-1987");
                hashtable.put("ISO2022KR", "ISO-2022-KR");
                hashtable.put("ISO2022JP", "ISO-2022-JP");
                hashtable.put("ISO2022CN", "ISO-2022-CN");
                hashtable.put("KOI8_R", "KOI8-R");
                hashtable.put("MS874", "TIS-620");
                hashtable.put("CP874", "TIS-620");
                hashtable.put("MS950", "WINDOWS-950");
                hashtable.put("CP950", "WINDOWS-950");
                hashtable.put("MS932", "SHIFT_JIS");
                hashtable.put("MS949", "WINDOWS-949");
                hashtable.put("UTF8", "UTF-8");
                hashtable.put("CP737", "IBM737");
                hashtable.put("CP838", "IBM838");
                hashtable.put("CP856", "IBM856");
                hashtable.put("CP858", "IBM858");
                hashtable.put("CP921", "IBM921");
                hashtable.put("CP922", "IBM922");
                hashtable.put("CP923", "IBM923");
                hashtable.put("CP930", "IBM930");
                hashtable.put("CP933", "IBM933");
                hashtable.put("CP935", "IBM935");
                hashtable.put("CP937", "IBM937");
                hashtable.put("CP942", "IBM942");
                hashtable.put("CP942C", "IBM942C");
                hashtable.put("CP943", "IBM943");
                hashtable.put("CP943C", "IBM943C");
                hashtable.put("CP948", "IBM948");
                hashtable.put("CP949", "WINDOWS-949");
                hashtable.put("CP949C", "WINDOWS-949");
                hashtable.put("CP1006", "IBM1006");
                hashtable.put("CP1025", "IBM1025");
                hashtable.put("CP1097", "IBM1097");
                hashtable.put("CP1098", "IBM1098");
                hashtable.put("CP1112", "IBM1112");
                hashtable.put("CP1122", "IBM1122");
                hashtable.put("CP1123", "IBM1123");
                hashtable.put("CP1124", "IBM1124");
                hashtable.put("CP1381", "IBM1381");
                hashtable.put("CP1383", "IBM1383");
                hashtable.put("CP33722", "IBM33722");
                hashtable.put("GBK", "WINDOWS-936");
                hashtable.put("MS936", "WINDOWS-936");
                hashtable.put("ISO_2022", "");
                hashtable.put("ISO2022CN_CNS", "ISO-2022-CN");
                hashtable.put("ISO2022CN_GB", "ISO-2022-CN");
                hashtable.put("JIS0201", "JIS_X0201");
                hashtable.put("JIS0208", "JIS_C6226-1983");
                hashtable.put("JIS0212", "JIS_X0212-1990");
                hashtable.put("JOHAB", "KSC5601-1992");
                hashtable.put("TIS620", "TIS-620");
                hashtable.put("ISO8859_15_FDIS", "ISO_8859-15");
                hashtable.put("ISO8859_13", "ISO_8859-13");
                hashtable.put("SJIS", "SHIFT_JIS");
                return hashtable;
            }
            case 4: {
                hashtable.put("8859_1", "ISO-8859-1");
                hashtable.put("8859_2", "ISO-8859-2");
                hashtable.put("8859_3", "ISO-8859-3");
                hashtable.put("8859_4", "ISO-8859-4");
                hashtable.put("8859_5", "ISO-8859-5");
                hashtable.put("8859_6", "ISO-8859-6");
                hashtable.put("8859_7", "ISO-8859-7");
                hashtable.put("8859_8", "ISO-8859-8");
                hashtable.put("8859_9", "ISO-8859-9");
                hashtable.put("ASCII", "ASCII");
                hashtable.put("ISO8859_1", "ISO-8859-1");
                hashtable.put("ISO8859_2", "ISO-8859-2");
                hashtable.put("ISO8859_3", "ISO-8859-3");
                hashtable.put("ISO8859_4", "ISO-8859-4");
                hashtable.put("ISO8859_5", "ISO-8859-5");
                hashtable.put("ISO8859_6", "ISO-8859-6");
                hashtable.put("ISO8859_7", "ISO-8859-7");
                hashtable.put("ISO8859_8", "ISO-8859-8");
                hashtable.put("ISO8859_9", "ISO-8859-9");
                hashtable.put("BIG5", "BIG5");
                hashtable.put("CP037", "EBCDIC");
                hashtable.put("CP273", "IBM273");
                hashtable.put("CP277", "EBCDIC-CP-DK");
                hashtable.put("CP278", "EBCDIC-CP-FI");
                hashtable.put("CP280", "EBCDIC-CP-IT");
                hashtable.put("CP284", "EBCDIC-CP-ES");
                hashtable.put("CP285", "EBCDIC-CP-GB");
                hashtable.put("CP297", "EBCDIC-CP-FR");
                hashtable.put("CP420", "EBCDIC-CP-AR1");
                hashtable.put("CP424", "EBCDIC-CP-HP");
                hashtable.put("CP500", "EBCDIC-CP-BE");
                hashtable.put("CP437", "IBM437");
                hashtable.put("CP775", "IBM775");
                hashtable.put("CP850", "IBM850");
                hashtable.put("CP852", "IBM852");
                hashtable.put("CP855", "IBM855");
                hashtable.put("CP857", "IBM857");
                hashtable.put("CP860", "IBM860");
                hashtable.put("CP861", "IBM861");
                hashtable.put("CP862", "IBM862");
                hashtable.put("CP863", "IBM863");
                hashtable.put("CP864", "IBM864");
                hashtable.put("CP865", "IBM865");
                hashtable.put("CP866", "IBM866");
                hashtable.put("CP868", "IBM868");
                hashtable.put("CP869", "IBM869");
                hashtable.put("CP870", "EBCDIC-CP-ROECE");
                hashtable.put("CP871", "EBCDIC-CP-IS");
                hashtable.put("CP918", "EBCDIC-CP-AR2");
                hashtable.put("CP1026", "IBM1026");
                hashtable.put("CP1250", "WINDOWS-1250");
                hashtable.put("CP1251", "WINDOWS-1251");
                hashtable.put("CP1252", "WINDOWS-1252");
                hashtable.put("CP1253", "WINDOWS-1253");
                hashtable.put("CP1254", "WINDOWS-1254");
                hashtable.put("CP1255", "WINDOWS-1255");
                hashtable.put("CP1256", "WINDOWS-1256");
                hashtable.put("CP1257", "WINDOWS-1257");
                hashtable.put("CP1258", "WINDOWS-1258");
                hashtable.put("EUC_CN", "GB2312");
                hashtable.put("GBK", "WINDOWS-936");
                hashtable.put("EUC_JP", "EUC-JP");
                hashtable.put("EUC_TW", "EUC-TW");
                hashtable.put("EUC_KR", "KS_C_5601-1987");
                hashtable.put("ISO2022KR", "ISO-2022-KR");
                hashtable.put("ISO2022JP", "ISO-2022-JP");
                hashtable.put("ISO2022CN", "ISO-2022-CN");
                hashtable.put("KOI8_R", "KOI8-R");
                hashtable.put("MS874", "TIS-620");
                hashtable.put("CP874", "TIS-620");
                hashtable.put("MS950", "WINDOWS-950");
                hashtable.put("CP950", "WINDOWS-950");
                hashtable.put("MS932", "SHIFT_JIS");
                hashtable.put("MS949", "WINDOWS-949");
                hashtable.put("CP949", "WINDOWS-949");
                hashtable.put("CP949C", "WINDOWS-949");
                hashtable.put("UTF8", "UTF-8");
                hashtable.put("CP737", "IBM737");
                hashtable.put("CP838", "IBM838");
                hashtable.put("CP856", "IBM856");
                hashtable.put("CP858", "IBM858");
                hashtable.put("CP921", "IBM921");
                hashtable.put("CP922", "IBM922");
                hashtable.put("CP923", "IBM923");
                hashtable.put("CP930", "IBM930");
                hashtable.put("CP933", "IBM933");
                hashtable.put("CP935", "IBM935");
                hashtable.put("CP937", "IBM937");
                hashtable.put("CP942", "IBM942");
                hashtable.put("CP942C", "IBM942C");
                hashtable.put("CP943", "IBM943");
                hashtable.put("CP943C", "IBM943C");
                hashtable.put("CP948", "IBM948");
                hashtable.put("CP1006", "IBM1006");
                hashtable.put("CP1025", "IBM1025");
                hashtable.put("CP1097", "IBM1097");
                hashtable.put("CP1098", "IBM1098");
                hashtable.put("CP1112", "IBM1112");
                hashtable.put("CP1122", "IBM1122");
                hashtable.put("CP1123", "IBM1123");
                hashtable.put("CP1124", "IBM1124");
                hashtable.put("CP1381", "IBM1381");
                hashtable.put("CP1383", "IBM1383");
                hashtable.put("CP33722", "IBM33722");
                hashtable.put("MS936", "WINDOWS-936");
                hashtable.put("ISO_2022", "");
                hashtable.put("ISO2022CN_CNS", "ISO-2022-CN");
                hashtable.put("ISO2022CN_GB", "ISO-2022-CN");
                hashtable.put("JIS0201", "JIS_X0201");
                hashtable.put("JIS0208", "JIS_C6226-1983");
                hashtable.put("JIS0212", "JIS_X0212-1990");
                hashtable.put("JOHAB", "KSC5601-1992");
                hashtable.put("TIS620", "TIS-620");
                hashtable.put("ISO8859_15_FDIS", "ISO_8859-15");
                hashtable.put("SJIS", "SHIFT_JIS");
                return hashtable;
            }
        }
        return hashtable;
    }

    static Hashtable createIANACharset2JAVACharset() {
        Integer n;
        String string = System.getProperty("java.version");
        if (string.length() > 5) {
            string = string.substring(0, 5);
        }
        int n2 = (n = (Integer)jdk2NlsVersion.get(string)) != null ? n : 5;
        Hashtable<String, String> hashtable = new Hashtable<String, String>(400, 1.0f);
        switch (n2) {
            case 5: {
                hashtable.put("ASCII", "ASCII");
                hashtable.put("US-ASCII", "ASCII");
                hashtable.put("ANSI_X3.4-1986", "ASCII");
                hashtable.put("ANSI_X3.4-1968", "ASCII");
                hashtable.put("US", "ASCII");
                hashtable.put("CP367", "ASCII");
                hashtable.put("CSASCII", "ASCII");
                hashtable.put("CSKOI8R", "KOI8_R");
                hashtable.put("ISO-IR-6", "ASCII");
                hashtable.put("ISO_646.IRV:1991", "ASCII");
                hashtable.put("ISO646-US", "ASCII");
                hashtable.put("IBM367", "ASCII");
                hashtable.put("EBCDIC-CP-HP", "Cp424");
                hashtable.put("IBM1006", "Cp1006");
                hashtable.put("IBM1025", "Cp1025");
                hashtable.put("IBM1097", "Cp1097");
                hashtable.put("IBM1098", "Cp1098");
                hashtable.put("IBM1112", "Cp1112");
                hashtable.put("IBM1122", "Cp1122");
                hashtable.put("IBM1123", "Cp1123");
                hashtable.put("IBM1124", "Cp1124");
                hashtable.put("IBM1381", "Cp1381");
                hashtable.put("IBM1383", "Cp1383");
                hashtable.put("IBM33722", "Cp33722");
                hashtable.put("IBM737", "Cp737");
                hashtable.put("IBM838", "Cp838");
                hashtable.put("IBM856", "Cp856");
                hashtable.put("IBM858", "Cp858");
                hashtable.put("IBM921", "Cp921");
                hashtable.put("IBM922", "Cp922");
                hashtable.put("IBM923", "Cp923");
                hashtable.put("IBM930", "Cp930");
                hashtable.put("IBM933", "Cp933");
                hashtable.put("IBM935", "Cp935");
                hashtable.put("IBM937", "Cp937");
                hashtable.put("IBM942", "Cp942");
                hashtable.put("IBM942C", "Cp942C");
                hashtable.put("IBM943", "Cp943");
                hashtable.put("IBM943C", "Cp943C");
                hashtable.put("IBM948", "Cp948");
                hashtable.put("JIS_C6226-1983", "JIS0208");
                hashtable.put("JIS_X0201", "JIS0201");
                hashtable.put("JIS_X0212-1990", "JIS0212");
                hashtable.put("KSC5601-1992", "Johab");
                hashtable.put("ISO8859-1", "ISO8859_1");
                hashtable.put("ISO-8859-1", "ISO8859_1");
                hashtable.put("ISO_8859-1", "ISO8859_1");
                hashtable.put("ISO_8859-1:1987", "ISO8859_1");
                hashtable.put("ISO-IR-100", "ISO8859_1");
                hashtable.put("LATIN1", "ISO8859_1");
                hashtable.put("L1", "ISO8859_1");
                hashtable.put("IBM819", "ISO8859_1");
                hashtable.put("CP819", "ISO8859_1");
                hashtable.put("CSISOLATIN1", "ISO8859_1");
                hashtable.put("ISO-8859-2", "ISO8859_2");
                hashtable.put("ISO_8859-2", "ISO8859_2");
                hashtable.put("ISO_8859-2:1987", "ISO8859_2");
                hashtable.put("ISO8859-2", "ISO8859_2");
                hashtable.put("ISO-IR-101", "ISO8859_2");
                hashtable.put("LATIN2", "ISO8859_2");
                hashtable.put("L2", "ISO8859_2");
                hashtable.put("CSISOLATIN2", "ISO8859_2");
                hashtable.put("ISO-8859-3", "ISO8859_3");
                hashtable.put("ISO_8859-3", "ISO8859_3");
                hashtable.put("ISO_8859-3:1988", "ISO8859_3");
                hashtable.put("ISO-IR-109", "ISO8859_3");
                hashtable.put("LATIN3", "ISO8859_3");
                hashtable.put("L3", "ISO8859_3");
                hashtable.put("CSISOLATIN3", "ISO8859_3");
                hashtable.put("ISO-8859-4", "ISO8859_4");
                hashtable.put("ISO_8859-4", "ISO8859_4");
                hashtable.put("ISO_8859-4:1988", "ISO8859_4");
                hashtable.put("ISO-IR-110", "ISO8859_4");
                hashtable.put("LATIN4", "ISO8859_4");
                hashtable.put("L4", "ISO8859_4");
                hashtable.put("CSISOLATIN4", "ISO8859_4");
                hashtable.put("ISO-8859-5", "ISO8859_5");
                hashtable.put("ISO_8859-5", "ISO8859_5");
                hashtable.put("ISO_8859-5:1988", "ISO8859_5");
                hashtable.put("ISO-IR-144", "ISO8859_5");
                hashtable.put("CYRILLIC", "ISO8859_5");
                hashtable.put("CSISOLATINCYRILLIC", "ISO8859_5");
                hashtable.put("ISO-8859-6", "ISO8859_6");
                hashtable.put("ISO_8859-6", "ISO8859_6");
                hashtable.put("ISO_8859-6:1987", "ISO8859_6");
                hashtable.put("ISO-IR-127", "ISO8859_6");
                hashtable.put("ECMA-114", "ISO8859_6");
                hashtable.put("ARABIC", "ISO8859_6");
                hashtable.put("ASMO-708", "ISO8859_6");
                hashtable.put("CSISOLATINARABIC", "ISO8859_6");
                hashtable.put("ISO-8859-7", "ISO8859_7");
                hashtable.put("ISO_8859-7", "ISO8859_7");
                hashtable.put("ISO_8859-7:1987", "ISO8859_7");
                hashtable.put("ISO-IR-126", "ISO8859_7");
                hashtable.put("ECMA-118", "ISO8859_7");
                hashtable.put("ELOT_928", "ISO8859_7");
                hashtable.put("GREEK", "ISO8859_7");
                hashtable.put("GREEK8", "ISO8859_7");
                hashtable.put("CSISOLATINGREEK", "ISO8859_7");
                hashtable.put("ISO-8859-8", "ISO8859_8");
                hashtable.put("ISO_8859-8", "ISO8859_8");
                hashtable.put("ISO_8859-8:1988", "ISO8859_8");
                hashtable.put("ISO-IR-138", "ISO8859_8");
                hashtable.put("HEBREW", "ISO8859_8");
                hashtable.put("VISUAL", "ISO8859_8");
                hashtable.put("ISO-8859-8 VISUAL", "ISO8859_8");
                hashtable.put("CSISOLATINHEBREW", "ISO8859_8");
                hashtable.put("ISO-8859-9", "ISO8859_9");
                hashtable.put("ISO_8859-9", "ISO8859_9");
                hashtable.put("ISO_8859-9:1989", "ISO8859_9");
                hashtable.put("ISO-IR-148", "ISO8859_9");
                hashtable.put("LATIN5", "ISO8859_9");
                hashtable.put("L5", "ISO8859_9");
                hashtable.put("CSISOLATIN5", "ISO8859_9");
                hashtable.put("BIG5", "Big5");
                hashtable.put("CSBIG5", "Big5");
                hashtable.put("X-X-BIG5", "Big5");
                hashtable.put("EBCDIC", "Cp037");
                hashtable.put("EBCDIC-CP-US", "Cp037");
                hashtable.put("EBCDIC-CP-CA", "Cp037");
                hashtable.put("EBCDIC-CP-NL", "Cp037");
                hashtable.put("EBCDIC-CP-WT", "Cp037");
                hashtable.put("IBM037", "Cp037");
                hashtable.put("CP037", "Cp037");
                hashtable.put("CSIBM037", "Cp037");
                hashtable.put("IBM273", "Cp273");
                hashtable.put("CP273", "Cp273");
                hashtable.put("CSIBM273", "Cp273");
                hashtable.put("EBCDIC-CP-DK", "Cp277");
                hashtable.put("EBCDIC-CP-NO", "Cp277");
                hashtable.put("IBM277", "Cp277");
                hashtable.put("CSIBM277", "Cp277");
                hashtable.put("EBCDIC-CP-FI", "Cp278");
                hashtable.put("EBCDIC-CP-SE", "Cp278");
                hashtable.put("IBM278", "Cp278");
                hashtable.put("CP278", "Cp278");
                hashtable.put("CSIBM278", "Cp278");
                hashtable.put("EBCDIC-CP-IT", "Cp280");
                hashtable.put("IBM280", "Cp280");
                hashtable.put("CP280", "Cp280");
                hashtable.put("CSIBM280", "Cp280");
                hashtable.put("EBCDIC-CP-ES", "Cp284");
                hashtable.put("IBM284", "Cp284");
                hashtable.put("CP284", "Cp284");
                hashtable.put("CSIBM284", "Cp284");
                hashtable.put("EBCDIC-CP-GB", "Cp285");
                hashtable.put("IBM285", "Cp285");
                hashtable.put("CP285", "Cp285");
                hashtable.put("CSIBM285", "Cp285");
                hashtable.put("EBCDIC-CP-FR", "Cp297");
                hashtable.put("IBM297", "Cp297");
                hashtable.put("CP297", "Cp297");
                hashtable.put("CSIBM297", "Cp297");
                hashtable.put("EBCDIC-CP-AR1", "Cp420");
                hashtable.put("IBM420", "Cp420");
                hashtable.put("CP420", "Cp420");
                hashtable.put("CSIBM420", "Cp420");
                hashtable.put("EBCDIC-CP-HE", "Cp424");
                hashtable.put("IBM424", "Cp424");
                hashtable.put("CP424", "Cp424");
                hashtable.put("CSIBM424", "Cp424");
                hashtable.put("IBM437", "Cp437");
                hashtable.put("CP437", "Cp437");
                hashtable.put("437", "Cp437");
                hashtable.put("CSPC8CODEPAGE437", "Cp437");
                hashtable.put("EBCDIC-CP-BE", "Cp500");
                hashtable.put("EBCDIC-CP-CH", "Cp500");
                hashtable.put("IBM500", "Cp500");
                hashtable.put("CP500", "Cp500");
                hashtable.put("CSIBM500", "Cp500");
                hashtable.put("IBM775", "Cp775");
                hashtable.put("CP775", "Cp775");
                hashtable.put("CSPC775BALTIC", "Cp775");
                hashtable.put("IBM850", "Cp850");
                hashtable.put("CP850", "Cp850");
                hashtable.put("850", "Cp850");
                hashtable.put("CSPC850MULTILINGUAL", "Cp850");
                hashtable.put("IBM852", "Cp852");
                hashtable.put("852", "Cp852");
                hashtable.put("CP852", "Cp852");
                hashtable.put("CSPCP852", "Cp852");
                hashtable.put("IBM855", "Cp855");
                hashtable.put("CP855", "Cp855");
                hashtable.put("855", "Cp855");
                hashtable.put("CSIBM855", "Cp855");
                hashtable.put("IBM857", "Cp857");
                hashtable.put("CP857", "Cp857");
                hashtable.put("857", "Cp857");
                hashtable.put("CSIBM857", "Cp857");
                hashtable.put("IBM860", "Cp860");
                hashtable.put("CP860", "Cp860");
                hashtable.put("860", "Cp860");
                hashtable.put("CSIBM860", "Cp860");
                hashtable.put("IBM861", "Cp861");
                hashtable.put("CP861", "Cp861");
                hashtable.put("861", "Cp861");
                hashtable.put("CSIBM861", "Cp861");
                hashtable.put("CP-IS", "Cp861");
                hashtable.put("IBM862", "Cp862");
                hashtable.put("CP862", "Cp862");
                hashtable.put("862", "Cp862");
                hashtable.put("CSPC862LATINHEBREW", "Cp862");
                hashtable.put("IBM863", "Cp863");
                hashtable.put("CP863", "Cp863");
                hashtable.put("863", "Cp863");
                hashtable.put("CSIBM863", "Cp863");
                hashtable.put("IBM864", "Cp864");
                hashtable.put("CP864", "Cp864");
                hashtable.put("CSIBM864", "Cp864");
                hashtable.put("IBM865", "Cp865");
                hashtable.put("CP865", "Cp865");
                hashtable.put("865", "Cp865");
                hashtable.put("CSIBM865", "Cp865");
                hashtable.put("IBM866", "Cp866");
                hashtable.put("866", "Cp866");
                hashtable.put("CP866", "Cp866");
                hashtable.put("CSIBM866", "Cp866");
                hashtable.put("IBM868", "Cp868");
                hashtable.put("CP868", "Cp868");
                hashtable.put("CP-AR", "Cp868");
                hashtable.put("CSIBM868", "Cp868");
                hashtable.put("IBM869", "Cp869");
                hashtable.put("CP869", "Cp869");
                hashtable.put("869", "Cp869");
                hashtable.put("CP-GR", "Cp869");
                hashtable.put("CSIBM869", "Cp869");
                hashtable.put("EBCDIC-CP-ROECE", "Cp870");
                hashtable.put("EBCDIC-CP-YU", "Cp870");
                hashtable.put("IBM870", "Cp870");
                hashtable.put("CP870", "Cp870");
                hashtable.put("CSIBM870", "Cp870");
                hashtable.put("EBCDIC-CP-IS", "Cp871");
                hashtable.put("IBM871", "Cp871");
                hashtable.put("CP871", "Cp871");
                hashtable.put("CSIBM871", "Cp871");
                hashtable.put("EBCDIC-CP-AR2", "Cp918");
                hashtable.put("IBM918", "Cp918");
                hashtable.put("CP918", "Cp918");
                hashtable.put("CSIBM918", "Cp918");
                hashtable.put("IBM1026", "Cp1026");
                hashtable.put("CP1026", "Cp1026");
                hashtable.put("CSIBM1026", "Cp1026");
                hashtable.put("WINDOWS-1250", "Cp1250");
                hashtable.put("X-CP1250", "Cp1250");
                hashtable.put("WINDOWS-1251", "Cp1251");
                hashtable.put("X-CP1251", "Cp1251");
                hashtable.put("WINDOWS-1252", "Cp1252");
                hashtable.put("WINDOWS-1253", "Cp1253");
                hashtable.put("WINDOWS-1254", "Cp1254");
                hashtable.put("WINDOWS-1255", "Cp1255");
                hashtable.put("LOGICAL", "Cp1255");
                hashtable.put("WINDOWS-1256", "Cp1256");
                hashtable.put("WINDOWS-1257", "Cp1257");
                hashtable.put("WINDOWS-1258", "Cp1258");
                hashtable.put("EUC-CN", "EUC_CN");
                hashtable.put("EUC-JP", "EUC_JP");
                hashtable.put("CSEUCPKDFMTJAPANESE", "EUC_JP");
                hashtable.put("EXTENDED_UNIX_CODE_PACKED_FORMAT_FOR_JAPANESE", "EUC_JP");
                hashtable.put("X-EUC", "EUC_JP");
                hashtable.put("X-EUC-JP", "EUC_JP");
                hashtable.put("KS_C_5601-1987", "EUC_KR");
                hashtable.put("EUC-KR", "EUC_KR");
                hashtable.put("KOREAN", "EUC_KR");
                hashtable.put("KS_C_5601", "EUC_KR");
                hashtable.put("CSKSC56011987", "EUC_KR");
                hashtable.put("CSEUC-KR", "EUC_KR");
                hashtable.put("CSEUCKR", "EUC_KR");
                hashtable.put("IBM00858", "Cp858");
                hashtable.put("CCSID00858", "Cp858");
                hashtable.put("CP00858", "Cp858");
                hashtable.put("PC-MULTILINGUAL-850+EURO", "Cp858");
                hashtable.put("IBM00924", "Cp924");
                hashtable.put("CCSID00924", "Cp924");
                hashtable.put("CP00924", "Cp924");
                hashtable.put("EBCDIC-LATIN9--EURO", "Cp924");
                hashtable.put("IBM01140", "Cp1140");
                hashtable.put("CCSID01140", "Cp1140");
                hashtable.put("CP01140", "Cp1140");
                hashtable.put("EBCDIC-US-37+EURO", "Cp1140");
                hashtable.put("IBM01141", "Cp1141");
                hashtable.put("CCSID01141", "Cp1141");
                hashtable.put("CP01141", "Cp1141");
                hashtable.put("EBCDIC-DE-273+EURO", "Cp1141");
                hashtable.put("IBM01142", "Cp1142");
                hashtable.put("CCSID01142", "Cp1142");
                hashtable.put("CP01142", "Cp1142");
                hashtable.put("EBCDIC-DK-277+EURO", "Cp1142");
                hashtable.put("EBCDIC-NO-277+EURO", "Cp1142");
                hashtable.put("IBM01143", "Cp1143");
                hashtable.put("CCSID01143", "Cp1143");
                hashtable.put("CP01143", "Cp1143");
                hashtable.put("EBCDIC-FI-278+EURO", "Cp1143");
                hashtable.put("EBCDIC-SE-278+EURO", "Cp1143");
                hashtable.put("IBM01144", "Cp1144");
                hashtable.put("CCSID01144", "Cp1144");
                hashtable.put("CP01144", "Cp1144");
                hashtable.put("EBCDIC-IT-280+EURO", "Cp1144");
                hashtable.put("IBM01145", "Cp1145");
                hashtable.put("CCSID01145", "Cp1145");
                hashtable.put("CP01145", "Cp1145");
                hashtable.put("EBCDIC-ES-284+EURO", "Cp1145");
                hashtable.put("IBM01146", "Cp1146");
                hashtable.put("CCSID01146", "Cp1146");
                hashtable.put("CP01146", "Cp1146");
                hashtable.put("EBCDIC-GB-285+EURO", "Cp1146");
                hashtable.put("IBM01147", "Cp1147");
                hashtable.put("CCSID01147", "Cp1147");
                hashtable.put("CP01147", "Cp1147");
                hashtable.put("EBCDIC-FR-297+EURO", "Cp1147");
                hashtable.put("IBM01148", "Cp1148");
                hashtable.put("CP01148", "Cp1148");
                hashtable.put("CCSID01148", "Cp1148");
                hashtable.put("EBCDIC-INTERNATIONAL-500+EURO", "Cp1148");
                hashtable.put("IBM01149", "Cp1149");
                hashtable.put("CCSID01149", "Cp1149");
                hashtable.put("CP01149", "Cp1149");
                hashtable.put("EBCDIC-IS-871+EURO", "Cp1149");
                hashtable.put("EUC-TW", "EUC_TW");
                hashtable.put("GBK", "MS936");
                hashtable.put("GB2312", "EUC_CN");
                hashtable.put("CHINESE", "EUC_CN");
                hashtable.put("CSGB2312", "EUC_CN");
                hashtable.put("CSISO58GB231280", "EUC_CN");
                hashtable.put("GB_2312-80", "EUC_CN");
                hashtable.put("ISO-IR-58", "EUC_CN");
                hashtable.put("ISO-2022-KR", "ISO2022KR");
                hashtable.put("CSISO2022KR", "ISO2022KR");
                hashtable.put("ISO-2022-JP", "ISO2022JP");
                hashtable.put("CSISO2022JP", "ISO2022JP");
                hashtable.put("ISO-2022-CN", "ISO2022CN");
                hashtable.put("CSISO2022CN", "ISO2022CN");
                hashtable.put("KOI8-R", "KOI8_R");
                hashtable.put("CSKOI8-R", "KOI8_R");
                hashtable.put("KOI", "KOI8_R");
                hashtable.put("WINDOWS-874", "TIS620");
                hashtable.put("TIS-620", "TIS620");
                hashtable.put("SHIFT_JIS", "MS932");
                hashtable.put("SHIFT-JIS", "MS932");
                hashtable.put("MS_KANJI", "MS932");
                hashtable.put("X-MS-CP932", "MS932");
                hashtable.put("X-SJIS", "MS932");
                hashtable.put("CSSHIFTJIS", "MS932");
                hashtable.put("CSWINDOWS31J", "MS932");
                hashtable.put("WINDOWS-949", "MS949");
                hashtable.put("WINDOWS-950", "MS950");
                hashtable.put("WINDOWS-936", "MS936");
                hashtable.put("UTF-8", "UTF8");
                hashtable.put("UNICODE-1-1-UTF-8", "UTF8");
                hashtable.put("UNICODE-2-0-UTF-8", "UTF8");
                hashtable.put("X-UNICODE-2-0-UTF-8", "UTF8");
                hashtable.put("X-ANSI", "Cp1252");
                hashtable.put("ISO_8859-15", "ISO8859_15_FDIS");
                hashtable.put("ISO_8859-13", "ISO8859_13");
                hashtable.put("ISO-8859-15", "ISO8859_15_FDIS");
                hashtable.put("ISO-8859-13", "ISO8859_13");
                return hashtable;
            }
        }
        hashtable.put("ASCII", "ASCII");
        hashtable.put("US-ASCII", "ASCII");
        hashtable.put("ANSI_X3.4-1986", "ASCII");
        hashtable.put("ANSI_X3.4-1968", "ASCII");
        hashtable.put("US", "ASCII");
        hashtable.put("CP367", "ASCII");
        hashtable.put("CSASCII", "ASCII");
        hashtable.put("CSKOI8R", "KOI8_R");
        hashtable.put("ISO-IR-6", "ASCII");
        hashtable.put("ISO_646.IRV:1991", "ASCII");
        hashtable.put("ISO646-US", "ASCII");
        hashtable.put("IBM367", "ASCII");
        hashtable.put("EBCDIC-CP-HP", "Cp424");
        hashtable.put("IBM1006", "Cp1006");
        hashtable.put("IBM1025", "Cp1025");
        hashtable.put("IBM1097", "Cp1097");
        hashtable.put("IBM1098", "Cp1098");
        hashtable.put("IBM1112", "Cp1112");
        hashtable.put("IBM1122", "Cp1122");
        hashtable.put("IBM1123", "Cp1123");
        hashtable.put("IBM1124", "Cp1124");
        hashtable.put("IBM1381", "Cp1381");
        hashtable.put("IBM1383", "Cp1383");
        hashtable.put("IBM33722", "Cp33722");
        hashtable.put("IBM737", "Cp737");
        hashtable.put("IBM838", "Cp838");
        hashtable.put("IBM856", "Cp856");
        hashtable.put("IBM858", "Cp858");
        hashtable.put("IBM921", "Cp921");
        hashtable.put("IBM922", "Cp922");
        hashtable.put("IBM923", "Cp923");
        hashtable.put("IBM930", "Cp930");
        hashtable.put("IBM933", "Cp933");
        hashtable.put("IBM935", "Cp935");
        hashtable.put("IBM937", "Cp937");
        hashtable.put("IBM942", "Cp942");
        hashtable.put("IBM942C", "Cp942C");
        hashtable.put("IBM943", "Cp943");
        hashtable.put("IBM943C", "Cp943C");
        hashtable.put("IBM948", "Cp948");
        hashtable.put("JIS_C6226-1983", "JIS0208");
        hashtable.put("JIS_X0201", "JIS0201");
        hashtable.put("JIS_X0212-1990", "JIS0212");
        hashtable.put("KSC5601-1992", "Johab");
        hashtable.put("ISO8859-1", "ISO8859_1");
        hashtable.put("ISO-8859-1", "ISO8859_1");
        hashtable.put("ISO_8859-1", "ISO8859_1");
        hashtable.put("ISO_8859-1:1987", "ISO8859_1");
        hashtable.put("ISO-IR-100", "ISO8859_1");
        hashtable.put("LATIN1", "ISO8859_1");
        hashtable.put("L1", "ISO8859_1");
        hashtable.put("IBM819", "ISO8859_1");
        hashtable.put("CP819", "ISO8859_1");
        hashtable.put("CSISOLATIN1", "ISO8859_1");
        hashtable.put("ISO-8859-2", "ISO8859_2");
        hashtable.put("ISO_8859-2", "ISO8859_2");
        hashtable.put("ISO_8859-2:1987", "ISO8859_2");
        hashtable.put("ISO8859-2", "ISO8859_2");
        hashtable.put("ISO-IR-101", "ISO8859_2");
        hashtable.put("LATIN2", "ISO8859_2");
        hashtable.put("L2", "ISO8859_2");
        hashtable.put("CSISOLATIN2", "ISO8859_2");
        hashtable.put("ISO-8859-3", "ISO8859_3");
        hashtable.put("ISO_8859-3", "ISO8859_3");
        hashtable.put("ISO_8859-3:1988", "ISO8859_3");
        hashtable.put("ISO-IR-109", "ISO8859_3");
        hashtable.put("LATIN3", "ISO8859_3");
        hashtable.put("L3", "ISO8859_3");
        hashtable.put("CSISOLATIN3", "ISO8859_3");
        hashtable.put("ISO-8859-4", "ISO8859_4");
        hashtable.put("ISO_8859-4", "ISO8859_4");
        hashtable.put("ISO_8859-4:1988", "ISO8859_4");
        hashtable.put("ISO-IR-110", "ISO8859_4");
        hashtable.put("LATIN4", "ISO8859_4");
        hashtable.put("L4", "ISO8859_4");
        hashtable.put("CSISOLATIN4", "ISO8859_4");
        hashtable.put("ISO-8859-5", "ISO8859_5");
        hashtable.put("ISO_8859-5", "ISO8859_5");
        hashtable.put("ISO_8859-5:1988", "ISO8859_5");
        hashtable.put("ISO-IR-144", "ISO8859_5");
        hashtable.put("CYRILLIC", "ISO8859_5");
        hashtable.put("CSISOLATINCYRILLIC", "ISO8859_5");
        hashtable.put("ISO-8859-6", "ISO8859_6");
        hashtable.put("ISO_8859-6", "ISO8859_6");
        hashtable.put("ISO_8859-6:1987", "ISO8859_6");
        hashtable.put("ISO-IR-127", "ISO8859_6");
        hashtable.put("ECMA-114", "ISO8859_6");
        hashtable.put("ARABIC", "ISO8859_6");
        hashtable.put("ASMO-708", "ISO8859_6");
        hashtable.put("CSISOLATINARABIC", "ISO8859_6");
        hashtable.put("ISO-8859-7", "ISO8859_7");
        hashtable.put("ISO_8859-7", "ISO8859_7");
        hashtable.put("ISO_8859-7:1987", "ISO8859_7");
        hashtable.put("ISO-IR-126", "ISO8859_7");
        hashtable.put("ECMA-118", "ISO8859_7");
        hashtable.put("ELOT_928", "ISO8859_7");
        hashtable.put("GREEK", "ISO8859_7");
        hashtable.put("GREEK8", "ISO8859_7");
        hashtable.put("CSISOLATINGREEK", "ISO8859_7");
        hashtable.put("ISO-8859-8", "ISO8859_8");
        hashtable.put("ISO_8859-8", "ISO8859_8");
        hashtable.put("ISO_8859-8:1988", "ISO8859_8");
        hashtable.put("ISO-IR-138", "ISO8859_8");
        hashtable.put("HEBREW", "ISO8859_8");
        hashtable.put("VISUAL", "ISO8859_8");
        hashtable.put("ISO-8859-8 VISUAL", "ISO8859_8");
        hashtable.put("CSISOLATINHEBREW", "ISO8859_8");
        hashtable.put("ISO-8859-9", "ISO8859_9");
        hashtable.put("ISO_8859-9", "ISO8859_9");
        hashtable.put("ISO_8859-9:1989", "ISO8859_9");
        hashtable.put("ISO-IR-148", "ISO8859_9");
        hashtable.put("LATIN5", "ISO8859_9");
        hashtable.put("L5", "ISO8859_9");
        hashtable.put("CSISOLATIN5", "ISO8859_9");
        hashtable.put("ISO_8859-13", "ISO8859_13");
        hashtable.put("ISO-8859-13", "ISO8859_13");
        hashtable.put("ISO_8859-15", "ISO8859_15_FDIS");
        hashtable.put("ISO-8859-15", "ISO8859_15_FDIS");
        hashtable.put("BIG5", "Big5");
        hashtable.put("CSBIG5", "Big5");
        hashtable.put("X-X-BIG5", "Big5");
        hashtable.put("EBCDIC", "Cp037");
        hashtable.put("EBCDIC-CP-US", "Cp037");
        hashtable.put("EBCDIC-CP-CA", "Cp037");
        hashtable.put("EBCDIC-CP-NL", "Cp037");
        hashtable.put("EBCDIC-CP-WT", "Cp037");
        hashtable.put("IBM037", "Cp037");
        hashtable.put("CP037", "Cp037");
        hashtable.put("CSIBM037", "Cp037");
        hashtable.put("IBM273", "Cp273");
        hashtable.put("CP273", "Cp273");
        hashtable.put("CSIBM273", "Cp273");
        hashtable.put("EBCDIC-CP-DK", "Cp277");
        hashtable.put("EBCDIC-CP-NO", "Cp277");
        hashtable.put("IBM277", "Cp277");
        hashtable.put("CSIBM277", "Cp277");
        hashtable.put("EBCDIC-CP-FI", "Cp278");
        hashtable.put("EBCDIC-CP-SE", "Cp278");
        hashtable.put("IBM278", "Cp278");
        hashtable.put("CP278", "Cp278");
        hashtable.put("CSIBM278", "Cp278");
        hashtable.put("EBCDIC-CP-IT", "Cp280");
        hashtable.put("IBM280", "Cp280");
        hashtable.put("CP280", "Cp280");
        hashtable.put("CSIBM280", "Cp280");
        hashtable.put("EBCDIC-CP-ES", "Cp284");
        hashtable.put("IBM284", "Cp284");
        hashtable.put("CP284", "Cp284");
        hashtable.put("CSIBM284", "Cp284");
        hashtable.put("EBCDIC-CP-GB", "Cp285");
        hashtable.put("IBM285", "Cp285");
        hashtable.put("CP285", "Cp285");
        hashtable.put("CSIBM285", "Cp285");
        hashtable.put("EBCDIC-CP-FR", "Cp297");
        hashtable.put("IBM297", "Cp297");
        hashtable.put("CP297", "Cp297");
        hashtable.put("CSIBM297", "Cp297");
        hashtable.put("EBCDIC-CP-AR1", "Cp420");
        hashtable.put("IBM420", "Cp420");
        hashtable.put("CP420", "Cp420");
        hashtable.put("CSIBM420", "Cp420");
        hashtable.put("EBCDIC-CP-HE", "Cp424");
        hashtable.put("IBM424", "Cp424");
        hashtable.put("CP424", "Cp424");
        hashtable.put("CSIBM424", "Cp424");
        hashtable.put("IBM437", "Cp437");
        hashtable.put("CP437", "Cp437");
        hashtable.put("437", "Cp437");
        hashtable.put("CSPC8CODEPAGE437", "Cp437");
        hashtable.put("EBCDIC-CP-BE", "Cp500");
        hashtable.put("EBCDIC-CP-CH", "Cp500");
        hashtable.put("IBM500", "Cp500");
        hashtable.put("CP500", "Cp500");
        hashtable.put("CSIBM500", "Cp500");
        hashtable.put("IBM775", "Cp775");
        hashtable.put("CP775", "Cp775");
        hashtable.put("CSPC775BALTIC", "Cp775");
        hashtable.put("IBM850", "Cp850");
        hashtable.put("CP850", "Cp850");
        hashtable.put("850", "Cp850");
        hashtable.put("CSPC850MULTILINGUAL", "Cp850");
        hashtable.put("IBM852", "Cp852");
        hashtable.put("852", "Cp852");
        hashtable.put("CP852", "Cp852");
        hashtable.put("CSPCP852", "Cp852");
        hashtable.put("IBM855", "Cp855");
        hashtable.put("CP855", "Cp855");
        hashtable.put("855", "Cp855");
        hashtable.put("CSIBM855", "Cp855");
        hashtable.put("IBM857", "Cp857");
        hashtable.put("CP857", "Cp857");
        hashtable.put("857", "Cp857");
        hashtable.put("CSIBM857", "Cp857");
        hashtable.put("IBM860", "Cp860");
        hashtable.put("CP860", "Cp860");
        hashtable.put("860", "Cp860");
        hashtable.put("CSIBM860", "Cp860");
        hashtable.put("IBM861", "Cp861");
        hashtable.put("CP861", "Cp861");
        hashtable.put("861", "Cp861");
        hashtable.put("CSIBM861", "Cp861");
        hashtable.put("CP-IS", "Cp861");
        hashtable.put("IBM862", "Cp862");
        hashtable.put("CP862", "Cp862");
        hashtable.put("862", "Cp862");
        hashtable.put("CSPC862LATINHEBREW", "Cp862");
        hashtable.put("IBM863", "Cp863");
        hashtable.put("CP863", "Cp863");
        hashtable.put("863", "Cp863");
        hashtable.put("CSIBM863", "Cp863");
        hashtable.put("IBM864", "Cp864");
        hashtable.put("CP864", "Cp864");
        hashtable.put("CSIBM864", "Cp864");
        hashtable.put("IBM865", "Cp865");
        hashtable.put("CP865", "Cp865");
        hashtable.put("865", "Cp865");
        hashtable.put("CSIBM865", "Cp865");
        hashtable.put("IBM866", "Cp866");
        hashtable.put("866", "Cp866");
        hashtable.put("CP866", "Cp866");
        hashtable.put("CSIBM866", "Cp866");
        hashtable.put("IBM868", "Cp868");
        hashtable.put("CP868", "Cp868");
        hashtable.put("CP-AR", "Cp868");
        hashtable.put("CSIBM868", "Cp868");
        hashtable.put("IBM869", "Cp869");
        hashtable.put("CP869", "Cp869");
        hashtable.put("869", "Cp869");
        hashtable.put("CP-GR", "Cp869");
        hashtable.put("CSIBM869", "Cp869");
        hashtable.put("EBCDIC-CP-ROECE", "Cp870");
        hashtable.put("EBCDIC-CP-YU", "Cp870");
        hashtable.put("IBM870", "Cp870");
        hashtable.put("CP870", "Cp870");
        hashtable.put("CSIBM870", "Cp870");
        hashtable.put("EBCDIC-CP-IS", "Cp871");
        hashtable.put("IBM871", "Cp871");
        hashtable.put("CP871", "Cp871");
        hashtable.put("CSIBM871", "Cp871");
        hashtable.put("EBCDIC-CP-AR2", "Cp918");
        hashtable.put("IBM918", "Cp918");
        hashtable.put("CP918", "Cp918");
        hashtable.put("CSIBM918", "Cp918");
        hashtable.put("IBM1026", "Cp1026");
        hashtable.put("CP1026", "Cp1026");
        hashtable.put("CSIBM1026", "Cp1026");
        hashtable.put("WINDOWS-1250", "Cp1250");
        hashtable.put("X-CP1250", "Cp1250");
        hashtable.put("WINDOWS-1251", "Cp1251");
        hashtable.put("X-CP1251", "Cp1251");
        hashtable.put("WINDOWS-1252", "Cp1252");
        hashtable.put("WINDOWS-1253", "Cp1253");
        hashtable.put("WINDOWS-1254", "Cp1254");
        hashtable.put("WINDOWS-1255", "Cp1255");
        hashtable.put("LOGICAL", "Cp1255");
        hashtable.put("WINDOWS-1256", "Cp1256");
        hashtable.put("WINDOWS-1257", "Cp1257");
        hashtable.put("WINDOWS-1258", "Cp1258");
        hashtable.put("EUC-CN", "EUC_CN");
        hashtable.put("EUC-JP", "EUC_JP");
        hashtable.put("CSEUCPKDFMTJAPANESE", "EUC_JP");
        hashtable.put("EXTENDED_UNIX_CODE_PACKED_FORMAT_FOR_JAPANESE", "EUC_JP");
        hashtable.put("X-EUC", "EUC_JP");
        hashtable.put("X-EUC-JP", "EUC_JP");
        hashtable.put("KS_C_5601-1987", "EUC_KR");
        hashtable.put("EUC-KR", "EUC_KR");
        hashtable.put("KOREAN", "EUC_KR");
        hashtable.put("KS_C_5601", "EUC_KR");
        hashtable.put("CSKSC56011987", "EUC_KR");
        hashtable.put("CSEUC-KR", "EUC_KR");
        hashtable.put("CSEUCKR", "EUC_KR");
        hashtable.put("EUC-TW", "EUC_TW");
        hashtable.put("GBK", "MS936");
        hashtable.put("GB2312", "EUC_CN");
        hashtable.put("CHINESE", "EUC_CN");
        hashtable.put("CSGB2312", "EUC_CN");
        hashtable.put("CSISO58GB231280", "EUC_CN");
        hashtable.put("GB_2312-80", "EUC_CN");
        hashtable.put("ISO-IR-58", "EUC_CN");
        hashtable.put("ISO-2022-KR", "ISO2022KR");
        hashtable.put("CSISO2022KR", "ISO2022KR");
        hashtable.put("IBM00858", "Cp858");
        hashtable.put("CCSID00858", "Cp858");
        hashtable.put("CP00858", "Cp858");
        hashtable.put("PC-MULTILINGUAL-850+EURO", "Cp858");
        hashtable.put("IBM00924", "Cp924");
        hashtable.put("CCSID00924", "Cp924");
        hashtable.put("CP00924", "Cp924");
        hashtable.put("EBCDIC-LATIN9--EURO", "Cp924");
        hashtable.put("IBM01140", "Cp1140");
        hashtable.put("CCSID01140", "Cp1140");
        hashtable.put("CP01140", "Cp1140");
        hashtable.put("EBCDIC-US-37+EURO", "Cp1140");
        hashtable.put("IBM01141", "Cp1141");
        hashtable.put("CCSID01141", "Cp1141");
        hashtable.put("CP01141", "Cp1141");
        hashtable.put("EBCDIC-DE-273+EURO", "Cp1141");
        hashtable.put("IBM01142", "Cp1142");
        hashtable.put("CCSID01142", "Cp1142");
        hashtable.put("CP01142", "Cp1142");
        hashtable.put("EBCDIC-DK-277+EURO", "Cp1142");
        hashtable.put("EBCDIC-NO-277+EURO", "Cp1142");
        hashtable.put("IBM01143", "Cp1143");
        hashtable.put("CCSID01143", "Cp1143");
        hashtable.put("CP01143", "Cp1143");
        hashtable.put("EBCDIC-FI-278+EURO", "Cp1143");
        hashtable.put("EBCDIC-SE-278+EURO", "Cp1143");
        hashtable.put("IBM01144", "Cp1144");
        hashtable.put("CCSID01144", "Cp1144");
        hashtable.put("CP01144", "Cp1144");
        hashtable.put("EBCDIC-IT-280+EURO", "Cp1144");
        hashtable.put("IBM01145", "Cp1145");
        hashtable.put("CCSID01145", "Cp1145");
        hashtable.put("CP01145", "Cp1145");
        hashtable.put("EBCDIC-ES-284+EURO", "Cp1145");
        hashtable.put("IBM01146", "Cp1146");
        hashtable.put("CCSID01146", "Cp1146");
        hashtable.put("CP01146", "Cp1146");
        hashtable.put("EBCDIC-GB-285+EURO", "Cp1146");
        hashtable.put("IBM01147", "Cp1147");
        hashtable.put("CCSID01147", "Cp1147");
        hashtable.put("CP01147", "Cp1147");
        hashtable.put("EBCDIC-FR-297+EURO", "Cp1147");
        hashtable.put("IBM01148", "Cp1148");
        hashtable.put("CP01148", "Cp1148");
        hashtable.put("CCSID01148", "Cp1148");
        hashtable.put("EBCDIC-INTERNATIONAL-500+EURO", "Cp1148");
        hashtable.put("IBM01149", "Cp1149");
        hashtable.put("CCSID01149", "Cp1149");
        hashtable.put("CP01149", "Cp1149");
        hashtable.put("EBCDIC-IS-871+EURO", "Cp1149");
        hashtable.put("ISO-2022-JP", "ISO2022JP");
        hashtable.put("CSISO2022JP", "ISO2022JP");
        hashtable.put("ISO-2022-CN", "ISO2022CN");
        hashtable.put("CSISO2022CN", "ISO2022CN");
        hashtable.put("KOI8-R", "KOI8_R");
        hashtable.put("CSKOI8-R", "KOI8_R");
        hashtable.put("KOI", "KOI8_R");
        hashtable.put("WINDOWS-874", "TIS620");
        hashtable.put("TIS-620", "TIS620");
        hashtable.put("SHIFT_JIS", "MS932");
        hashtable.put("SHIFT-JIS", "MS932");
        hashtable.put("MS_KANJI", "MS932");
        hashtable.put("X-MS-CP932", "MS932");
        hashtable.put("X-SJIS", "MS932");
        hashtable.put("CSSHIFTJIS", "MS932");
        hashtable.put("CSWINDOWS31J", "MS932");
        hashtable.put("WINDOWS-949", "MS949");
        hashtable.put("WINDOWS-950", "MS950");
        hashtable.put("WINDOWS-936", "MS936");
        hashtable.put("UTF-8", "UTF8");
        hashtable.put("UNICODE-1-1-UTF-8", "UTF8");
        hashtable.put("UNICODE-2-0-UTF-8", "UTF8");
        hashtable.put("X-UNICODE-2-0-UTF-8", "UTF8");
        hashtable.put("X-ANSI", "Cp1252");
        return hashtable;
    }

    static {
        jdk2NlsVersion = new Hashtable();
        jdk2NlsVersion.put("1.1.8", new Integer(4));
        jdk2NlsVersion.put("1.2", new Integer(4));
        jdk2NlsVersion.put("1.2.1", new Integer(5));
        jdk2NlsVersion.put("1.2.1p", new Integer(5));
        jdk2NlsVersion.put("1.2.2", new Integer(5));
        jdk2NlsVersion.put("1.3.0", new Integer(5));
    }
}

