/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.hadoop.execute;

import java.awt.Component;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import oracle.dbtools.common.utils.BasicDBObject;
import oracle.dbtools.data.loadservice.ExitCode;
import oracle.dbtools.extract.models.ExtractListModel;
import oracle.dbtools.extract.models.ExtractObject;
import oracle.dbtools.importer.ImportResources;
import oracle.dbtools.importer.core.ImportKeys;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.controls.sqldialog.ObjectActionController;
import oracle.dbtools.raptor.hadoop.core.HadoopEncryption;
import oracle.dbtools.raptor.hadoop.core.HadoopGenericTable;
import oracle.dbtools.raptor.hadoop.core.HadoopKeys;
import oracle.dbtools.raptor.hadoop.core.HadoopProperties;
import oracle.dbtools.raptor.hadoop.core.HadoopStrings;
import oracle.dbtools.raptor.hadoop.core.HadoopUtils;
import oracle.dbtools.raptor.hadoop.execute.HadoopExec;
import oracle.dbtools.raptor.hadoop.ui.HadoopWizArb;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.transfer.location.SshLocation;
import oracle.dbtools.transfer.location.SshSessionLocation;
import oracle.dbtools.transfer.utility.ScriptOutput;
import oracle.dbtools.util.Logger;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;
import org.apache.sshd.client.channel.ChannelShell;
import org.apache.sshd.client.session.ClientSession;
import org.stringtemplate.v4.ST;

public class BDACopyExec
extends HadoopExec {
    public static final int TYPE_DB_OBJECTS = 0;
    public static final int TYPE_QUERY = 1;
    private static final String NEW_LINE = "\n";
    private static final String ENV = "#!/bin/bash\n";
    private static final String HADOOP_HOME = "export PATH=$HADOOP_HOME/bin:${PATH}";
    private static final String P_CLUSTER_TNS_ADMIN = "oracle.hadoop.ctoh.connection.clusterTnsAdmin=";
    private static final String P_CLUSTER_WALLET_LOC = "oracle.hadoop.ctoh.connection.clusterWalletLoc=";
    private static final String P_COLUMNS = "oracle.hadoop.ctoh.columns=";
    private static final String P_CONN_URL = "oracle.hadoop.ctoh.jdbc.url=";
    private static final String P_CONN_USER = "oracle.hadoop.ctoh.connection.username=";
    private static final String P_HOME = "oracle.hadoop.ctoh.home=";
    private static final String P_MAX_SPLITS = "oracle.hadoop.ctoh.maxSplits=";
    private static final String P_OUTPUT_DIR = "mapreduce.output.fileoutputformat.outputdir=";
    private static final String P_OUTPUT = "oracle.hadoop.ctoh.datapump.output=";
    private static final String P_SPLITTER_TYPE = "oracle.hadoop.ctoh.splitterType=";
    private static final String P_PASS = "oracle.hadoop.ctoh.connection.password=";
    private static final String P_PASS_ENCRYPTED = "oracle.hadoop.ctoh.connection.encrypted.password=";
    private static final String P_SYSTEM_ID = "oracle.hadoop.ctoh.connection.systemId=";
    private static final String P_TARGET_TABLE = "oracle.hadoop.ctoh.target.table=";
    private static final String P_TABLE = "oracle.hadoop.ctoh.table=";
    private static final String P_TABLE_DP_BASENAME = "oracle.hadoop.ctoh.datapump.basename=";
    private static final String P_WALLET_TNS_ENTRY = "oracle.hadoop.ctoh.connection.tnsEntry=";
    private static final String P_WALLET_TNS_ADMIN = "oracle.hadoop.ctoh.connection.tnsAdmin=${TNS_ADMIN}";
    private static final String P_CLUSTER_WALLET_TNS_ENTRY = "oracle.hadoop.ctoh.connection.clusterTnsEntry=";
    private static final String P_CLUSTER_WALLET_TNS_ADMIN = "oracle.hadoop.ctoh.connection.clusterTnsAdmin=${CLUSTER_TNS_ADMIN}";
    private static final String P_WALLET_LOC = "oracle.hadoop.ctoh.connection.walletLoc=${WALLET_LOCATION}";
    private static final String P_WHERE = "oracle.hadoop.ctoh.whereClause=";
    private static final String V_SPLITTER_TYPE_BLOCK_SPLITTER = "BLOCK_SPLITTER";
    private static final String CLASSPATH1 = "setenv HADOOP_CLASSPATH  ";
    private static final String CLASSPATH2 = "/jlib/*\n";
    private static final String MKDIR = "mkdir -p ";
    private static final String EXEC_C2H_DIRECT = "hadoop jar  ${CP2HADOOP_HOME}/jlib/orahivedp.jar  oracle.hadoop.ctoh.CtohDriver";
    private static final String PARM = "-D ";
    private static final String SEP = " \\\n";
    private static final String EXEC = "\r\n";
    private static final SimpleDateFormat S_DATEFORMAT = new SimpleDateFormat("yyyyMMddHHmmss");
    protected final String ENCODING_UTF8 = "UTF-8";
    private DatabaseQueryTask<Void> _task = null;
    private ExtractListModel _listModel;
    private ExtractObject _eo;
    private BasicDBObject _dbo;
    protected String _srcConnUrl;
    protected String _srcUser;
    private String _srcXTabName;
    private String[] _srcStrFiles;
    private String _sourceEnv;
    private String _destDataFormat;
    private String _oraPath;
    private String _destDir;
    private StringBuffer _process;
    private String _sourceXTab;
    private String _putScript;
    private String _direct;
    private String _hiveTab;
    private String _hiveXTab;
    private String _hiveTempXTab;
    private String _appendHiveXTab;
    private String _dropTempDeployFile;
    private String _dropDirectWorkDir;
    private String _dropTempHiveFiles;
    private String _dropTempHiveTable;
    private String _dropSource;
    SshSessionLocation _sessLoc;
    private String _tempDir;
    private String _tempName;
    private String _xmlName;
    private String _xml;
    private ScriptOutput _result;
    boolean _isStagingMethod = true;
    boolean _isExistingTable;
    boolean _isCleanupSourceNeeded = false;
    boolean _isCleanupDestNeeded = false;
    boolean _isCleanupDeployNeeded = false;
    boolean _isFail = false;
    boolean _isWallet = false;
    boolean _cancel = false;
    private HashMap<BasicDBObject, String> _transientXTabs = new HashMap();
    private int timeout = 60000;

    @Override
    public ExitCode start(HadoopProperties hadoopProperties) {
        this._logPrefix = HadoopWizArb.getString("BDA_EXEC_LOG_PREFIX");
        this._isExistingTable = (Boolean)hadoopProperties.get(ImportKeys.IS_EXISTING_TABLE);
        this._isStagingMethod = hadoopProperties.get(ImportKeys.LOAD_METHOD).equals(3);
        this._destDataFormat = (String)hadoopProperties.get(HadoopKeys.DEST_DATA_FORMAT);
        this._exitCode = super.start(hadoopProperties);
        this._srcUser = HadoopUtils.getOracleUser(this._hProps);
        this._srcConnUrl = HadoopUtils.getOracleUrl(this._hProps);
        this._destTableName = "'\"" + (String)hadoopProperties.get(HadoopKeys.DEST_SCHEMA) + "\".\"" + (String)hadoopProperties.get(HadoopKeys.DEST_TABLE) + "\" '";
        this._sessLoc = (SshSessionLocation)hadoopProperties.get(HadoopKeys.SSH_SESSION_LOCATION);
        this._tempDir = "sqldev_temp/";
        this._tempName = HadoopUtils.getTempName("sqldev_c2h");
        this._sourceEnv = (String)hadoopProperties.get(HadoopKeys.ENV_SOURCE);
        if (this._isStagingMethod) {
            this._oraPath = HadoopUtils.getDirectoryPath(this._srcConn, (String)this._hProps.get(ImportKeys.ORADIRNAME));
            if (!this._oraPath.endsWith("/") && !this._oraPath.endsWith("\\")) {
                this._oraPath = this._oraPath + "/";
            }
        } else {
            this._oraPath = "";
        }
        this._destDir = (String)this._hProps.get(HadoopKeys.DEST_DIR);
        this.openLog();
        this._listModel = (ExtractListModel)this._hProps.get(HadoopKeys.EXTRACT_LIST_MODEL);
        List list = this._listModel.getList(0);
        Iterator iterator = list.iterator();
        if (iterator.hasNext()) {
            ExtractObject extractObject;
            this._eo = extractObject = (ExtractObject)iterator.next();
            this._dbo = extractObject.getDBObject();
            this._sourceXTab = this.getSourceXTab();
            if (this._isStagingMethod) {
                this._putScript = this.getPutScript();
            } else {
                this._direct = this.getDirectHiveScript();
            }
            if (!this._isExistingTable) {
                if (this._destDataFormat.equals("Data Pump")) {
                    this._hiveXTab = this.getHiveXTab();
                } else {
                    this._hiveTempXTab = this.getHiveTempXTab();
                    this._hiveTab = this.getHiveTab();
                    this._dropTempHiveFiles = this.getDropTempHiveFiles();
                    this._dropTempHiveTable = this.getDropHiveTempXTab();
                }
            } else if (!this._destDataFormat.equals("Data Pump")) {
                this._hiveTempXTab = this.getHiveTempXTab();
                this._appendHiveXTab = this.getAppendHiveXTab();
                this._dropTempHiveFiles = this.getDropTempHiveFiles();
                this._dropTempHiveTable = this.getDropHiveTempXTab();
            }
            if (this._isStagingMethod) {
                this._dropTempDeployFile = this.getDropTempDeployFile();
                this._dropSource = this.getDropSource();
            } else {
                this._dropTempDeployFile = this.getDropDirect();
                this._dropDirectWorkDir = this.getDropDirectWorkDir();
            }
        }
        this._process = new StringBuffer();
        this.log(HadoopWizArb.format("BDA_EXEC_START", HadoopWizArb.getString("COPY_BDA")));
        this.log(HadoopWizArb.getString("CLUSTER") + " " + hadoopProperties.getString(HadoopKeys.CLUSTER));
        this.log(HadoopWizArb.getString("ENV_FILE") + " " + hadoopProperties.getString(HadoopKeys.ENV_FILE));
        this.log("SSH HOST: " + hadoopProperties.getString(HadoopKeys.SSH_HOST));
        return this._exitCode;
    }

    @Override
    public ExitCode doExec() {
        this.doWithRaptorTask();
        return this._exitCode;
    }

    public String getScript() {
        this._process.append(HadoopWizArb.getString("BDA_EXEC_PROCESS") + NEW_LINE);
        if (this._isStagingMethod) {
            this.processStep(HadoopWizArb.format("BDA_EXEC_STEP_CREATE_SOURCE", this._srcConnDisplayName), this._sourceXTab);
            this.processStep(HadoopWizArb.getString("BDA_EXEC_STEP_HADOOP_PUT"), this._putScript);
        } else {
            this.processStep("Direct Copy from Oracle", this._direct);
        }
        if (!this._isExistingTable) {
            if (!this._destDataFormat.equals(HadoopStrings.DATA_PUMP)) {
                this.processStep(HadoopWizArb.format("BDA_EXEC_STEP_CREATE_TEMP_DEST", this._destConnDisplayName), this._hiveTempXTab);
                this.processStep(HadoopWizArb.format("BDA_EXEC_STEP_CREATE_DEST_TAB", this._destConnDisplayName), this._hiveTab);
            } else {
                this.processStep(HadoopWizArb.format("BDA_EXEC_STEP_CREATE_DEST", this._destConnDisplayName), this._hiveXTab);
            }
        } else if (!this._destDataFormat.equals(HadoopStrings.DATA_PUMP)) {
            this.processStep(HadoopWizArb.format("BDA_EXEC_STEP_CREATE_TEMP_DEST", this._destConnDisplayName), this._hiveTempXTab);
            this.processStep(HadoopWizArb.format("BDA_EXEC_STEP_APPEND_DEST", this._destConnDisplayName), this._appendHiveXTab);
        }
        if (!this._destDataFormat.equals(HadoopStrings.DATA_PUMP)) {
            this.processStep(HadoopWizArb.format("BDA_EXEC_STEP_DROP_TEMP_HIVE_FILES", this._destConnDisplayName), this._dropTempHiveFiles);
            this.processStep(HadoopWizArb.format("BDA_EXEC_STEP_DROP_TEMP_HIVE_TABLE", this._destConnDisplayName), this._dropTempHiveTable);
        }
        if (this._isStagingMethod) {
            this.processStep(HadoopWizArb.format("BDA_EXEC_STEP_DROP_DEPLOY_FILE", new Object[0]), this._dropTempDeployFile);
            this.processStep(HadoopWizArb.format("BDA_EXEC_STEP_CLEANUP_SOURCE", new Object[0]), this._dropSource);
        } else if (this._hProps.getValueBoolean(HadoopKeys.DELETE_DEPLOY).booleanValue() && this._dropTempDeployFile != null && !this._dropTempDeployFile.isEmpty()) {
            this.processStep(HadoopWizArb.format("BDA_EXEC_STEP_DROP_DEPLOY_FILE", new Object[0]), this._dropTempDeployFile);
            this.processStep(HadoopWizArb.format("BDA_EXEC_STEP_DROP_WORK_DIR", new Object[0]), this._dropDirectWorkDir);
        }
        return this._process.toString();
    }

    private String getDirectHiveScript() {
        String string;
        String string2 = this._dbo.getSchemaName() + "." + this._dbo.getObjectName();
        String string3 = HadoopWizArb.format("BDA_EXEC_STEP_LOAD", this._destTableName, this._destConnDisplayName, string2);
        this.log(NEW_LINE + HadoopWizArb.format("BDA_EXEC_STEP_START", string3));
        String string4 = "$C2H_HOME";
        StringBuilder stringBuilder = new StringBuilder("hadoop jar  ${CP2HADOOP_HOME}/jlib/orahivedp.jar  oracle.hadoop.ctoh.CtohDriver \\\n");
        stringBuilder.append("-D oracle.hadoop.ctoh.maxSplits=" + this._hProps.getValueInteger(HadoopKeys.PARALLEL).toString() + SEP);
        stringBuilder.append("-D oracle.hadoop.ctoh.table=" + string2 + SEP);
        stringBuilder.append("-D oracle.hadoop.ctoh.datapump.basename=" + this._tempName + SEP);
        stringBuilder.append("-D mapreduce.output.fileoutputformat.outputdir=" + this._tempName + SEP);
        stringBuilder.append("-D oracle.hadoop.ctoh.datapump.output=" + (String)this._hProps.get(HadoopKeys.DEST_DIR) + SEP);
        stringBuilder.append("-D oracle.hadoop.ctoh.splitterType=BLOCK_SPLITTER \\\n");
        this._eo = (ExtractObject)this._hProps.get(HadoopKeys.EXTRACT_OBJECT);
        String string5 = HadoopUtils.getWhere(this._eo);
        if (string5 != null) {
            string5.trim();
            if (!string5.isEmpty()) {
                stringBuilder.append("-D oracle.hadoop.ctoh.whereClause=\" " + string5 + " \"" + SEP);
            }
        }
        if (!(string = this._eo.getColumns()).startsWith("*")) {
            stringBuilder.append("-D oracle.hadoop.ctoh.columns=" + string + SEP);
        }
        this.doCredentials(stringBuilder);
        return stringBuilder.toString();
    }

    private void doCredentials(StringBuilder stringBuilder) {
        this._isWallet = (Boolean)this._hProps.get(HadoopKeys.IS_USE_WALLET);
        if (this._isWallet) {
            stringBuilder.append("-D oracle.hadoop.ctoh.connection.walletLoc=${WALLET_LOCATION} \\\n");
            stringBuilder.append("-D oracle.hadoop.ctoh.connection.tnsAdmin=${TNS_ADMIN} \\\n");
            stringBuilder.append("-D oracle.hadoop.ctoh.connection.tnsEntry=" + (String)this._hProps.get(HadoopKeys.WALLET_CREDENTIAL) + SEP);
            stringBuilder.append("-D oracle.hadoop.ctoh.connection.clusterTnsAdmin=${CLUSTER_TNS_ADMIN} \\\n");
        } else {
            stringBuilder.append("-D oracle.hadoop.ctoh.jdbc.url=" + this._srcConnUrl + SEP);
            stringBuilder.append("-D oracle.hadoop.ctoh.connection.username=" + this._srcUser + SEP);
            this.setPasswordXml();
            stringBuilder.append("-conf " + this._xmlName + SEP);
        }
    }

    private void setPasswordXml() {
        String string = HadoopEncryption.getRandomUUID();
        String string2 = HadoopEncryption.encryptPassword(HadoopUtils.getOraclePass(this._hProps), string, HadoopEncryption.getCTOHSalt(this._tempName, this._dbo.getSchemaName() + "." + this._dbo.getObjectName()));
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<?xml version=\"1.0\"?>" + this.getTerm());
        stringBuffer.append("  <configuration>" + this.getTerm());
        stringBuffer.append("    <property>" + this.getTerm());
        stringBuffer.append("      <name>oracle.hadoop.ctoh.connection.systemId</name>" + this.getTerm());
        stringBuffer.append("      <value>" + string + "</value>" + this.getTerm());
        stringBuffer.append("    </property>" + this.getTerm());
        stringBuffer.append("    <property>" + this.getTerm());
        stringBuffer.append("      <name>oracle.hadoop.ctoh.connection.encrypted.password</name>" + this.getTerm());
        stringBuffer.append("      <value>" + string2 + "</value>" + this.getTerm());
        stringBuffer.append("    </property>" + this.getTerm());
        stringBuffer.append("  </configuration>" + this.getTerm());
        this._xml = stringBuffer.toString();
        this._xmlName = this._tempDir + this._tempName + "_conf.xml";
    }

    public void doWithRaptorTask() {
        IRaptorTaskRunMode iRaptorTaskRunMode = IRaptorTaskRunMode.MODAL_OPTIONAL;
        String string = HadoopWizArb.getString("COPY_BDA");
        this._task = new DatabaseQueryTask<Void>(string, iRaptorTaskRunMode, false, true){

            public Void doWork() {
                try {
                    if (BDACopyExec.this._isStagingMethod) {
                        if (BDACopyExec.this._cancel || !BDACopyExec.this.doSourceXTab()) {
                            BDACopyExec.this._isFail = true;
                        }
                        if (!BDACopyExec.this._cancel && !BDACopyExec.this.doCopyBDAPut(BDACopyExec.this._dbo)) {
                            // empty if block
                        }
                    } else if (BDACopyExec.this._cancel || !BDACopyExec.this.doDirect(BDACopyExec.this._dbo)) {
                        BDACopyExec.this._isFail = true;
                    }
                    if (!BDACopyExec.this._isFail) {
                        if (!BDACopyExec.this._isExistingTable) {
                            if (!BDACopyExec.this._destDataFormat.equals(HadoopStrings.DATA_PUMP)) {
                                if (BDACopyExec.this._cancel || !BDACopyExec.this.doHiveTempXTab(BDACopyExec.this._dbo)) {
                                    BDACopyExec.this._isFail = true;
                                }
                                if (BDACopyExec.this._cancel || BDACopyExec.this._isFail || !BDACopyExec.this.doHiveTab(BDACopyExec.this._dbo)) {
                                    BDACopyExec.this._isFail = true;
                                }
                            } else if (BDACopyExec.this._cancel || BDACopyExec.this._isFail || !BDACopyExec.this.doHiveXTab(BDACopyExec.this._dbo)) {
                                BDACopyExec.this._isFail = true;
                            }
                        } else if (!BDACopyExec.this._destDataFormat.equals(HadoopStrings.DATA_PUMP)) {
                            if (BDACopyExec.this._cancel || BDACopyExec.this._isFail || !BDACopyExec.this.doHiveTempXTab(BDACopyExec.this._dbo)) {
                                BDACopyExec.this._isFail = true;
                            }
                            if (BDACopyExec.this._cancel && BDACopyExec.this._isFail || !BDACopyExec.this.doAppendHiveXTab(BDACopyExec.this._dbo)) {
                                BDACopyExec.this._isFail = true;
                            }
                        }
                    }
                    if (!BDACopyExec.this._destDataFormat.equals(HadoopStrings.DATA_PUMP) && BDACopyExec.this._isCleanupDestNeeded) {
                        if (!BDACopyExec.this.doDropTempHiveFiles(BDACopyExec.this._dbo)) {
                            BDACopyExec.this._isFail = true;
                        }
                        if (!BDACopyExec.this.doDropHiveTempXTab(BDACopyExec.this._dbo)) {
                            BDACopyExec.this._isFail = true;
                        }
                    }
                    if (BDACopyExec.this._isCleanupDeployNeeded) {
                        if (BDACopyExec.this._isStagingMethod) {
                            if (!BDACopyExec.this.doDropTempDeployFile(BDACopyExec.this._dbo)) {
                                BDACopyExec.this._isFail = true;
                            }
                        } else if (!BDACopyExec.this.dropDirectDeploy() || !BDACopyExec.this.doDropDirectWorkDir()) {
                            BDACopyExec.this._isFail = true;
                        }
                    }
                }
                catch (Exception exception) {
                    Logger.warn(((Object)((Object)this)).getClass(), (String)exception.getStackTrace()[0].toString(), (Throwable)exception);
                }
                this.finish();
                return null;
            }

            public boolean cancel() {
                BDACopyExec.this._cancel = true;
                return true;
            }

            public String getConnectionName() {
                return BDACopyExec.this._srcConnName;
            }

            public String getQuery() {
                return "";
            }

            private void finish() {
                BDACopyExec.this.doCleanupSource(BDACopyExec.this._dbo);
                String string = HadoopWizArb.getString("COPY_BDA_SUCCESS");
                if (BDACopyExec.this._cancel) {
                    string = HadoopWizArb.getString("COPY_BDA_CANCELLED");
                } else if (BDACopyExec.this._isFail) {
                    string = HadoopWizArb.getString("COPY_BDA_ERROR");
                }
                BDACopyExec.this.log(string);
                BDACopyExec.this.closeLog();
                try {
                    HadoopExec.openLogNode(BDACopyExec.this.getLogFile().toURI().toURL());
                }
                catch (Exception exception) {
                    Logger.warn(((Object)((Object)this)).getClass(), (String)exception.getStackTrace()[0].toString(), (Throwable)exception);
                }
                if (!BDACopyExec.this._isExistingTable) {
                    this.getPostProcessCallback().run();
                }
                Logger.info(((Object)((Object)this)).getClass(), (String)string);
                this.showFinalMsg(string);
            }

            private ObjectActionController.ObjectActionPostProcess getPostProcessCallback() {
                ObjectAction objectAction = (ObjectAction)BDACopyExec.this._hProps.get(ImportKeys.OBJECTACTION);
                DBObject dBObject = (DBObject)BDACopyExec.this._hProps.get(ImportKeys.DBOBJECT);
                ObjectActionController.ObjectActionPostProcess objectActionPostProcess = ObjectActionController.getPostProcessCallback((ObjectAction)objectAction, (DBObject)dBObject);
                return objectActionPostProcess;
            }

            private void showFinalMsg(String string) {
                final String string2 = string == null || string.length() == 0 ? "" : string;
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            MessageDialog.information((Component)Ide.getMainWindow(), (Object)string2, (String)ImportResources.getString((String)"TASK_SHORT_NAME"), null);
                        }
                        catch (Exception exception) {
                            Logger.warn(this.getClass(), (String)exception.getStackTrace()[0].toString(), (Throwable)exception);
                        }
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        };
        this._task.setCancellable(true);
        this._task.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                BDACopyExec.this._task = null;
            }
        });
        RaptorTaskManager.getInstance().addTask(this._task);
    }

    public void cancelExport() {
    }

    private boolean doSourceXTab() throws Exception {
        ExitCode exitCode = ExitCode.EXIT_SUCCESS;
        String string = HadoopWizArb.format("BDA_EXEC_STEP_CREATE_SOURCE", this._srcConnDisplayName);
        this._task.setMessage(string);
        this.log(NEW_LINE + HadoopWizArb.format("BDA_EXEC_STEP_START", string));
        this.log(this._sourceXTab);
        exitCode = this.pstmtExec((Connection)this._hProps.get(HadoopKeys.SOURCE_CONN), this._sourceXTab);
        if (exitCode != ExitCode.EXIT_SUCCESS) {
            this.log("\n\n" + exitCode.getMessage());
            this.setExitCodeHighest(exitCode);
        }
        this.log(NEW_LINE + HadoopWizArb.format("OLH_EXEC_STEP_END", exitCode != ExitCode.EXIT_ERROR ? HadoopWizArb.getString("OLH_EXEC_SUCCESS") : HadoopWizArb.getString("OSCH_EXEC_FAIL"), string));
        if (exitCode != ExitCode.EXIT_ERROR) {
            this._isCleanupSourceNeeded = true;
            return true;
        }
        return false;
    }

    private String getSourceXTab() {
        BasicDBObject basicDBObject = this._eo.getDBObject();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd_HHmmssssss");
        StringBuilder stringBuilder = new StringBuilder(simpleDateFormat.format(new Date()));
        this._srcXTabName = "X_" + stringBuilder;
        this._transientXTabs.put(basicDBObject, this._srcXTabName);
        basicDBObject.getObjectName();
        ST sT = this.getTemplateGroup().getInstanceOf("CreateSourceXTableStatement");
        sT.add("xtableName", (Object)this._srcXTabName);
        sT.add("dirName", (Object)((String)this._hProps.get(ImportKeys.ORADIRNAME)));
        int n = (Integer)this._hProps.get(HadoopKeys.PARALLEL);
        n = n < 1 ? 1 : n;
        this._srcStrFiles = new String[n];
        for (int i = 0; i < n; ++i) {
            this._srcStrFiles[i] = "'" + this._srcXTabName + i + "_sqldev.dmp'";
        }
        sT.add("fileList", (Object)this._srcStrFiles);
        sT.add("parallel", (Object)n);
        sT.add("select", (Object)HadoopUtils.getSQL(this._eo));
        return sT.render();
    }

    private boolean doCopyBDAPut(BasicDBObject basicDBObject) throws Exception {
        String string = HadoopWizArb.getString("BDA_EXEC_STEP_HADOOP_PUT");
        this._task.setMessage(string);
        this.log(NEW_LINE + HadoopWizArb.format("BDA_EXEC_STEP_START", string));
        this.log(this._putScript);
        boolean bl = this.copyAndExecuteScript(this._putScript);
        this.log(HadoopWizArb.format("BDA_EXEC_STEP_END", string) + NEW_LINE);
        return bl;
    }

    private String getPutScript() {
        String string = "hadoop fs -mkdir " + this._destDir + HadoopUtils.getTerm();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        for (int i = 0; i < this._srcStrFiles.length; ++i) {
            String string2 = this._srcStrFiles[i].substring(1, this._srcStrFiles[i].length() - 1);
            stringBuffer.append(this.getPut(this._oraPath + string2, this._destDir + "/" + string2));
        }
        return stringBuffer.toString();
    }

    private boolean doDirect(BasicDBObject basicDBObject) throws Exception {
        String string = HadoopWizArb.getString("BDA_EXEC_STEP_HADOOP_DIRECT_COPY");
        this._task.setMessage(string);
        this.log(NEW_LINE + HadoopWizArb.format("BDA_EXEC_STEP_START", string));
        if (this._direct.isEmpty()) {
            this.getScript();
        }
        this._isCleanupDeployNeeded = true;
        this.executeAsScript(this._direct);
        this.log("*** SCRIPT ***\n" + this._direct + NEW_LINE + NEW_LINE + this.getFormattedOutput(this._result));
        string = HadoopWizArb.format("OLH_EXEC_STEP_LOAD", this._destTableName, this._destConnDisplayName, this._dbo.getSchemaName() + "." + this._dbo.getObjectName());
        this.log(NEW_LINE + HadoopWizArb.format("OLH_EXEC_STEP_END", this._result.rc == 0 ? HadoopWizArb.getString("OLH_EXEC_SUCCESS") : HadoopWizArb.getString("OSCH_EXEC_FAIL"), string));
        ExitCode exitCode = ExitCode.EXIT_SUCCESS;
        if (this._result.rc != 0) {
            exitCode = ExitCode.EXIT_ERROR;
            this.signalCancel();
            this.setExitCodeHighest(exitCode);
            return false;
        }
        return true;
    }

    private String getPut(String string, String string2) {
        ST sT = this.getTemplateGroup().getInstanceOf("CopyBDAMove");
        sT.add("fileName", (Object)string);
        sT.add("fileName2", (Object)string2);
        String string3 = sT.render() + NEW_LINE;
        return string3;
    }

    private boolean copyAndExecuteScript(String string) {
        try {
            String string2;
            this._isCleanupDeployNeeded = true;
            String string3 = this._sourceEnv + string;
            ScriptOutput scriptOutput = HadoopUtils.copyAndExecuteScript((SshLocation)this._sessLoc, string3, this._tempName + ".deploy", this._tempDir + "/");
            String string4 = string2 = scriptOutput.stdout != null ? scriptOutput.stdout.trim() : "";
            if (!string2.isEmpty()) {
                this.log("STDOUT:\n" + string2 + (string2.endsWith(NEW_LINE) ? "" : NEW_LINE));
            }
            String string5 = string2 = scriptOutput.stderr != null ? scriptOutput.stderr.trim() : "";
            if (!string2.isEmpty()) {
                this.log("\nSTDOUT:\n" + string2 + (string2.endsWith(NEW_LINE) ? "" : NEW_LINE));
            }
            this.log("RETURN CODE: " + scriptOutput.rc);
            return scriptOutput.rc == 0;
        }
        catch (Exception exception) {
            this.log(HadoopWizArb.getString("BDA_EXEC_SCRIPT_FAIL") + " " + exception.getMessage());
            Logger.warn(this.getClass(), (Throwable)exception);
            return false;
        }
    }

    private boolean executeCommand(String string) {
        try {
            String string2;
            ScriptOutput scriptOutput = HadoopUtils.executeCommand(this._session, string);
            String string3 = string2 = scriptOutput.stdout != null ? scriptOutput.stdout.trim() : "";
            if (!string2.isEmpty()) {
                this.log("STDOUT:\n" + string2 + (string2.endsWith(NEW_LINE) ? "" : NEW_LINE));
            }
            String string4 = string2 = scriptOutput.stderr != null ? scriptOutput.stderr.trim() : "";
            if (!string2.isEmpty()) {
                this.log("\nSTDOUT:\n" + string2 + (string2.endsWith(NEW_LINE) ? "" : NEW_LINE));
            }
            this.log("RETURN CODE: " + scriptOutput.rc);
            return scriptOutput.rc == 0;
        }
        catch (Exception exception) {
            this.log(HadoopWizArb.getString("BDA_EXEC_SCRIPT_FAIL") + " " + exception.getMessage());
            Logger.warn(this.getClass(), (Throwable)exception);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScriptOutput executeScript(ClientSession clientSession, String string) {
        assert (string != null);
        Logger.fine(this.getClass(), (String)("script = \"" + string + "\""));
        String string2 = string + "\nexit $?\n";
        ChannelShell channelShell = null;
        ScriptOutput scriptOutput = new ScriptOutput();
        try {
            Object object = clientSession;
            synchronized (object) {
                assert (clientSession != null && clientSession.isOpen());
                channelShell = clientSession.createShellChannel();
            }
            object = new ByteArrayInputStream(string2.getBytes());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2048);
            ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream(2048);
            channelShell.setIn((InputStream)object);
            channelShell.setOut((OutputStream)byteArrayOutputStream);
            channelShell.setErr((OutputStream)byteArrayOutputStream2);
            channelShell.open().verify((long)this.timeout);
            do {
                Thread.sleep(500L);
            } while (!channelShell.isEofSignalled());
            scriptOutput.stdout = byteArrayOutputStream.toString();
            scriptOutput.stderr = byteArrayOutputStream2.toString();
            channelShell.close();
        }
        catch (IOException iOException) {
            Logger.severe(this.getClass(), (String)HadoopWizArb.getString("SSH_ERROR1"), (Throwable)iOException);
        }
        catch (Exception exception) {
            Logger.severe(this.getClass(), (String)HadoopWizArb.getString("SSH_ERROR2"), (Throwable)exception);
        }
        return scriptOutput;
    }

    private void processStep(String string, String string2) {
        try {
            this._process.append(NEW_LINE + HadoopWizArb.format("BDA_EXEC_STEP_START", string) + NEW_LINE);
            this._process.append(string2 + NEW_LINE);
            this._process.append(HadoopWizArb.format("BDA_EXEC_STEP_END", string) + NEW_LINE);
        }
        catch (Exception exception) {
            this.log(exception.getMessage());
        }
    }

    private boolean doCleanupSource(BasicDBObject basicDBObject) {
        if (this._isCleanupSourceNeeded) {
            try {
                String string = HadoopWizArb.getString("BDA_EXEC_STEP_CLEANUP_SOURCE");
                this._task.setMessage(string);
                this.log(NEW_LINE + HadoopWizArb.format("BDA_EXEC_STEP_START", string));
                this.log(this._dropSource);
                ExitCode exitCode = this.pstmtExec(this._srcConn, this._dropSource);
                if (exitCode != ExitCode.EXIT_SUCCESS) {
                    this.log("\n\n" + exitCode.getMessage());
                    this.setExitCodeHighest(exitCode);
                }
                this.log(exitCode.getMessage().isEmpty() ? "Drop External Table " + HadoopWizArb.getString("BDA_EXEC_SUCCESS") : exitCode.getMessage());
                this.log(NEW_LINE + HadoopWizArb.format("OLH_EXEC_STEP_END", exitCode != ExitCode.EXIT_ERROR ? HadoopWizArb.getString("OLH_EXEC_SUCCESS") : HadoopWizArb.getString("OSCH_EXEC_FAIL"), string));
                return exitCode != ExitCode.EXIT_ERROR;
            }
            catch (Exception exception) {
                Logger.warn(this.getClass(), (String)HadoopWizArb.getString("COPY_CLEANUP_ERROR"), (Throwable)exception);
                return false;
            }
        }
        return true;
    }

    private String getDropSource() {
        ST sT = this.getTemplateGroup().getInstanceOf("DropTableStatementForPrepare");
        sT.add("tableName", (Object)this._transientXTabs.get(this._dbo));
        return sT.render();
    }

    private boolean doHiveXTab(BasicDBObject basicDBObject) {
        try {
            String string = HadoopWizArb.format("BDA_EXEC_STEP_CREATE_DEST", this._destConnDisplayName);
            this._task.setMessage(string);
            this.log(NEW_LINE + HadoopWizArb.format("BDA_EXEC_STEP_START", string));
            ExitCode exitCode = ExitCode.EXIT_SUCCESS;
            this.log(this._hiveXTab);
            exitCode = this.pstmtExec(this._destConn, this._hiveXTab);
            if (exitCode != ExitCode.EXIT_SUCCESS) {
                this.log("\n\n" + exitCode.getMessage());
                this.setExitCodeHighest(exitCode);
            }
            this.log(NEW_LINE + HadoopWizArb.format("OLH_EXEC_STEP_END", exitCode != ExitCode.EXIT_ERROR ? HadoopWizArb.getString("OLH_EXEC_SUCCESS") : HadoopWizArb.getString("OSCH_EXEC_FAIL"), string));
            return exitCode != ExitCode.EXIT_ERROR;
        }
        catch (Exception exception) {
            this.log(exception.getMessage());
            return false;
        }
    }

    private String getHiveXTab() {
        ST sT = this.getTemplateGroup().getInstanceOf("CreateHiveXTableStatement");
        sT.add("xtableName", (Object)((String)this._hProps.get(HadoopKeys.DEST_SCHEMA) + "." + (String)this._hProps.get(HadoopKeys.DEST_TABLE)));
        String string = HadoopGenericTable.ORIGIN + " " + "\"" + HadoopUtils.getGlobalName(this._srcConn) + "\"" + ":" + "\"" + this._dbo.getSchemaName() + "\"" + ":" + "\"" + this._dbo.getObjectName() + "\"";
        sT.add("origin", (Object)string);
        sT.add("hdfs_dir", (Object)((String)this._hProps.get(HadoopKeys.DEST_DIR)));
        return sT.render();
    }

    private boolean doHiveTempXTab(BasicDBObject basicDBObject) {
        try {
            String string = HadoopWizArb.format("BDA_EXEC_STEP_CREATE_TEMP_DEST", this._destConnDisplayName);
            this._task.setMessage(string);
            this.log(NEW_LINE + HadoopWizArb.format("BDA_EXEC_STEP_START", string));
            ExitCode exitCode = ExitCode.EXIT_SUCCESS;
            this.log(this._hiveTempXTab);
            exitCode = this.pstmtExec(this._destConn, this._hiveTempXTab);
            if (exitCode != ExitCode.EXIT_ERROR) {
                this._isCleanupDestNeeded = true;
            } else {
                this.log("\n\n" + exitCode.getMessage());
                this.setExitCodeHighest(exitCode);
            }
            this.log(NEW_LINE + HadoopWizArb.format("OLH_EXEC_STEP_END", exitCode != ExitCode.EXIT_ERROR ? HadoopWizArb.getString("OLH_EXEC_SUCCESS") : HadoopWizArb.getString("OSCH_EXEC_FAIL"), string));
            return exitCode != ExitCode.EXIT_ERROR;
        }
        catch (Exception exception) {
            this.log(exception.getMessage());
            return false;
        }
    }

    private String getHiveTempXTab() {
        ST sT = this.getTemplateGroup().getInstanceOf("CreateHiveXTableStatement");
        sT.add("xtableName", (Object)((String)this._hProps.get(HadoopKeys.DEST_SCHEMA) + "." + this._srcXTabName));
        String string = HadoopGenericTable.ORIGIN + " " + "\"" + HadoopUtils.getGlobalName(this._srcConn) + "\"" + ":" + "\"" + this._dbo.getSchemaName() + "\"" + ":" + "\"" + this._dbo.getObjectName() + "\"";
        sT.add("origin", (Object)string);
        sT.add("hdfs_dir", (Object)((String)this._hProps.get(HadoopKeys.DEST_DIR)));
        return sT.render();
    }

    private boolean doHiveTab(BasicDBObject basicDBObject) {
        try {
            String string = HadoopWizArb.format("BDA_EXEC_STEP_CREATE_DEST_TAB", this._destConnDisplayName);
            this._task.setMessage(string);
            this.log(NEW_LINE + HadoopWizArb.format("BDA_EXEC_STEP_START", string));
            ExitCode exitCode = ExitCode.EXIT_SUCCESS;
            this.log(this._hiveTab);
            exitCode = this.pstmtExec(this._destConn, this._hiveTab);
            if (exitCode != ExitCode.EXIT_SUCCESS) {
                this.log("\n\n" + exitCode.getMessage());
                this.setExitCodeHighest(exitCode);
            }
            this.log(NEW_LINE + HadoopWizArb.format("OLH_EXEC_STEP_END", exitCode != ExitCode.EXIT_ERROR ? HadoopWizArb.getString("OLH_EXEC_SUCCESS") : HadoopWizArb.getString("OSCH_EXEC_FAIL"), string));
            return exitCode != ExitCode.EXIT_ERROR;
        }
        catch (Exception exception) {
            this.log(exception.getMessage());
            return false;
        }
    }

    private String getHiveTab() {
        ST sT = this.getTemplateGroup().getInstanceOf("CreateHiveTableStatement");
        sT.add("dtableName", (Object)((String)this._hProps.get(HadoopKeys.DEST_SCHEMA) + "." + (String)this._hProps.get(HadoopKeys.DEST_TABLE)));
        sT.add("stableName", (Object)((String)this._hProps.get(HadoopKeys.DEST_SCHEMA) + "." + this._srcXTabName));
        String string = HadoopGenericTable.ORIGIN + " " + "\"" + HadoopUtils.getGlobalName(this._srcConn) + "\"" + ":" + "\"" + this._dbo.getSchemaName() + "\"" + ":" + "\"" + this._dbo.getObjectName() + "\"";
        sT.add("origin", (Object)string);
        sT.add("format", (Object)this._destDataFormat);
        return sT.render();
    }

    private boolean doAppendHiveXTab(BasicDBObject basicDBObject) {
        try {
            String string = HadoopWizArb.format("BDA_EXEC_STEP_APPEND_DEST", this._destConnDisplayName);
            this._task.setMessage(string);
            this.log(NEW_LINE + HadoopWizArb.format("BDA_EXEC_STEP_START", string));
            ExitCode exitCode = ExitCode.EXIT_SUCCESS;
            this.log(this._appendHiveXTab);
            exitCode = this.pstmtExec(this._destConn, this._appendHiveXTab);
            if (exitCode != ExitCode.EXIT_SUCCESS) {
                this.log("\n\n" + exitCode.getMessage());
                this.setExitCodeHighest(exitCode);
            }
            this.log(NEW_LINE + HadoopWizArb.format("OLH_EXEC_STEP_END", exitCode != ExitCode.EXIT_ERROR ? HadoopWizArb.getString("OLH_EXEC_SUCCESS") : HadoopWizArb.getString("OSCH_EXEC_FAIL"), string));
            return exitCode != ExitCode.EXIT_ERROR;
        }
        catch (Exception exception) {
            this.log(exception.getMessage());
            return false;
        }
    }

    private String getAppendHiveXTab() {
        ST sT = this.getTemplateGroup().getInstanceOf("AppendHiveXTableStatement");
        sT.add("dtableName", (Object)((String)this._hProps.get(HadoopKeys.DEST_SCHEMA) + "." + (String)this._hProps.get(HadoopKeys.DEST_TABLE)));
        sT.add("stableName", (Object)((String)this._hProps.get(HadoopKeys.DEST_SCHEMA) + "." + this._srcXTabName));
        return sT.render();
    }

    private boolean doDropTempHiveFiles(BasicDBObject basicDBObject) throws Exception {
        String string = HadoopWizArb.getString("BDA_EXEC_STEP_DROP_TEMP_HIVE_FILES");
        this._task.setMessage(string);
        this.log(NEW_LINE + HadoopWizArb.format("BDA_EXEC_STEP_START", string));
        this.log(this._dropTempHiveFiles + (this._dropTempDeployFile.isEmpty() ? "" : NEW_LINE + this._dropTempDeployFile));
        boolean bl = this.copyAndExecuteScript(this._dropTempHiveFiles);
        this.log(HadoopWizArb.format("BDA_EXEC_STEP_END", string) + NEW_LINE);
        return bl;
    }

    private boolean doDropTempDeployFile(BasicDBObject basicDBObject) throws Exception {
        String string = HadoopWizArb.getString("BDA_EXEC_STEP_DROP_DEPLOY_FILE");
        this._task.setMessage(string);
        this.log(NEW_LINE + HadoopWizArb.format("BDA_EXEC_STEP_START", string));
        this.log(this._dropTempDeployFile);
        boolean bl = this.executeCommand(this._dropTempDeployFile);
        this.log(HadoopWizArb.format("BDA_EXEC_STEP_END", string) + NEW_LINE);
        return bl;
    }

    private String getDropTempHiveFiles() {
        if (!this._destDataFormat.equals("Data Pump")) {
            return "hadoop fs -rm -r " + (String)this._hProps.get(HadoopKeys.DEST_DIR);
        }
        return "";
    }

    private String getDropTempDeployFile() {
        return "rm " + this._tempDir + "/" + this._tempName + ".deploy";
    }

    private boolean doDropHiveTempXTab(BasicDBObject basicDBObject) throws Exception {
        try {
            String string = HadoopWizArb.format("BDA_EXEC_STEP_DROP_TEMP_HIVE_TABLE", this._destConnDisplayName);
            this._task.setMessage(string);
            this.log(NEW_LINE + HadoopWizArb.format("BDA_EXEC_STEP_START", string));
            ExitCode exitCode = ExitCode.EXIT_SUCCESS;
            this.log(this._dropTempHiveTable);
            exitCode = this.pstmtExec(this._destConn, this._dropTempHiveTable);
            if (exitCode != ExitCode.EXIT_SUCCESS) {
                this.log("\n\n" + exitCode.getMessage());
                this.setExitCodeHighest(exitCode);
            }
            this.log(NEW_LINE + HadoopWizArb.format("OLH_EXEC_STEP_END", exitCode != ExitCode.EXIT_ERROR ? HadoopWizArb.getString("OLH_EXEC_SUCCESS") : HadoopWizArb.getString("OSCH_EXEC_FAIL"), string));
            return exitCode != ExitCode.EXIT_ERROR;
        }
        catch (Exception exception) {
            this.log(exception.getMessage());
            return false;
        }
    }

    private String getDropHiveTempXTab() {
        return "DROP TABLE " + (String)this._hProps.get(HadoopKeys.DEST_SCHEMA) + "." + this._srcXTabName;
    }

    private String getDropDirectWorkDir() {
        return "hadoop fs -rm -r " + this._tempName;
    }

    private boolean doDropDirectWorkDir() throws Exception {
        boolean bl = true;
        if (this._hProps.getValueBoolean(HadoopKeys.DELETE_DEPLOY).booleanValue() && this._dropTempDeployFile != null && !this._dropTempDeployFile.isEmpty()) {
            String string = HadoopWizArb.getString("BDA_EXEC_STEP_DROP_WORK_DIR");
            this._task.setMessage(string);
            this.log(NEW_LINE + HadoopWizArb.format("BDA_EXEC_STEP_START", string));
            this.log(this._dropDirectWorkDir);
            bl = this.executeCommand(this._dropDirectWorkDir);
            this.log(HadoopWizArb.format("BDA_EXEC_STEP_END", string) + NEW_LINE);
        }
        return bl;
    }

    private String getDropDirect() {
        String string = "";
        if (this._hProps.getValueBoolean(HadoopKeys.DELETE_DEPLOY).booleanValue()) {
            string = !this._isWallet ? "rm " + this._xmlName + NEW_LINE : "";
            string = string + "rm " + this._tempDir + this._tempName + ".deploy" + NEW_LINE;
        }
        return string;
    }

    private boolean dropDirectDeploy() {
        boolean bl = true;
        if (this._hProps.getValueBoolean(HadoopKeys.DELETE_DEPLOY).booleanValue() && this._dropTempDeployFile != null && !this._dropTempDeployFile.isEmpty()) {
            String string = HadoopWizArb.getString("OLH_EXEC_STEP_DELETE_DEPLOY_PUT");
            this.log(NEW_LINE + HadoopWizArb.format("OLH_EXEC_STEP_START", string));
            ExitCode exitCode = ExitCode.EXIT_SUCCESS;
            this.log(this._dropTempDeployFile);
            ScriptOutput scriptOutput = HadoopUtils.executeCommand(this._session, this._dropTempDeployFile);
            if (scriptOutput.rc != 0) {
                this.log(HadoopWizArb.format("OSCH_EXEC_REMOVE_FAILED", this.getFormattedOutput(scriptOutput)));
                exitCode = ExitCode.EXIT_WARNING;
                this.setExitCodeHighest(ExitCode.EXIT_WARNING);
                bl = true;
            }
            this.log(NEW_LINE + HadoopWizArb.format("OLH_EXEC_STEP_END", scriptOutput.rc == 0 ? HadoopWizArb.getString("OLH_EXEC_SUCCESS") : HadoopWizArb.getString("OLH_EXEC_FAIL"), string));
        }
        return bl;
    }

    private boolean executeAsScript(String string) {
        try {
            Long l;
            Object object;
            ExitCode exitCode = ExitCode.EXIT_SUCCESS;
            String string2 = (String)this._hProps.get(HadoopKeys.SSH_HOST);
            this.log("SSH HOST: " + string2);
            if (!this._isWallet) {
                try {
                    object = new ByteArrayInputStream(this._xml.getBytes("UTF-8"));
                    l = HadoopUtils.putFile(this._session, this._xmlName, (ByteArrayInputStream)object);
                    if (l < 1L) {
                        this.log(HadoopWizArb.format("OSCH_EXEC_PUT_FAILED", this._xmlName));
                        exitCode = ExitCode.EXIT_ERROR;
                        this.setExitCodeHighest(ExitCode.EXIT_ERROR);
                        return false;
                    }
                }
                catch (Exception exception) {
                    this.log(HadoopWizArb.format("OSCH_EXEC_PUT_FAILED", this._xmlName, exception.getMessage()));
                    exitCode = ExitCode.EXIT_ERROR;
                    this.setExitCodeHighest(ExitCode.EXIT_ERROR);
                    return false;
                }
            }
            object = this._sourceEnv + MKDIR + this._tempDir + NEW_LINE + string;
            l = (SshSessionLocation)this._hProps.get(HadoopKeys.SSH_SESSION_LOCATION);
            this._result = HadoopUtils.copyAndExecuteScript((SshLocation)l, (String)object, this._tempName + ".deploy", this._tempDir + "/");
            return this._result.rc == 0;
        }
        catch (Exception exception) {
            this.log(HadoopWizArb.getString("OLH_EXEC_SCRIPT_FAIL") + " " + exception.getMessage());
            Logger.warn(this.getClass(), (Throwable)exception);
            return false;
        }
    }

    private String getTerm() {
        return NEW_LINE;
    }
}

